﻿namespace VedAstro.Library
{
    /// <summary>
    /// Represents events in EventsDataList.xml
    /// Static typed name list of events,
    /// This is not the primary list, not all events here will be checked,
    /// only events in the XML list are checked
    /// Not all events here have to have a method
    /// </summary>
    public enum EventName
    {
        Empty,
        GoodTarabala,
        BadTarabala,
        GoodChandrabala,
        BadChandrabala,
        GoodPanchaka,
        BadPanchaka,
        SiddhaYogaSunday,
        SiddhaYogaMonday,
        SiddhaYogaTuesday,
        SiddhaYogaWednesday,
        SiddhaYogaThursday,
        SiddhaYogaFriday,
        SiddhaYogaSaturday,
        AmritaSiddhaYoga,
        PanchangaSuddhi,
        UgraYoga,
        SuryaSankramana,
        KarthariDosha,
        ShashtashtaRiphagathaChandraDosha,
        SagrahaChandraDosha,
        UdayasthaSuddhi,
        SiddhaYoga,
        SakunaKarana,
        BadNithyaYoga,
        LagnaThyajya,
        BhriguShatka,
        Kujasthama,
        GoodHairCutting,
        GoodNailCutting,
        FixedConstellationRuling,
        SoftConstellationRuling,
        LightConstellationRuling,
        SharpConstellationRuling,
        MovableConstellationRuling,
        DreadfulConstellationRuling,
        MixedConstellationRuling,
        LagnaLordIsWeekdayLord,

        Ekadashi,


        NotAuspiciousDay,
        GoodPlanetsInLagna,
        GoodRullingConstellation,
        BadRullingConstellation,
        GoodTakingInjections,
        GoodSellingForProfit,
        BavaKarana,
        TaitulaKarana,
        BhadraKarana,
        JanmaNakshatraRulling,
        SunIsStrong,
        MoonIsStrong,
        MarsIsStrong,
        MercuryIsStrong,
        JupiterIsStrong,
        VenusIsStrong,
        SaturnIsStrong,
        House1IsStrong,
        House2IsStrong,
        House3IsStrong,
        House4IsStrong,
        House5IsStrong,
        House6IsStrong,
        House7IsStrong,
        House8IsStrong,
        House9IsStrong,
        House10IsStrong,
        House11IsStrong,
        House12IsStrong,
        BadForBuyingToolsUtensilsJewellery,
        GoodForBuyingBrassVessels,
        GoodForBuyingCopperVessels,
        GoodForBuyingSteelIronVessels,
        GoodForBuyingSilverVessels,
        GoodForBuyingJewellery,
        GoodPlanetsIn11th,
        GoodPlanetsInKendra,
        Sunrise,
        Sunset,
        Midday,
        TarabalaJanmaStrong,
        TarabalaSampatStrong,
        TarabalaVipatStrong,
        TarabalaKshemaStrong,
        TarabalaPratyakStrong,
        TarabalaSadhanaStrong,
        TarabalaNaidhanaStrong,
        TarabalaMitraStrong,
        TarabalaParamaMitraStrong,
        TarabalaJanmaMiddling,
        TarabalaSampatMiddling,
        TarabalaVipatMiddling,
        TarabalaKshemaMiddling,
        TarabalaPratyakMiddling,
        TarabalaSadhanaMiddling,
        TarabalaNaidhanaMiddling,
        TarabalaMitraMiddling,
        TarabalaParamaMitraMiddling,
        TarabalaJanmaWeak,
        TarabalaSampatWeak,
        TarabalaVipatWeak,
        TarabalaKshemaWeak,
        TarabalaPratyakWeak,
        TarabalaSadhanaWeak,
        TarabalaNaidhanaWeak,
        TarabalaMitraWeak,
        TarabalaParamaMitraWeak,
        Papashadvargas,

        CombinedEvent,
        GoodMoonSignForSelling,
        GoodWeekdayForSelling,


        Lord6And8Dasa,
        Lord5And9Dasa,
        BhuktiDasaLordInBadHouses,

        BadLunarMonthForBuilding,
        GoodSunSignForBuilding,
        BadSunSignForBuilding,
        GoodLunarDayForBuilding,
        GoodWeekDayForBuilding,
        BadLunarPhaseForBuilding,
        BadWeekDayForBuilding,
        BadWeekDayForRepairs,
        GoodYogaForRepairs,
        GoodYogaForRepairs2,
        Lord2Dasa,
        Lord3Dasa,
        Lord5And9DasaBhukti,
        LagnaLordDasa,
        Saturn4thDasa,
        Jupiter6thDasa,
        ElevatedSunDasa,
        SunWithLord9Or10Dasa,
        SunWithLord5Dasa,
        SunWithLord2Dasa,
        SunBadPositionDasa,
        ExaltedSunDasa,

        Yama1,
        Yama2,
        Yama3,
        Yama4,
        Yama5,


        #region AGRICULTURE

        BadForStartingAllAgriculture,
        GoodLunarDayAgriculture,
        BadLagnaForAllAgriculture,
        GoodYogaForAllAgriculture,
        GoodAnySeedsSowing,

        GoodForPlantingFloweringPlants,
        GoodForPlantingGarlic,
        GoodForPlantingPeachAndOthers,
        GoodForPlantingTomatoesAndOthers,
        GoodForPlantingGrains,
        GoodForPlantingOnionAndOthers,
        GoodForPlantingPepperAndOthers,
        GoodForPlantingPotatoAndOthers,
        GoodForPlantingGrainsAndOthers,
        GoodForPlantingPumpkinsAndOthers,
        GoodForPlantingTrees,
        GoodForPlantingFlowerSeeds,
        GoodForPlantingSugarcane,
        GoodForPlantingFruitTrees,
        GoodForPlantingFlowerTrees,
        GoodForPlantingFlowers,
        GoodForPlantingFlowerCuttings,

        #endregion

        #region ASHTAKVARGA_GOCHARA

        SunTransit8Bindu,
        SunTransit7Bindu,
        SunTransit6Bindu,
        SunTransit5Bindu,
        SunTransit4Bindu,
        SunTransit3Bindu,
        SunTransit2Bindu,
        SunTransit1Bindu,
        SunTransit0Bindu,
        MoonTransit8Bindu,
        MoonTransit7Bindu,
        MoonTransit6Bindu,
        MoonTransit5Bindu,
        MoonTransit4Bindu,
        MoonTransit3Bindu,
        MoonTransit2Bindu,
        MoonTransit1Bindu,
        MoonTransit0Bindu,
        MarsTransit8Bindu,
        MarsTransit7Bindu,
        MarsTransit6Bindu,
        MarsTransit5Bindu,
        MarsTransit4Bindu,
        MarsTransit3Bindu,
        MarsTransit2Bindu,
        MarsTransit1Bindu,
        MarsTransit0Bindu,
        MercuryTransit8Bindu,
        MercuryTransit7Bindu,
        MercuryTransit6Bindu,
        MercuryTransit5Bindu,
        MercuryTransit4Bindu,
        MercuryTransit3Bindu,
        MercuryTransit2Bindu,
        MercuryTransit1Bindu,
        MercuryTransit0Bindu,
        JupiterTransit8Bindu,
        JupiterTransit7Bindu,
        JupiterTransit6Bindu,
        JupiterTransit5Bindu,
        JupiterTransit4Bindu,
        JupiterTransit3Bindu,
        JupiterTransit2Bindu,
        JupiterTransit1Bindu,
        JupiterTransit0Bindu,
        VenusTransit8Bindu,
        VenusTransit7Bindu,
        VenusTransit6Bindu,
        VenusTransit5Bindu,
        VenusTransit4Bindu,
        VenusTransit3Bindu,
        VenusTransit2Bindu,
        VenusTransit1Bindu,
        VenusTransit0Bindu,
        SaturnTransit8Bindu,
        SaturnTransit7Bindu,
        SaturnTransit6Bindu,
        SaturnTransit5Bindu,
        SaturnTransit4Bindu,
        SaturnTransit3Bindu,
        SaturnTransit2Bindu,
        SaturnTransit1Bindu,
        SaturnTransit0Bindu,
        #endregion

        #region GOCHARA_TRANSITS


        SunGocharaInHouse1,
        SunGocharaInHouse2,
        SunGocharaInHouse3,
        SunGocharaInHouse4,
        SunGocharaInHouse5,
        SunGocharaInHouse6,
        SunGocharaInHouse7,
        SunGocharaInHouse8,
        SunGocharaInHouse9,
        SunGocharaInHouse10,
        SunGocharaInHouse11,
        SunGocharaInHouse12,
        MoonGocharaInHouse1,
        MoonGocharaInHouse2,
        MoonGocharaInHouse3,
        MoonGocharaInHouse4,
        MoonGocharaInHouse5,
        MoonGocharaInHouse6,
        MoonGocharaInHouse7,
        MoonGocharaInHouse8,
        MoonGocharaInHouse9,
        MoonGocharaInHouse10,
        MoonGocharaInHouse11,
        MoonGocharaInHouse12,
        MarsGocharaInHouse1,
        MarsGocharaInHouse2,
        MarsGocharaInHouse3,
        MarsGocharaInHouse4,
        MarsGocharaInHouse5,
        MarsGocharaInHouse6,
        MarsGocharaInHouse7,
        MarsGocharaInHouse8,
        MarsGocharaInHouse9,
        MarsGocharaInHouse10,
        MarsGocharaInHouse11,
        MarsGocharaInHouse12,
        MercuryGocharaInHouse1,
        MercuryGocharaInHouse2,
        MercuryGocharaInHouse3,
        MercuryGocharaInHouse4,
        MercuryGocharaInHouse5,
        MercuryGocharaInHouse6,
        MercuryGocharaInHouse7,
        MercuryGocharaInHouse8,
        MercuryGocharaInHouse9,
        MercuryGocharaInHouse10,
        MercuryGocharaInHouse11,
        MercuryGocharaInHouse12,
        JupiterGocharaInHouse1,
        JupiterGocharaInHouse2,
        JupiterGocharaInHouse3,
        JupiterGocharaInHouse4,
        JupiterGocharaInHouse5,
        JupiterGocharaInHouse6,
        JupiterGocharaInHouse7,
        JupiterGocharaInHouse8,
        JupiterGocharaInHouse9,
        JupiterGocharaInHouse10,
        JupiterGocharaInHouse11,
        JupiterGocharaInHouse12,
        VenusGocharaInHouse1,
        VenusGocharaInHouse2,
        VenusGocharaInHouse3,
        VenusGocharaInHouse4,
        VenusGocharaInHouse5,
        VenusGocharaInHouse6,
        VenusGocharaInHouse7,
        VenusGocharaInHouse8,
        VenusGocharaInHouse9,
        VenusGocharaInHouse10,
        VenusGocharaInHouse11,
        VenusGocharaInHouse12,
        SaturnGocharaInHouse1,
        SaturnGocharaInHouse2,
        SaturnGocharaInHouse3,
        SaturnGocharaInHouse4,
        SaturnGocharaInHouse5,
        SaturnGocharaInHouse6,
        SaturnGocharaInHouse7,
        SaturnGocharaInHouse8,
        SaturnGocharaInHouse9,
        SaturnGocharaInHouse10,
        SaturnGocharaInHouse11,
        SaturnGocharaInHouse12,
        RahuGocharaInHouse1,
        RahuGocharaInHouse2,
        RahuGocharaInHouse3,
        RahuGocharaInHouse4,
        RahuGocharaInHouse5,
        RahuGocharaInHouse6,
        RahuGocharaInHouse7,
        RahuGocharaInHouse8,
        RahuGocharaInHouse9,
        RahuGocharaInHouse10,
        RahuGocharaInHouse11,
        RahuGocharaInHouse12,
        KetuGocharaInHouse1,
        KetuGocharaInHouse2,
        KetuGocharaInHouse3,
        KetuGocharaInHouse4,
        KetuGocharaInHouse5,
        KetuGocharaInHouse6,
        KetuGocharaInHouse7,
        KetuGocharaInHouse8,
        KetuGocharaInHouse9,
        KetuGocharaInHouse10,
        KetuGocharaInHouse11,
        KetuGocharaInHouse12,
        GocharaSummary,

        #endregion

        #region DASA_PERIODS

        //DASA - PD1 108
        AriesSunPD1,
        TaurusSunPD1,
        GeminiSunPD1,
        CancerSunPD1,
        LeoSunPD1,
        VirgoSunPD1,
        LibraSunPD1,
        ScorpioSunPD1,
        SagittariusSunPD1,
        CapricornSunPD1,
        AquariusSunPD1,
        PiscesSunPD1,
        AriesMoonPD1,
        TaurusMoonPD1,
        GeminiMoonPD1,
        CancerMoonPD1,
        LeoMoonPD1,
        VirgoMoonPD1,
        LibraMoonPD1,
        ScorpioMoonPD1,
        SagittariusMoonPD1,
        CapricornMoonPD1,
        AquariusMoonPD1,
        PiscesMoonPD1,
        AriesMarsPD1,
        TaurusMarsPD1,
        GeminiMarsPD1,
        CancerMarsPD1,
        LeoMarsPD1,
        VirgoMarsPD1,
        LibraMarsPD1,
        ScorpioMarsPD1,
        SagittariusMarsPD1,
        CapricornMarsPD1,
        AquariusMarsPD1,
        PiscesMarsPD1,
        AriesRahuPD1,
        TaurusRahuPD1,
        GeminiRahuPD1,
        CancerRahuPD1,
        LeoRahuPD1,
        VirgoRahuPD1,
        LibraRahuPD1,
        ScorpioRahuPD1,
        SagittariusRahuPD1,
        CapricornRahuPD1,
        AquariusRahuPD1,
        PiscesRahuPD1,
        AriesJupiterPD1,
        TaurusJupiterPD1,
        GeminiJupiterPD1,
        CancerJupiterPD1,
        LeoJupiterPD1,
        VirgoJupiterPD1,
        LibraJupiterPD1,
        ScorpioJupiterPD1,
        SagittariusJupiterPD1,
        CapricornJupiterPD1,
        AquariusJupiterPD1,
        PiscesJupiterPD1,
        AriesSaturnPD1,
        TaurusSaturnPD1,
        GeminiSaturnPD1,
        CancerSaturnPD1,
        LeoSaturnPD1,
        VirgoSaturnPD1,
        LibraSaturnPD1,
        ScorpioSaturnPD1,
        SagittariusSaturnPD1,
        CapricornSaturnPD1,
        AquariusSaturnPD1,
        PiscesSaturnPD1,
        AriesMercuryPD1,
        TaurusMercuryPD1,
        GeminiMercuryPD1,
        CancerMercuryPD1,
        LeoMercuryPD1,
        VirgoMercuryPD1,
        LibraMercuryPD1,
        ScorpioMercuryPD1,
        SagittariusMercuryPD1,
        CapricornMercuryPD1,
        AquariusMercuryPD1,
        PiscesMercuryPD1,
        AriesKetuPD1,
        TaurusKetuPD1,
        GeminiKetuPD1,
        CancerKetuPD1,
        LeoKetuPD1,
        VirgoKetuPD1,
        LibraKetuPD1,
        ScorpioKetuPD1,
        SagittariusKetuPD1,
        CapricornKetuPD1,
        AquariusKetuPD1,
        PiscesKetuPD1,
        AriesVenusPD1,
        TaurusVenusPD1,
        GeminiVenusPD1,
        CancerVenusPD1,
        LeoVenusPD1,
        VirgoVenusPD1,
        LibraVenusPD1,
        ScorpioVenusPD1,
        SagittariusVenusPD1,
        CapricornVenusPD1,
        AquariusVenusPD1,
        PiscesVenusPD1,


        //BHUKTI

        SunSunPD2,
        SunMoonPD2,
        SunMarsPD2,
        SunRahuPD2,
        SunJupiterPD2,
        SunSaturnPD2,
        SunMercuryPD2,
        SunKetuPD2,
        SunVenusPD2,
        MoonSunPD2,
        MoonMoonPD2,
        MoonMarsPD2,
        MoonRahuPD2,
        MoonJupiterPD2,
        MoonSaturnPD2,
        MoonMercuryPD2,
        MoonKetuPD2,
        MoonVenusPD2,
        MarsSunPD2,
        MarsMoonPD2,
        MarsMarsPD2,
        MarsRahuPD2,
        MarsJupiterPD2,
        MarsSaturnPD2,
        MarsMercuryPD2,
        MarsKetuPD2,
        MarsVenusPD2,
        RahuSunPD2,
        RahuMoonPD2,
        RahuMarsPD2,
        RahuRahuPD2,
        RahuJupiterPD2,
        RahuSaturnPD2,
        RahuMercuryPD2,
        RahuKetuPD2,
        RahuVenusPD2,
        JupiterSunPD2,
        JupiterMoonPD2,
        JupiterMarsPD2,
        JupiterRahuPD2,
        JupiterJupiterPD2,
        JupiterSaturnPD2,
        JupiterMercuryPD2,
        JupiterKetuPD2,
        JupiterVenusPD2,
        SaturnSunPD2,
        SaturnMoonPD2,
        SaturnMarsPD2,
        SaturnRahuPD2,
        SaturnJupiterPD2,
        SaturnSaturnPD2,
        SaturnMercuryPD2,
        SaturnKetuPD2,
        SaturnVenusPD2,
        MercurySunPD2,
        MercuryMoonPD2,
        MercuryMarsPD2,
        MercuryRahuPD2,
        MercuryJupiterPD2,
        MercurySaturnPD2,
        MercuryMercuryPD2,
        MercuryKetuPD2,
        MercuryVenusPD2,
        KetuSunPD2,
        KetuMoonPD2,
        KetuMarsPD2,
        KetuRahuPD2,
        KetuJupiterPD2,
        KetuSaturnPD2,
        KetuMercuryPD2,
        KetuKetuPD2,
        KetuVenusPD2,
        VenusSunPD2,
        VenusMoonPD2,
        VenusMarsPD2,
        VenusRahuPD2,
        VenusJupiterPD2,
        VenusSaturnPD2,
        VenusMercuryPD2,
        VenusKetuPD2,
        VenusVenusPD2,



        //ANTARAM

        SunSunPD3,
        MoonSunPD3,
        MarsSunPD3,
        RahuSunPD3,
        JupiterSunPD3,
        SaturnSunPD3,
        MercurySunPD3,
        KetuSunPD3,
        VenusSunPD3,
        SunMoonPD3,
        MoonMoonPD3,
        MarsMoonPD3,
        RahuMoonPD3,
        JupiterMoonPD3,
        SaturnMoonPD3,
        MercuryMoonPD3,
        KetuMoonPD3,
        VenusMoonPD3,
        SunMarsPD3,
        MoonMarsPD3,
        MarsMarsPD3,
        RahuMarsPD3,
        JupiterMarsPD3,
        SaturnMarsPD3,
        MercuryMarsPD3,
        KetuMarsPD3,
        VenusMarsPD3,
        SunRahuPD3,
        MoonRahuPD3,
        MarsRahuPD3,
        RahuRahuPD3,
        JupiterRahuPD3,
        SaturnRahuPD3,
        MercuryRahuPD3,
        KetuRahuPD3,
        VenusRahuPD3,
        SunJupiterPD3,
        MoonJupiterPD3,
        MarsJupiterPD3,
        RahuJupiterPD3,
        JupiterJupiterPD3,
        SaturnJupiterPD3,
        MercuryJupiterPD3,
        KetuJupiterPD3,
        VenusJupiterPD3,
        SunSaturnPD3,
        MoonSaturnPD3,
        MarsSaturnPD3,
        RahuSaturnPD3,
        JupiterSaturnPD3,
        SaturnSaturnPD3,
        MercurySaturnPD3,
        KetuSaturnPD3,
        VenusSaturnPD3,
        SunMercuryPD3,
        MoonMercuryPD3,
        MarsMercuryPD3,
        RahuMercuryPD3,
        JupiterMercuryPD3,
        SaturnMercuryPD3,
        MercuryMercuryPD3,
        KetuMercuryPD3,
        VenusMercuryPD3,
        SunKetuPD3,
        MoonKetuPD3,
        MarsKetuPD3,
        RahuKetuPD3,
        JupiterKetuPD3,
        SaturnKetuPD3,
        MercuryKetuPD3,
        KetuKetuPD3,
        VenusKetuPD3,
        SunVenusPD3,
        MoonVenusPD3,
        MarsVenusPD3,
        RahuVenusPD3,
        JupiterVenusPD3,
        SaturnVenusPD3,
        MercuryVenusPD3,
        KetuVenusPD3,
        VenusVenusPD3,

        //SUKSHMA
        SunSunPD4,
        MoonSunPD4,
        MarsSunPD4,
        RahuSunPD4,
        JupiterSunPD4,
        SaturnSunPD4,
        MercurySunPD4,
        KetuSunPD4,
        VenusSunPD4,
        SunMoonPD4,
        MoonMoonPD4,
        MarsMoonPD4,
        RahuMoonPD4,
        JupiterMoonPD4,
        SaturnMoonPD4,
        MercuryMoonPD4,
        KetuMoonPD4,
        VenusMoonPD4,
        SunMarsPD4,
        MoonMarsPD4,
        MarsMarsPD4,
        RahuMarsPD4,
        JupiterMarsPD4,
        SaturnMarsPD4,
        MercuryMarsPD4,
        KetuMarsPD4,
        VenusMarsPD4,
        SunRahuPD4,
        MoonRahuPD4,
        MarsRahuPD4,
        RahuRahuPD4,
        JupiterRahuPD4,
        SaturnRahuPD4,
        MercuryRahuPD4,
        KetuRahuPD4,
        VenusRahuPD4,
        SunJupiterPD4,
        MoonJupiterPD4,
        MarsJupiterPD4,
        RahuJupiterPD4,
        JupiterJupiterPD4,
        SaturnJupiterPD4,
        MercuryJupiterPD4,
        KetuJupiterPD4,
        VenusJupiterPD4,
        SunSaturnPD4,
        MoonSaturnPD4,
        MarsSaturnPD4,
        RahuSaturnPD4,
        JupiterSaturnPD4,
        SaturnSaturnPD4,
        MercurySaturnPD4,
        KetuSaturnPD4,
        VenusSaturnPD4,
        SunMercuryPD4,
        MoonMercuryPD4,
        MarsMercuryPD4,
        RahuMercuryPD4,
        JupiterMercuryPD4,
        SaturnMercuryPD4,
        MercuryMercuryPD4,
        KetuMercuryPD4,
        VenusMercuryPD4,
        SunKetuPD4,
        MoonKetuPD4,
        MarsKetuPD4,
        RahuKetuPD4,
        JupiterKetuPD4,
        SaturnKetuPD4,
        MercuryKetuPD4,
        KetuKetuPD4,
        VenusKetuPD4,
        SunVenusPD4,
        MoonVenusPD4,
        MarsVenusPD4,
        RahuVenusPD4,
        JupiterVenusPD4,
        SaturnVenusPD4,
        MercuryVenusPD4,
        KetuVenusPD4,
        VenusVenusPD4,


        //PRANA
        SunSunPD5,
        MoonSunPD5,
        MarsSunPD5,
        RahuSunPD5,
        JupiterSunPD5,
        SaturnSunPD5,
        MercurySunPD5,
        KetuSunPD5,
        VenusSunPD5,
        SunMoonPD5,
        MoonMoonPD5,
        MarsMoonPD5,
        RahuMoonPD5,
        JupiterMoonPD5,
        SaturnMoonPD5,
        MercuryMoonPD5,
        KetuMoonPD5,
        VenusMoonPD5,
        SunMarsPD5,
        MoonMarsPD5,
        MarsMarsPD5,
        RahuMarsPD5,
        JupiterMarsPD5,
        SaturnMarsPD5,
        MercuryMarsPD5,
        KetuMarsPD5,
        VenusMarsPD5,
        SunRahuPD5,
        MoonRahuPD5,
        MarsRahuPD5,
        RahuRahuPD5,
        JupiterRahuPD5,
        SaturnRahuPD5,
        MercuryRahuPD5,
        KetuRahuPD5,
        VenusRahuPD5,
        SunJupiterPD5,
        MoonJupiterPD5,
        MarsJupiterPD5,
        RahuJupiterPD5,
        JupiterJupiterPD5,
        SaturnJupiterPD5,
        MercuryJupiterPD5,
        KetuJupiterPD5,
        VenusJupiterPD5,
        SunSaturnPD5,
        MoonSaturnPD5,
        MarsSaturnPD5,
        RahuSaturnPD5,
        JupiterSaturnPD5,
        SaturnSaturnPD5,
        MercurySaturnPD5,
        KetuSaturnPD5,
        VenusSaturnPD5,
        SunMercuryPD5,
        MoonMercuryPD5,
        MarsMercuryPD5,
        RahuMercuryPD5,
        JupiterMercuryPD5,
        SaturnMercuryPD5,
        MercuryMercuryPD5,
        KetuMercuryPD5,
        VenusMercuryPD5,
        SunKetuPD5,
        MoonKetuPD5,
        MarsKetuPD5,
        RahuKetuPD5,
        JupiterKetuPD5,
        SaturnKetuPD5,
        MercuryKetuPD5,
        KetuKetuPD5,
        VenusKetuPD5,
        SunVenusPD5,
        MoonVenusPD5,
        MarsVenusPD5,
        RahuVenusPD5,
        JupiterVenusPD5,
        SaturnVenusPD5,
        MercuryVenusPD5,
        KetuVenusPD5,
        VenusVenusPD5,


        //PD6
        SunSunPD6,
        MoonSunPD6,
        MarsSunPD6,
        RahuSunPD6,
        JupiterSunPD6,
        SaturnSunPD6,
        MercurySunPD6,
        KetuSunPD6,
        VenusSunPD6,
        SunMoonPD6,
        MoonMoonPD6,
        MarsMoonPD6,
        RahuMoonPD6,
        JupiterMoonPD6,
        SaturnMoonPD6,
        MercuryMoonPD6,
        KetuMoonPD6,
        VenusMoonPD6,
        SunMarsPD6,
        MoonMarsPD6,
        MarsMarsPD6,
        RahuMarsPD6,
        JupiterMarsPD6,
        SaturnMarsPD6,
        MercuryMarsPD6,
        KetuMarsPD6,
        VenusMarsPD6,
        SunRahuPD6,
        MoonRahuPD6,
        MarsRahuPD6,
        RahuRahuPD6,
        JupiterRahuPD6,
        SaturnRahuPD6,
        MercuryRahuPD6,
        KetuRahuPD6,
        VenusRahuPD6,
        SunJupiterPD6,
        MoonJupiterPD6,
        MarsJupiterPD6,
        RahuJupiterPD6,
        JupiterJupiterPD6,
        SaturnJupiterPD6,
        MercuryJupiterPD6,
        KetuJupiterPD6,
        VenusJupiterPD6,
        SunSaturnPD6,
        MoonSaturnPD6,
        MarsSaturnPD6,
        RahuSaturnPD6,
        JupiterSaturnPD6,
        SaturnSaturnPD6,
        MercurySaturnPD6,
        KetuSaturnPD6,
        VenusSaturnPD6,
        SunMercuryPD6,
        MoonMercuryPD6,
        MarsMercuryPD6,
        RahuMercuryPD6,
        JupiterMercuryPD6,
        SaturnMercuryPD6,
        MercuryMercuryPD6,
        KetuMercuryPD6,
        VenusMercuryPD6,
        SunKetuPD6,
        MoonKetuPD6,
        MarsKetuPD6,
        RahuKetuPD6,
        JupiterKetuPD6,
        SaturnKetuPD6,
        MercuryKetuPD6,
        KetuKetuPD6,
        VenusKetuPD6,
        SunVenusPD6,
        MoonVenusPD6,
        MarsVenusPD6,
        RahuVenusPD6,
        JupiterVenusPD6,
        SaturnVenusPD6,
        MercuryVenusPD6,
        KetuVenusPD6,
        VenusVenusPD6,


        //PD7
        SunSunPD7,
        MoonSunPD7,
        MarsSunPD7,
        RahuSunPD7,
        JupiterSunPD7,
        SaturnSunPD7,
        MercurySunPD7,
        KetuSunPD7,
        VenusSunPD7,
        SunMoonPD7,
        MoonMoonPD7,
        MarsMoonPD7,
        RahuMoonPD7,
        JupiterMoonPD7,
        SaturnMoonPD7,
        MercuryMoonPD7,
        KetuMoonPD7,
        VenusMoonPD7,
        SunMarsPD7,
        MoonMarsPD7,
        MarsMarsPD7,
        RahuMarsPD7,
        JupiterMarsPD7,
        SaturnMarsPD7,
        MercuryMarsPD7,
        KetuMarsPD7,
        VenusMarsPD7,
        SunRahuPD7,
        MoonRahuPD7,
        MarsRahuPD7,
        RahuRahuPD7,
        JupiterRahuPD7,
        SaturnRahuPD7,
        MercuryRahuPD7,
        KetuRahuPD7,
        VenusRahuPD7,
        SunJupiterPD7,
        MoonJupiterPD7,
        MarsJupiterPD7,
        RahuJupiterPD7,
        JupiterJupiterPD7,
        SaturnJupiterPD7,
        MercuryJupiterPD7,
        KetuJupiterPD7,
        VenusJupiterPD7,
        SunSaturnPD7,
        MoonSaturnPD7,
        MarsSaturnPD7,
        RahuSaturnPD7,
        JupiterSaturnPD7,
        SaturnSaturnPD7,
        MercurySaturnPD7,
        KetuSaturnPD7,
        VenusSaturnPD7,
        SunMercuryPD7,
        MoonMercuryPD7,
        MarsMercuryPD7,
        RahuMercuryPD7,
        JupiterMercuryPD7,
        SaturnMercuryPD7,
        MercuryMercuryPD7,
        KetuMercuryPD7,
        VenusMercuryPD7,
        SunKetuPD7,
        MoonKetuPD7,
        MarsKetuPD7,
        RahuKetuPD7,
        JupiterKetuPD7,
        SaturnKetuPD7,
        MercuryKetuPD7,
        KetuKetuPD7,
        VenusKetuPD7,
        SunVenusPD7,
        MoonVenusPD7,
        MarsVenusPD7,
        RahuVenusPD7,
        JupiterVenusPD7,
        SaturnVenusPD7,
        MercuryVenusPD7,
        KetuVenusPD7,
        VenusVenusPD7,


        //PD8
        SunSunPD8,
        MoonSunPD8,
        MarsSunPD8,
        RahuSunPD8,
        JupiterSunPD8,
        SaturnSunPD8,
        MercurySunPD8,
        KetuSunPD8,
        VenusSunPD8,
        SunMoonPD8,
        MoonMoonPD8,
        MarsMoonPD8,
        RahuMoonPD8,
        JupiterMoonPD8,
        SaturnMoonPD8,
        MercuryMoonPD8,
        KetuMoonPD8,
        VenusMoonPD8,
        SunMarsPD8,
        MoonMarsPD8,
        MarsMarsPD8,
        RahuMarsPD8,
        JupiterMarsPD8,
        SaturnMarsPD8,
        MercuryMarsPD8,
        KetuMarsPD8,
        VenusMarsPD8,
        SunRahuPD8,
        MoonRahuPD8,
        MarsRahuPD8,
        RahuRahuPD8,
        JupiterRahuPD8,
        SaturnRahuPD8,
        MercuryRahuPD8,
        KetuRahuPD8,
        VenusRahuPD8,
        SunJupiterPD8,
        MoonJupiterPD8,
        MarsJupiterPD8,
        RahuJupiterPD8,
        JupiterJupiterPD8,
        SaturnJupiterPD8,
        MercuryJupiterPD8,
        KetuJupiterPD8,
        VenusJupiterPD8,
        SunSaturnPD8,
        MoonSaturnPD8,
        MarsSaturnPD8,
        RahuSaturnPD8,
        JupiterSaturnPD8,
        SaturnSaturnPD8,
        MercurySaturnPD8,
        KetuSaturnPD8,
        VenusSaturnPD8,
        SunMercuryPD8,
        MoonMercuryPD8,
        MarsMercuryPD8,
        RahuMercuryPD8,
        JupiterMercuryPD8,
        SaturnMercuryPD8,
        MercuryMercuryPD8,
        KetuMercuryPD8,
        VenusMercuryPD8,
        SunKetuPD8,
        MoonKetuPD8,
        MarsKetuPD8,
        RahuKetuPD8,
        JupiterKetuPD8,
        SaturnKetuPD8,
        MercuryKetuPD8,
        KetuKetuPD8,
        VenusKetuPD8,
        SunVenusPD8,
        MoonVenusPD8,
        MarsVenusPD8,
        RahuVenusPD8,
        JupiterVenusPD8,
        SaturnVenusPD8,
        MercuryVenusPD8,
        KetuVenusPD8,
        VenusVenusPD8,

        #endregion

        #region TRAVEL

        GoodLunarDayForTravel,
        BadLunarDayForTravel,
        GoodConstellationForTravel,
        BadConstellationForTravel,
        BadWeekdayForTravelNorth,
        BadWeekdayForTravelWest,
        BadWeekdayForTravelSouth,
        BadWeekdayForTravelEast,
        GoodLagnaForTravel,
        BestLagnaForTravel,
        WorstLagnaForTravel,
        BadLagnaForTravel,
        GoodPlanetsInLagnaForTravel,
        GoodMoonJupiterTravelYoga,
        FortifiedMoonTravelYoga,
        StrongJupiterTravelYoga,
        EasyPeacefulTravelYoga,
        NeutralizeBadTravelYoga,
        StrongBeneficsTravelYoga,
        IdealPlanetsTravelYoga,

        #endregion

        #region PANCHA PAKSHI

        BirdRuling,
        BirdEating,
        BirdWalking,
        BirdSleeping,
        BirdDying,

        #endregion

        #region GHATAKA CHAKRA

        GhatakaMoonSign,
        GhatakaTithiGroup,
        GhatakaWeekDay,
        GhatakaMoonConstellation,
        GhatakaLagna,

        #endregion
    }
}