@ok k2_skip
<?php

function get_cert_data() : string {
  return "-----BEGIN CERTIFICATE-----
MIIDazCCAlOgAwIBAgIUGueadw4P4qBbd4ZcVxGKRdh2xaYwDQYJKoZIhvcNAQEL
BQAwRTELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUxITAfBgNVBAoM
GEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDAeFw0yMDEwMjExMzI4MzhaFw0yMTEw
MjExMzI4MzhaMEUxCzAJBgNVBAYTAkFVMRMwEQYDVQQIDApTb21lLVN0YXRlMSEw
HwYDVQQKDBhJbnRlcm5ldCBXaWRnaXRzIFB0eSBMdGQwggEiMA0GCSqGSIb3DQEB
AQUAA4IBDwAwggEKAoIBAQCwVgkvzmAZkmMNCkcu1WTNFoFt352RM3TEuOsHZySR
Mk+5Mwc1lwokbKw3gjIN794xGNWcGHeg4iR7bOOPvmfNYgsqcnTHDCG1A3YJB9D+
JwPKV1Kk+23JfqLJ35RuFQzBF7YH+CVV5/1KiJhie6SVtF7EP4kKPMiH9j4Xs7IV
MyAN6kqdQNznNeDt4Q3L4nuWmsSNk+z5eZpRLG8A16uZXXWXnGyKqwutw09zMqdu
1kPy/fpJt8ftbj4uiP/He/cs2K4Us2kyYj30UA9jpvDvQcRBcU0AxA1DEO8jnX2W
3aY5R2KIvf8g+MYYBaDLkZr5Ro3+VooBtLHWFMRQhvQDAgMBAAGjUzBRMB0GA1Ud
DgQWBBSH0c+M4Eivckk1aqQwU34VWlg85zAfBgNVHSMEGDAWgBSH0c+M4Eivckk1
aqQwU34VWlg85zAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAb
1NzCrBanG9w+VB+lIBJpnsy8gpPcZrXvgqzXnRFRp7LZXwZjqyKxwxzB9ik6dTxg
ck1fqpArUwLnjI7qzBKQaZc/7hX4jOVPXSz+7Yef1gdGzQaGSv8+L/Q6Z1jCO94y
MT7L4T6XXPK034+9SkSN17OT1sKNIn30ZuIU2pJCyxESE96PQAfZ3/kSoI+N4Edx
8nXNmxIxur4vcIeIqfTyodQmyTWzqpMwzltermP9y12lWf9Oxwy07VPDqLfpeeC2
8ft2o8gj7Xa5BdWzdJ/JPBGXodQbT+OuYhH2E+GVb8xu1cb4Dr7hpy5Y+mwG0tR5
SwD3IhxiqzidJOkIFPyT
-----END CERTIFICATE-----
";
}

function get_private_key_data() : string {
  return "-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCwVgkvzmAZkmMN
Ckcu1WTNFoFt352RM3TEuOsHZySRMk+5Mwc1lwokbKw3gjIN794xGNWcGHeg4iR7
bOOPvmfNYgsqcnTHDCG1A3YJB9D+JwPKV1Kk+23JfqLJ35RuFQzBF7YH+CVV5/1K
iJhie6SVtF7EP4kKPMiH9j4Xs7IVMyAN6kqdQNznNeDt4Q3L4nuWmsSNk+z5eZpR
LG8A16uZXXWXnGyKqwutw09zMqdu1kPy/fpJt8ftbj4uiP/He/cs2K4Us2kyYj30
UA9jpvDvQcRBcU0AxA1DEO8jnX2W3aY5R2KIvf8g+MYYBaDLkZr5Ro3+VooBtLHW
FMRQhvQDAgMBAAECggEBAKsbsWpsTiBCRk9fC9fMRjYkgo+Fj7ZYQhSqg5X5Zihm
s6m4dGRyHetecHakpcGUYv0tZgpES8EX7+K8tMzFLKDFZKRZ0CteAE9P/neg2BHm
9eygc5eYSt5dPcW6aKOxVWEBiyeMiV4k8Uoj5gqahAior9Sq+mWuucAFGBeTzVh3
WH9HXD4f8/oh/mye3YnsiqSD8j3IbhI6PslMxWeWIn82ZC02TV0D6m3GYX3ZGv0q
ZWNyHZ/2G7ULkqn8CgDFxWFmIzvrBuFTglEwpMob+6E7hxeKmW/ADBqHnLIEcnwH
Ypp9Y7oRyiI/0tY8+W1kgVfIkvH7IoK6gOdYVRm+ZDECgYEA4x4DGZUYLCSGTAbS
E4dNDkIbVxXbf+WFfRKVO2vHIJKqZBSESuC6YE2svQiw58DxZSAi8cyeaJeX7VhF
muhDK3rIYdiXx25g2HPTSQXkF4rYcWw2ESUmG2FFnuTBTBu8So4HSWS9l8Wju3uC
Ety2Pm3TmhTXcyX6ulkGqzFs+lUCgYEAxsLNMlBmg6Zk/oe6hW1zXFaKVXHAek2f
RJeIWjvqvCHeR+5O+R0CS6QqL/NTCoVeDY1/YitVXs6tu0ICCRQR7KsFWpTi1h7P
3BNHXTdYqiTFZPOb/NlIw9wYXYgEAPq5aHqMqb13DTVvmwoS21nGgZpHidhSu+PI
Dr+oGOdfvPcCgYBlgB8wirJf3/7o8U9njNtCGQcw90K+uOvchraM9NDsXL+rtIOf
FyoUKgKeBMlS+aaoZCFZ4PGWmtE6MG4DGfQS9W+iUvMaHNlJQxJVGz3hy5qJrivH
o8uRBvrfVSqSAf83bpwRD+Wvc5OGEV+DYIJOCjU8Mj5LZtjT+T+CuLcUdQKBgCiH
AfYXZL/FRuSLYmHgblxOnQhNGHUXrLj8uOXFP9i6gythkSLEYnpv79Y1JCKKDSJw
TqACu/aH5+69x9J4ECuUt5O/tfz47WMvXybHqUGQG9u4vH6zA15EW4d+u2pDtVhz
XIkjw8misq4HQM8PICW/AoU94ajECj/PnoPtcZ0DAoGBALsZ6etnJYC6RFrq6tkC
Sp2iHd4lfQVx0e9AdmRpT4L2HJlQnCqNkxopL4hyuvopJbKIqydogCoJTZlUZzId
6UYF4ksoNizHeI2XvfFH6vnVHlV0P7xsPwV2Iy6EFE0vikLjznztvHylRbJSqys2
e17/wWykWuwfLx6ThU3D/iSY
-----END PRIVATE KEY-----
";
}

/**
 * @param $priv_key mixed - always string in KPHP and string|resource in PHP
 * @param $headers string[]
 */
function openssl_pkcs7_sign_test_wrapper(string $infile, string $outfile,
                                         string $sign_cert, $priv_key,
                                         array $headers, int $flags) {
  var_dump(openssl_pkcs7_sign($infile, $outfile, $sign_cert, $priv_key, $headers, $flags));
  if ($outfile) {
    $signed_data = file_get_contents($outfile);
    var_dump(strpos($signed_data, file_get_contents($infile)));
    var_dump(strlen($signed_data));
    
  }
}

function test_openssl_pkcs7_sign() {
  $infile = "test_openssl_pkcs7_sign_in_file";
  file_put_contents($infile, "test_cert_from_data");

  $outfile = "test_openssl_pkcs7_sign_out_file";
  $test_flags = [
    0,
    PKCS7_DETACHED,
    PKCS7_DETACHED | PKCS7_NOVERIFY,
    PKCS7_DETACHED | PKCS7_BINARY | PKCS7_NOATTR,
    PKCS7_DETACHED | PKCS7_NOCHAIN | PKCS7_NOATTR
  ];
  $test_headers = [
    [],
    ["hello" => "world"],
    ["hello", "world"],
    ["hello", "world", "hello" => "world"]
  ];

  foreach($test_flags as $flags) {
    foreach($test_headers as $headers) {
      openssl_pkcs7_sign_test_wrapper($infile, $outfile, get_cert_data(), get_private_key_data(), $headers, $flags);
    }
  }

  $cert_file = "test_openssl_pkcs7_sign_cert";
  file_put_contents($cert_file, get_cert_data());
  foreach($test_flags as $flags) {
    foreach($test_headers as $headers) {
      openssl_pkcs7_sign_test_wrapper($infile, $outfile, "file://$cert_file", openssl_pkey_get_private(get_private_key_data()), $headers, $flags);
    }
  }
}

test_openssl_pkcs7_sign();
