@ok
<?php

$certificate = <<<EOF
-----BEGIN CERTIFICATE-----
MIIDazCCAlOgAwIBAgIUM2N/ghpbi9B4S2PNcmKylVu6qNAwDQYJKoZIhvcNAQEL
BQAwRTELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUxITAfBgNVBAoM
GEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDAeFw0yMDEwMjExMzM3MTlaFw0yMTEw
MjExMzM3MTlaMEUxCzAJBgNVBAYTAkFVMRMwEQYDVQQIDApTb21lLVN0YXRlMSEw
HwYDVQQKDBhJbnRlcm5ldCBXaWRnaXRzIFB0eSBMdGQwggEiMA0GCSqGSIb3DQEB
AQUAA4IBDwAwggEKAoIBAQDJ4L96idNQxd0zIcbHnAm0TAD+P9j1j/aMBW/Xqq/N
wdnUzCaj5sXP7wPemXOa1adyZZPf+y6N/BRmROQTHQ5ACq5aC8bj9j+iIh1sr8wy
q2ulv2I5ya+EijEdI+aV9PPaw4ZjwFVLhsimpCqUGg6xewRIE1bfpvkFDTh3t+x+
934xeZrLQjybq8jhyGUxpPVmm7qIgMg3h29ubJs+dEn8tnf+cM9tk3gZXcpnUmm7
hhyvH+mf3cGHsnW/WZ+/Di1IUPqJPw744bpPAZfSAqOWypu2/XZRedvwa9KBfY/N
EPqp2fD3sKNURhxPg4nrjIu24zDyJY4rAchhLDB/j67dAgMBAAGjUzBRMB0GA1Ud
DgQWBBRBB1A15ReS/WLe8mkhRRLmt0fMkzAfBgNVHSMEGDAWgBRBB1A15ReS/WLe
8mkhRRLmt0fMkzAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQB1
5c1r8ys83G4ZPbDijmDAYMiTn6dpj5QZVQzJ6+Ii0sHQC3G81dKVwi+kjv4wd8Qx
sr/xhhEGYz/HXNsic1kNJesem0eiqEadj2I4l/VKPpF7k/mfVdJRMmmSSoQjeHBD
Bh2s3EGrZKzs0iEUl6/dzWoCv0xcXB5/g1nsTFEpF6rH8OQg+tNxpzEGz7gYBg6w
dWA/yDkCSRBAhGRlxJ9UQVpLr/tDn0x53QqfC6mq4wH73ghlHlWNrDDmAQLcF1ZK
mcbr89vkJ9wrPacySkwkMRAdO0+lWaznwjbEwTUK/0QZWysJPUw0phqsYyTn0KFi
nvYpS4Nc4toUevFuCxqv
-----END CERTIFICATE-----
EOF;

$private_key = <<<EOF
-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDJ4L96idNQxd0z
IcbHnAm0TAD+P9j1j/aMBW/Xqq/NwdnUzCaj5sXP7wPemXOa1adyZZPf+y6N/BRm
ROQTHQ5ACq5aC8bj9j+iIh1sr8wyq2ulv2I5ya+EijEdI+aV9PPaw4ZjwFVLhsim
pCqUGg6xewRIE1bfpvkFDTh3t+x+934xeZrLQjybq8jhyGUxpPVmm7qIgMg3h29u
bJs+dEn8tnf+cM9tk3gZXcpnUmm7hhyvH+mf3cGHsnW/WZ+/Di1IUPqJPw744bpP
AZfSAqOWypu2/XZRedvwa9KBfY/NEPqp2fD3sKNURhxPg4nrjIu24zDyJY4rAchh
LDB/j67dAgMBAAECggEAa1HneSU8CXymk0AphIQXRJoDDSa0GBdoYheh1W0P+LpN
Kys8f3V3Q4s062l4Y5+hXNdTPYcywJh538RP2zlfEfybo5MPMLEAMxkfu1/ZljY7
C+oqNb5aaINuiKdFNgL6gBnhn7XnojcNBEnRuNoBZaiYJhjh3hPN3jmhA0PrnbLS
P09LuUu4hl0jAnVjyWZZz5JtBas/xtvxTjmHHuXJh7yoAQ2RAvnhWTSwvTpwxekC
ivHecit9LqnW4DrR2E2JLrJ0sWtjEt5hfH+DB2LBUuyPgC1zw6kf/kWSMZuNrGlw
FlFECyA8IF9AGsC3GZ7MobN16rtSySUqFpXzlBSloQKBgQDzwK8sn4YNg0ftCb/D
wJ0ezAiIkNqSE/MvoqKpVZp5m6SJpWQ1rfFLhQY8DNtl4zxeiFoPaQvq41cEI4wp
FFs8wdBn3bebrCfkcL+hwQbUF4NRUvZj/sFVgIxri/DoASWcQ4umwSVC0KnQoiQ7
Ce+tstnfLM+vdL27FfWDMWa/XwKBgQDUBXEO0glLPK0mrXjNL1qy4QZRPT8Q6fHF
kfv9Ik33T80ZGZTYLBEf6x7B5Fiymquc+AIJNfuFNjR9HWgbPHxCrEXh8Jk6hzRO
pWg7f0bfCG9N0vk6hcRuZjD9VQeTdTiTmZ0KsfUTCJyWBeS7YKiE5aUY4dYJAL6I
LnfpA5AHQwKBgQDZPcyh/5bw6iUrfHndlAg0j3G3jSpP8NnXhaJlOvcPFQli5/XU
5a7dOLSixm6vcwO12N4zR9MoR++gr7HWVt8t2irMt01Rv/BZ56bTGf7k/gO6ci9I
VZ+nfYcovrM5gvQrPgPz3cZAs0n1uNyDhcqIS5NkFUMQRAJpABwtDdVeDwKBgEZz
nHLRRjdS7TJp+DcuIhRIg8Hg+SDUq/r7nGEr0f547O0HPBds5S/W//xrtTF8BcR+
AKcw4egM7/oXGG3cdmntNrdyLGhvXuk3O2Bx1YntEpcooJpassAAgwzbAU51aBxb
sfxIz+fIN8f+I1hEMRsf9/FBsc6CCc3UqxGplmVjAoGAbsfPjBWeZwnvXJKit/7m
zq/Yb5nPZaOj3+ThE3lkj1YbLi0uikwBSq6qOH7FAlU4dNFw3lDi3Dv+B/bkCQHV
X0PiNUXzW3XI5upkKFEywZoalo1I0PbnQ8O6xPJtr/qwU/epH6IvNe2VH57F6zHt
F8Q1HP10FI4YYEnQ3a7JK18=
-----END PRIVATE KEY-----
EOF
;

$public_key = <<<EOF
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyeC/eonTUMXdMyHGx5wJ
tEwA/j/Y9Y/2jAVv16qvzcHZ1Mwmo+bFz+8D3plzmtWncmWT3/sujfwUZkTkEx0O
QAquWgvG4/Y/oiIdbK/MMqtrpb9iOcmvhIoxHSPmlfTz2sOGY8BVS4bIpqQqlBoO
sXsESBNW36b5BQ04d7fsfvd+MXmay0I8m6vI4chlMaT1Zpu6iIDIN4dvbmybPnRJ
/LZ3/nDPbZN4GV3KZ1Jpu4Ycrx/pn93Bh7J1v1mfvw4tSFD6iT8O+OG6TwGX0gKj
lsqbtv12UXnb8GvSgX2PzRD6qdnw97CjVEYcT4OJ64yLtuMw8iWOKwHIYSwwf4+u
3QIDAQAB
-----END PUBLIC KEY-----
EOF;


$data = "Hello, world!";

$signature_sha1 = "";
$signature_md5 = "";

openssl_sign($data, $signature_sha1, $private_key);
openssl_sign($data, $signature_md5, $private_key, OPENSSL_ALGO_MD5);

var_dump(base64_encode($signature_sha1));
var_dump(base64_encode($signature_md5));

var_dump(openssl_verify($data, $signature_sha1, $public_key));
var_dump(openssl_verify($data, $signature_md5, $public_key, OPENSSL_ALGO_MD5));

var_dump(openssl_verify($data, $signature_sha1, $public_key, OPENSSL_ALGO_MD5));
var_dump(openssl_verify($data, $signature_md5, $public_key));

$signature_sha1[0] = 10;
$signature_md5[0] = 10;
var_dump(openssl_verify($data, $signature_sha1, $public_key));
var_dump(openssl_verify($data, $signature_md5, $public_key, OPENSSL_ALGO_MD5));

