// Compiler for PHP (aka KPHP)
// Copyright (c) 2020 LLC «V Kontakte»
// Distributed under the GPL v3 License, see LICENSE.notice.txt

#pragma once

#include <cstddef>

class PhpScriptMutableGlobals;

struct script_t {
  void (*run)();   // this is entrypoint to generated code
  void (*clear)(PhpScriptMutableGlobals &php_globals);
};

/// Initializes const variables represented as globals C++ symbols. Definition is generated by compiler.
void init_php_scripts_once_in_master() noexcept;
/// Initializes mutable globals in a single linear memory piece.
void init_php_scripts_in_each_worker(PhpScriptMutableGlobals &php_globals) noexcept;

script_t *get_script();
/// It's called from init_php_scripts() and set the entrypoint to generated code
void set_script(void (*run)(), void (*clear)(PhpScriptMutableGlobals &php_globals));

struct script_result {
  const char *headers;
  int headers_len;
  const char *body;
  int body_len;
  int exit_code;
};

