#include "runtime/memory_usage.h"

#include "runtime/php-script-globals.h"

// a strong implementation is codegenerated by the compiler if env KPHP_ENABLE_GLOBAL_VARS_MEMORY_STATS
array<int64_t> __attribute__ ((weak)) globals_memory_stats_impl(int64_t lower_bound, const PhpScriptMutableGlobals &php_globals) noexcept;

array<int64_t> f$get_global_vars_memory_stats(int64_t lower_bound) {
  if (!globals_memory_stats_impl) {
    php_warning("called get_global_vars_memory_stats(), but the binary was compiled without KPHP_ENABLE_GLOBAL_VARS_MEMORY_STATS");
    return {};
  }
  return globals_memory_stats_impl(lower_bound, PhpScriptMutableGlobals::current());
}
