// Compiler for PHP (aka KPHP)
// Copyright (c) 2020 LLC «V Kontakte»
// Distributed under the GPL v3 License, see LICENSE.notice.txt

#pragma once

#include "runtime-light/coroutine/task.h"

class PhpScriptMutableGlobals;

/// Initializes const variables represented as globals C++ symbols. Definition is generated by compiler.
void init_php_scripts_once_in_master() noexcept;
/// Initializes mutable globals. Definition is generated by compiler.
void init_php_scripts_in_each_worker(PhpScriptMutableGlobals &php_globals, task_t<void> &run) noexcept;
