<?php

/**
 * Auto-generated for vk-flex-data-gen.php file
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */

/**
 * Возвращает правила для склонения одного из языков flex
 *
 * @param int $lang_id
 * @param array $language_config
 *
 * @return array
 */
function setupFlexNew($lang_id, $language_config) {
  switch ($lang_id) {
    // Русский
    case 0:

      $language_config['flexible_symbols'] = 'АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЭЮЯабвгдеёжзийклмнопрстуфхцчшщьэюя';

      $language_config['names'] = [
        [
          'patterns' => ['*ь'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'и', 'Acc' => 'ь', 'Ins' => 'ью', 'Abl' => 'и'],
        ],
        [
          'patterns' => ['Гюзель', 'Гузель', 'Айгуль', 'Айгюль', 'Гюнэль', 'Гюнель', 'Аревик', 'Севиль', 'Астхик', 'Шагик', 'Татевик', 'Сатеник', 'Манушак', 'Анушик', 'Хасмик', 'Назик', 'Кайцак', 'Ардак', 'Арпик', 'Гюзяль', 'Жибек', 'Асель', 'Николь', 'Аниель', 'Асмик', 'Ола', 'Эттель', 'Илль', 'Амель', 'Абигаль', '*хаяа', 'Ассоль', 'Нинель', 'Асаль', 'Айсель', 'Изабель', 'Фаягуль', 'Анель', 'Аннель', 'Эстель', 'Мариэль', 'Акпеиль', 'Джансель', 'Николя', 'Айгузель', 'Сюмбель', 'Темптель'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*гуль', '*гюль'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Даниэл(ь)', 'Мишел(ь)', 'Марсел(ь)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Аревик()', 'Астхик()', 'Шагик()', 'Татевик()', 'Сатеник()', 'Манушак()', 'Анушик()', 'Хасмик()', 'Назик()', 'Кайцак()', 'Ардак()', 'Арпик()', 'Жибек()', 'Асмик()', 'Айчурок()', 'Дондок()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*о', '*у', '*ы', '*э', '*ё', '*ю', '*и', '*е', '*О', '*У', '*Ы', '*Э', '*Ё', '*Ю', '*И', '*Е'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*у(а)', '*и(а)', '*э(а)', '*е(а)', '*ю(а)', '*а(а)', '*о(а)'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*й'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ий'],
          'male'     => ['Gen' => 'ия', 'Dat' => 'ию', 'Acc' => 'ия', 'Ins' => 'ием', 'Abl' => 'ии'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*я'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*ия', 'Ліл(ія)'],
          'male'     => ['Gen' => 'ии', 'Dat' => 'ие', 'Acc' => 'ию', 'Ins' => 'ией', 'Abl' => 'ие'],
          'female'   => ['Gen' => 'ии', 'Dat' => 'ии', 'Acc' => 'ию', 'Ins' => 'ией', 'Abl' => 'ии'],
        ],
        [
          'patterns' => ['Али(я)', 'Нажи(я)', 'Гали(я)', 'Альфи(я)', 'Балхи(я)', 'Нури(я)', 'Зульфи(я)', 'Ади(я)', 'Кадри(я)', 'Дани(я)', 'Гвазба(я)', 'Зали(я)', 'Гульфи(я)', 'Руми(я)', 'Раушани(я)', 'Сани(я)', 'Рани(я)', 'Аси(я)', 'Нази(я)', 'Рамзи(я)', 'Марзи(я)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*а'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*к(а)', '*х(а)', '*г(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*ш(а)', '*ж(а)', '*ч(а)', '*щ(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ей', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ей', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*ца'],
          'male'     => ['Gen' => 'цы', 'Dat' => 'це', 'Acc' => 'цу', 'Ins' => 'цей', 'Abl' => 'це'],
          'female'   => ['Gen' => 'цы', 'Dat' => 'це', 'Acc' => 'цу', 'Ins' => 'цей', 'Abl' => 'це'],
        ],
        [
          'patterns' => ['Миляуш(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Пётр'],
          'male'     => ['Gen' => 'Петра', 'Dat' => 'Петру', 'Acc' => 'Петра', 'Ins' => 'Петром', 'Abl' => 'Петре'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Павел'],
          'male'     => ['Gen' => 'Павла', 'Dat' => 'Павлу', 'Acc' => 'Павла', 'Ins' => 'Павлом', 'Abl' => 'Павле'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Лев'],
          'male'     => ['Gen' => 'Льва', 'Dat' => 'Льву', 'Acc' => 'Льва', 'Ins' => 'Львом', 'Abl' => 'Льве'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а(ёк)', '*о(ёк)', '*у(ёк)', '*е(ёк)', '*и(ёк)'],
          'male'     => ['Gen' => 'йка', 'Dat' => 'йку', 'Acc' => 'йка', 'Ins' => 'йком', 'Abl' => 'йке'],
          'female'   => ['Gen' => 'йка', 'Dat' => 'йку', 'Acc' => 'йка', 'Ins' => 'йком', 'Abl' => 'йке'],
        ],
        [
          'patterns' => ['*ёк', 'Жен(ек)'],
          'male'     => ['Gen' => 'ька', 'Dat' => 'ьку', 'Acc' => 'ька', 'Ins' => 'ьком', 'Abl' => 'ьке'],
          'female'   => ['Gen' => 'ька', 'Dat' => 'ьку', 'Acc' => 'ька', 'Ins' => 'ьком', 'Abl' => 'ьке'],
        ],
        [
          'patterns' => ['*ок', '*що(к)', 'Альто(к)', 'Ено(к)', 'Шерло(к)'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ке'],
          'female'   => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ке'],
        ],
        [
          'patterns' => ['Юрец'],
          'male'     => ['Gen' => 'Юрца', 'Dat' => 'Юрцу', 'Acc' => 'Юрца', 'Ins' => 'Юрцом', 'Abl' => 'Юрце'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Тореш()', 'Януш()', 'Куаныш()', 'Антош()', 'Сурадж()', 'Жорж()', 'Серж()', 'Тадеуш()', 'Жениш()', 'Франц()', 'Артюш()', 'Драгош()', 'Абуш()', 'Саяш()', 'Рич()', 'Томаш()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ем', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Сейт-', 'Аль-', 'Ка-', 'Нур-', 'Ир-', 'У', '&#1240;л-', 'Ава-'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Олч(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['Жан-', 'Пак-'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Иль(я)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'ю', 'Ins' => 'ёй', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Илия'],
          'male'     => ['Gen' => 'Илии', 'Dat' => 'Илии', 'Acc' => 'Илию', 'Ins' => 'Илией', 'Abl' => 'Илии'],
          'female'   => 'fixed',
        ],
      ];

      $language_config['surnames'] = [
        [
          'patterns' => ['*о', '*у', '*ы', '*э', '*ё', '*ю', '*и', '*е', '*О', '*У', '*Ы', '*Э', '*Ё', '*Ю', '*И', '*Е', 'Б'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*я', 'Панцула(я)', 'Качиба(я)', 'Сама(я)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['Цхака(я)', 'Баркла(я)', 'Арча(я)', 'Сана(я)', 'Бера(я)', 'Закара(я)', 'Ахала(я)', 'Ка(я)', 'Цома(я)', 'Шва(я)', 'Пла(я)', 'Саа(я)', 'Гурцка(я)', 'Ма(я)', 'Саджа(я)', 'Шула(я)', 'Ха(я)', 'Гузали(я)', 'Герга(я)', 'Зухба(я)', 'Кецба(я)', 'Багба(я)', 'Кишмара(я)', 'Цула(я)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*ая', '*иньск(а)', '*инськ(а)'],
          'male'     => ['Gen' => 'аи', 'Dat' => 'ае', 'Acc' => 'аю', 'Ins' => 'аей', 'Abl' => 'ае'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'ую', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['*ж(ая)', '*ш(ая)', '*щ(ая)', '*ч(ая)', '*ц(ая)'],
          'male'     => ['Gen' => 'аи', 'Dat' => 'ае', 'Acc' => 'аю', 'Ins' => 'аей', 'Abl' => 'ае'],
          'female'   => ['Gen' => 'ей', 'Dat' => 'ей', 'Acc' => 'ую', 'Ins' => 'ей', 'Abl' => 'ей'],
        ],
        [
          'patterns' => ['Чуж(ая)'],
          'male'     => ['Gen' => 'аи', 'Dat' => 'ае', 'Acc' => 'аю', 'Ins' => 'аей', 'Abl' => 'ае'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'ую', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['*яя'],
          'male'     => 'fixed',
          'female'   => ['Gen' => 'ей', 'Dat' => 'ей', 'Acc' => 'юю', 'Ins' => 'ей', 'Abl' => 'ей'],
        ],
        [
          'patterns' => ['*ия'],
          'male'     => ['Gen' => 'ии', 'Dat' => 'ии', 'Acc' => 'ию', 'Ins' => 'ией', 'Abl' => 'ии'],
          'female'   => ['Gen' => 'ии', 'Dat' => 'ии', 'Acc' => 'ию', 'Ins' => 'ией', 'Abl' => 'ии'],
        ],
        [
          'patterns' => ['Тун-Куй-Сю', 'Мякеля', 'Лямся', 'Талья', 'Луя', 'Рейня', 'Ростобая', 'Пелля', 'Время', 'Орава', 'Лапика', 'Дега', 'Титма', 'Ковыла', 'Мантула', 'Прока', 'Олусаньа', 'Хун', 'Гетия', 'Ча', 'Ма', 'Ойя', 'Вака', 'Шайя', 'Шна', 'Лукка', 'Ха', 'Ю', 'Аль', 'Дя', 'Хестонна', 'И', 'Карвосеноя', 'Совесть', 'Осень', 'С', 'Навсегда', 'Нега', 'Гершпигель', 'Гершпигель', 'Хыа', 'Ялыця'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а', 'Федын(а)', 'Вев(а)', 'Сачдев(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['Шмыгована', 'Лукасишен(а)', '*ов(а)', '*ев(а)', '*єв(а)', '*ёв(а)', '*ын(а)', '*ин(а)', 'ін(а)', 'Клеен(а)', 'Мартынив(а)', 'Анофен(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['*ськ(а)', '*цьк(а)', 'Швидк(а)', 'Будзинськ(а)', 'Скульск(а)'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'у', 'Ins' => 'ом', 'Abl' => 'е'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'ую', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['Ирчишен(а)', 'Вавричен(а)', 'Бикбаув(а)', 'Сахаув(а)', 'Мазав(а)', 'Зайв(а)', 'Молод(а)', 'Пылыпив(а)', 'Мазнив(а)', 'Алдушен(а)', 'Якимыв(а)', 'Якымив(а)', 'Панчишен(а)', 'Демчучен(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['Бов(а)', 'Сов(а)', 'Худын(а)', 'Щербин(а)', 'Калин(а)', 'Былин(а)', 'Медын(а)', 'Колеин(а)', 'Нов(а)', 'Яцин(а)', 'Кев(а)', 'Кручин(а)', 'Молин(а)', 'Рев(а)', 'Чуприн(а)', 'Дубын(а)', 'Пузын(а)', 'Бров(а)', 'Тычин(а)', 'Бобын(а)', 'Дубин(а)', 'Яцын(а)', 'Годын(а)', 'Мац(а)', 'Триголов(а)', 'Мин(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*у(а)', '*и(а)', '*э(а)', '*е(а)', '*ю(а)', '*а(а)', '*о(а)', '*я(а)'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*к(а)', '*х(а)', '*г(а)', 'Левш(а)', 'Ш(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*ш(а)', '*ж(а)', '*ч(а)', '*щ(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ей', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ей', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['Кваш(а)', 'Ганж(а)', 'Уш(а)', 'Ханаш(а)', 'Кривш(а)', 'Камш(а)', 'Гаранж(а)', 'Украин(а)', 'Кеж(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*ца'],
          'male'     => ['Gen' => 'цы', 'Dat' => 'це', 'Acc' => 'цу', 'Ins' => 'цей', 'Abl' => 'це'],
          'female'   => ['Gen' => 'цы', 'Dat' => 'це', 'Acc' => 'цу', 'Ins' => 'цей', 'Abl' => 'це'],
        ],
        [
          'patterns' => ['Дюм(а)', 'Петип(а)', 'Кешелав(а)', 'Малек(а)', 'Рошк(а)', 'Ракш(а)', 'Гар(а)', 'Шкут(а)', 'Куял(а)', 'Соум(а)', 'Том(а)', 'Коуги(я)', 'Тальм(а)', 'Опар(а)', 'Ф(а)', 'Бег(а)', 'Туг(а)', 'Дюб(а)', 'Баркала(я)', 'Гор(я)', 'Кабей(а)', 'Харчилав(а)', 'И', 'Тикк(а)', 'Гавв(а)', 'Карвасено(я)', 'Р(а)', 'Барр(а)', 'Зол(я)', 'Сал(я)', 'Усть', 'Гр(а)', 'Кеньо', 'Бова', 'Ката(я)', 'Уккол(а)', 'Хайкар(а)'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Далек(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'е'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'ую', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['*ч(ь)'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ем', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ь'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ень', 'Уласе(нь)', 'Пиве(нь)', 'Се(нь)', 'Ме(нь)', 'Хебе(нь)', 'Ште(нь)', 'Дре(нь)', 'Косте(нь)', 'Бирасте(нь)', 'Тристе(нь)', 'Шерше(нь)', 'Бе(нь)', 'Безде(нь)', 'Глуше(нь)', 'Дере(нь)', 'Липе(нь)', 'Дубе(нь)', 'Равге(нь)', 'Пиве(нь)', 'Ле(нь)', 'Цире(нь)', 'Говоре(нь)', 'Петре(нь)', 'Бре(нь)', 'Сеге(нь)', 'Тюре(нь)', 'Це(нь)', 'Сковпе(нь)', 'Арсе(нь)', 'Дзе(нь)', 'Ступе(нь)', 'Фе(нь)', 'Куте(нь)', 'Бе(нь)', 'Лазбе(нь)', 'Хитре(нь)', 'Кре(нь)', 'Ше(нь)', 'Невге(нь)', 'Кисте(нь)', 'Меле(нь)', 'Бобаре(нь)', 'Тавге(нь)', 'Гре(нь)', 'Че(нь)', 'Стрече(нь)', 'Меже(нь)', 'Куре(нь)', 'Петраше(нь)', 'Хаве(нь)', 'Гребе(нь)', 'Шеве(нь)', 'Петраше(нь)', 'Сире(нь)', 'Бобе(нь)', 'Стемпе(нь)', 'Бекре(нь)', 'Квете(нь)', 'Гуде(нь)', 'Пече(нь)', 'Крекоте(нь)', 'Зе(нь)', 'Ве(нь)', 'Че(нь)', 'Трипуте(нь)', 'Крупе(нь)', 'Креме(нь)', 'Неде(нь)', 'Ге(нь)', 'Ге(нь)', 'Буре(нь)', 'Оле(нь)', 'Буре(нь)', 'Оле(нь)', 'Висове(нь)', 'Свире(нь)', 'Кипе(нь)', 'Визе(нь)', 'Тавке(нь)', 'Шпе(нь)', 'Ре(нь)'],
          'male'     => ['Gen' => 'ня', 'Dat' => 'ню', 'Acc' => 'ня', 'Ins' => 'нем', 'Abl' => 'не'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*й', 'Берего(й)', 'Водосто(й)', 'Корро(й)', 'Коро(й)', 'Геро(й)', 'Стро(й)', 'Лыхопо(й)', 'Лихопо(й)', 'Воскобо(й)', 'Алло(й)', 'Градобо(й)', 'Драпо(й)', 'Тро(й)', 'Трибо(й)', 'Килиго(й)', 'Устро(й)', 'Рокджо(й)', 'Бо(й)', 'Во(й)', 'Го(й)', 'До(й)', 'Ко(й)', 'Но(й)', '*Ро(й)', 'Со(й)', 'Джо(й)', 'Гранобо(й)', 'То(й)', 'Ко(й)', 'Ло(й)', 'Уо(й)', 'Фо(й)', 'Хо(й)', 'Цо(й)', 'Чо(й)', 'Шо(й)', 'Забо(й)', 'Фро(й)', 'Свинобо(й)', 'Козодо(й)', 'Волобо(й)', 'Нагисо(й)', 'Сысо(й)', 'Бро(й)', 'Попушо(й)', 'Тоницо(й)', 'Малфо(й)', 'Чимпо(й)', 'Нецо(й)', 'Буки(й)', 'Карако(й)', 'Дупли(й)', 'Того(й)', 'Тяги(й)', 'Незбуди(й)', 'Анани(й)', 'Анани(й)', 'Сантони(й)', 'Прибо(й)', 'Барбо(й)', 'Барбо(й)', 'Карагеорги(й)', 'Дзо(й)', 'Ручи(й)', 'Папушо(й)', 'Якобо(й)', 'Рутени(й)', 'Гранабо(й)', 'Моки(й)', 'Аксено(й)', 'Хво(й)', 'Стры(й)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ой', '*ый'],
          'male'     => ['Gen' => 'ого', 'Dat' => 'ому', 'Acc' => 'ого', 'Ins' => 'ым', 'Abl' => 'ом'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Трет(ий)'],
          'male'     => ['Gen' => 'ьего', 'Dat' => 'ьему', 'Acc' => 'ьего', 'Ins' => 'ьим', 'Abl' => 'ьем'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*цый'],
          'male'     => ['Gen' => 'цего', 'Dat' => 'цему', 'Acc' => 'цего', 'Ins' => 'цым', 'Abl' => 'цем'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*г(ой)', '*к(ой)', '*х(ой)', '*ж(ой)', '*ш(ой)', '*щ(ой)', '*ч(ой)', 'Лугов(ий)'],
          'male'     => ['Gen' => 'ого', 'Dat' => 'ому', 'Acc' => 'ого', 'Ins' => 'им', 'Abl' => 'ом'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ий'],
          'male'     => ['Gen' => 'ия', 'Dat' => 'ию', 'Acc' => 'ия', 'Ins' => 'ием', 'Abl' => 'ии'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*г(ий)', '*к(ий)', '*х(ий)', 'Кичат(ий)', 'Козов(ий)', 'Поплужн(ий)', 'Покуліт(ий)', 'Покуліт(ий)', 'Остист(ий)', 'Бiл(ий)', 'Біл(ий)', 'Сір(ий)', 'Сір(ий)'],
          'male'     => ['Gen' => 'ого', 'Dat' => 'ому', 'Acc' => 'ого', 'Ins' => 'им', 'Abl' => 'ом'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ч(ий)', '*ж(ий)', '*ш(ий)', '*щ(ий)', '*н(ий)', 'Сво(й)'],
          'male'     => ['Gen' => 'его', 'Dat' => 'ему', 'Acc' => 'его', 'Ins' => 'им', 'Abl' => 'ем'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Арсени(й)', 'Гуржи(й)', 'Трухни(й)', 'Мохи(й)', 'Топчи(й)', 'Багри(й)', 'Тульчи(й)', 'Дони(й)', 'Ивани(й)', 'Маки(й)', 'Саланжи(й)', 'Таргони(й)', 'Стогни(й)', 'Оги(й)', 'Салі(й)', 'Сми(й)', 'Черни(й)', 'Барабо(й)', 'Багни(й)', 'Семени(й)', 'Гайтанжи(й)', 'Малани(й)', 'Компани(й)', 'Сырги(й)', 'Боки(й)', 'Копи(й)', 'Урсаки(й)', 'Би(й)', 'Жижи(й)', 'Серги(й)', 'Одоки(й)', 'Ки(й)', 'Стегни(й)', 'Петраки(й)', 'Парфени(й)', 'Палани(й)', 'Токи(й)', 'Абзы(й)', 'Недобо(й)', 'Чеко(й)', 'Небро(й)', 'Дебо(й)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'и'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ей'],
          'male'     => ['Gen' => 'ея', 'Dat' => 'ею', 'Acc' => 'ея', 'Ins' => 'еем', 'Abl' => 'ее'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Солов(ей)', 'Вороб(ей)', 'Мурав(ей)'],
          'male'     => ['Gen' => 'ья', 'Dat' => 'ью', 'Acc' => 'ья', 'Ins' => 'ьем', 'Abl' => 'ье'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Сук', 'Гнеп', 'Кремс', 'Фа', 'Куст', 'Горох', 'Рысь', 'Лысь', 'А', 'О', 'Ухань', 'И', 'С', 'Кость', 'Выспотыкаетесь', 'Тилла', 'Авила', 'Дин', 'Навсегда'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*их', '*ых'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Эрлих()', 'Жих()', 'Христ(ос)', 'Сиваш()', 'Беглец()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Говоре(к)', 'Шпе(к)', '*ок', '*ек', '*ч(ёк)', 'Коновалён(ак)', 'Клё(к)', '*що(к)', '*що(к)', 'Конте(к)', 'Берневе(к)', '', 'Лёре(к)', 'Иванцо(к)', 'Блэйло(к)', 'Петруче(к)', 'Коршаче(к)', 'Опаре(к)', 'Сухобо(к)', 'Голоско(к)', 'Рее(к)', 'Куте(к)', 'Отро(к)', 'Выруче(к)', 'Джирайо(к)', 'Галаме(к)', 'Строче(к)', 'Зубаче(к)', 'Суще(к)', 'Дыче(к)', 'Вороче(к)', 'Пауше(к)', 'Дже(к)', 'Смуше(к)', 'Дьяче(к)', 'Казаче(к)', 'Маче(к)', 'Куо(к)', 'Смарщё(к)', 'Скваре(к)', 'Микитее(к)', 'Ткаце(к)', 'Коте(к)', 'Якуше(к)', 'Сое(к)', 'Мике(к)', 'Дуно(к)', 'Семене(к)', 'Заме(к)', 'Вечоре(к)', 'Явье(к)'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ке'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*бе(к)', 'Войтише(к)', 'Цве(к)', 'Дуде(к)', 'Буче(к)', 'Ляше(к)', 'Ше(к)', 'Клаче(к)', 'Баче(к)', 'Кривобо(к)', 'Джамбе(к)', 'Мроже(к)', 'Керпе(к)', 'Любе(к)', 'Стре(к)', 'Маршале(к)', 'Жуче(к)', 'Корчмаре(к)', 'Дяче(к)', 'Цумбе(к)', 'Собе-Пане(к)', 'Штре(к)', 'Сире(к)', 'Псуе(к)', 'Матие(к)', 'Пане(к)', 'Маше(к)', 'Тимоше(к)', 'Домбе(к)', 'Пасе(к)', 'Поле(к)', 'Саде(к)', 'Стро(к)', 'Ско(к)', 'Смо(к)', 'Воло(к)', 'Набо(к)', 'Бро(к)', 'Шейнро(к)', 'Скаче(к)', 'Тере(к)', 'Якубе(к)', 'Жунусбе(к)', 'Суше(к)', 'Юкшто(к)', 'Гае(к)', 'Бо(к)', 'Бло(к)', 'Кониче(к)', 'Козодро(к)', 'Гло(к)', 'Сте(к)', 'Проро(к)', 'Чапе(к)', 'Калымбе(к)', 'Булатбе(к)', 'Чуле(к)', 'Ное(к)', 'Коо(к)', 'Домаше(к)', 'Ходаче(к)', 'Гре(к)', 'Гуче(к)', 'Волче(к)', 'Дро(к)', 'Клембе(к)', 'Гайдее(к)', 'Кулаче(к)', 'Филобо(к)', 'Ре(к)', 'Туребе(к)', 'Климе(к)', 'Кириче(к)', 'Ваце(к)', 'Херте(к)', 'Бе(к)', 'Конюше(к)', 'Ге(к)', 'Даутбе(к)', 'Саче(к)', 'Кло(к)', 'Долейше(к)', 'Айдарбе(к)', 'Мозо(к)', 'Краче(к)', 'Ро(к)', 'Кре(к)', 'Ерме(к)', 'Дане(к)', 'Быче(к)', 'Краснощё(к)', 'Здро(к)', 'Недосе(к)', 'Синео(к)', 'Фо(к)', 'Шо(к)', 'Птаче(к)', 'Хабе(к)', 'Подрабине(к)', 'Боче(к)', 'Саме(к)', 'Фле(к)', 'Эрюре(к)', 'Кряче(к)', 'Вольче(к)', 'Заране(к)', 'Лоше(к)', 'Гле(к)', 'Пельте(к)', 'Шрео(к)', 'Го(к)', 'Павшо(к)', 'Куле(к)', 'Рабе(к)', 'Заране(к)', 'Зброже(к)', 'Доброско(к)', 'Хлопче(к)', 'Бре(к)', 'Чиле(к)', 'Вале(к)', 'Шне(к)', 'Алибе(к)', 'Паце(к)', 'До(к)', 'Лодбро(к)', 'Але(к)', 'Теле(к)', 'Але(к)', 'Лещео(к)', 'Куре(к)', 'Смерче(к)', 'Здро(к)', 'Саросе(к)', 'Крюче(к)', 'Толче(к)', 'Кро(к)', 'Стое(к)', 'Обмо(к)', 'Жерносе(к)', 'Толо(к)', 'Лое(к)', 'Боже(к)', 'Бабе(к)', 'Тышле(к)', 'Крсе(к)', 'Пате(к)', 'Геро(к)', 'Чесно(к)', 'Малоо(к)', 'Вальцене(к)', 'Казыбе(к)', 'Мадибе(к)', 'Бельте(к)', 'То(к)', 'Раде(к)', 'Иманбе(к)', 'Боре(к)', 'Садубе(к)', 'Унуче(к)', 'Раче(к)', 'Иорде(к)', 'Понче(к)', 'Че(к)', 'Янаше(к)', 'Гузе(к)', 'Кымкабе(к)', 'Чве(к)', 'Се(к)', 'Витенбе(к)', 'Каирбе(к)', 'Чле(к)', 'Глуше(к)', 'Бирсе(к)', 'Бле(к)', 'Татло(к)', 'Рысбе(к)', 'Соло(к)', 'Сухане(к)', 'Хае(к)', 'Павлючё(к)', 'Пуче(к)', 'Максудбе(к)', 'Боче(к)', 'Гасе(к)', 'Про(к)', 'Ккро(к)', 'Манде(к)', 'Проце(к)', 'Кривобо(к)', 'Старосе(к)', 'Карасе(к)', 'Красноще(к)', 'Быче(к)', 'Кудре(к)', 'Барыше(к)', 'Овчаре(к)', 'Боло(к)', 'Коза(к)', 'Со(к)', 'Ноце(к)', 'Клоче(к)', 'Сре(к)', 'Жернасе(к)', 'Цейпе(к)', 'Дио(к)', 'Круче(к)', 'Дарзне(к)', 'Кло(к)', 'Черноо(к)', 'Мице(к)', 'Гейде(к)', 'Полубо(к)', 'Дерешо(к)', 'Гавине(к)', 'Ко(к)', 'Краснощо(к)', 'Четырбо(к)', 'Мо(к)', 'Ро(к)', 'Дзинтарне(к)', 'Рыче(к)', 'Горбаче(к)', 'Биле(к)', 'Раззо(к)', 'Лерё(к)', 'Шаче(к)', 'Ратче(к)', 'Колто(к)', 'Челе(к)', 'Броже(к)', 'Кабаче(к)', 'Глё(к)', 'Кле(к)', 'Гураче(к)', 'Скворо(к)', 'Русно(к)', 'Синящо(к)', 'Челе(к)', 'Пе(к)', 'Сапе(к)', 'Райбе(к)', 'Ко(к)', 'Кумо(к)', 'Тото(к)', 'Велико(к)'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ке'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а(ёк)', '*о(ёк)', '*у(ёк)', '*е(ёк)', '*и(ёк)'],
          'male'     => ['Gen' => 'йка', 'Dat' => 'йку', 'Acc' => 'йка', 'Ins' => 'йком', 'Abl' => 'йке'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ёк', 'Огон(ек)'],
          'male'     => ['Gen' => 'ька', 'Dat' => 'ьку', 'Acc' => 'ька', 'Ins' => 'ьком', 'Abl' => 'ьке'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Черношве(ц)', '*ец', 'Коре(ц)', 'Ое(ц)', 'Шке(ц)', 'Яре(ц)', 'Шле(ц)', 'Шпе(ц)', 'Марин(ец)', 'Фе(ц)', 'Куриле(ц)', 'Бе(ц)'],
          'male'     => ['Gen' => 'ца', 'Dat' => 'цу', 'Acc' => 'ца', 'Ins' => 'цем', 'Abl' => 'це'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Жуклин(ец)', 'Гапан(ец)', 'Кремен(ец)', 'Ворон(ец)', 'Сасков(ец)', 'Трохим(ец)', 'Шите(ц)', 'Вороб(ец)', 'Пригне(ц)', 'Лисов(ец)', 'Рухов(ец)', 'От(ец)', 'Чигрин(ец)', 'Тестел(ец)', 'Короб(ец)', 'Лубен(ец)', 'Краве(ц)', 'Шве(ц)', 'Жн(ец)', 'Кузне(ц)', 'Добрин(ец)', 'Дубин(ец)', 'Бо(ец)', 'Титов(ец)', 'Скреб(ец)', 'Канив(ец)', 'Митьков(ец)', 'Зимов(ец)', 'Мул(ец)', 'Дон(ец)', 'Сидор(ец)', 'Туров(ец)', 'Герге(ц)', 'Орде(ц)', 'Де(ц)', 'Солон(ец)', 'Насков(ец)', 'Ливин(ец)', 'Чуднов(ец)', 'Мыслив(ец)', 'Малахов(ец)', 'Козуб(ец)', 'Казан(ец)', 'Якуб(ец)', 'Козин(ец)', 'Москал(ец)', 'Обод(ец)', 'Супрун(ец)', 'Шабан(ец)', 'Корни(ец)', 'Степан(ец)', 'Брагин(ец)', 'Левин(ец)', 'Руб(ец)', 'Кацав(ец)', 'Остап(ец)', 'Гороб(ец)', 'Кербе(ц)', 'Волын(ец)', 'Адын(ец)', 'Сив(ец)', 'Мелехов(ец)', 'Кор(ец)', 'Кре(ц)', 'Хлеб(ец)', 'Сидоров(ец)', 'Дан(ец)', 'Пасов(ец)', 'Сте(ц)', 'Березин(ец)', 'Москов(ец)', 'Зем(ец)', 'Редков(ец)', 'Черне(ц)', 'Крржев(ец)', 'Баков(ец)', 'Демьян(ец)', 'Богре(ц)', 'Голын(ец)', 'Домов(ец)', 'Писар(ец)', 'Мисов(ец)', 'Куп(ец)', 'Пилип(ец)', 'Крив(ец)', 'Скомор(ец)', 'Гарин(ец)', 'Гришков(ец)', 'Мошен(ец)', 'Гаврилов(ец)', 'Дун(ец)', 'Марков(ец)', 'Лесков(ец)', 'Сан(ец)', 'Слив(ец)', 'Мышков(ец)', 'Лашне(ц)', 'Марине(ц)', 'Ум(ец)', 'Караку(ц)', 'Вежнов(ец)', 'Михнов(ец)', 'Ребков(ец)', 'Белев(ец)', 'Стругов(ец)', 'Лукьян(ец)', 'Кожен(ец)', 'Юшков(ец)', 'Ферен(ец)', 'Медлов(ец)', 'Жуков(ец)', 'Полтав(ец)', 'Ляхов(ец)', 'Максим(ец)', 'Чернов(ец)', 'Товпен(ец)', 'Долголев(ец)', 'Конон(ец)', 'Яким(ец)', 'Обушве(ц)', 'Мале(ц)', 'Салтов(ец)', 'Стрил(ец)', 'Раков(ец)', 'Харма(ц)', 'Ман(ец)', 'Божен(ец)', 'Бабин(ец)', 'Абле(ц)', 'Кудре(ц)', 'Ше(ц)', 'Антон(ец)', 'Близне(ц)', 'Липов(ец)', 'Пе(ц)', 'Федор(ец)', 'Скобле(ц)', 'Ве(ц)', 'Гале(ц)', 'Фастов(ец)', 'Стовп(ец)', 'Краве(ц)', 'Не(ц)', 'Лисив(ец)', 'Бегун(ец)', 'Кобе(ц)', 'Хин(ец)', 'Семен(ец)', 'Карпе(ц)', 'Роман(ец)', 'Иван(ец)', 'Скором(ец)', 'Шаков(ец)', 'Рослов(ец)', 'Куров(ец)', 'Грицов(ец)', 'Штербе(ц)', 'Замир(ец)', 'Гусин(ец)', 'Бров(ец)', 'Мазе(ц)', 'Конов(ец)', 'Демидов(ец)', 'Дубов(ец)', 'Лысков(ец)', 'Дедов(ец)', 'Левков(ец)', 'Рыбян(ец)', 'Волове(ц)', 'Борозен(ец)', 'Сосков(ец)', 'Стром(ец)', 'Корин(ец)', 'Зин(ец)', 'Янкун(ец)', 'Гребен(ец)', 'Крижив(ец)', 'Литвин(ец)', 'Кролив(ец)', 'Цве(ц)', 'Могилев(ец)', 'Яков(ец)', 'Корон(ец)', 'Юхим(ец)', 'Тишков(ец)', 'Захар(ец)', 'Чабан(ец)', 'Скрип(ец)', 'Стовпе(ц)', 'Глаубе(ц)', 'Дашив(ец)', 'Котелев(ец)', 'Котков(ец)', 'Локе(ц)', 'Быков(ец)', 'Кишин(ец)', 'Косин(ец)', 'Самохов(ец)', 'Кремне(ц)', 'Горов(ец)', 'Пше(ц)', 'Багнов(ец)', 'Ряб(ец)', 'Гарне(ц)', 'Мушав(ец)', 'Раб(ец)', 'Перегин(ец)', 'Компан(ец)', 'Брашев(ец)', 'Ле(ц)', 'Шене(ц)', 'Таран(ец)', 'Лубин(ец)', 'Мирон(ец)', 'Ольхов(ец)', 'Кохов(ец)', 'Власов(ец)', 'Ильков(ец)', 'Ипе(ц)', 'Шапоре(ц)', 'Шапоре(ц)', 'Здоров(ец)', 'Здоров(ец)', 'Чирвон(ец)', 'Здоров(ец)', 'Чирвон(ец)', 'Зинков(ец)', 'Кабан(ец)', 'Анисков(ец)', 'Машин(ец)', 'Адам(ец)', 'Маков(ец)', 'Никипор(ец)', 'Гоб(ец)', 'Деревен(ец)', 'Павлюков(ец)', 'Михайле(ц)', 'Митков(ец)', 'Пелеп(ец)', 'Самар(ец)', 'Браган(ец)', 'Крампе(ц)', 'Милюн(ец)', 'Мишков(ец)', 'Саван(ец)', 'Остапов(ец)', 'Карачин(ец)', 'Бухов(ец)', 'Немер(ец)', 'Леонов(ец)', 'Петров(ец)', 'Гузов(ец)', 'Вашков(ец)', 'Наум(ец)', 'Кошов(ец)', 'Корен(ец)'],
          'male'     => ['Gen' => 'ца', 'Dat' => 'цу', 'Acc' => 'ца', 'Ins' => 'цом', 'Abl' => 'це'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Е(лец)', 'Моска(лец)', 'Стре(лец)', 'Гаври(лец)', 'Кова(лец)', 'Ты(лец)', 'Васи(лец)', 'Бе(лец)', 'Крохми(лец)'],
          'male'     => ['Gen' => 'льца', 'Dat' => 'льцу', 'Acc' => 'льца', 'Ins' => 'льцом', 'Abl' => 'льце'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*лец'],
          'male'     => ['Gen' => 'льца', 'Dat' => 'льцу', 'Acc' => 'льца', 'Ins' => 'льцем', 'Abl' => 'льце'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а(ец)', '*е(ец)', '*и(ец)', '*о(ец)', '*у(ец)', '*ю(ец)', '*я(ец)', '*ы(ец)'],
          'male'     => ['Gen' => 'йца', 'Dat' => 'йцу', 'Acc' => 'йца', 'Ins' => 'йцем', 'Abl' => 'йце'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Бо(ец)', 'Буга(ец)'],
          'male'     => ['Gen' => 'йца', 'Dat' => 'йцу', 'Acc' => 'йца', 'Ins' => 'йцом', 'Abl' => 'йце'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Шв(ец)', 'Жн(ец)', 'Игр(ец)', 'За(ец)', 'Бразн(ец)', 'Гр(ец)', 'Ойн(ец)', 'Хейф(ец)', 'Х(ец)', 'Корни(ец)', 'Кн(ец)'],
          'male'     => ['Gen' => 'еца', 'Dat' => 'ецу', 'Acc' => 'еца', 'Ins' => 'ецом', 'Abl' => 'еце'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Кеб(ец)', 'Ге(ец)', 'Км(ец)', 'Г(ец)', 'М(ец)', 'Пр(ец)', 'Кл(ец)', 'Коп(ец)', 'Реж(ец)', 'К(ец)', 'Р(ец)', 'Коломо(ец)', 'Орд(ец)', 'Шт(ец)', 'Штайм(ец)', 'Коломи(ец)'],
          'male'     => ['Gen' => 'еца', 'Dat' => 'ецу', 'Acc' => 'еца', 'Ins' => 'ецем', 'Abl' => 'еце'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Вет(ер)'],
          'male'     => ['Gen' => 'ра', 'Dat' => 'ру', 'Acc' => 'ра', 'Ins' => 'ром', 'Abl' => 'ре'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Хох(ол)', 'Ор(ел)'],
          'male'     => ['Gen' => 'ла', 'Dat' => 'лу', 'Acc' => 'ла', 'Ins' => 'лом', 'Abl' => 'ле'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ёл'],
          'male'     => ['Gen' => 'ла', 'Dat' => 'лу', 'Acc' => 'ла', 'Ins' => 'лом', 'Abl' => 'ле'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Анё(л)', 'Псё(л)', 'Рокотё(л)', 'Костё(л)'],
          'male'     => ['Gen' => 'ла', 'Dat' => 'лу', 'Acc' => 'ла', 'Ins' => 'лом', 'Abl' => 'ле'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Лев'],
          'male'     => ['Gen' => 'Льва', 'Dat' => 'Льву', 'Acc' => 'Льва', 'Ins' => 'Львом', 'Abl' => 'Льве'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Каптёл'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*', 'Хвин()', 'Иов()', 'Манчын()', 'Целестин()', 'Син()', 'Цын()', 'Брин()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Варкентин()', 'Эллин()', 'Мартын()', 'Лин()', 'Пингвин()', 'Цин()', 'Литвин()', 'Дин()', 'Мин()', 'Новосёл()', 'Джын()', 'Бардадын()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ев()', '*ов()', '*ёв()', '*ув()', '*ин()', '*ын()', '*iн()', '*ін()', 'Ковалышен()', 'Процкив()', 'Гнатив()', 'Павлив()', 'Котив()', 'Сенив()', 'Фризен()', 'Алдушен()', 'Демянив()', 'Демчучен()', 'Петрив()', 'Панчишен()', 'Гаврышкив()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ым', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*(оў)', '*(аў)'],
          'male'     => ['Gen' => 'ова', 'Dat' => 'ову', 'Acc' => 'ова', 'Ins' => 'овым', 'Abl' => 'ове'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ч()', '*ш()', '*ц()', '*щ()', '*ж()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ем', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Сыч()', 'Карандаш()', 'Чиж()', 'Кулиш()', 'Кулеш()', 'Пыж()', 'Барабаш()', 'Пархач()', 'Черныш()', 'Карташ()', 'Деркач()', 'Грин()', 'Шин()', 'Кин()', 'Плющ()', 'Крин()', 'Кныш()', 'Корж()', 'Лин()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'е'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Тер-', 'Нор-', 'Сулима-', 'Бей-', 'Джан-', 'Гаген-', 'Крым-', 'И-', 'ген-', 'Сун-', 'Сун-дин-', 'дин-', 'Ин-', 'Ин-Дин-', 'Дин-', 'Бит-', 'Догуй-', 'Кызыл-', 'Аль-', 'Фон-', 'Шангыр-', '-оол()', 'Бадма-', 'дер-', 'Ван-', 'Ван-дер-', 'Ага-', 'ча-', 'Юн-', 'Эль-', '-Паш(а)', 'Ал-', 'Рза-', 'Бут-', 'Гук-', 'Алдын-', 'Чин-', 'Лин-', 'Дель-', 'Гуан-', 'Тин-', ' ', 'Ир-', 'Покинь-', 'Тилла', '&#1240;л-', 'Па-', 'Ве-', 'Гехт-', 'Рефа', 'Сак-', 'Тун-', 'Серин-', 'Цин-', 'Дэ-', 'Я-', 'О-', 'Аль-', 'Сармини-', 'Жан-', 'Ми-', 'Ай-', 'Чен-', 'На-', 'Сы-', 'Ли-', 'Шан-', 'Тя-', 'Шен-', 'Пак-', 'Си', 'Ай-', 'Секерж-', 'Мелик-', 'Буд-', 'Ен-', 'Джек-', 'Куй-', 'Пей-', 'Шин-', 'У', 'Чан-', 'Бен-', 'На-', 'Сы-', 'Тя-', 'Дын-', 'Зан-', 'На-', 'Бей-', 'Ак-', 'Хан-', 'Ка-'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Кривощё(к)'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ке'],
          'female'   => 'fixed',
        ],
      ];

      break;

    // Украинский
    case 1:

      $language_config['flexible_symbols'] = 'АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЭЮЯIабвгдеёжзийклмнопрстуфхцчшщьэюяiІі';

      $language_config['names'] = [
        [
          'patterns' => ['*у', '*ы', '*э', '*ё', '*ю', '*и', '*е', '*і', '*i'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*я'],
          'male'     => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'ю', 'Ins' => 'ею', 'Abl' => 'i'],
          'female'   => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'ю', 'Ins' => 'ею', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*і(я)'],
          'male'     => ['Gen' => 'ї', 'Dat' => 'ї', 'Acc' => 'ю', 'Ins' => 'єю', 'Abl' => 'ї'],
          'female'   => ['Gen' => 'ї', 'Dat' => 'ї', 'Acc' => 'ю', 'Ins' => 'єю', 'Abl' => 'ї'],
        ],
        [
          'patterns' => ['*о'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'овi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а'],
          'male'     => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'i'],
          'female'   => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*ш(а)', '*ж(а)', '*ч(а)', '*щ(а)'],
          'male'     => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ею', 'Abl' => 'i'],
          'female'   => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ею', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*ц(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ею', 'Abl' => 'i'],
          'female'   => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ею', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*(ка)'],
          'male'     => ['Gen' => 'ки', 'Dat' => 'цi', 'Acc' => 'ку', 'Ins' => 'кою', 'Abl' => 'цi'],
          'female'   => ['Gen' => 'ки', 'Dat' => 'цi', 'Acc' => 'ку', 'Ins' => 'кою', 'Abl' => 'цi'],
        ],
        [
          'patterns' => ['*(га)'],
          'male'     => ['Gen' => 'ги', 'Dat' => 'зi', 'Acc' => 'гу', 'Ins' => 'гою', 'Abl' => 'зi'],
          'female'   => ['Gen' => 'ги', 'Dat' => 'зi', 'Acc' => 'гу', 'Ins' => 'гою', 'Abl' => 'зi'],
        ],
        [
          'patterns' => ['*(ха)'],
          'male'     => ['Gen' => 'хи', 'Dat' => 'сi', 'Acc' => 'ху', 'Ins' => 'хою', 'Abl' => 'сi'],
          'female'   => ['Gen' => 'хи', 'Dat' => 'сi', 'Acc' => 'ху', 'Ins' => 'хою', 'Abl' => 'сi'],
        ],
        [
          'patterns' => ['*й'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'єм', 'Abl' => 'ї'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ь'],
          'male'     => ['Gen' => 'я', 'Dat' => 'евi', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'евi'],
          'female'   => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'ь', 'Ins' => 'ю', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['Любов(ь)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'евi', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'евi'],
          'female'   => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'ь', 'Ins' => '&#39;ю', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*ёк'],
          'male'     => ['Gen' => 'ька', 'Dat' => 'ьковi', 'Acc' => 'ька', 'Ins' => 'ьком', 'Abl' => 'ьковi'],
          'female'   => ['Gen' => 'ька', 'Dat' => 'ьковi', 'Acc' => 'ька', 'Ins' => 'ьком', 'Abl' => 'ьковi'],
        ],
        [
          'patterns' => ['*ок'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ковi', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ковi'],
          'female'   => ['Gen' => 'ка', 'Dat' => 'ковi', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ковi'],
        ],
        [
          'patterns' => ['*'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'овi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Ігор', 'Iгор'],
          'male'     => ['Gen' => 'Ігоря', 'Dat' => 'Ігоревi', 'Acc' => 'Ігоря', 'Ins' => 'Ігорем', 'Abl' => 'Ігоревi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Гюзель', 'Гузель', 'Айгуль', 'Айгюль', 'Гюнэль', 'Гюнель', 'Даниэль', 'Аревик', 'Ніколь', 'Нiколь', 'Астхик', 'Шагик', 'Татевик', 'Сатеник', 'Манушак', 'Анушик', 'Хасмик', 'Назик', 'Кайцак', 'Ардак', 'Арпик', 'Гюзяль', 'Жибек', 'Асель', 'Николь', 'Аниель', 'Асмик', 'Ола', 'Нiколь'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ий'],
          'male'     => ['Gen' => 'iя', 'Dat' => 'iю', 'Acc' => 'iя', 'Ins' => 'iєм', 'Abl' => 'iї'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ия', 'Настас(ья)'],
          'male'     => ['Gen' => 'iї', 'Dat' => 'iї', 'Acc' => 'iю', 'Ins' => 'iєю', 'Abl' => 'iї'],
          'female'   => ['Gen' => 'iї', 'Dat' => 'iї', 'Acc' => 'iю', 'Ins' => 'iєю', 'Abl' => 'iї'],
        ],
        [
          'patterns' => ['Пётр'],
          'male'     => ['Gen' => 'Петра', 'Dat' => 'Петровi', 'Acc' => 'Петра', 'Ins' => 'Петром', 'Abl' => 'Петровi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Павел'],
          'male'     => ['Gen' => 'Павла', 'Dat' => 'Павловi', 'Acc' => 'Павла', 'Ins' => 'Павлом', 'Abl' => 'Павловi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Якiв', 'Яків'],
          'male'     => ['Gen' => 'Якова', 'Dat' => 'Якововi', 'Acc' => 'Якова', 'Ins' => 'Яковом', 'Abl' => 'Якововi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Лев'],
          'male'     => ['Gen' => 'Льва', 'Dat' => 'Львовi', 'Acc' => 'Льва', 'Ins' => 'Львом', 'Abl' => 'Львовi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а(ёк)', '*о(ёк)', '*у(ёк)', '*е(ёк)', '*и(ёк)'],
          'male'     => ['Gen' => 'йка', 'Dat' => 'йковi', 'Acc' => 'йка', 'Ins' => 'йком', 'Abl' => 'йковi'],
          'female'   => ['Gen' => 'йка', 'Dat' => 'йковi', 'Acc' => 'йка', 'Ins' => 'йком', 'Abl' => 'йковi'],
        ],
        [
          'patterns' => ['Юрец'],
          'male'     => ['Gen' => 'Юрца', 'Dat' => 'Юрцевi', 'Acc' => 'Юрца', 'Ins' => 'Юрцем', 'Abl' => 'Юрцевi'],
          'female'   => 'fixed',
        ],
      ];

      $language_config['surnames'] = [
        [
          'patterns' => ['*у', '*ы', '*э', '*ё', '*ю', '*и', '*е', '*і', '*i', 'Бобро()', 'Моцьо()'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*о'],
          'male'     => ['Gen' => 'а', 'Dat' => 'овi', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'овi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*(ьо)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ьовi', 'Acc' => 'я', 'Ins' => 'ьом', 'Abl' => 'ьовi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ко'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ковi', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ку'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*я'],
          'male'     => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'ю', 'Ins' => 'ею', 'Abl' => 'i'],
          'female'   => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'ю', 'Ins' => 'ею', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*і(я)'],
          'male'     => ['Gen' => 'ї', 'Dat' => 'ї', 'Acc' => 'ю', 'Ins' => 'єю', 'Abl' => 'ї'],
          'female'   => ['Gen' => 'ї', 'Dat' => 'ї', 'Acc' => 'ю', 'Ins' => 'єю', 'Abl' => 'ї'],
        ],
        [
          'patterns' => ['Цхака(я)', 'Баркла(я)', 'Арча(я)', 'Сана(я)', 'Шва(я)'],
          'male'     => ['Gen' => 'ї', 'Dat' => 'ї', 'Acc' => 'ю', 'Ins' => 'єю', 'Abl' => 'ї'],
          'female'   => ['Gen' => 'ї', 'Dat' => 'ї', 'Acc' => 'ю', 'Ins' => 'єю', 'Abl' => 'ї'],
        ],
        [
          'patterns' => ['*ая', 'Чепурн(а)', 'Молод(а)'],
          'male'     => ['Gen' => 'аї', 'Dat' => 'аї', 'Acc' => 'аю', 'Ins' => 'аєю', 'Abl' => 'аї'],
          'female'   => ['Gen' => 'ої', 'Dat' => 'ої', 'Acc' => 'ую', 'Ins' => 'ою', 'Abl' => 'ої'],
        ],
        [
          'patterns' => ['*ий'],
          'male'     => ['Gen' => 'iя', 'Dat' => 'iю', 'Acc' => 'iя', 'Ins' => 'iєм', 'Abl' => 'iї'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ия', '*iя'],
          'male'     => ['Gen' => 'iї', 'Dat' => 'iї', 'Acc' => 'iю', 'Ins' => 'iєю', 'Abl' => 'iї'],
          'female'   => ['Gen' => 'iї', 'Dat' => 'iї', 'Acc' => 'iю', 'Ins' => 'iєю', 'Abl' => 'iї'],
        ],
        [
          'patterns' => ['*а'],
          'male'     => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'i'],
          'female'   => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*ш(а)', '*ж(а)', '*ч(а)', '*щ(а)'],
          'male'     => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ею', 'Abl' => 'i'],
          'female'   => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ею', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*ц(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ею', 'Abl' => 'i'],
          'female'   => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ею', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*(ка)'],
          'male'     => ['Gen' => 'ки', 'Dat' => 'цi', 'Acc' => 'ку', 'Ins' => 'кою', 'Abl' => 'цi'],
          'female'   => ['Gen' => 'ки', 'Dat' => 'цi', 'Acc' => 'ку', 'Ins' => 'кою', 'Abl' => 'цi'],
        ],
        [
          'patterns' => ['*ськ(а)', '*цьк(а)', 'Ловск(а)', 'Горяч(а)'],
          'male'     => ['Gen' => 'аї', 'Dat' => 'аї', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'аї'],
          'female'   => ['Gen' => 'ої', 'Dat' => 'iй', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'iй'],
        ],
        [
          'patterns' => ['*(га)'],
          'male'     => ['Gen' => 'ги', 'Dat' => 'зi', 'Acc' => 'гу', 'Ins' => 'гою', 'Abl' => 'зi'],
          'female'   => ['Gen' => 'ги', 'Dat' => 'зi', 'Acc' => 'гу', 'Ins' => 'гою', 'Abl' => 'зi'],
        ],
        [
          'patterns' => ['*(ха)'],
          'male'     => ['Gen' => 'хи', 'Dat' => 'сi', 'Acc' => 'ху', 'Ins' => 'хою', 'Abl' => 'сi'],
          'female'   => ['Gen' => 'хи', 'Dat' => 'сi', 'Acc' => 'ху', 'Ins' => 'хою', 'Abl' => 'сi'],
        ],
        [
          'patterns' => ['*й'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'єм', 'Abl' => 'ї'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ь', 'Кобзар()'],
          'male'     => ['Gen' => 'я', 'Dat' => 'евi', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'евi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ов(а)', '*ев(а)', '*єв(а)', '*ёв(а)', '*ын(а)', '*ин(а)', '*ін(а)', 'Бруцьк(а)', 'Левінськ(а)', 'Підгородецьк(а)', 'Каміновськ(а)', 'Ряб(а)', 'Голобород(а)', 'Сух(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'i'],
          'female'   => ['Gen' => 'ої', 'Dat' => 'iй', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'iй'],
        ],
        [
          'patterns' => ['Бов(а)', 'Сов(а)', 'Худын(а)', 'Щербин(а)', 'Калин(а)', 'Причин(а)', 'Украин(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'i'],
          'female'   => ['Gen' => 'и', 'Dat' => 'i', 'Acc' => 'у', 'Ins' => 'ою', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*у(а)', '*и(а)', '*э(а)', '*е(а)', '*ю(а)'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Дюм(а)', 'Петип(а)', 'Кешелав(а)', 'Малек(а)', 'Рошк(а)', 'Ракш(а)', 'Гар(а)', 'Шкут(а)', 'Опар(а)', 'Ф(а)', 'Бег(а)', 'Ізьо', 'Iзьо', 'Козло'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ень', 'Уласе(нь)', 'Пиве(нь)', 'Се(нь)', 'Бе(нь)', 'Арсе(нь)', 'Целе(нь)', 'Ште(нь)', 'Дзе(нь)', 'Петраше(нь)', 'Хаве(нь)', 'Ле(нь)', 'Че(нь)', 'Кіпе(нь)'],
          'male'     => ['Gen' => 'ня', 'Dat' => 'ню', 'Acc' => 'ня', 'Ins' => 'нем', 'Abl' => 'невi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*й', 'Берего(й)', 'Водосто(й)', 'Корро(й)', 'Коро(й)', 'Геро(й)', 'Стро(й)', 'Алло(й)', 'Парі(й)', 'Параці(й)', 'Куці(й)', 'Градобо(й)', 'Бо(й)', 'Во(й)', 'Го(й)', 'До(й)', 'Ко(й)', 'Ло(й)', 'Но(й)', 'Ро(й)', 'Со(й)', 'Маті(й)', 'Бро(й)', 'То(й)', 'Ко(й)', 'Ло(й)', 'Уо(й)', 'Фо(й)', 'Хо(й)', 'Цо(й)', 'Чо(й)', 'Шо(й)', 'Гарматі(й)', 'Ивані(й)', 'Ивани(й)', 'Гузі(й)', 'Рокджо(й)', 'Смі(й)', 'Сми(й)', 'Салі(й)', 'Капі(й)', 'Черепі(й)', 'Горді(й)', 'Зоші(й)', 'Кiндi(й)', 'Кінді(й)', 'Коробі(й)', 'Зорі(й)', 'Коробi(й)', 'Зорi(й)', 'Іпаті(й)', 'Гандзі(й)', 'Манжели(й)', 'Короби(й)', 'Рi(й)', 'Калiнi(й)', 'Передрi(й)', 'Мохнi(й)', 'Рі(й)', 'Каліні(й)', 'Передрі(й)', 'Мохні(й)', 'Стулi(й)', 'Стулі(й)', 'Покулiти(й)', 'Покуліти(й)', 'Матвi(й)', 'Матві(й)', 'Вахнi(й)', 'Вахні(й)', 'Барандi(й)', 'Баранді(й)', 'Солове(й)', 'Повалі(й)', 'Передери(й)', 'Бурій', 'Бурі(й)', 'Турі(й)', 'Поході(й)', 'Хрепті(й)', 'Чекрі(й)', 'Лупаці(й)', 'Пукі(й)', 'Солове(й)', 'Бороді(й)', 'Жарі(й)', 'Ганзі(й)', 'Волочі(й)', 'Смолі(й)', 'Смоли(й)', 'Годі(й)', 'Ковордані(й)', 'Коворданi(й)', 'Пеці(й)', 'Шаблі(й)', 'Маланчі(й)', 'Солові(й)', 'Гапі(й)', 'Гузлі(й)', 'Гері(й)', 'Корні(й)', 'Федорі(й)', 'Щербі(й)', 'Гасі(й)', 'Тягі(й)', 'Незбуді(й)', 'Мокі(й)', 'Польчі(й)', 'Ігнаті(й)', 'Iгнаті(й)', 'Садлі(й)', 'Васалаті(й)', 'Паздрі(й)', 'Сапі(й)', 'Мандзі(й)', 'Гулі(й)', 'Бедрі(й)', 'Вайнагі(й)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'єм', 'Abl' => 'ї'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ой', '*ый', 'Новотн(ий)', 'Криклив(ий)'],
          'male'     => ['Gen' => 'ого', 'Dat' => 'ому', 'Acc' => 'ого', 'Ins' => 'им', 'Abl' => 'iм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*цый'],
          'male'     => ['Gen' => 'цего', 'Dat' => 'цему', 'Acc' => 'цего', 'Ins' => 'цим', 'Abl' => 'цiм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*(гой)', '*(гий)'],
          'male'     => ['Gen' => 'гого', 'Dat' => 'гому', 'Acc' => 'гого', 'Ins' => 'гим', 'Abl' => 'зiм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*(кой)', '*(кий)'],
          'male'     => ['Gen' => 'кого', 'Dat' => 'кому', 'Acc' => 'кого', 'Ins' => 'ким', 'Abl' => 'цiм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*(хой)', '*(хий)'],
          'male'     => ['Gen' => 'хого', 'Dat' => 'хому', 'Acc' => 'хого', 'Ins' => 'хим', 'Abl' => 'сiм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ий'],
          'male'     => ['Gen' => 'ого', 'Dat' => 'ому', 'Acc' => 'ого', 'Ins' => 'им', 'Abl' => 'iм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ч(ий)', '*ж(ий)', '*ш(ий)', '*щ(ий)'],
          'male'     => ['Gen' => 'его', 'Dat' => 'ему', 'Acc' => 'его', 'Ins' => 'им', 'Abl' => 'iм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Арсени(й)', 'Гуржи(й)', 'Трухни(й)', 'Мохи(й)', 'Топчи(й)', 'Мыгалати(й)', 'Палі(й)', 'Бабі(й)', 'Бабi(й)', 'Красі(й)', 'Красi(й)', 'Баби(й)', 'Гладi(й)', 'Гладі(й)', 'Багрі(й)', 'Багрi(й)', 'Базалі(й)', 'Базалi(й)', 'Кулі(й)', 'Кулi(й)', 'Гі(й)', 'Гi(й)', 'Гурі(й)', 'Гурi(й)', 'Козi(й)', 'Козі(й)', 'Чернi(й)', 'Черні(й)', 'Таці(й)', 'Таци(й)', 'Мосі(й)', 'Мосi(й)', 'Фості(й)', 'Фостi(й)', 'Курі(й)', 'Курi(й)', 'Пазі(й)', 'Пазi(й)', 'Талі(й)', 'Талi(й)', 'Мадзі(й)', 'Мадзi(й)', 'Скубі(й)', 'Скубi(й)', 'Колоді(й)', 'Колодi(й)', 'Маслі(й)', 'Маслi(й)', 'Мукосі(й)', 'Мукосi(й)', 'Багні(й)', 'Багнi(й)', 'Шкебi(й)', 'Шкебі(й)', 'Замрi(й)', 'Замрі(й)', 'Садварi(й)', 'Садварі(й)', 'Чолі(й)', 'Чолi(й)', 'Уші(й)', 'Ушi(й)', 'Савелі(й)', 'Савелi(й)', 'Сосні(й)', 'Соснi(й)', 'Дубі(й)', 'Дубi(й)', 'Дуплі(й)', 'Микиті(й)', 'Плаксі(й)', 'Єврі(й)', 'Муші(й)', 'Шкурупі(й)', 'Галі(й)', 'Казноді(й)', 'Дари(й)', 'Топі(й)', 'Топi(й)', 'Магді(й)', 'Магдi(й)', 'Яремі(й)', 'Яремi(й)', 'Каспрі(й)', 'Каспрi(й)', 'Мусі(й)', 'Мусi(й)', 'Малані(й)', 'Маланi(й)', 'Дупли(й)', 'Телегі(й)', 'Криклі(й)', 'Сисо(й)', 'Сагі(й)', 'Шамрі(й)', 'Рябі(й)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'єм', 'Abl' => 'ї'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ій', 'Скотн(ий)'],
          'male'     => ['Gen' => 'ього', 'Dat' => 'ьому', 'Acc' => 'ього', 'Ins' => 'iм', 'Abl' => 'iм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ей'],
          'male'     => ['Gen' => 'ея', 'Dat' => 'ею', 'Acc' => 'ея', 'Ins' => 'еєм', 'Abl' => 'еї'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Солов(ей)', 'Вороб(ей)'],
          'male'     => ['Gen' => '&#39;я', 'Dat' => '&#39;ю', 'Acc' => '&#39;я', 'Ins' => '&#39;єм', 'Abl' => '&#39;ї'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*их', '*ых'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Лок(оть)'],
          'male'     => ['Gen' => 'тя', 'Dat' => 'тевi', 'Acc' => 'тя', 'Ins' => 'тем', 'Abl' => 'тевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['К(іт)', 'К(iт)'],
          'male'     => ['Gen' => 'ота', 'Dat' => 'оту', 'Acc' => 'ота', 'Ins' => 'отом', 'Abl' => 'отовi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Рябов(іл)', 'Рябов(iл)'],
          'male'     => ['Gen' => 'ола', 'Dat' => 'олу', 'Acc' => 'ола', 'Ins' => 'олом', 'Abl' => 'оловi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Здане(к)', '*ок', '*ек', '*ч(ёк)', '*ч(ёк)', '*ч(ёк)', '*ч(ёк)', '*ч(ёк)', '*ч(ёк)'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ковi', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ковi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ёк'],
          'male'     => ['Gen' => 'ька', 'Dat' => 'ьковi', 'Acc' => 'ька', 'Ins' => 'ьком', 'Abl' => 'ьковi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Войтише(к)', 'Цве(к)', 'Дуде(к)', 'Буче(к)', 'Ляше(к)', 'Ше(к)', 'Клаче(к)', 'Баче(к)', 'Маче(к)', 'Сте(к)', 'Шо(к)', 'Синєо(к)', 'Лабе(к)', 'Бе(к)', 'Гре(к)', 'Корчмаре(к)', 'Дяче(к)', 'Цумбе(к)', 'Собе-Пане(к)', 'Штре(к)', 'Сире(к)', 'Псуе(к)', 'Матие(к)', 'Пане(к)', 'Поле(к)', 'Саде(к)', 'Стро(к)', 'Ско(к)', 'Смо(к)', 'Воло(к)', 'Набо(к)', 'Бро(к)', 'Про(к)', 'Шпе(к)', 'Тягнибо(к)', 'Кло(к)', 'Кле(к)', 'Шпе(к)', 'Сапе(к)', 'Райбе(к)'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ковi', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ковi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ец'],
          'male'     => ['Gen' => 'ца', 'Dat' => 'цу', 'Acc' => 'ца', 'Ins' => 'цом', 'Abl' => 'цевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Е(лец)'],
          'male'     => ['Gen' => 'льца', 'Dat' => 'льцу', 'Acc' => 'льца', 'Ins' => 'льцом', 'Abl' => 'льцевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*лец'],
          'male'     => ['Gen' => 'льца', 'Dat' => 'льцу', 'Acc' => 'льца', 'Ins' => 'льцем', 'Abl' => 'льцевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а(ец)', '*е(ец)', '*и(ец)', '*о(ец)', '*у(ец)', '*ю(ец)', '*я(ец)', '*ы(ец)'],
          'male'     => ['Gen' => 'йца', 'Dat' => 'йцу', 'Acc' => 'йца', 'Ins' => 'йцем', 'Abl' => 'йцевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*і(ець)', '*і(єць)', '*а(єць)', '*е(єць)', '*и(єць)', '*о(єць)', '*у(єць)', '*ю(єць)', '*я(єць)', '*ы(єць)', '*i(єць)', '*i(ець)'],
          'male'     => ['Gen' => 'йця', 'Dat' => 'йцю', 'Acc' => 'йця', 'Ins' => 'йцем', 'Abl' => 'йцевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Ясков(ець)', 'Україн(ець)', 'Литвин(ець)'],
          'male'     => ['Gen' => 'ця', 'Dat' => 'цевi', 'Acc' => 'ця', 'Ins' => 'цем', 'Abl' => 'цевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ець', 'Кме(ць)'],
          'male'     => ['Gen' => 'ця', 'Dat' => 'цю', 'Acc' => 'ця', 'Ins' => 'цем', 'Abl' => 'цевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*лець'],
          'male'     => ['Gen' => 'льця', 'Dat' => 'льцю', 'Acc' => 'льця', 'Ins' => 'льцем', 'Abl' => 'льцевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Шв(ець)', 'Жн(ець)', 'За(ець)', 'Б(ець)', 'Бразн(ець)', 'Гр(ець)', 'Ойн(ець)', 'Хейф(ець)', 'Ст(ець)', 'Карп(ець)', 'Д(ець)', 'Тип(ець)', 'Кн(ець)'],
          'male'     => ['Gen' => 'еця', 'Dat' => 'ецю', 'Acc' => 'еця', 'Ins' => 'ецем', 'Abl' => 'ецевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Шв(ец)', 'Жн(ец)', 'За(ец)', 'Б(ец)', 'Бразн(ец)', 'Гр(ец)', 'Ойн(ец)', 'Хейф(ец)', 'Г(ец)', 'Кн(ец)'],
          'male'     => ['Gen' => 'еца', 'Dat' => 'ецу', 'Acc' => 'еца', 'Ins' => 'ецом', 'Abl' => 'ецевi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ёл'],
          'male'     => ['Gen' => 'ла', 'Dat' => 'лу', 'Acc' => 'ла', 'Ins' => 'лом', 'Abl' => 'ловi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*', 'Литвин()', 'Попадин()', 'Штих()', 'Каптьол()', 'Лев()', 'Лин()', 'Iзбаш()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'овi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ев()', '*ов()', '*ёв()', '*єв()', '*ів()', '*ин()', '*ын()', '*iн()', '*ін()', 'Ковалышен()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'им', 'Abl' => 'овi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Ільк(ів)', 'Івашк(ів)'],
          'male'     => ['Gen' => 'ова', 'Dat' => 'ову', 'Acc' => 'ова', 'Ins' => 'овим', 'Abl' => 'овi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ч()', '*ш()', '*ц()', '*щ()', '*ж()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ем', 'Abl' => 'евi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Токар()'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'евi'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Сыч()', 'Карандаш()', 'Чиж()', 'Кулиш()', 'Пыж()', 'Барабаш()', 'Пархач()', 'Деркач()', 'Грин()', 'Шин()', 'Новосёл()', 'Гасин()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ом', 'Abl' => 'евi'],
          'female'   => 'fixed',
        ],
      ];

      break;

    // Белорусский (тарашкевица)
    case 2:
    case 114:

      $language_config['flexible_symbols'] = 'АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЫЬЭЮЯIабвгдеёжзийклмнопрстуфхцчшщыьэюяiўІі';

      $language_config['names'] = [
        [
          'patterns' => ['*у', '*э', '*ё', '*ю', '*и', '*е'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*я'],
          'male'     => ['Gen' => 'i', 'Dat' => 'ю', 'Acc' => 'ю', 'Ins' => 'ем', 'Abl' => 'ю'],
          'female'   => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'ю', 'Ins' => 'яй', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*г(о)', '*к(о)', '*х(о)'],
          'male'     => ['Gen' => 'i', 'Dat' => 'у', 'Acc' => 'у', 'Ins' => 'ом', 'Abl' => 'у'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*о'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'у', 'Acc' => 'у', 'Ins' => 'ом', 'Abl' => 'у'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ў'],
          'male'     => ['Gen' => 'ва', 'Dat' => 'ву', 'Acc' => 'ва', 'Ins' => 'вам', 'Abl' => 'ву'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*й', '*ь'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'ю'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ы'],
          'male'     => ['Gen' => 'ыя', 'Dat' => 'ыю', 'Acc' => 'ыя', 'Ins' => 'ыем', 'Abl' => 'ыю'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*і', '*i'],
          'male'     => ['Gen' => 'iя', 'Dat' => 'iю', 'Acc' => 'iя', 'Ins' => 'iем', 'Abl' => 'iю'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ка'],
          'male'     => ['Gen' => 'кi', 'Dat' => 'ку', 'Acc' => 'ку', 'Ins' => 'кам', 'Abl' => 'ку'],
          'female'   => ['Gen' => 'кi', 'Dat' => 'цы', 'Acc' => 'ку', 'Ins' => 'кай', 'Abl' => 'цы'],
        ],
        [
          'patterns' => ['*га'],
          'male'     => ['Gen' => 'гi', 'Dat' => 'гу', 'Acc' => 'гу', 'Ins' => 'гам', 'Abl' => 'гу'],
          'female'   => ['Gen' => 'гi', 'Dat' => 'зе', 'Acc' => 'гу', 'Ins' => 'гай', 'Abl' => 'зе'],
        ],
        [
          'patterns' => ['*ха'],
          'male'     => ['Gen' => 'хi', 'Dat' => 'ху', 'Acc' => 'ху', 'Ins' => 'хам', 'Abl' => 'ху'],
          'female'   => ['Gen' => 'хi', 'Dat' => 'се', 'Acc' => 'ху', 'Ins' => 'хай', 'Abl' => 'се'],
        ],
        [
          'patterns' => ['*ж(а)', '*ш(а)', '*ч(а)', '*ц(а)', '*р(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'у', 'Acc' => 'у', 'Ins' => 'ам', 'Abl' => 'у'],
          'female'   => ['Gen' => 'ы', 'Dat' => 'ы', 'Acc' => 'у', 'Ins' => 'ай', 'Abl' => 'ы'],
        ],
        [
          'patterns' => ['*ща'],
          'male'     => ['Gen' => 'шчы', 'Dat' => 'шчу', 'Acc' => 'шчу', 'Ins' => 'шчам', 'Abl' => 'шчу'],
          'female'   => ['Gen' => 'шчы', 'Dat' => 'шчы', 'Acc' => 'шчу', 'Ins' => 'шчай', 'Abl' => 'шчы'],
        ],
        [
          'patterns' => ['*ста'],
          'male'     => ['Gen' => 'сты', 'Dat' => 'сту', 'Acc' => 'сту', 'Ins' => 'стам', 'Abl' => 'сту'],
          'female'   => ['Gen' => 'сты', 'Dat' => 'сьце', 'Acc' => 'сту', 'Ins' => 'стай', 'Abl' => 'сьце'],
        ],
        [
          'patterns' => ['*зта'],
          'male'     => ['Gen' => 'зты', 'Dat' => 'зту', 'Acc' => 'зту', 'Ins' => 'зтам', 'Abl' => 'зту'],
          'female'   => ['Gen' => 'зты', 'Dat' => 'зьце', 'Acc' => 'зту', 'Ins' => 'зтай', 'Abl' => 'зьце'],
        ],
        [
          'patterns' => ['*нта'],
          'male'     => ['Gen' => 'нты', 'Dat' => 'нту', 'Acc' => 'нту', 'Ins' => 'нтам', 'Abl' => 'нту'],
          'female'   => ['Gen' => 'нты', 'Dat' => 'ньце', 'Acc' => 'нту', 'Ins' => 'нтай', 'Abl' => 'нзьце'],
        ],
        [
          'patterns' => ['*лта'],
          'male'     => ['Gen' => 'лты', 'Dat' => 'лту', 'Acc' => 'лту', 'Ins' => 'лтам', 'Abl' => 'лту'],
          'female'   => ['Gen' => 'лты', 'Dat' => 'льце', 'Acc' => 'лту', 'Ins' => 'лтай', 'Abl' => 'льце'],
        ],
        [
          'patterns' => ['*сда'],
          'male'     => ['Gen' => 'сды', 'Dat' => 'сду', 'Acc' => 'сду', 'Ins' => 'сдам', 'Abl' => 'сду'],
          'female'   => ['Gen' => 'сды', 'Dat' => 'сьдзе', 'Acc' => 'сду', 'Ins' => 'сдай', 'Abl' => 'сьдзе'],
        ],
        [
          'patterns' => ['*зда'],
          'male'     => ['Gen' => 'зды', 'Dat' => 'зду', 'Acc' => 'зду', 'Ins' => 'здам', 'Abl' => 'зду'],
          'female'   => ['Gen' => 'зды', 'Dat' => 'зьдзе', 'Acc' => 'зду', 'Ins' => 'здай', 'Abl' => 'зьдзе'],
        ],
        [
          'patterns' => ['*нда'],
          'male'     => ['Gen' => 'нды', 'Dat' => 'нду', 'Acc' => 'нду', 'Ins' => 'ндам', 'Abl' => 'нду'],
          'female'   => ['Gen' => 'нды', 'Dat' => 'ньдзе', 'Acc' => 'нду', 'Ins' => 'ндай', 'Abl' => 'нзьдзе'],
        ],
        [
          'patterns' => ['*лда'],
          'male'     => ['Gen' => 'лды', 'Dat' => 'лду', 'Acc' => 'лду', 'Ins' => 'лдам', 'Abl' => 'лду'],
          'female'   => ['Gen' => 'лды', 'Dat' => 'льдзе', 'Acc' => 'лду', 'Ins' => 'лдай', 'Abl' => 'льдзе'],
        ],
        [
          'patterns' => ['*та'],
          'male'     => ['Gen' => 'ты', 'Dat' => 'ту', 'Acc' => 'ту', 'Ins' => 'там', 'Abl' => 'ту'],
          'female'   => ['Gen' => 'ты', 'Dat' => 'це', 'Acc' => 'ту', 'Ins' => 'тай', 'Abl' => 'це'],
        ],
        [
          'patterns' => ['*да'],
          'male'     => ['Gen' => 'ды', 'Dat' => 'ду', 'Acc' => 'ду', 'Ins' => 'дам', 'Abl' => 'ду'],
          'female'   => ['Gen' => 'ды', 'Dat' => 'дзе', 'Acc' => 'ду', 'Ins' => 'дай', 'Abl' => 'дзе'],
        ],
        [
          'patterns' => ['*а'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'у', 'Acc' => 'у', 'Ins' => 'ам', 'Abl' => 'у'],
          'female'   => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ай', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*щ'],
          'male'     => ['Gen' => 'шча', 'Dat' => 'шчу', 'Acc' => 'шча', 'Ins' => 'шчам', 'Abl' => 'шчу'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ам', 'Abl' => 'у'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Пётр', 'Петр'],
          'male'     => ['Gen' => 'Пятры', 'Dat' => 'Пятру', 'Acc' => 'Пятру', 'Ins' => 'Пятром', 'Abl' => 'Пятру'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Павел', 'Павал'],
          'male'     => ['Gen' => 'Паўла', 'Dat' => 'Паўлу', 'Acc' => 'Паўла', 'Ins' => 'Паўлам', 'Abl' => 'Паўлу'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Аляксандар', 'Александр'],
          'male'     => ['Gen' => 'Аляксандра', 'Dat' => 'Аляксандру', 'Acc' => 'Аляксандра', 'Ins' => 'Аляксандрам', 'Abl' => 'Аляксандру'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Зьм\xb3цер', 'Зьмiцер'],
          'male'     => ['Gen' => 'Зьмітра', 'Dat' => 'Зьмітру', 'Acc' => 'Зьмітра', 'Ins' => 'Зьмітром', 'Abl' => 'Зьмітры'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Зм\xb3цер', 'Змiцер'],
          'male'     => ['Gen' => 'Змітра', 'Dat' => 'Змітру', 'Acc' => 'Змітра', 'Ins' => 'Змітром', 'Abl' => 'Змітры'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Ільля', 'Ільля', 'Ілья'],
          'male'     => ['Gen' => 'Ільлi', 'Dat' => 'Ільлю', 'Acc' => 'Ільлю', 'Ins' => 'Ільлём', 'Abl' => 'Ільлю'],
          'female'   => 'fixed',
        ],
      ];

      $language_config['surnames'] = [
        [
          'patterns' => ['*у', '*э', '*ё', '*ю', '*е', '*уа'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ая'],
          'male'     => ['Gen' => 'аi', 'Dat' => 'аю', 'Acc' => 'аю', 'Ins' => 'аем', 'Abl' => 'аю'],
          'female'   => ['Gen' => 'ай', 'Dat' => 'ай', 'Acc' => 'ую', 'Ins' => 'ай', 'Abl' => 'ай'],
        ],
        [
          'patterns' => ['*яя'],
          'male'     => ['Gen' => 'яi', 'Dat' => 'яю', 'Acc' => 'яю', 'Ins' => 'яем', 'Abl' => 'яю'],
          'female'   => ['Gen' => 'яй', 'Dat' => 'яй', 'Acc' => 'юю', 'Ins' => 'яй', 'Abl' => 'яй'],
        ],
        [
          'patterns' => ['*я'],
          'male'     => ['Gen' => 'i', 'Dat' => 'ю', 'Acc' => 'ю', 'Ins' => 'ем', 'Abl' => 'ю'],
          'female'   => ['Gen' => 'i', 'Dat' => 'i', 'Acc' => 'ю', 'Ins' => 'яй', 'Abl' => 'i'],
        ],
        [
          'patterns' => ['*йко', '*ько'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ых'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ка', '*ко'],
          'male'     => ['Gen' => 'кi', 'Dat' => 'ку', 'Acc' => 'ку', 'Ins' => 'кам', 'Abl' => 'ку'],
          'female'   => ['Gen' => 'кi', 'Dat' => 'цы', 'Acc' => 'ку', 'Ins' => 'кай', 'Abl' => 'цы'],
        ],
        [
          'patterns' => ['*га', '*го'],
          'male'     => ['Gen' => 'гi', 'Dat' => 'гу', 'Acc' => 'гу', 'Ins' => 'гам', 'Abl' => 'гу'],
          'female'   => ['Gen' => 'гi', 'Dat' => 'зе', 'Acc' => 'гу', 'Ins' => 'гай', 'Abl' => 'зе'],
        ],
        [
          'patterns' => ['*ха', '*хо'],
          'male'     => ['Gen' => 'хi', 'Dat' => 'ху', 'Acc' => 'ху', 'Ins' => 'хам', 'Abl' => 'ху'],
          'female'   => ['Gen' => 'хi', 'Dat' => 'се', 'Acc' => 'ху', 'Ins' => 'хай', 'Abl' => 'се'],
        ],
        [
          'patterns' => ['*о'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ў'],
          'male'     => ['Gen' => 'ва', 'Dat' => 'ву', 'Acc' => 'ва', 'Ins' => 'вам', 'Abl' => 'ву'],
          'female'   => ['Gen' => 'ва', 'Dat' => 'ву', 'Acc' => 'ва', 'Ins' => 'вам', 'Abl' => 'ву'],
        ],
        [
          'patterns' => ['*ь'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => 'ю'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ы'],
          'male'     => ['Gen' => 'ага', 'Dat' => 'аму', 'Acc' => 'ага', 'Ins' => 'ым', 'Abl' => 'ым'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*і', '*i'],
          'male'     => ['Gen' => 'ага', 'Dat' => 'аму', 'Acc' => 'ага', 'Ins' => 'iм', 'Abl' => 'iм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*и'],
          'male'     => ['Gen' => 'ага', 'Dat' => 'аму', 'Acc' => 'ага', 'Ins' => 'им', 'Abl' => 'им'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ый'],
          'male'     => ['Gen' => 'ага', 'Dat' => 'аму', 'Acc' => 'ага', 'Ins' => 'ым', 'Abl' => 'ым'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ий'],
          'male'     => ['Gen' => 'ага', 'Dat' => 'аму', 'Acc' => 'ага', 'Ins' => 'им', 'Abl' => 'им'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ій'],
          'male'     => ['Gen' => 'ага', 'Dat' => 'аму', 'Acc' => 'ага', 'Ins' => 'iм', 'Abl' => 'iм'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ой'],
          'male'     => ['Gen' => 'ога', 'Dat' => 'ому', 'Acc' => 'ога', 'Ins' => 'ом', 'Abl' => 'ом'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*й'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ям', 'Abl' => 'ю'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ж(а)', '*ш(а)', '*ч(а)', '*ц(а)', '*р(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'у', 'Acc' => 'у', 'Ins' => 'ам', 'Abl' => 'у'],
          'female'   => ['Gen' => 'ы', 'Dat' => 'ы', 'Acc' => 'у', 'Ins' => 'ай', 'Abl' => 'ы'],
        ],
        [
          'patterns' => ['*ща'],
          'male'     => ['Gen' => 'шчы', 'Dat' => 'шчу', 'Acc' => 'шчу', 'Ins' => 'шчам', 'Abl' => 'шчу'],
          'female'   => ['Gen' => 'шчы', 'Dat' => 'шчы', 'Acc' => 'шчу', 'Ins' => 'шчай', 'Abl' => 'шчы'],
        ],
        [
          'patterns' => ['*ста'],
          'male'     => ['Gen' => 'сты', 'Dat' => 'сту', 'Acc' => 'сту', 'Ins' => 'стам', 'Abl' => 'сту'],
          'female'   => ['Gen' => 'сты', 'Dat' => 'сьце', 'Acc' => 'сту', 'Ins' => 'стай', 'Abl' => 'сьце'],
        ],
        [
          'patterns' => ['*зта'],
          'male'     => ['Gen' => 'зты', 'Dat' => 'зту', 'Acc' => 'зту', 'Ins' => 'зтам', 'Abl' => 'зту'],
          'female'   => ['Gen' => 'зты', 'Dat' => 'зьце', 'Acc' => 'зту', 'Ins' => 'зтай', 'Abl' => 'зьце'],
        ],
        [
          'patterns' => ['*нта'],
          'male'     => ['Gen' => 'нты', 'Dat' => 'нту', 'Acc' => 'нту', 'Ins' => 'нтам', 'Abl' => 'нту'],
          'female'   => ['Gen' => 'нты', 'Dat' => 'ньце', 'Acc' => 'нту', 'Ins' => 'нтай', 'Abl' => 'нзьце'],
        ],
        [
          'patterns' => ['*лта'],
          'male'     => ['Gen' => 'лты', 'Dat' => 'лту', 'Acc' => 'лту', 'Ins' => 'лтам', 'Abl' => 'лту'],
          'female'   => ['Gen' => 'лты', 'Dat' => 'льце', 'Acc' => 'лту', 'Ins' => 'лтай', 'Abl' => 'льце'],
        ],
        [
          'patterns' => ['*сда'],
          'male'     => ['Gen' => 'сды', 'Dat' => 'сду', 'Acc' => 'сду', 'Ins' => 'сдам', 'Abl' => 'сду'],
          'female'   => ['Gen' => 'сды', 'Dat' => 'сьдзе', 'Acc' => 'сду', 'Ins' => 'сдай', 'Abl' => 'сьдзе'],
        ],
        [
          'patterns' => ['*зда'],
          'male'     => ['Gen' => 'зды', 'Dat' => 'зду', 'Acc' => 'зду', 'Ins' => 'здам', 'Abl' => 'зду'],
          'female'   => ['Gen' => 'зды', 'Dat' => 'зьдзе', 'Acc' => 'зду', 'Ins' => 'здай', 'Abl' => 'зьдзе'],
        ],
        [
          'patterns' => ['*нда'],
          'male'     => ['Gen' => 'нды', 'Dat' => 'нду', 'Acc' => 'нду', 'Ins' => 'ндам', 'Abl' => 'нду'],
          'female'   => ['Gen' => 'нды', 'Dat' => 'ньдзе', 'Acc' => 'нду', 'Ins' => 'ндай', 'Abl' => 'нзьдзе'],
        ],
        [
          'patterns' => ['*лда'],
          'male'     => ['Gen' => 'лды', 'Dat' => 'лду', 'Acc' => 'лду', 'Ins' => 'лдам', 'Abl' => 'лду'],
          'female'   => ['Gen' => 'лды', 'Dat' => 'льдзе', 'Acc' => 'лду', 'Ins' => 'лдай', 'Abl' => 'льдзе'],
        ],
        [
          'patterns' => ['*та'],
          'male'     => ['Gen' => 'ты', 'Dat' => 'ту', 'Acc' => 'ту', 'Ins' => 'там', 'Abl' => 'ту'],
          'female'   => ['Gen' => 'ты', 'Dat' => 'це', 'Acc' => 'ту', 'Ins' => 'тай', 'Abl' => 'це'],
        ],
        [
          'patterns' => ['*да'],
          'male'     => ['Gen' => 'ды', 'Dat' => 'ду', 'Acc' => 'ду', 'Ins' => 'дам', 'Abl' => 'ду'],
          'female'   => ['Gen' => 'ды', 'Dat' => 'дзе', 'Acc' => 'ду', 'Ins' => 'дай', 'Abl' => 'дзе'],
        ],
        [
          'patterns' => ['*ев(а)', '*ав(а)', '*ів(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'у', 'Acc' => 'у', 'Ins' => 'ам', 'Abl' => 'у'],
          'female'   => ['Gen' => 'ай', 'Dat' => 'ай', 'Acc' => 'у', 'Ins' => 'ай', 'Abl' => 'ай'],
        ],
        [
          'patterns' => ['*ова'],
          'male'     => ['Gen' => 'овы', 'Dat' => 'ову', 'Acc' => 'ову', 'Ins' => 'овам', 'Abl' => 'ову'],
          'female'   => ['Gen' => 'овай', 'Dat' => 'овай', 'Acc' => 'ову', 'Ins' => 'овай', 'Abl' => 'овай'],
        ],
        [
          'patterns' => ['Мороз(ова)', 'Волк(ова)', 'Михайл(ова)', 'Фёдор(ова)', 'Федор(ова)', 'Александр(ова)', 'Степан(ова)', 'Павл(ова)', 'Богдан(ова)', 'Егор(ова)', 'Филипп(ова)', 'Захар(ова)', 'Виноград(ова)', 'Максим(ова)', 'Герасим(ова)', 'Марк(ова)', 'Новик(ова)', 'Макар(ова)'],
          'male'     => ['Gen' => 'авы', 'Dat' => 'аву', 'Acc' => 'аву', 'Ins' => 'авам', 'Abl' => 'аву'],
          'female'   => ['Gen' => 'авай', 'Dat' => 'авай', 'Acc' => 'аву', 'Ins' => 'авай', 'Abl' => 'авай'],
        ],
        [
          'patterns' => ['*а'],
          'male'     => ['Gen' => 'ы', 'Dat' => 'у', 'Acc' => 'у', 'Ins' => 'ам', 'Abl' => 'у'],
          'female'   => ['Gen' => 'ы', 'Dat' => 'е', 'Acc' => 'у', 'Ins' => 'ай', 'Abl' => 'е'],
        ],
        [
          'patterns' => ['*щ'],
          'male'     => ['Gen' => 'шча', 'Dat' => 'шчу', 'Acc' => 'шча', 'Ins' => 'шчам', 'Abl' => 'шчу'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ов()', '*ев()', '*ав()', '*ів()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ым', 'Abl' => 'у'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ок'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'ком', 'Abl' => 'ку'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ак', 'Коза(к)'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'кам', 'Abl' => 'ку'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Хлеб(ец)'],
          'male'     => ['Gen' => 'ца', 'Dat' => 'цу', 'Acc' => 'ца', 'Ins' => 'цем', 'Abl' => 'цу'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*цер'],
          'male'     => ['Gen' => 'тра', 'Dat' => 'тру', 'Acc' => 'тра', 'Ins' => 'тром', 'Abl' => 'тры'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*', 'Рак()'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ам', 'Abl' => 'у'],
          'female'   => 'fixed',
        ],
      ];

      break;

    // Чешский
    case 21:

      $language_config['flexible_symbols'] = 'QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm';

      $language_config['names'] = [
        [
          'patterns' => ['*a'],
          'male'     => ['Gen' => 'y', 'Dat' => 'ovi', 'Acc' => 'u', 'Ins' => 'ou', 'Abl' => 'ovi'],
          'female'   => ['Gen' => 'y', 'Dat' => '&#283;', 'Acc' => 'u', 'Ins' => 'ou', 'Abl' => '&#283;'],
        ],
        [
          'patterns' => ['*'],
          'male'     => ['Gen' => 'a', 'Dat' => 'ovi', 'Acc' => 'a', 'Ins' => 'em', 'Abl' => 'ovi'],
          'female'   => 'fixed',
        ],
      ];

      $language_config['surnames'] = [
        [
          'patterns' => ['*a'],
          'male'     => ['Gen' => 'y', 'Dat' => 'ovi', 'Acc' => 'u', 'Ins' => 'ou', 'Abl' => 'ovi'],
          'female'   => ['Gen' => 'y', 'Dat' => '&#283;', 'Acc' => 'u', 'Ins' => 'ou', 'Abl' => '&#283;'],
        ],
        [
          'patterns' => ['*'],
          'male'     => ['Gen' => 'a', 'Dat' => 'ovi', 'Acc' => 'a', 'Ins' => 'em', 'Abl' => 'ovi'],
          'female'   => 'fixed',
        ],
      ];

      break;

    // Башкирский
    case 51:

      $language_config['flexible_symbols'] = 'АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЭЮЯабвгдеёжзийклмнопрстуфхцчшщьэюяQWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm';

      $language_config['names'] = [
        [
          'patterns' => ['*а()', '*о()', '*ы()', '*э()', '*е()', '*я()', '*ё()'],
          'male'     => ['Gen' => 'ны&#1187;', 'Dat' => '&#1171;а', 'Acc' => 'ны', 'Ins' => 'ла', 'Abl' => 'нан'],
          'female'   => ['Gen' => 'ны&#1187;', 'Dat' => '&#1171;а', 'Acc' => 'ны', 'Ins' => 'ла', 'Abl' => 'нан'],
        ],
        [
          'patterns' => ['*у()', '*р()', '*и()', '*й()', '*ю()'],
          'male'     => ['Gen' => '&#1177;ы&#1187;', 'Dat' => '&#1171;а', 'Acc' => '&#1177;ы', 'Ins' => '&#1177;а', 'Abl' => '&#1177;ан'],
          'female'   => ['Gen' => '&#1177;ы&#1187;', 'Dat' => '&#1171;а', 'Acc' => '&#1177;ы', 'Ins' => '&#1177;а', 'Abl' => '&#1177;ан'],
        ],
        [
          'patterns' => ['*р(ь)'],
          'male'     => ['Gen' => '&#1177;е&#1187;', 'Dat' => 'г&#1241;', 'Acc' => '&#1177;е', 'Ins' => '&#1177;&#1241;', 'Abl' => '&#1177;&#1241;н'],
          'female'   => ['Gen' => '&#1177;е&#1187;', 'Dat' => 'г&#1241;', 'Acc' => '&#1177;е', 'Ins' => '&#1177;&#1241;', 'Abl' => '&#1177;&#1241;н'],
        ],
        [
          'patterns' => ['*н()', '*л()', '*м()', '*з()', '*ж()'],
          'male'     => ['Gen' => 'ды&#1187;', 'Dat' => '&#1171;а', 'Acc' => 'ды', 'Ins' => 'да', 'Abl' => 'дан'],
          'female'   => ['Gen' => 'ды&#1187;', 'Dat' => '&#1171;а', 'Acc' => 'ды', 'Ins' => 'да', 'Abl' => 'дан'],
        ],
        [
          'patterns' => ['*н(ь)', '*л(ь)', '*м(ь)', '*з(ь)'],
          'male'     => ['Gen' => 'де&#1187;', 'Dat' => 'г&#1241;', 'Acc' => 'де', 'Ins' => 'д&#1241;', 'Abl' => 'д&#1241;н'],
          'female'   => ['Gen' => 'де&#1187;', 'Dat' => 'г&#1241;', 'Acc' => 'де', 'Ins' => 'д&#1241;', 'Abl' => 'д&#1241;н'],
        ],
        [
          'patterns' => ['*ц()', '*к()', '*г()', '*ш()', '*щ()', '*х()', '*ф()', '*в()', '*п()', '*ч()', '*с()', '*т()', '*б()'],
          'male'     => ['Gen' => 'ты&#1187;', 'Dat' => '&#1185;а', 'Acc' => 'ты', 'Ins' => 'та', 'Abl' => 'тан'],
          'female'   => ['Gen' => 'ты&#1187;', 'Dat' => '&#1185;а', 'Acc' => 'ты', 'Ins' => 'та', 'Abl' => 'тан'],
        ],
        [
          'patterns' => ['*к(ь)', '*г(ь)', '*ф(ь)', '*в(ь)', '*п(ь)', '*с(ь)', '*т(ь)', '*б(ь)'],
          'male'     => ['Gen' => 'те&#1187;', 'Dat' => 'к&#1241;', 'Acc' => 'те', 'Ins' => 'т&#1241;', 'Abl' => 'т&#1241;н'],
          'female'   => ['Gen' => 'те&#1187;', 'Dat' => 'к&#1241;', 'Acc' => 'те', 'Ins' => 'т&#1241;', 'Abl' => 'т&#1241;н'],
        ],
        [
          'patterns' => ['*a()', '*o()', '*e()'],
          'male'     => ['Gen' => '’ны&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’ны', 'Ins' => '’ла', 'Abl' => '’нан'],
          'female'   => ['Gen' => '’ны&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’ны', 'Ins' => '’ла', 'Abl' => '’нан'],
        ],
        [
          'patterns' => ['*u()', '*r()', '*i()', '*y()', '*w()'],
          'male'     => ['Gen' => '’&#1177;ы&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’&#1177;ы', 'Ins' => '’&#1177;а', 'Abl' => '’&#1177;ан'],
          'female'   => ['Gen' => '’&#1177;ы&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’&#1177;ы', 'Ins' => '’&#1177;а', 'Abl' => '’&#1177;ан'],
        ],
        [
          'patterns' => ['*n()', '*l()', '*m()', '*z()', '*j()'],
          'male'     => ['Gen' => '’ды&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’ды', 'Ins' => '’да', 'Abl' => '’дан'],
          'female'   => ['Gen' => '’ды&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’ды', 'Ins' => '’да', 'Abl' => '’дан'],
        ],
        [
          'patterns' => ['*q()', '*t()', '*p()', '*s()', '*d()', '*f()', '*g()', '*h()', '*k()', '*x()', '*c()', '*v()', '*b()'],
          'male'     => ['Gen' => '’ты&#1187;', 'Dat' => '’&#1185;а', 'Acc' => '’ты', 'Ins' => '’та', 'Abl' => '’тан'],
          'female'   => ['Gen' => '’ты&#1187;', 'Dat' => '’&#1185;а', 'Acc' => '’ты', 'Ins' => '’та', 'Abl' => '’тан'],
        ],
      ];

      $language_config['surnames'] = [
        [
          'patterns' => ['*а()', '*о()', '*ы()', '*э()', '*е()', '*я()', '*ё()'],
          'male'     => ['Gen' => 'ны&#1187;', 'Dat' => '&#1171;а', 'Acc' => 'ны', 'Ins' => 'ла', 'Abl' => 'нан'],
          'female'   => ['Gen' => 'ны&#1187;', 'Dat' => '&#1171;а', 'Acc' => 'ны', 'Ins' => 'ла', 'Abl' => 'нан'],
        ],
        [
          'patterns' => ['*у()', '*р()', '*и()', '*й()', '*ю()'],
          'male'     => ['Gen' => '&#1177;ы&#1187;', 'Dat' => '&#1171;а', 'Acc' => '&#1177;ы', 'Ins' => '&#1177;а', 'Abl' => '&#1177;ан'],
          'female'   => ['Gen' => '&#1177;ы&#1187;', 'Dat' => '&#1171;а', 'Acc' => '&#1177;ы', 'Ins' => '&#1177;а', 'Abl' => '&#1177;ан'],
        ],
        [
          'patterns' => ['*р(ь)'],
          'male'     => ['Gen' => '&#1177;е&#1187;', 'Dat' => 'г&#1241;', 'Acc' => '&#1177;е', 'Ins' => '&#1177;&#1241;', 'Abl' => '&#1177;&#1241;н'],
          'female'   => ['Gen' => '&#1177;е&#1187;', 'Dat' => 'г&#1241;', 'Acc' => '&#1177;е', 'Ins' => '&#1177;&#1241;', 'Abl' => '&#1177;&#1241;н'],
        ],
        [
          'patterns' => ['*н()', '*л()', '*м()', '*з()', '*ж()'],
          'male'     => ['Gen' => 'ды&#1187;', 'Dat' => '&#1171;а', 'Acc' => 'ды', 'Ins' => 'да', 'Abl' => 'дан'],
          'female'   => ['Gen' => 'ды&#1187;', 'Dat' => '&#1171;а', 'Acc' => 'ды', 'Ins' => 'да', 'Abl' => 'дан'],
        ],
        [
          'patterns' => ['*н(ь)', '*л(ь)', '*м(ь)', '*з(ь)'],
          'male'     => ['Gen' => 'де&#1187;', 'Dat' => 'г&#1241;', 'Acc' => 'де', 'Ins' => 'д&#1241;', 'Abl' => 'д&#1241;н'],
          'female'   => ['Gen' => 'де&#1187;', 'Dat' => 'г&#1241;', 'Acc' => 'де', 'Ins' => 'д&#1241;', 'Abl' => 'д&#1241;н'],
        ],
        [
          'patterns' => ['*ц()', '*к()', '*г()', '*ш()', '*щ()', '*х()', '*ф()', '*в()', '*п()', '*ч()', '*с()', '*т()', '*б()'],
          'male'     => ['Gen' => 'ты&#1187;', 'Dat' => '&#1185;а', 'Acc' => 'ты', 'Ins' => 'та', 'Abl' => 'тан'],
          'female'   => ['Gen' => 'ты&#1187;', 'Dat' => '&#1185;а', 'Acc' => 'ты', 'Ins' => 'та', 'Abl' => 'тан'],
        ],
        [
          'patterns' => ['*к(ь)', '*г(ь)', '*ф(ь)', '*в(ь)', '*п(ь)', '*с(ь)', '*т(ь)', '*б(ь)'],
          'male'     => ['Gen' => 'те&#1187;', 'Dat' => 'к&#1241;', 'Acc' => 'те', 'Ins' => 'т&#1241;', 'Abl' => 'т&#1241;н'],
          'female'   => ['Gen' => 'те&#1187;', 'Dat' => 'к&#1241;', 'Acc' => 'те', 'Ins' => 'т&#1241;', 'Abl' => 'т&#1241;н'],
        ],
        [
          'patterns' => ['*a()', '*o()', '*e()'],
          'male'     => ['Gen' => '’ны&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’ны', 'Ins' => '’ла', 'Abl' => '’нан'],
          'female'   => ['Gen' => '’ны&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’ны', 'Ins' => '’ла', 'Abl' => '’нан'],
        ],
        [
          'patterns' => ['*u()', '*r()', '*i()', '*y()', '*w()'],
          'male'     => ['Gen' => '’&#1177;ы&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’&#1177;ы', 'Ins' => '’&#1177;а', 'Abl' => '’&#1177;ан'],
          'female'   => ['Gen' => '’&#1177;ы&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’&#1177;ы', 'Ins' => '’&#1177;а', 'Abl' => '’&#1177;ан'],
        ],
        [
          'patterns' => ['*n()', '*l()', '*m()', '*z()', '*j()'],
          'male'     => ['Gen' => '’ды&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’ды', 'Ins' => '’да', 'Abl' => '’дан'],
          'female'   => ['Gen' => '’ды&#1187;', 'Dat' => '’&#1171;а', 'Acc' => '’ды', 'Ins' => '’да', 'Abl' => '’дан'],
        ],
        [
          'patterns' => ['*q()', '*t()', '*p()', '*s()', '*d()', '*f()', '*g()', '*h()', '*k()', '*x()', '*c()', '*v()', '*b()'],
          'male'     => ['Gen' => '’ты&#1187;', 'Dat' => '’&#1185;а', 'Acc' => '’ты', 'Ins' => '’та', 'Abl' => '’тан'],
          'female'   => ['Gen' => '’ты&#1187;', 'Dat' => '’&#1185;а', 'Acc' => '’ты', 'Ins' => '’та', 'Abl' => '’тан'],
        ],
      ];

      break;

    // Дореволюционный
    case 100:

      $language_config['flexible_symbols'] = 'АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЬЭЮЯIабвгдеёжзийклмнопрстуфхцчшщъьэюяi';

      $language_config['names'] = [
        [
          'patterns' => ['*ь'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'ем', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => 'и', 'Acc' => 'ь', 'Ins' => 'ью', 'Abl' => 'и'],
        ],
        [
          'patterns' => ['Гюзель', 'Гузель', 'Айгуль', 'Айгюль', 'Гюнэль', 'Гюнель', 'Даниэль', 'Аревикъ', 'Астхикъ', 'Шагикъ', 'Татевикъ', 'Сатеникъ', 'Манушакъ', 'Анушикъ', 'Хасмикъ', 'Назикъ', 'Кайцакъ', 'Ардакъ', 'Арпикъ', 'Гюзяль', 'Жибекъ', 'Асель', 'Николь', 'Аниель', 'Асмикъ', 'Ола', 'Эттель'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*о', '*у', '*ы', '*э', '*ё', '*ю', '*и', '*е'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*й'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'емъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*iй'],
          'male'     => ['Gen' => 'iя', 'Dat' => 'iю', 'Acc' => 'iя', 'Ins' => 'iемъ', 'Abl' => 'iи'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*я'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*iя'],
          'male'     => ['Gen' => 'iи', 'Dat' => 'i&#1123;', 'Acc' => 'iю', 'Ins' => 'iей', 'Abl' => 'i&#1123;'],
          'female'   => ['Gen' => 'iи', 'Dat' => 'iи', 'Acc' => 'iю', 'Ins' => 'iей', 'Abl' => 'iи'],
        ],
        [
          'patterns' => ['Алi(я)', 'Нажi(я)', 'Галi(я)', 'Альфi(я)', 'Балхi(я)', 'Нурi(я)'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*а'],
          'male'     => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*к(а)', '*х(а)', '*г(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*ш(а)', '*ж(а)', '*ч(а)', '*щ(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ей', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ей', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*ца'],
          'male'     => ['Gen' => 'цы', 'Dat' => 'ц&#1123;', 'Acc' => 'цу', 'Ins' => 'цей', 'Abl' => 'ц&#1123;'],
          'female'   => ['Gen' => 'цы', 'Dat' => 'ц&#1123;', 'Acc' => 'цу', 'Ins' => 'цей', 'Abl' => 'ц&#1123;'],
        ],
        [
          'patterns' => ['Миляуш(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*', '*(ъ)'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'омъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Пётръ'],
          'male'     => ['Gen' => 'Петра', 'Dat' => 'Петру', 'Acc' => 'Петра', 'Ins' => 'Петромъ', 'Abl' => 'Петр&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Павелъ'],
          'male'     => ['Gen' => 'Павла', 'Dat' => 'Павлу', 'Acc' => 'Павла', 'Ins' => 'Павломъ', 'Abl' => 'Павл&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Левъ'],
          'male'     => ['Gen' => 'Льва', 'Dat' => 'Льву', 'Acc' => 'Льва', 'Ins' => 'Львомъ', 'Abl' => 'Льв&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а(ёкъ)', '*о(ёкъ)', '*у(ёкъ)', '*е(ёкъ)', '*и(ёкъ)'],
          'male'     => ['Gen' => 'йка', 'Dat' => 'йку', 'Acc' => 'йка', 'Ins' => 'йкомъ', 'Abl' => 'йк&#1123;'],
          'female'   => ['Gen' => 'йка', 'Dat' => 'йку', 'Acc' => 'йка', 'Ins' => 'йкомъ', 'Abl' => 'йк&#1123;'],
        ],
        [
          'patterns' => ['*ёкъ'],
          'male'     => ['Gen' => 'ька', 'Dat' => 'ьку', 'Acc' => 'ька', 'Ins' => 'ькомъ', 'Abl' => 'ьк&#1123;'],
          'female'   => ['Gen' => 'ька', 'Dat' => 'ьку', 'Acc' => 'ька', 'Ins' => 'ькомъ', 'Abl' => 'ьк&#1123;'],
        ],
        [
          'patterns' => ['*окъ'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'комъ', 'Abl' => 'к&#1123;'],
          'female'   => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'комъ', 'Abl' => 'к&#1123;'],
        ],
        [
          'patterns' => ['Юрецъ'],
          'male'     => ['Gen' => 'Юрца', 'Dat' => 'Юрцу', 'Acc' => 'Юрца', 'Ins' => 'Юрцомъ', 'Abl' => 'Юрц&#1123;'],
          'female'   => 'fixed',
        ],
      ];

      $language_config['surnames'] = [
        [
          'patterns' => ['*о', '*у', '*ы', '*э', '*ё', '*ю', '*и', '*е'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*я'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['Цхака(я)', 'Баркла(я)', 'Арча(я)', 'Сана(я)', 'Бера(я)'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'ю', 'Ins' => 'ей', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*ая'],
          'male'     => ['Gen' => 'аи', 'Dat' => 'а&#1123;', 'Acc' => 'аю', 'Ins' => 'аей', 'Abl' => 'а&#1123;'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'ую', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['*ж(ая)', '*ш(ая)', '*щ(ая)', '*ч(ая)', '*ц(ая)'],
          'male'     => ['Gen' => 'аи', 'Dat' => 'а&#1123;', 'Acc' => 'аю', 'Ins' => 'аей', 'Abl' => 'а&#1123;'],
          'female'   => ['Gen' => 'ей', 'Dat' => 'ей', 'Acc' => 'ую', 'Ins' => 'ей', 'Abl' => 'ей'],
        ],
        [
          'patterns' => ['*яя'],
          'male'     => 'fixed',
          'female'   => ['Gen' => 'ей', 'Dat' => 'ей', 'Acc' => 'юю', 'Ins' => 'ей', 'Abl' => 'ей'],
        ],
        [
          'patterns' => ['*iя'],
          'male'     => ['Gen' => 'iи', 'Dat' => 'iи', 'Acc' => 'iю', 'Ins' => 'iей', 'Abl' => 'iи'],
          'female'   => ['Gen' => 'iи', 'Dat' => 'i&#1123;', 'Acc' => 'iю', 'Ins' => 'iей', 'Abl' => 'i&#1123;'],
        ],
        [
          'patterns' => ['Мякеля', 'Лямся', 'Талья', 'Луя', 'Рейня', 'Ростобая', 'Пелля', 'Время', 'Титма'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а'],
          'male'     => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*ов(а)', '*ев(а)', '*ёв(а)', '*ын(а)', '*ин(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['Былин(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['Швидк(а)'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'у', 'Ins' => 'омъ', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['Ирчишен(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'ой', 'Dat' => 'ой', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => 'ой'],
        ],
        [
          'patterns' => ['Бов(а)', 'Сов(а)', 'Худын(а)', 'Щербин(а)', 'Калин(а)'],
          'male'     => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'ы', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*у(а)', '*и(а)', '*э(а)', '*е(а)', '*ю(а)', '*а(а)', '*о(а)'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*к(а)', '*х(а)', '*г(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*ш(а)', '*ж(а)', '*ч(а)', '*щ(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ей', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ей', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['Кваш(а)', 'Ганж(а)', 'Уш(а)', 'Ханаш(а)'],
          'male'     => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
          'female'   => ['Gen' => 'и', 'Dat' => '&#1123;', 'Acc' => 'у', 'Ins' => 'ой', 'Abl' => '&#1123;'],
        ],
        [
          'patterns' => ['*ца'],
          'male'     => ['Gen' => 'цы', 'Dat' => 'ц&#1123;', 'Acc' => 'цу', 'Ins' => 'цей', 'Abl' => 'ц&#1123;'],
          'female'   => ['Gen' => 'цы', 'Dat' => 'ц&#1123;', 'Acc' => 'цу', 'Ins' => 'цей', 'Abl' => 'ц&#1123;'],
        ],
        [
          'patterns' => ['Дюм(а)', 'Петип(а)', 'Кешелав(а)', 'Малек(а)', 'Рошк(а)', 'Ракш(а)', 'Гар(а)', 'Шкут(а)', 'Опар(а)', 'Ф(а)', 'Бег(а)', 'Туг(а)', 'Дюб(а)'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ь'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'емъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ень', 'Уласе(нь)', 'Пиве(нь)', 'Се(нь)', 'Ме(нь)', 'Хебе(нь)', 'Ште(нь)', 'Дере(нь)', 'Липе(нь)'],
          'male'     => ['Gen' => 'ня', 'Dat' => 'ню', 'Acc' => 'ня', 'Ins' => 'немъ', 'Abl' => 'н&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Журав(ель)'],
          'male'     => ['Gen' => 'ля', 'Dat' => 'лю', 'Acc' => 'ля', 'Ins' => 'лемъ', 'Abl' => 'л&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*й', 'Берего(й)', 'Водосто(й)', 'Корро(й)', 'Коро(й)', 'Геро(й)', 'Стро(й)', 'Алло(й)', 'Градобо(й)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'емъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Бо(й)', 'Во(й)', 'Го(й)', 'До(й)', 'Ко(й)', 'Ло(й)', 'Но(й)', 'Ро(й)', 'Со(й)', 'То(й)', 'Ко(й)', 'Ло(й)', 'Уо(й)', 'Фо(й)', 'Хо(й)', 'Цо(й)', 'Чо(й)', 'Шо(й)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'емъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ой', '*ый'],
          'male'     => ['Gen' => 'ого', 'Dat' => 'ому', 'Acc' => 'ого', 'Ins' => 'ымъ', 'Abl' => 'омъ'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*цый'],
          'male'     => ['Gen' => 'цего', 'Dat' => 'цему', 'Acc' => 'цего', 'Ins' => 'цымъ', 'Abl' => 'цемъ'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*г(ой)', '*к(ой)', '*х(ой)', '*ж(ой)', '*ш(ой)', '*щ(ой)', '*ч(ой)'],
          'male'     => ['Gen' => 'ого', 'Dat' => 'ому', 'Acc' => 'ого', 'Ins' => 'имъ', 'Abl' => 'омъ'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*iй'],
          'male'     => ['Gen' => 'iя', 'Dat' => 'iю', 'Acc' => 'iя', 'Ins' => 'iемъ', 'Abl' => 'iи'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*г(iй)', '*к(iй)', '*х(iй)'],
          'male'     => ['Gen' => 'ого', 'Dat' => 'ому', 'Acc' => 'ого', 'Ins' => 'имъ', 'Abl' => 'омъ'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ч(iй)', '*ж(iй)', '*ш(iй)', '*щ(iй)', '*н(iй)'],
          'male'     => ['Gen' => 'его', 'Dat' => 'ему', 'Acc' => 'его', 'Ins' => 'имъ', 'Abl' => 'емъ'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Арсенi(й)', 'Гуржi(й)', 'Трухнi(й)', 'Мохi(й)', 'Топчi(й)', 'Багрi(й)', 'Тульчi(й)', 'Саланжi(й)'],
          'male'     => ['Gen' => 'я', 'Dat' => 'ю', 'Acc' => 'я', 'Ins' => 'емъ', 'Abl' => 'и'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ей'],
          'male'     => ['Gen' => 'ея', 'Dat' => 'ею', 'Acc' => 'ея', 'Ins' => 'еемъ', 'Abl' => 'е&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Солов(ей)', 'Вороб(ей)'],
          'male'     => ['Gen' => 'ья', 'Dat' => 'ью', 'Acc' => 'ья', 'Ins' => 'ьемъ', 'Abl' => 'ь&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Кротъ', 'Сукъ', 'Гнепъ', 'Кремсъ', 'Чанъ', 'Фа', 'Кустъ'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ихъ', '*ыхъ'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*окъ', '*екъ', '*ч(ёкъ)'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'комъ', 'Abl' => 'к&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Войтише(къ)', 'Цве(къ)', 'Дуде(къ)', 'Буче(къ)', 'Ляше(къ)', 'Ше(къ)', 'Клаче(къ)', 'Баче(къ)', 'Корчмаре(къ)', 'Дяче(къ)', 'Цумбе(къ)', 'Собе-Пане(къ)', 'Штре(къ)', 'Сире(къ)', 'Псуе(къ)', 'Матие(къ)', 'Пане(къ)', 'Поле(къ)', 'Саде(къ)', 'Стро(къ)', 'Ско(къ)', 'Смо(къ)', 'Воло(къ)', 'Набо(къ)', 'Бро(къ)', 'Шейнро(къ)', 'Скаче(къ)', 'Толо(къ)', 'Гае(къ)'],
          'male'     => ['Gen' => 'ка', 'Dat' => 'ку', 'Acc' => 'ка', 'Ins' => 'комъ', 'Abl' => 'к&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ёкъ'],
          'male'     => ['Gen' => 'ька', 'Dat' => 'ьку', 'Acc' => 'ька', 'Ins' => 'ькомъ', 'Abl' => 'ьк&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ецъ'],
          'male'     => ['Gen' => 'ца', 'Dat' => 'цу', 'Acc' => 'ца', 'Ins' => 'цемъ', 'Abl' => 'ц&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Жуклин(ецъ)', 'Гапан(ецъ)', 'Кремен(ецъ)', 'Ворон(ецъ)', 'Рухов(ецъ)', 'От(ецъ)', 'Чигрин(ецъ)', 'Тестел(ецъ)', 'Короб(ецъ)', 'Лубен(ецъ)', 'Крав(ецъ)', 'Шв(ецъ)', 'Жн(ецъ)', 'Бо(ецъ)', 'Титов(ецъ)', 'Скреб(ецъ)', 'Канив(ецъ)', 'Митьков(ецъ)', 'Зимов(ецъ)', 'Мул(ецъ)', 'Дон(ецъ)', 'Сидор(ецъ)', 'Туров(ецъ)', 'Ливин(ецъ)', 'Чуднов(ецъ)', 'Мыслив(ецъ)', 'Бел(ецъ)', 'Малахов(ецъ)', 'Козуб(ецъ)', 'Казан(ецъ)', 'Якуб(ецъ)', 'Козин(ецъ)', 'Москал(ецъ)', 'Шабан(ецъ)', 'Корни(ецъ)', 'Степан(ецъ)', 'Брагин(ецъ)', 'Левин(ецъ)', 'Руб(ецъ)', 'Кацав(ецъ)', 'Остап(ецъ)'],
          'male'     => ['Gen' => 'ца', 'Dat' => 'цу', 'Acc' => 'ца', 'Ins' => 'цомъ', 'Abl' => 'ц&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Е(лецъ)'],
          'male'     => ['Gen' => 'льца', 'Dat' => 'льцу', 'Acc' => 'льца', 'Ins' => 'льцомъ', 'Abl' => 'льц&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*лецъ'],
          'male'     => ['Gen' => 'льца', 'Dat' => 'льцу', 'Acc' => 'льца', 'Ins' => 'льцемъ', 'Abl' => 'льц&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*а(ецъ)', '*е(ецъ)', '*и(ецъ)', '*о(ецъ)', '*у(ецъ)', '*ю(ецъ)', '*я(ецъ)', '*ы(ецъ)'],
          'male'     => ['Gen' => 'йца', 'Dat' => 'йцу', 'Acc' => 'йца', 'Ins' => 'йцемъ', 'Abl' => 'йце'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Шв(ецъ)', 'Жн(ецъ)', 'За(ецъ)', 'Б(ецъ)', 'Бразн(ецъ)', 'Гр(ецъ)', 'Ойн(ецъ)', 'Хейф(ецъ)'],
          'male'     => ['Gen' => 'еца', 'Dat' => 'ецу', 'Acc' => 'еца', 'Ins' => 'ецомъ', 'Abl' => 'ец&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Кеб(ецъ)', 'Ге(ецъ)'],
          'male'     => ['Gen' => 'еца', 'Dat' => 'ецу', 'Acc' => 'еца', 'Ins' => 'ецемъ', 'Abl' => 'ец&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Вет(еръ)'],
          'male'     => ['Gen' => 'ра', 'Dat' => 'ру', 'Acc' => 'ра', 'Ins' => 'ромъ', 'Abl' => 'р&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ёлъ'],
          'male'     => ['Gen' => 'ла', 'Dat' => 'лу', 'Acc' => 'ла', 'Ins' => 'ломъ', 'Abl' => 'л&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Каптёлъ'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*', '*(ъ)'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'омъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Варкентин(ъ)', 'Эллин(ъ)'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'омъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ев(ъ)', '*ов(ъ)', '*ёв(ъ)', '*ин(ъ)', '*ын(ъ)', 'Ковалышен(ъ)'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'ымъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['*ч(ъ)', '*ш(ъ)', '*ц(ъ)', '*щ(ъ)', '*ж(ъ)'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'емъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Сыч(ъ)', 'Карандаш(ъ)', 'Чиж(ъ)', 'Кулиш(ъ)', 'Пыж(ъ)', 'Барабаш(ъ)', 'Пархач(ъ)', 'Деркач(ъ)', 'Грин(ъ)', 'Шин(ъ)'],
          'male'     => ['Gen' => 'а', 'Dat' => 'у', 'Acc' => 'а', 'Ins' => 'омъ', 'Abl' => '&#1123;'],
          'female'   => 'fixed',
        ],
        [
          'patterns' => ['Тер-', 'Нор-', 'Сулима-', 'Бей-', 'Джан-', 'Гаген-'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
      ];

      break;

    //  Осетинский (Нередактируемый)
    case 91:

      $language_config['flexible_symbols'] = "АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЭЮЯабвгдеёжзийклмнопрстуфхцчшщьэюя;";

      $language_config['names'] = [
        [
          'patterns' => ['*ау()', '*еу()', '*иу()', '*ыу()', '*оу()', '*уу()', '*юу()', '*яу()', '*ёу()', '*&#230;у()'],
          'male'     => ['Gen' => 'ы', 'Dat' => '&#230;н', 'Dir' => 'м&#230;', 'Ine' => 'ы', 'Abl' => '&#230;й', 'Ade' => 'ыл', 'Equ' => 'ау', 'Com' => 'им&#230;'],
          'female'   => ['Gen' => 'ы', 'Dat' => '&#230;н', 'Dir' => 'м&#230;', 'Ine' => 'ы', 'Abl' => '&#230;й', 'Ade' => 'ыл', 'Equ' => 'ау', 'Com' => 'им&#230;'],
        ],
        [
          'patterns' => ['*а()', '*е()', '*и()', '*ы()', '*о()', '*у()', '*ю()', '*я()', '*ё()', '*&#230;()'],
          'male'     => ['Gen' => 'йы', 'Dat' => 'й&#230;н', 'Dir' => 'м&#230;', 'Ine' => 'йы', 'Abl' => 'й&#230;', 'Ade' => 'йыл', 'Equ' => 'йау', 'Com' => 'им&#230;'],
          'female'   => ['Gen' => 'йы', 'Dat' => 'й&#230;н', 'Dir' => 'м&#230;', 'Ine' => 'йы', 'Abl' => 'й&#230;', 'Ade' => 'йыл', 'Equ' => 'йау', 'Com' => 'им&#230;'],
        ],
        [
          'patterns' => ['*'],
          'male'     => ['Gen' => 'ы', 'Dat' => '&#230;н', 'Dir' => 'м&#230;', 'Ine' => 'ы', 'Abl' => '&#230;й', 'Ade' => 'ыл', 'Equ' => 'ау', 'Com' => 'им&#230;'],
          'female'   => ['Gen' => 'ы', 'Dat' => '&#230;н', 'Dir' => 'м&#230;', 'Ine' => 'ы', 'Abl' => '&#230;й', 'Ade' => 'ыл', 'Equ' => 'ау', 'Com' => 'им&#230;'],
        ],
      ];

      $language_config['surnames'] = [
        [
          'patterns' => ['*'],
          'male'     => 'fixed',
          'female'   => 'fixed',
        ],
      ];

    break;
  }

  return $language_config;
}
