include_guard(GLOBAL)

option(PDO_LIBS_STATIC_LINKING "Enable static linking with database libs for PDO")
if(PDO_LIBS_STATIC_LINKING)
    add_definitions(-DPDO_LIBS_STATIC_LINKING)
endif()
cmake_print_variables(PDO_LIBS_STATIC_LINKING)

option(PDO_DRIVER_MYSQL "Enable MySQL PDO driver")
if(PDO_DRIVER_MYSQL)
    add_definitions(-DPDO_DRIVER_MYSQL)
endif()
cmake_print_variables(PDO_DRIVER_MYSQL)

option(PDO_DRIVER_PGSQL "Enable pgSQL PDO driver")
if (PDO_DRIVER_PGSQL)
    if (APPLE)
        set(PostgreSQL_ROOT "/usr/local/opt/libpq" CACHE INTERNAL "")
    else()
        set(PostgreSQL_ADDITIONAL_VERSIONS "14")
    endif()
    find_package(PostgreSQL REQUIRED)
    include_directories(${PostgreSQL_INCLUDE_DIR})
    string(FIND ${PostgreSQL_VERSION_STRING} "." PostgreSQL_VERSION_POS)
    string(SUBSTRING ${PostgreSQL_VERSION_STRING} 0 ${PostgreSQL_VERSION_POS} PostgreSQL_VERSION)
    add_definitions(-DPDO_DRIVER_PGSQL)
    add_compile_definitions(PDO_DRIVER_PGSQL_VERSION=${PostgreSQL_VERSION})
endif()
cmake_print_variables(PDO_DRIVER_PGSQL)

option(KPHP_TESTS "Build the tests" ON)
cmake_print_variables(KPHP_TESTS)

option(KPHP_CUSTOM_CMAKE "Use CMakeLists.txt of custom php project" OFF)
cmake_print_variables(KPHP_CUSTOM_CMAKE)

option(COMPILE_RUNTIME_LIGHT "Compile runtime-light (it require c++20)" OFF)
cmake_print_variables(COMPILE_RUNTIME_LIGHT)
