# Contributing to Animations

Welcome to Animations! Thanks for taking the time to contribute. We are delighted to have you here.

Provided below is a set of guidelines and tips for how to get started as a contributor to Animations. By contributing to this repository, you give everyone right to use your code as needed, and you are also liable for any copyrighted content that might get through our review process of PRs. The list is not meant to be exhaustive so please use your best judgment and feel free to propose changes to this document as you see fit!

Please adhere to these guidelines for your PRs to be considered for merging.

## Submitting A Question

Please either make an issue or write an message in our Discord Bot/Slack Channel.

# Contribution Guidelines
## Rules

- No frameworks allowed appart from [GSAP](https://greensock.com/gsap/). Pure HTML, CSS/SCSS, and JS animations.
- In case you use images, they must be external. Use a cloud based images service as ([cloudinary](https://cloudinary.com/), [imgur](https://imgur.com/), etc...) to store your images.
- Follow the Contribution Guidelines.
- By contributing to this repository, you give everyone right to use your code as needed.
- Be helpful and friendly.
- Above all have fun!

## How to Contribute

**Adding a new animation:**

1. Create a fork of the repository
2. Clone the forked repository, and create a new branch
    - New to forking a repository? Check out this [tutorial](https://github.com/firstcontributions/first-contributions) to learn how.
        > Please make sure that you do create a new branch before you make a pull request.
3. Create a new folder in relevant directory, with appropriate and unique name to best describe your animation (refrain from using generic names)
4. Add your animation and design files to your folder
    - Files should be named as follows
      1. index.html (base webpage)
      2. style.css (stylesheet)
      3. script.js (functions) - if any  
    - Please adhere to coding best practices, such as
      1. Commenting your code
      2. Don't repeat yourself (DRY principle)
      3. Proper and consistent naming
5. Commit your changes
6. Create a Pull Request with a proper title and description

**Fixing a bug:**

1. Check the [issues](https://github.com/UsmanAhmadSaeed/Animations/issues) page to see current list of questions and problems.
2. If your issue is not there, create a PR if you can fix the bug yourself or submit a new issue, 
   1. With an appropriate name and description that clearly explains the issue
   2. Label the issue appropriately
   3. Add steps to recreate the issue

## Style Guidelines

When creating pull requests, please make sure that the commit message is concise but _specific_. That way, community members can benefit from the short, concrete descriptions that they can refer back to later, if needed.

For your reference, here is a practical guide for writing good commit message via Git: [How to Write Good Commit Messages: A Practical Git Guide](https://www.freecodecamp.org/news/writing-good-commit-messages-a-practical-guide/)