# Animations Overview

Animations is an open source collection of coded animations, containing but not limited to loaders, menus, scroll transitions, and much more. We are always looking to expand our collection for open-source use and welcome all contributions that follow guidelines.

A list of animations currently in this collection is available at the end of this document.

## Community Health Guidelines

#### *If guidelines are not followed, PRs will be marked as spam without warning. Some examples include, commits and PRs without appropriate description, code without appropriate comments, using of prohibited frameworks etc.*

[Code of Conduct](/docs/CODE_OF_CONDUCT.md)

[Submitting A Question](/docs/SUPPORT.md)

[How To Contribute](/docs/CONTRIBUTING.md)

## Status

Help is needed in defining better guidelines, rules and creating a site to showcase projects. Please feel free to contribute.

## Animations List

### Click Animations

- [Big Button](https://animations.gq/Click%20Animations/big-button/index.html)

### Card Animations

- [Card](https://animations.gq/Card%20Animations/cards/card.html)
- [Card1](https://animations.gq/Card%20Animations/cards/Card%201/card.html)
- [Card Stack](https://animations.gq/Card%20Animations/cards_stack/card.html)


### Hover Animations

- [RGB button animation](https://animations.gq/Hover%20Animations/RGB%20button%20animation/index.html)
- [Glow Icons](https://animations.gq/Hover%20Animations/Glow%20Icons/index.html)

### Load Animations

- [Expanding Circle Loader](https://animations.gq/Load%20Animations/Expanding%20Circle%20Loader/index.html)
- [Jumping Dots Loader](https://animations.gq/Load%20Animations/Jumping%20Dots%20Loader/index.html)
- [Rotating Circle Loader Simple](https://animations.gq/Load%20Animations/Rotating%20Circle%20Loader%20Simple/index.html)
- [Wires Pull SVG Loader](https://animations.gq/Load%20Animations/Wires%20pull%20SVG%20loader/index.html)
- [Bouncing Circles](https://animations.gq/Load%20Animations/Bouncing%20Circles/index.html)
- [Ghost Loading Animation](https://animations.gq/Load%20Animations/Ghost%20Loading%20Animation/index.html)
- [Simple Loading Bar](https://animations.gq/Load%20Animations/Simple%20Loading%20Bar/index.html)

### Form Animations

- [Login Person](https://animations.gq/Form%20Animations/Show%20Password/index.html)

### Menu Animations
- [Outside Curve Navigation Menu](https://animations.gq/Menu%20Animations/Outside%20Curve%20Navigation%20Menu/index.html)
- [Liquid Animation](https://animations.gq/Menu%20Animations/Liquid%20Navigation%20Menu/index.html)
- [Clipping Navigation Menu](https://animations.gq/Menu%20Animations/Clipping%20Navigation%20Menu/index.html)

#### Filtered animations (to be improved or removed)
- [Flip Animation on Hover](https://animations.gq/Filtering/Flip%20Animation%20on%20Hover/index.html)
- [Heartbeat Loader](https://animations.gq/Filtering/Heartbeat%20Loader/index.html)
- [Looping Circle](https://animations.gq/Filtering/Looping%20Circle/index.html)
- [Tilting Animation on Hover](https://animations.gq/Filtering/Tilting%20Animation%20on%20Hover/glassmorph.html)
