/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import org.conscrypt.OpenSSLX25519Key;

public class OpenSSLX25519PrivateKey
implements OpenSSLX25519Key,
PrivateKey {
    private static final long serialVersionUID = -3136201500221850916L;
    private static final byte[] PKCS8_PREAMBLE = new byte[]{48, 46, 2, 1, 0, 48, 5, 6, 3, 43, 101, 110, 4, 34, 4, 32};
    private static final byte[] PKCS8_PREAMBLE_WITH_NULL = new byte[]{48, 48, 2, 1, 0, 48, 7, 6, 3, 43, 101, 110, 5, 0, 4, 34, 4, 32};
    private byte[] uCoordinate;

    public OpenSSLX25519PrivateKey(PKCS8EncodedKeySpec keySpec) throws InvalidKeySpecException {
        byte[] encoded = keySpec.getEncoded();
        if (encoded == null || !"PKCS#8".equals(keySpec.getFormat())) {
            throw new InvalidKeySpecException("Key must be encoded in PKCS#8 format");
        }
        int preambleLength = OpenSSLX25519PrivateKey.matchesPreamble(PKCS8_PREAMBLE, encoded) | OpenSSLX25519PrivateKey.matchesPreamble(PKCS8_PREAMBLE_WITH_NULL, encoded);
        if (preambleLength == 0) {
            throw new InvalidKeySpecException("Key size is not correct size");
        }
        this.uCoordinate = Arrays.copyOfRange(encoded, PKCS8_PREAMBLE.length, encoded.length);
    }

    private static int matchesPreamble(byte[] preamble, byte[] encoded) {
        if (encoded.length != preamble.length + 32) {
            return 0;
        }
        int cmp = 0;
        for (int i = 0; i < preamble.length; ++i) {
            cmp |= encoded[i] ^ preamble[i];
        }
        if (cmp != 0) {
            return 0;
        }
        return preamble.length;
    }

    public OpenSSLX25519PrivateKey(byte[] coordinateBytes) {
        this.uCoordinate = (byte[])coordinateBytes.clone();
    }

    @Override
    public String getAlgorithm() {
        return "XDH";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        byte[] encoded = Arrays.copyOf(PKCS8_PREAMBLE, PKCS8_PREAMBLE.length + this.uCoordinate.length);
        System.arraycopy(this.uCoordinate, 0, encoded, PKCS8_PREAMBLE.length, this.uCoordinate.length);
        return encoded;
    }

    @Override
    public byte[] getU() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        return (byte[])this.uCoordinate.clone();
    }

    @Override
    public void destroy() {
        if (this.uCoordinate != null) {
            Arrays.fill(this.uCoordinate, (byte)0);
            this.uCoordinate = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.uCoordinate == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenSSLX25519PrivateKey)) {
            return false;
        }
        OpenSSLX25519PrivateKey that = (OpenSSLX25519PrivateKey)o;
        return Arrays.equals(this.uCoordinate, that.uCoordinate);
    }

    public int hashCode() {
        return Arrays.hashCode(this.uCoordinate);
    }
}

