/*
 *  Copyright 2022 UnitTestBot contributors (utbot.org)
 * <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This file is generated by jOOQ.
 */
package org.jacodb.impl.storage.jooq.tables.records


import org.jacodb.impl.storage.jooq.tables.Outerclasses
import org.jooq.Field
import org.jooq.Record1
import org.jooq.Record5
import org.jooq.Row5
import org.jooq.impl.UpdatableRecordImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class OuterclassesRecord() : UpdatableRecordImpl<OuterclassesRecord>(Outerclasses.OUTERCLASSES), Record5<Long?, Long?, String?, String?, String?> {

    var id: Long?
        set(value) = set(0, value)
        get() = get(0) as Long?

    var outerClassNameId: Long?
        set(value) = set(1, value)
        get() = get(1) as Long?

    var name: String?
        set(value) = set(2, value)
        get() = get(2) as String?

    var methodName: String?
        set(value) = set(3, value)
        get() = get(3) as String?

    var methodDesc: String?
        set(value) = set(4, value)
        get() = get(4) as String?

    // -------------------------------------------------------------------------
    // Primary key information
    // -------------------------------------------------------------------------

    override fun key(): Record1<Long?> = super.key() as Record1<Long?>

    // -------------------------------------------------------------------------
    // Record5 type implementation
    // -------------------------------------------------------------------------

    override fun fieldsRow(): Row5<Long?, Long?, String?, String?, String?> = super.fieldsRow() as Row5<Long?, Long?, String?, String?, String?>
    override fun valuesRow(): Row5<Long?, Long?, String?, String?, String?> = super.valuesRow() as Row5<Long?, Long?, String?, String?, String?>
    override fun field1(): Field<Long?> = Outerclasses.OUTERCLASSES.ID
    override fun field2(): Field<Long?> = Outerclasses.OUTERCLASSES.OUTER_CLASS_NAME_ID
    override fun field3(): Field<String?> = Outerclasses.OUTERCLASSES.NAME
    override fun field4(): Field<String?> = Outerclasses.OUTERCLASSES.METHOD_NAME
    override fun field5(): Field<String?> = Outerclasses.OUTERCLASSES.METHOD_DESC
    override fun component1(): Long? = id
    override fun component2(): Long? = outerClassNameId
    override fun component3(): String? = name
    override fun component4(): String? = methodName
    override fun component5(): String? = methodDesc
    override fun value1(): Long? = id
    override fun value2(): Long? = outerClassNameId
    override fun value3(): String? = name
    override fun value4(): String? = methodName
    override fun value5(): String? = methodDesc

    override fun value1(value: Long?): OuterclassesRecord {
        this.id = value
        return this
    }

    override fun value2(value: Long?): OuterclassesRecord {
        this.outerClassNameId = value
        return this
    }

    override fun value3(value: String?): OuterclassesRecord {
        this.name = value
        return this
    }

    override fun value4(value: String?): OuterclassesRecord {
        this.methodName = value
        return this
    }

    override fun value5(value: String?): OuterclassesRecord {
        this.methodDesc = value
        return this
    }

    override fun values(value1: Long?, value2: Long?, value3: String?, value4: String?, value5: String?): OuterclassesRecord {
        this.value1(value1)
        this.value2(value2)
        this.value3(value3)
        this.value4(value4)
        this.value5(value5)
        return this
    }

    /**
     * Create a detached, initialised OuterclassesRecord
     */
    constructor(id: Long? = null, outerClassNameId: Long? = null, name: String? = null, methodName: String? = null, methodDesc: String? = null): this() {
        this.id = id
        this.outerClassNameId = outerClassNameId
        this.name = name
        this.methodName = methodName
        this.methodDesc = methodDesc
    }
}
