/*
 *  Copyright 2022 UnitTestBot contributors (utbot.org)
 * <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This file is generated by jOOQ.
 */
package org.jacodb.impl.storage.jooq.tables.records


import org.jacodb.impl.storage.jooq.tables.Calls
import org.jooq.Field
import org.jooq.Record7
import org.jooq.Row7
import org.jooq.impl.TableRecordImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class CallsRecord() : TableRecordImpl<CallsRecord>(Calls.CALLS), Record7<String?, String?, Long?, Int?, String?, ByteArray?, Long?> {

    var calleeClassName: String?
        set(value) = set(0, value)
        get() = get(0) as String?

    var calleeName: String?
        set(value) = set(1, value)
        get() = get(1) as String?

    var calleeDescHash: Long?
        set(value) = set(2, value)
        get() = get(2) as Long?

    var opcode: Int?
        set(value) = set(3, value)
        get() = get(3) as Int?

    var callerClassName: String?
        set(value) = set(4, value)
        get() = get(4) as String?

    var callerMethodOffsets: ByteArray?
        set(value) = set(5, value)
        get() = get(5) as ByteArray?

    var locationId: Long?
        set(value) = set(6, value)
        get() = get(6) as Long?

    // -------------------------------------------------------------------------
    // Record7 type implementation
    // -------------------------------------------------------------------------

    override fun fieldsRow(): Row7<String?, String?, Long?, Int?, String?, ByteArray?, Long?> = super.fieldsRow() as Row7<String?, String?, Long?, Int?, String?, ByteArray?, Long?>
    override fun valuesRow(): Row7<String?, String?, Long?, Int?, String?, ByteArray?, Long?> = super.valuesRow() as Row7<String?, String?, Long?, Int?, String?, ByteArray?, Long?>
    override fun field1(): Field<String?> = Calls.CALLS.CALLEE_CLASS_NAME
    override fun field2(): Field<String?> = Calls.CALLS.CALLEE_NAME
    override fun field3(): Field<Long?> = Calls.CALLS.CALLEE_DESC_HASH
    override fun field4(): Field<Int?> = Calls.CALLS.OPCODE
    override fun field5(): Field<String?> = Calls.CALLS.CALLER_CLASS_NAME
    override fun field6(): Field<ByteArray?> = Calls.CALLS.CALLER_METHOD_OFFSETS
    override fun field7(): Field<Long?> = Calls.CALLS.LOCATION_ID
    override fun component1(): String? = calleeClassName
    override fun component2(): String? = calleeName
    override fun component3(): Long? = calleeDescHash
    override fun component4(): Int? = opcode
    override fun component5(): String? = callerClassName
    override fun component6(): ByteArray? = callerMethodOffsets
    override fun component7(): Long? = locationId
    override fun value1(): String? = calleeClassName
    override fun value2(): String? = calleeName
    override fun value3(): Long? = calleeDescHash
    override fun value4(): Int? = opcode
    override fun value5(): String? = callerClassName
    override fun value6(): ByteArray? = callerMethodOffsets
    override fun value7(): Long? = locationId

    override fun value1(value: String?): CallsRecord {
        this.calleeClassName = value
        return this
    }

    override fun value2(value: String?): CallsRecord {
        this.calleeName = value
        return this
    }

    override fun value3(value: Long?): CallsRecord {
        this.calleeDescHash = value
        return this
    }

    override fun value4(value: Int?): CallsRecord {
        this.opcode = value
        return this
    }

    override fun value5(value: String?): CallsRecord {
        this.callerClassName = value
        return this
    }

    override fun value6(value: ByteArray?): CallsRecord {
        this.callerMethodOffsets = value
        return this
    }

    override fun value7(value: Long?): CallsRecord {
        this.locationId = value
        return this
    }

    override fun values(value1: String?, value2: String?, value3: Long?, value4: Int?, value5: String?, value6: ByteArray?, value7: Long?): CallsRecord {
        this.value1(value1)
        this.value2(value2)
        this.value3(value3)
        this.value4(value4)
        this.value5(value5)
        this.value6(value6)
        this.value7(value7)
        return this
    }

    /**
     * Create a detached, initialised CallsRecord
     */
    constructor(calleeClassName: String? = null, calleeName: String? = null, calleeDescHash: Long? = null, opcode: Int? = null, callerClassName: String? = null, callerMethodOffsets: ByteArray? = null, locationId: Long? = null): this() {
        this.calleeClassName = calleeClassName
        this.calleeName = calleeName
        this.calleeDescHash = calleeDescHash
        this.opcode = opcode
        this.callerClassName = callerClassName
        this.callerMethodOffsets = callerMethodOffsets
        this.locationId = locationId
    }
}
