/*
 *  Copyright 2022 UnitTestBot contributors (utbot.org)
 * <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This file is generated by jOOQ.
 */
package org.jacodb.impl.storage.jooq.tables


import org.jacodb.impl.storage.jooq.DefaultSchema
import org.jacodb.impl.storage.jooq.tables.records.RefactoringsRecord
import org.jooq.*
import org.jooq.impl.DSL
import org.jooq.impl.Internal
import org.jooq.impl.SQLDataType
import org.jooq.impl.TableImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class Refactorings(
    alias: Name,
    child: Table<out Record>?,
    path: ForeignKey<out Record, RefactoringsRecord>?,
    aliased: Table<RefactoringsRecord>?,
    parameters: Array<Field<*>?>?
): TableImpl<RefactoringsRecord>(
    alias,
    DefaultSchema.DEFAULT_SCHEMA,
    child,
    path,
    aliased,
    parameters,
    DSL.comment(""),
    TableOptions.table()
) {
    companion object {

        /**
         * The reference instance of <code>Refactorings</code>
         */
        val REFACTORINGS = Refactorings()
    }

    /**
     * The class holding records for this type
     */
    override fun getRecordType(): Class<RefactoringsRecord> = RefactoringsRecord::class.java

    /**
     * The column <code>Refactorings.name</code>.
     */
    val NAME: TableField<RefactoringsRecord, String?> = createField(DSL.name("name"), SQLDataType.VARCHAR(1024).nullable(false), this, "")

    private constructor(alias: Name, aliased: Table<RefactoringsRecord>?): this(alias, null, null, aliased, null)
    private constructor(alias: Name, aliased: Table<RefactoringsRecord>?, parameters: Array<Field<*>?>?): this(alias, null, null, aliased, parameters)

    /**
     * Create an aliased <code>Refactorings</code> table reference
     */
    constructor(alias: String): this(DSL.name(alias))

    /**
     * Create an aliased <code>Refactorings</code> table reference
     */
    constructor(alias: Name): this(alias, null)

    /**
     * Create a <code>Refactorings</code> table reference
     */
    constructor(): this(DSL.name("Refactorings"), null)

    constructor(child: Table<out Record>, key: ForeignKey<out Record, RefactoringsRecord>): this(Internal.createPathAlias(child, key), child, key, REFACTORINGS, null)
    override fun getSchema(): Schema = DefaultSchema.DEFAULT_SCHEMA
    override fun `as`(alias: String): Refactorings = Refactorings(DSL.name(alias), this)
    override fun `as`(alias: Name): Refactorings = Refactorings(alias, this)

    /**
     * Rename this table
     */
    override fun rename(name: String): Refactorings = Refactorings(DSL.name(name), null)

    /**
     * Rename this table
     */
    override fun rename(name: Name): Refactorings = Refactorings(name, null)

    // -------------------------------------------------------------------------
    // Row1 type methods
    // -------------------------------------------------------------------------
    override fun fieldsRow(): Row1<String?> = super.fieldsRow() as Row1<String?>
}
