/*
 *  Copyright 2022 UnitTestBot contributors (utbot.org)
 * <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This file is generated by jOOQ.
 */
package org.jacodb.impl.storage.jooq.tables


import org.jacodb.impl.storage.jooq.DefaultSchema
import org.jacodb.impl.storage.jooq.indexes.FIELDS_CLASSID
import org.jacodb.impl.storage.jooq.indexes.FIELDS_CLASS_ID_NAME
import org.jacodb.impl.storage.jooq.keys.FK_FIELDS_CLASSES_1
import org.jacodb.impl.storage.jooq.keys.FK_FIELDS_SYMBOLS_1
import org.jacodb.impl.storage.jooq.keys.FK_FIELDS_SYMBOLS_2
import org.jacodb.impl.storage.jooq.keys.PK_FIELDS
import org.jacodb.impl.storage.jooq.tables.records.FieldsRecord
import org.jooq.*
import org.jooq.impl.DSL
import org.jooq.impl.Internal
import org.jooq.impl.SQLDataType
import org.jooq.impl.TableImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class Fields(
    alias: Name,
    child: Table<out Record>?,
    path: ForeignKey<out Record, FieldsRecord>?,
    aliased: Table<FieldsRecord>?,
    parameters: Array<Field<*>?>?
): TableImpl<FieldsRecord>(
    alias,
    DefaultSchema.DEFAULT_SCHEMA,
    child,
    path,
    aliased,
    parameters,
    DSL.comment(""),
    TableOptions.table()
) {
    companion object {

        /**
         * The reference instance of <code>Fields</code>
         */
        val FIELDS = Fields()
    }

    /**
     * The class holding records for this type
     */
    override fun getRecordType(): Class<FieldsRecord> = FieldsRecord::class.java

    /**
     * The column <code>Fields.id</code>.
     */
    val ID: TableField<FieldsRecord, Long?> = createField(DSL.name("id"), SQLDataType.BIGINT, this, "")

    /**
     * The column <code>Fields.access</code>.
     */
    val ACCESS: TableField<FieldsRecord, Int?> = createField(DSL.name("access"), SQLDataType.INTEGER.nullable(false), this, "")

    /**
     * The column <code>Fields.name</code>.
     */
    val NAME: TableField<FieldsRecord, Long?> = createField(DSL.name("name"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>Fields.signature</code>.
     */
    val SIGNATURE: TableField<FieldsRecord, String?> = createField(DSL.name("signature"), SQLDataType.CLOB, this, "")

    /**
     * The column <code>Fields.field_class</code>.
     */
    val FIELD_CLASS: TableField<FieldsRecord, Long?> = createField(DSL.name("field_class"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>Fields.class_id</code>.
     */
    val CLASS_ID: TableField<FieldsRecord, Long?> = createField(DSL.name("class_id"), SQLDataType.BIGINT.nullable(false), this, "")

    private constructor(alias: Name, aliased: Table<FieldsRecord>?): this(alias, null, null, aliased, null)
    private constructor(alias: Name, aliased: Table<FieldsRecord>?, parameters: Array<Field<*>?>?): this(alias, null, null, aliased, parameters)

    /**
     * Create an aliased <code>Fields</code> table reference
     */
    constructor(alias: String): this(DSL.name(alias))

    /**
     * Create an aliased <code>Fields</code> table reference
     */
    constructor(alias: Name): this(alias, null)

    /**
     * Create a <code>Fields</code> table reference
     */
    constructor(): this(DSL.name("Fields"), null)

    constructor(child: Table<out Record>, key: ForeignKey<out Record, FieldsRecord>): this(Internal.createPathAlias(child, key), child, key, FIELDS, null)
    override fun getSchema(): Schema = DefaultSchema.DEFAULT_SCHEMA
    override fun getIndexes(): List<Index> = listOf(FIELDS_CLASS_ID_NAME, FIELDS_CLASSID)
    override fun getPrimaryKey(): UniqueKey<FieldsRecord> = PK_FIELDS
    override fun getKeys(): List<UniqueKey<FieldsRecord>> = listOf(PK_FIELDS)
    override fun getReferences(): List<ForeignKey<FieldsRecord, *>> = listOf(FK_FIELDS_SYMBOLS_2, FK_FIELDS_SYMBOLS_1, FK_FIELDS_CLASSES_1)

    private lateinit var _fkFieldsSymbols_2: Symbols
    private lateinit var _fkFieldsSymbols_1: Symbols
    private lateinit var _classes: Classes
    fun fkFieldsSymbols_2(): Symbols {
        if (!this::_fkFieldsSymbols_2.isInitialized)
            _fkFieldsSymbols_2 = Symbols(this, FK_FIELDS_SYMBOLS_2)

        return _fkFieldsSymbols_2;
    }
    fun fkFieldsSymbols_1(): Symbols {
        if (!this::_fkFieldsSymbols_1.isInitialized)
            _fkFieldsSymbols_1 = Symbols(this, FK_FIELDS_SYMBOLS_1)

        return _fkFieldsSymbols_1;
    }
    fun classes(): Classes {
        if (!this::_classes.isInitialized)
            _classes = Classes(this, FK_FIELDS_CLASSES_1)

        return _classes;
    }
    override fun `as`(alias: String): Fields = Fields(DSL.name(alias), this)
    override fun `as`(alias: Name): Fields = Fields(alias, this)

    /**
     * Rename this table
     */
    override fun rename(name: String): Fields = Fields(DSL.name(name), null)

    /**
     * Rename this table
     */
    override fun rename(name: Name): Fields = Fields(name, null)

    // -------------------------------------------------------------------------
    // Row6 type methods
    // -------------------------------------------------------------------------
    override fun fieldsRow(): Row6<Long?, Int?, Long?, String?, Long?, Long?> = super.fieldsRow() as Row6<Long?, Int?, Long?, String?, Long?, Long?>
}
