/*
 *  Copyright 2022 UnitTestBot contributors (utbot.org)
 * <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This file is generated by jOOQ.
 */
package org.jacodb.impl.storage.jooq.tables


import org.jacodb.impl.storage.jooq.DefaultSchema
import org.jacodb.impl.storage.jooq.indexes.CLASSINNERCLASSES_CLASSID
import org.jacodb.impl.storage.jooq.indexes.CLASSINNERCLASSES_INNERCLASSID
import org.jacodb.impl.storage.jooq.keys.FK_CLASSINNERCLASSES_CLASSES_1
import org.jacodb.impl.storage.jooq.keys.FK_CLASSINNERCLASSES_SYMBOLS_1
import org.jacodb.impl.storage.jooq.keys.PK_CLASSINNERCLASSES
import org.jacodb.impl.storage.jooq.tables.records.ClassinnerclassesRecord
import org.jooq.*
import org.jooq.impl.DSL
import org.jooq.impl.Internal
import org.jooq.impl.SQLDataType
import org.jooq.impl.TableImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class Classinnerclasses(
    alias: Name,
    child: Table<out Record>?,
    path: ForeignKey<out Record, ClassinnerclassesRecord>?,
    aliased: Table<ClassinnerclassesRecord>?,
    parameters: Array<Field<*>?>?
): TableImpl<ClassinnerclassesRecord>(
    alias,
    DefaultSchema.DEFAULT_SCHEMA,
    child,
    path,
    aliased,
    parameters,
    DSL.comment(""),
    TableOptions.table()
) {
    companion object {

        /**
         * The reference instance of <code>ClassInnerClasses</code>
         */
        val CLASSINNERCLASSES = Classinnerclasses()
    }

    /**
     * The class holding records for this type
     */
    override fun getRecordType(): Class<ClassinnerclassesRecord> = ClassinnerclassesRecord::class.java

    /**
     * The column <code>ClassInnerClasses.id</code>.
     */
    val ID: TableField<ClassinnerclassesRecord, Long?> = createField(DSL.name("id"), SQLDataType.BIGINT, this, "")

    /**
     * The column <code>ClassInnerClasses.class_id</code>.
     */
    val CLASS_ID: TableField<ClassinnerclassesRecord, Long?> = createField(DSL.name("class_id"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>ClassInnerClasses.inner_class_id</code>.
     */
    val INNER_CLASS_ID: TableField<ClassinnerclassesRecord, Long?> = createField(DSL.name("inner_class_id"), SQLDataType.BIGINT.nullable(false), this, "")

    private constructor(alias: Name, aliased: Table<ClassinnerclassesRecord>?): this(alias, null, null, aliased, null)
    private constructor(alias: Name, aliased: Table<ClassinnerclassesRecord>?, parameters: Array<Field<*>?>?): this(alias, null, null, aliased, parameters)

    /**
     * Create an aliased <code>ClassInnerClasses</code> table reference
     */
    constructor(alias: String): this(DSL.name(alias))

    /**
     * Create an aliased <code>ClassInnerClasses</code> table reference
     */
    constructor(alias: Name): this(alias, null)

    /**
     * Create a <code>ClassInnerClasses</code> table reference
     */
    constructor(): this(DSL.name("ClassInnerClasses"), null)

    constructor(child: Table<out Record>, key: ForeignKey<out Record, ClassinnerclassesRecord>): this(Internal.createPathAlias(child, key), child, key, CLASSINNERCLASSES, null)
    override fun getSchema(): Schema = DefaultSchema.DEFAULT_SCHEMA
    override fun getIndexes(): List<Index> = listOf(CLASSINNERCLASSES_CLASSID, CLASSINNERCLASSES_INNERCLASSID)
    override fun getPrimaryKey(): UniqueKey<ClassinnerclassesRecord> = PK_CLASSINNERCLASSES
    override fun getKeys(): List<UniqueKey<ClassinnerclassesRecord>> = listOf(PK_CLASSINNERCLASSES)
    override fun getReferences(): List<ForeignKey<ClassinnerclassesRecord, *>> = listOf(FK_CLASSINNERCLASSES_CLASSES_1, FK_CLASSINNERCLASSES_SYMBOLS_1)

    private lateinit var _classes: Classes
    private lateinit var _symbols: Symbols
    fun classes(): Classes {
        if (!this::_classes.isInitialized)
            _classes = Classes(this, FK_CLASSINNERCLASSES_CLASSES_1)

        return _classes;
    }
    fun symbols(): Symbols {
        if (!this::_symbols.isInitialized)
            _symbols = Symbols(this, FK_CLASSINNERCLASSES_SYMBOLS_1)

        return _symbols;
    }
    override fun `as`(alias: String): Classinnerclasses = Classinnerclasses(DSL.name(alias), this)
    override fun `as`(alias: Name): Classinnerclasses = Classinnerclasses(alias, this)

    /**
     * Rename this table
     */
    override fun rename(name: String): Classinnerclasses = Classinnerclasses(DSL.name(name), null)

    /**
     * Rename this table
     */
    override fun rename(name: Name): Classinnerclasses = Classinnerclasses(name, null)

    // -------------------------------------------------------------------------
    // Row3 type methods
    // -------------------------------------------------------------------------
    override fun fieldsRow(): Row3<Long?, Long?, Long?> = super.fieldsRow() as Row3<Long?, Long?, Long?>
}
