/*
 *  Copyright 2022 UnitTestBot contributors (utbot.org)
 * <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This file is generated by jOOQ.
 */
package org.jacodb.impl.storage.jooq.tables


import org.jacodb.impl.storage.jooq.DefaultSchema
import org.jacodb.impl.storage.jooq.indexes.CLASSHIERARCHIES_CLASSID
import org.jacodb.impl.storage.jooq.indexes.CLASSHIERARCHIES_SUPERID
import org.jacodb.impl.storage.jooq.keys.FK_CLASSHIERARCHIES_CLASSES_1
import org.jacodb.impl.storage.jooq.keys.FK_CLASSHIERARCHIES_SYMBOLS_1
import org.jacodb.impl.storage.jooq.keys.PK_CLASSHIERARCHIES
import org.jacodb.impl.storage.jooq.tables.records.ClasshierarchiesRecord
import org.jooq.*
import org.jooq.impl.DSL
import org.jooq.impl.Internal
import org.jooq.impl.SQLDataType
import org.jooq.impl.TableImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class Classhierarchies(
    alias: Name,
    child: Table<out Record>?,
    path: ForeignKey<out Record, ClasshierarchiesRecord>?,
    aliased: Table<ClasshierarchiesRecord>?,
    parameters: Array<Field<*>?>?
): TableImpl<ClasshierarchiesRecord>(
    alias,
    DefaultSchema.DEFAULT_SCHEMA,
    child,
    path,
    aliased,
    parameters,
    DSL.comment(""),
    TableOptions.table()
) {
    companion object {

        /**
         * The reference instance of <code>ClassHierarchies</code>
         */
        val CLASSHIERARCHIES = Classhierarchies()
    }

    /**
     * The class holding records for this type
     */
    override fun getRecordType(): Class<ClasshierarchiesRecord> = ClasshierarchiesRecord::class.java

    /**
     * The column <code>ClassHierarchies.id</code>.
     */
    val ID: TableField<ClasshierarchiesRecord, Long?> = createField(DSL.name("id"), SQLDataType.BIGINT, this, "")

    /**
     * The column <code>ClassHierarchies.class_id</code>.
     */
    val CLASS_ID: TableField<ClasshierarchiesRecord, Long?> = createField(DSL.name("class_id"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>ClassHierarchies.super_id</code>.
     */
    val SUPER_ID: TableField<ClasshierarchiesRecord, Long?> = createField(DSL.name("super_id"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>ClassHierarchies.is_class_ref</code>.
     */
    val IS_CLASS_REF: TableField<ClasshierarchiesRecord, Boolean?> = createField(DSL.name("is_class_ref"), SQLDataType.BOOLEAN.nullable(false), this, "")

    private constructor(alias: Name, aliased: Table<ClasshierarchiesRecord>?): this(alias, null, null, aliased, null)
    private constructor(alias: Name, aliased: Table<ClasshierarchiesRecord>?, parameters: Array<Field<*>?>?): this(alias, null, null, aliased, parameters)

    /**
     * Create an aliased <code>ClassHierarchies</code> table reference
     */
    constructor(alias: String): this(DSL.name(alias))

    /**
     * Create an aliased <code>ClassHierarchies</code> table reference
     */
    constructor(alias: Name): this(alias, null)

    /**
     * Create a <code>ClassHierarchies</code> table reference
     */
    constructor(): this(DSL.name("ClassHierarchies"), null)

    constructor(child: Table<out Record>, key: ForeignKey<out Record, ClasshierarchiesRecord>): this(Internal.createPathAlias(child, key), child, key, CLASSHIERARCHIES, null)
    override fun getSchema(): Schema = DefaultSchema.DEFAULT_SCHEMA
    override fun getIndexes(): List<Index> = listOf(org.jacodb.impl.storage.jooq.indexes.`CLASS HIERARCHIES`, CLASSHIERARCHIES_CLASSID, CLASSHIERARCHIES_SUPERID)
    override fun getPrimaryKey(): UniqueKey<ClasshierarchiesRecord> = PK_CLASSHIERARCHIES
    override fun getKeys(): List<UniqueKey<ClasshierarchiesRecord>> = listOf(PK_CLASSHIERARCHIES)
    override fun getReferences(): List<ForeignKey<ClasshierarchiesRecord, *>> = listOf(FK_CLASSHIERARCHIES_CLASSES_1, FK_CLASSHIERARCHIES_SYMBOLS_1)

    private lateinit var _classes: Classes
    private lateinit var _symbols: Symbols
    fun classes(): Classes {
        if (!this::_classes.isInitialized)
            _classes = Classes(this, FK_CLASSHIERARCHIES_CLASSES_1)

        return _classes;
    }
    fun symbols(): Symbols {
        if (!this::_symbols.isInitialized)
            _symbols = Symbols(this, FK_CLASSHIERARCHIES_SYMBOLS_1)

        return _symbols;
    }
    override fun `as`(alias: String): Classhierarchies = Classhierarchies(DSL.name(alias), this)
    override fun `as`(alias: Name): Classhierarchies = Classhierarchies(alias, this)

    /**
     * Rename this table
     */
    override fun rename(name: String): Classhierarchies = Classhierarchies(DSL.name(name), null)

    /**
     * Rename this table
     */
    override fun rename(name: Name): Classhierarchies = Classhierarchies(name, null)

    // -------------------------------------------------------------------------
    // Row4 type methods
    // -------------------------------------------------------------------------
    override fun fieldsRow(): Row4<Long?, Long?, Long?, Boolean?> = super.fieldsRow() as Row4<Long?, Long?, Long?, Boolean?>
}
