/*
 *  Copyright 2022 UnitTestBot contributors (utbot.org)
 * <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This file is generated by jOOQ.
 */
package org.jacodb.impl.storage.jooq.tables


import org.jacodb.impl.storage.jooq.DefaultSchema
import org.jacodb.impl.storage.jooq.indexes.CLASSES_LOCATION
import org.jacodb.impl.storage.jooq.indexes.CLASSES_NAME
import org.jacodb.impl.storage.jooq.indexes.CLASSES_OUTERMETHODID
import org.jacodb.impl.storage.jooq.keys.*
import org.jacodb.impl.storage.jooq.tables.records.ClassesRecord
import org.jooq.*
import org.jooq.impl.DSL
import org.jooq.impl.Internal
import org.jooq.impl.SQLDataType
import org.jooq.impl.TableImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class Classes(
    alias: Name,
    child: Table<out Record>?,
    path: ForeignKey<out Record, ClassesRecord>?,
    aliased: Table<ClassesRecord>?,
    parameters: Array<Field<*>?>?
): TableImpl<ClassesRecord>(
    alias,
    DefaultSchema.DEFAULT_SCHEMA,
    child,
    path,
    aliased,
    parameters,
    DSL.comment(""),
    TableOptions.table()
) {
    companion object {

        /**
         * The reference instance of <code>Classes</code>
         */
        val CLASSES = Classes()
    }

    /**
     * The class holding records for this type
     */
    override fun getRecordType(): Class<ClassesRecord> = ClassesRecord::class.java

    /**
     * The column <code>Classes.id</code>.
     */
    val ID: TableField<ClassesRecord, Long?> = createField(DSL.name("id"), SQLDataType.BIGINT, this, "")

    /**
     * The column <code>Classes.access</code>.
     */
    val ACCESS: TableField<ClassesRecord, Int?> = createField(DSL.name("access"), SQLDataType.INTEGER.nullable(false), this, "")

    /**
     * The column <code>Classes.name</code>.
     */
    val NAME: TableField<ClassesRecord, Long?> = createField(DSL.name("name"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>Classes.signature</code>.
     */
    val SIGNATURE: TableField<ClassesRecord, String?> = createField(DSL.name("signature"), SQLDataType.CLOB, this, "")

    /**
     * The column <code>Classes.bytecode</code>.
     */
    val BYTECODE: TableField<ClassesRecord, ByteArray?> = createField(DSL.name("bytecode"), SQLDataType.BLOB.nullable(false), this, "")

    /**
     * The column <code>Classes.location_id</code>.
     */
    val LOCATION_ID: TableField<ClassesRecord, Long?> = createField(DSL.name("location_id"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>Classes.package_id</code>.
     */
    val PACKAGE_ID: TableField<ClassesRecord, Long?> = createField(DSL.name("package_id"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>Classes.outer_class</code>.
     */
    val OUTER_CLASS: TableField<ClassesRecord, Long?> = createField(DSL.name("outer_class"), SQLDataType.BIGINT, this, "")

    /**
     * The column <code>Classes.outer_method</code>.
     */
    val OUTER_METHOD: TableField<ClassesRecord, Long?> = createField(DSL.name("outer_method"), SQLDataType.BIGINT, this, "")

    private constructor(alias: Name, aliased: Table<ClassesRecord>?): this(alias, null, null, aliased, null)
    private constructor(alias: Name, aliased: Table<ClassesRecord>?, parameters: Array<Field<*>?>?): this(alias, null, null, aliased, parameters)

    /**
     * Create an aliased <code>Classes</code> table reference
     */
    constructor(alias: String): this(DSL.name(alias))

    /**
     * Create an aliased <code>Classes</code> table reference
     */
    constructor(alias: Name): this(alias, null)

    /**
     * Create a <code>Classes</code> table reference
     */
    constructor(): this(DSL.name("Classes"), null)

    constructor(child: Table<out Record>, key: ForeignKey<out Record, ClassesRecord>): this(Internal.createPathAlias(child, key), child, key, CLASSES, null)
    override fun getSchema(): Schema = DefaultSchema.DEFAULT_SCHEMA
    override fun getIndexes(): List<Index> = listOf(CLASSES_LOCATION, CLASSES_NAME, CLASSES_OUTERMETHODID)
    override fun getPrimaryKey(): UniqueKey<ClassesRecord> = PK_CLASSES
    override fun getKeys(): List<UniqueKey<ClassesRecord>> = listOf(PK_CLASSES)
    override fun getReferences(): List<ForeignKey<ClassesRecord, *>> = listOf(FK_CLASSES_SYMBOLS_2, FK_CLASSES_BYTECODELOCATIONS_1, FK_CLASSES_SYMBOLS_1, FK_CLASSES_OUTERCLASSES_1, FK_CLASSES_METHODS_1)

    private lateinit var _fkClassesSymbols_2: Symbols
    private lateinit var _bytecodelocations: Bytecodelocations
    private lateinit var _fkClassesSymbols_1: Symbols
    private lateinit var _outerclasses: Outerclasses
    private lateinit var _methods: Methods
    fun fkClassesSymbols_2(): Symbols {
        if (!this::_fkClassesSymbols_2.isInitialized)
            _fkClassesSymbols_2 = Symbols(this, FK_CLASSES_SYMBOLS_2)

        return _fkClassesSymbols_2;
    }
    fun bytecodelocations(): Bytecodelocations {
        if (!this::_bytecodelocations.isInitialized)
            _bytecodelocations = Bytecodelocations(this, FK_CLASSES_BYTECODELOCATIONS_1)

        return _bytecodelocations;
    }
    fun fkClassesSymbols_1(): Symbols {
        if (!this::_fkClassesSymbols_1.isInitialized)
            _fkClassesSymbols_1 = Symbols(this, FK_CLASSES_SYMBOLS_1)

        return _fkClassesSymbols_1;
    }
    fun outerclasses(): Outerclasses {
        if (!this::_outerclasses.isInitialized)
            _outerclasses = Outerclasses(this, FK_CLASSES_OUTERCLASSES_1)

        return _outerclasses;
    }
    fun methods(): Methods {
        if (!this::_methods.isInitialized)
            _methods = Methods(this, FK_CLASSES_METHODS_1)

        return _methods;
    }
    override fun `as`(alias: String): Classes = Classes(DSL.name(alias), this)
    override fun `as`(alias: Name): Classes = Classes(alias, this)

    /**
     * Rename this table
     */
    override fun rename(name: String): Classes = Classes(DSL.name(name), null)

    /**
     * Rename this table
     */
    override fun rename(name: Name): Classes = Classes(name, null)

    // -------------------------------------------------------------------------
    // Row9 type methods
    // -------------------------------------------------------------------------
    override fun fieldsRow(): Row9<Long?, Int?, Long?, String?, ByteArray?, Long?, Long?, Long?, Long?> = super.fieldsRow() as Row9<Long?, Int?, Long?, String?, ByteArray?, Long?, Long?, Long?, Long?>
}
