/*
 *  Copyright 2022 UnitTestBot contributors (utbot.org)
 * <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This file is generated by jOOQ.
 */
package org.jacodb.impl.storage.jooq.tables


import org.jacodb.impl.storage.jooq.DefaultSchema
import org.jacodb.impl.storage.jooq.keys.*
import org.jacodb.impl.storage.jooq.tables.records.AnnotationvaluesRecord
import org.jooq.*
import org.jooq.impl.DSL
import org.jooq.impl.Internal
import org.jooq.impl.SQLDataType
import org.jooq.impl.TableImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class Annotationvalues(
    alias: Name,
    child: Table<out Record>?,
    path: ForeignKey<out Record, AnnotationvaluesRecord>?,
    aliased: Table<AnnotationvaluesRecord>?,
    parameters: Array<Field<*>?>?
): TableImpl<AnnotationvaluesRecord>(
    alias,
    DefaultSchema.DEFAULT_SCHEMA,
    child,
    path,
    aliased,
    parameters,
    DSL.comment(""),
    TableOptions.table()
) {
    companion object {

        /**
         * The reference instance of <code>AnnotationValues</code>
         */
        val ANNOTATIONVALUES = Annotationvalues()
    }

    /**
     * The class holding records for this type
     */
    override fun getRecordType(): Class<AnnotationvaluesRecord> = AnnotationvaluesRecord::class.java

    /**
     * The column <code>AnnotationValues.id</code>.
     */
    val ID: TableField<AnnotationvaluesRecord, Long?> = createField(DSL.name("id"), SQLDataType.BIGINT, this, "")

    /**
     * The column <code>AnnotationValues.annotation_id</code>.
     */
    val ANNOTATION_ID: TableField<AnnotationvaluesRecord, Long?> = createField(DSL.name("annotation_id"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>AnnotationValues.name</code>.
     */
    val NAME: TableField<AnnotationvaluesRecord, String?> = createField(DSL.name("name"), SQLDataType.VARCHAR(256).nullable(false), this, "")

    /**
     * The column <code>AnnotationValues.ref_annotation_id</code>.
     */
    val REF_ANNOTATION_ID: TableField<AnnotationvaluesRecord, Long?> = createField(DSL.name("ref_annotation_id"), SQLDataType.BIGINT, this, "")

    /**
     * The column <code>AnnotationValues.kind</code>.
     */
    val KIND: TableField<AnnotationvaluesRecord, Int?> = createField(DSL.name("kind"), SQLDataType.INTEGER, this, "")

    /**
     * The column <code>AnnotationValues.value</code>.
     */
    val VALUE: TableField<AnnotationvaluesRecord, String?> = createField(DSL.name("value"), SQLDataType.CLOB, this, "")

    /**
     * The column <code>AnnotationValues.class_symbol</code>.
     */
    val CLASS_SYMBOL: TableField<AnnotationvaluesRecord, Long?> = createField(DSL.name("class_symbol"), SQLDataType.BIGINT, this, "")

    /**
     * The column <code>AnnotationValues.enum_value</code>.
     */
    val ENUM_VALUE: TableField<AnnotationvaluesRecord, Long?> = createField(DSL.name("enum_value"), SQLDataType.BIGINT, this, "")

    private constructor(alias: Name, aliased: Table<AnnotationvaluesRecord>?): this(alias, null, null, aliased, null)
    private constructor(alias: Name, aliased: Table<AnnotationvaluesRecord>?, parameters: Array<Field<*>?>?): this(alias, null, null, aliased, parameters)

    /**
     * Create an aliased <code>AnnotationValues</code> table reference
     */
    constructor(alias: String): this(DSL.name(alias))

    /**
     * Create an aliased <code>AnnotationValues</code> table reference
     */
    constructor(alias: Name): this(alias, null)

    /**
     * Create a <code>AnnotationValues</code> table reference
     */
    constructor(): this(DSL.name("AnnotationValues"), null)

    constructor(child: Table<out Record>, key: ForeignKey<out Record, AnnotationvaluesRecord>): this(Internal.createPathAlias(child, key), child, key, ANNOTATIONVALUES, null)
    override fun getSchema(): Schema = DefaultSchema.DEFAULT_SCHEMA
    override fun getPrimaryKey(): UniqueKey<AnnotationvaluesRecord> = PK_ANNOTATIONVALUES
    override fun getKeys(): List<UniqueKey<AnnotationvaluesRecord>> = listOf(PK_ANNOTATIONVALUES)
    override fun getReferences(): List<ForeignKey<AnnotationvaluesRecord, *>> = listOf(FK_ANNOTATIONVALUES_ANNOTATIONS_2, FK_ANNOTATIONVALUES_ANNOTATIONS_1, FK_ANNOTATIONVALUES_SYMBOLS_1, FK_ANNOTATIONVALUES_SYMBOLS_2)

    private lateinit var _fkAnnotationvaluesAnnotations_2: Annotations
    private lateinit var _fkAnnotationvaluesAnnotations_1: Annotations
    private lateinit var _fkAnnotationvaluesSymbols_1: Symbols
    private lateinit var _fkAnnotationvaluesSymbols_2: Symbols
    fun fkAnnotationvaluesAnnotations_2(): Annotations {
        if (!this::_fkAnnotationvaluesAnnotations_2.isInitialized)
            _fkAnnotationvaluesAnnotations_2 = Annotations(this, FK_ANNOTATIONVALUES_ANNOTATIONS_2)

        return _fkAnnotationvaluesAnnotations_2;
    }
    fun fkAnnotationvaluesAnnotations_1(): Annotations {
        if (!this::_fkAnnotationvaluesAnnotations_1.isInitialized)
            _fkAnnotationvaluesAnnotations_1 = Annotations(this, FK_ANNOTATIONVALUES_ANNOTATIONS_1)

        return _fkAnnotationvaluesAnnotations_1;
    }
    fun fkAnnotationvaluesSymbols_1(): Symbols {
        if (!this::_fkAnnotationvaluesSymbols_1.isInitialized)
            _fkAnnotationvaluesSymbols_1 = Symbols(this, FK_ANNOTATIONVALUES_SYMBOLS_1)

        return _fkAnnotationvaluesSymbols_1;
    }
    fun fkAnnotationvaluesSymbols_2(): Symbols {
        if (!this::_fkAnnotationvaluesSymbols_2.isInitialized)
            _fkAnnotationvaluesSymbols_2 = Symbols(this, FK_ANNOTATIONVALUES_SYMBOLS_2)

        return _fkAnnotationvaluesSymbols_2;
    }
    override fun `as`(alias: String): Annotationvalues = Annotationvalues(DSL.name(alias), this)
    override fun `as`(alias: Name): Annotationvalues = Annotationvalues(alias, this)

    /**
     * Rename this table
     */
    override fun rename(name: String): Annotationvalues = Annotationvalues(DSL.name(name), null)

    /**
     * Rename this table
     */
    override fun rename(name: Name): Annotationvalues = Annotationvalues(name, null)

    // -------------------------------------------------------------------------
    // Row8 type methods
    // -------------------------------------------------------------------------
    override fun fieldsRow(): Row8<Long?, Long?, String?, Long?, Int?, String?, Long?, Long?> = super.fieldsRow() as Row8<Long?, Long?, String?, Long?, Int?, String?, Long?, Long?>
}
