/*
 *  Copyright 2022 UnitTestBot contributors (utbot.org)
 * <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This file is generated by jOOQ.
 */
package org.jacodb.impl.storage.jooq.keys


import org.jacodb.impl.storage.jooq.tables.*
import org.jacodb.impl.storage.jooq.tables.records.*
import org.jooq.ForeignKey
import org.jooq.UniqueKey
import org.jooq.impl.DSL
import org.jooq.impl.Internal


// -------------------------------------------------------------------------
// UNIQUE and PRIMARY KEY definitions
// -------------------------------------------------------------------------

val PK_ANNOTATIONS: UniqueKey<AnnotationsRecord> = Internal.createUniqueKey(Annotations.ANNOTATIONS, DSL.name("pk_Annotations"), arrayOf(Annotations.ANNOTATIONS.ID), true)
val PK_ANNOTATIONVALUES: UniqueKey<AnnotationvaluesRecord> = Internal.createUniqueKey(Annotationvalues.ANNOTATIONVALUES, DSL.name("pk_AnnotationValues"), arrayOf(Annotationvalues.ANNOTATIONVALUES.ID), true)
val PK_BYTECODELOCATIONS: UniqueKey<BytecodelocationsRecord> = Internal.createUniqueKey(Bytecodelocations.BYTECODELOCATIONS, DSL.name("pk_BytecodeLocations"), arrayOf(Bytecodelocations.BYTECODELOCATIONS.ID), true)
val PK_CLASSES: UniqueKey<ClassesRecord> = Internal.createUniqueKey(Classes.CLASSES, DSL.name("pk_Classes"), arrayOf(Classes.CLASSES.ID), true)
val PK_CLASSHIERARCHIES: UniqueKey<ClasshierarchiesRecord> = Internal.createUniqueKey(Classhierarchies.CLASSHIERARCHIES, DSL.name("pk_ClassHierarchies"), arrayOf(Classhierarchies.CLASSHIERARCHIES.ID), true)
val PK_CLASSINNERCLASSES: UniqueKey<ClassinnerclassesRecord> = Internal.createUniqueKey(Classinnerclasses.CLASSINNERCLASSES, DSL.name("pk_ClassInnerClasses"), arrayOf(Classinnerclasses.CLASSINNERCLASSES.ID), true)
val PK_FIELDS: UniqueKey<FieldsRecord> = Internal.createUniqueKey(Fields.FIELDS, DSL.name("pk_Fields"), arrayOf(Fields.FIELDS.ID), true)
val PK_METHODPARAMETERS: UniqueKey<MethodparametersRecord> = Internal.createUniqueKey(Methodparameters.METHODPARAMETERS, DSL.name("pk_MethodParameters"), arrayOf(Methodparameters.METHODPARAMETERS.ID), true)
val PK_METHODS: UniqueKey<MethodsRecord> = Internal.createUniqueKey(Methods.METHODS, DSL.name("pk_Methods"), arrayOf(Methods.METHODS.ID), true)
val PK_OUTERCLASSES: UniqueKey<OuterclassesRecord> = Internal.createUniqueKey(Outerclasses.OUTERCLASSES, DSL.name("pk_OuterClasses"), arrayOf(Outerclasses.OUTERCLASSES.ID), true)
val PK_SYMBOLS: UniqueKey<SymbolsRecord> = Internal.createUniqueKey(Symbols.SYMBOLS, DSL.name("pk_Symbols"), arrayOf(Symbols.SYMBOLS.ID), true)

// -------------------------------------------------------------------------
// FOREIGN KEY definitions
// -------------------------------------------------------------------------

val FK_ANNOTATIONS_ANNOTATIONS_1: ForeignKey<AnnotationsRecord, AnnotationsRecord> = Internal.createForeignKey(Annotations.ANNOTATIONS, DSL.name("fk_Annotations_Annotations_1"), arrayOf(Annotations.ANNOTATIONS.PARENT_ANNOTATION), org.jacodb.impl.storage.jooq.keys.PK_ANNOTATIONS, arrayOf(Annotations.ANNOTATIONS.ID), true)
val FK_ANNOTATIONS_CLASSES_1: ForeignKey<AnnotationsRecord, ClassesRecord> = Internal.createForeignKey(Annotations.ANNOTATIONS, DSL.name("fk_Annotations_Classes_1"), arrayOf(Annotations.ANNOTATIONS.CLASS_ID), org.jacodb.impl.storage.jooq.keys.PK_CLASSES, arrayOf(Classes.CLASSES.ID), true)
val FK_ANNOTATIONS_FIELDS_1: ForeignKey<AnnotationsRecord, FieldsRecord> = Internal.createForeignKey(Annotations.ANNOTATIONS, DSL.name("fk_Annotations_Fields_1"), arrayOf(Annotations.ANNOTATIONS.FIELD_ID), org.jacodb.impl.storage.jooq.keys.PK_FIELDS, arrayOf(Fields.FIELDS.ID), true)
val FK_ANNOTATIONS_METHODPARAMETERS_1: ForeignKey<AnnotationsRecord, MethodparametersRecord> = Internal.createForeignKey(Annotations.ANNOTATIONS, DSL.name("fk_Annotations_MethodParameters_1"), arrayOf(Annotations.ANNOTATIONS.PARAM_ID), org.jacodb.impl.storage.jooq.keys.PK_METHODPARAMETERS, arrayOf(Methodparameters.METHODPARAMETERS.ID), true)
val FK_ANNOTATIONS_METHODS_1: ForeignKey<AnnotationsRecord, MethodsRecord> = Internal.createForeignKey(Annotations.ANNOTATIONS, DSL.name("fk_Annotations_Methods_1"), arrayOf(Annotations.ANNOTATIONS.METHOD_ID), org.jacodb.impl.storage.jooq.keys.PK_METHODS, arrayOf(Methods.METHODS.ID), true)
val FK_ANNOTATIONS_SYMBOLS_1: ForeignKey<AnnotationsRecord, SymbolsRecord> = Internal.createForeignKey(Annotations.ANNOTATIONS, DSL.name("fk_Annotations_Symbols_1"), arrayOf(Annotations.ANNOTATIONS.ANNOTATION_NAME), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_ANNOTATIONVALUES_ANNOTATIONS_1: ForeignKey<AnnotationvaluesRecord, AnnotationsRecord> = Internal.createForeignKey(Annotationvalues.ANNOTATIONVALUES, DSL.name("fk_AnnotationValues_Annotations_1"), arrayOf(Annotationvalues.ANNOTATIONVALUES.REF_ANNOTATION_ID), org.jacodb.impl.storage.jooq.keys.PK_ANNOTATIONS, arrayOf(Annotations.ANNOTATIONS.ID), true)
val FK_ANNOTATIONVALUES_ANNOTATIONS_2: ForeignKey<AnnotationvaluesRecord, AnnotationsRecord> = Internal.createForeignKey(Annotationvalues.ANNOTATIONVALUES, DSL.name("fk_AnnotationValues_Annotations_2"), arrayOf(Annotationvalues.ANNOTATIONVALUES.ANNOTATION_ID), org.jacodb.impl.storage.jooq.keys.PK_ANNOTATIONS, arrayOf(Annotations.ANNOTATIONS.ID), true)
val FK_ANNOTATIONVALUES_SYMBOLS_1: ForeignKey<AnnotationvaluesRecord, SymbolsRecord> = Internal.createForeignKey(Annotationvalues.ANNOTATIONVALUES, DSL.name("fk_AnnotationValues_Symbols_1"), arrayOf(Annotationvalues.ANNOTATIONVALUES.CLASS_SYMBOL), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_ANNOTATIONVALUES_SYMBOLS_2: ForeignKey<AnnotationvaluesRecord, SymbolsRecord> = Internal.createForeignKey(Annotationvalues.ANNOTATIONVALUES, DSL.name("fk_AnnotationValues_Symbols_2"), arrayOf(Annotationvalues.ANNOTATIONVALUES.ENUM_VALUE), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_BUILDERS_BYTECODELOCATIONS_1: ForeignKey<BuildersRecord, BytecodelocationsRecord> = Internal.createForeignKey(Builders.BUILDERS, DSL.name("fk_Builders_BytecodeLocations_1"), arrayOf(Builders.BUILDERS.LOCATION_ID), org.jacodb.impl.storage.jooq.keys.PK_BYTECODELOCATIONS, arrayOf(Bytecodelocations.BYTECODELOCATIONS.ID), true)
val FK_BYTECODELOCATIONS_BYTECODELOCATIONS_1: ForeignKey<BytecodelocationsRecord, BytecodelocationsRecord> = Internal.createForeignKey(Bytecodelocations.BYTECODELOCATIONS, DSL.name("fk_BytecodeLocations_BytecodeLocations_1"), arrayOf(Bytecodelocations.BYTECODELOCATIONS.UPDATED_ID), org.jacodb.impl.storage.jooq.keys.PK_BYTECODELOCATIONS, arrayOf(Bytecodelocations.BYTECODELOCATIONS.ID), true)
val FK_CALLS_BYTECODELOCATIONS_1: ForeignKey<CallsRecord, BytecodelocationsRecord> = Internal.createForeignKey(Calls.CALLS, DSL.name("fk_Calls_BytecodeLocations_1"), arrayOf(Calls.CALLS.LOCATION_ID), org.jacodb.impl.storage.jooq.keys.PK_BYTECODELOCATIONS, arrayOf(Bytecodelocations.BYTECODELOCATIONS.ID), true)
val FK_CLASSES_BYTECODELOCATIONS_1: ForeignKey<ClassesRecord, BytecodelocationsRecord> = Internal.createForeignKey(Classes.CLASSES, DSL.name("fk_Classes_BytecodeLocations_1"), arrayOf(Classes.CLASSES.LOCATION_ID), org.jacodb.impl.storage.jooq.keys.PK_BYTECODELOCATIONS, arrayOf(Bytecodelocations.BYTECODELOCATIONS.ID), true)
val FK_CLASSES_METHODS_1: ForeignKey<ClassesRecord, MethodsRecord> = Internal.createForeignKey(Classes.CLASSES, DSL.name("fk_Classes_Methods_1"), arrayOf(Classes.CLASSES.OUTER_METHOD), org.jacodb.impl.storage.jooq.keys.PK_METHODS, arrayOf(Methods.METHODS.ID), true)
val FK_CLASSES_OUTERCLASSES_1: ForeignKey<ClassesRecord, OuterclassesRecord> = Internal.createForeignKey(Classes.CLASSES, DSL.name("fk_Classes_OuterClasses_1"), arrayOf(Classes.CLASSES.OUTER_CLASS), org.jacodb.impl.storage.jooq.keys.PK_OUTERCLASSES, arrayOf(Outerclasses.OUTERCLASSES.ID), true)
val FK_CLASSES_SYMBOLS_1: ForeignKey<ClassesRecord, SymbolsRecord> = Internal.createForeignKey(Classes.CLASSES, DSL.name("fk_Classes_Symbols_1"), arrayOf(Classes.CLASSES.PACKAGE_ID), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_CLASSES_SYMBOLS_2: ForeignKey<ClassesRecord, SymbolsRecord> = Internal.createForeignKey(Classes.CLASSES, DSL.name("fk_Classes_Symbols_2"), arrayOf(Classes.CLASSES.NAME), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_CLASSHIERARCHIES_CLASSES_1: ForeignKey<ClasshierarchiesRecord, ClassesRecord> = Internal.createForeignKey(Classhierarchies.CLASSHIERARCHIES, DSL.name("fk_ClassHierarchies_Classes_1"), arrayOf(Classhierarchies.CLASSHIERARCHIES.CLASS_ID), org.jacodb.impl.storage.jooq.keys.PK_CLASSES, arrayOf(Classes.CLASSES.ID), true)
val FK_CLASSHIERARCHIES_SYMBOLS_1: ForeignKey<ClasshierarchiesRecord, SymbolsRecord> = Internal.createForeignKey(Classhierarchies.CLASSHIERARCHIES, DSL.name("fk_ClassHierarchies_Symbols_1"), arrayOf(Classhierarchies.CLASSHIERARCHIES.SUPER_ID), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_CLASSINNERCLASSES_CLASSES_1: ForeignKey<ClassinnerclassesRecord, ClassesRecord> = Internal.createForeignKey(Classinnerclasses.CLASSINNERCLASSES, DSL.name("fk_ClassInnerClasses_Classes_1"), arrayOf(Classinnerclasses.CLASSINNERCLASSES.CLASS_ID), org.jacodb.impl.storage.jooq.keys.PK_CLASSES, arrayOf(Classes.CLASSES.ID), true)
val FK_CLASSINNERCLASSES_SYMBOLS_1: ForeignKey<ClassinnerclassesRecord, SymbolsRecord> = Internal.createForeignKey(Classinnerclasses.CLASSINNERCLASSES, DSL.name("fk_ClassInnerClasses_Symbols_1"), arrayOf(Classinnerclasses.CLASSINNERCLASSES.INNER_CLASS_ID), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_FIELDS_CLASSES_1: ForeignKey<FieldsRecord, ClassesRecord> = Internal.createForeignKey(Fields.FIELDS, DSL.name("fk_Fields_Classes_1"), arrayOf(Fields.FIELDS.CLASS_ID), org.jacodb.impl.storage.jooq.keys.PK_CLASSES, arrayOf(Classes.CLASSES.ID), true)
val FK_FIELDS_SYMBOLS_1: ForeignKey<FieldsRecord, SymbolsRecord> = Internal.createForeignKey(Fields.FIELDS, DSL.name("fk_Fields_Symbols_1"), arrayOf(Fields.FIELDS.FIELD_CLASS), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_FIELDS_SYMBOLS_2: ForeignKey<FieldsRecord, SymbolsRecord> = Internal.createForeignKey(Fields.FIELDS, DSL.name("fk_Fields_Symbols_2"), arrayOf(Fields.FIELDS.NAME), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_METHODPARAMETERS_METHODS_1: ForeignKey<MethodparametersRecord, MethodsRecord> = Internal.createForeignKey(Methodparameters.METHODPARAMETERS, DSL.name("fk_MethodParameters_Methods_1"), arrayOf(Methodparameters.METHODPARAMETERS.METHOD_ID), org.jacodb.impl.storage.jooq.keys.PK_METHODS, arrayOf(Methods.METHODS.ID), true)
val FK_METHODPARAMETERS_SYMBOLS_1: ForeignKey<MethodparametersRecord, SymbolsRecord> = Internal.createForeignKey(Methodparameters.METHODPARAMETERS, DSL.name("fk_MethodParameters_Symbols_1"), arrayOf(Methodparameters.METHODPARAMETERS.PARAMETER_CLASS), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_METHODS_CLASSES_1: ForeignKey<MethodsRecord, ClassesRecord> = Internal.createForeignKey(Methods.METHODS, DSL.name("fk_Methods_Classes_1"), arrayOf(Methods.METHODS.CLASS_ID), org.jacodb.impl.storage.jooq.keys.PK_CLASSES, arrayOf(Classes.CLASSES.ID), true)
val FK_METHODS_SYMBOLS_1: ForeignKey<MethodsRecord, SymbolsRecord> = Internal.createForeignKey(Methods.METHODS, DSL.name("fk_Methods_Symbols_1"), arrayOf(Methods.METHODS.RETURN_CLASS), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_METHODS_SYMBOLS_2: ForeignKey<MethodsRecord, SymbolsRecord> = Internal.createForeignKey(Methods.METHODS, DSL.name("fk_Methods_Symbols_2"), arrayOf(Methods.METHODS.NAME), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
val FK_OUTERCLASSES_SYMBOLS_1: ForeignKey<OuterclassesRecord, SymbolsRecord> = Internal.createForeignKey(Outerclasses.OUTERCLASSES, DSL.name("fk_OuterClasses_Symbols_1"), arrayOf(Outerclasses.OUTERCLASSES.OUTER_CLASS_NAME_ID), org.jacodb.impl.storage.jooq.keys.PK_SYMBOLS, arrayOf(Symbols.SYMBOLS.ID), true)
