import matplotlib.pyplot as plt
import pandas as pd
import logging

def apply_operations(df, operations):
    """
    Applies the operations to the DataFrame one by one.
    Args:
        df (pd.DataFrame): The DataFrame to apply operations on.
        operations (list): List of operation strings generated by the model.
    Returns:
        pd.DataFrame or matplotlib plot: The modified DataFrame or the plot figure.
    """
    local_scope = {'df': df}  # Include 'df' so it's available for operations

    for operation in operations:
        try:
            # Execute the operation and modify the local scope
            exec(operation, {"__builtins__": None}, local_scope)
        except Exception as e:
            logging.error(f"Error executing operation: {e}. Operation: {operation}")

    try:
        # Check if 'result_string' exists in the local scope and return it
        if 'result_string' in local_scope:
            return local_scope['result_string']

        # Check if 'result_plot' is created in the local scope
        elif 'result_plot' in local_scope:
            # If 'result_plot' is a plot, it will be an Axes object; retrieve its figure
            if isinstance(local_scope['result_plot'], plt.Axes):
                fig = local_scope['result_plot'].get_figure()
                return fig
            else:
                logging.error("Unexpected plot type in 'result_plot'. Expected Axes object.")
                return None
        # Otherwise, return the DataFrame if modified
        elif 'df' in local_scope:
            return local_scope['df']
        else:
            logging.error("No result (DataFrame, string, or plot) returned from operations.")
            return None
        
    except Exception as e:
        logging.error(f"Error handling the result: {e}")
        return None
