# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-08-19 10:50
from __future__ import unicode_literals

import datetime
from django.db import migrations, models
import django.db.models.deletion
import tinymce.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='GroupedLocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_pk', models.CharField(max_length=255)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
        ),
        migrations.CreateModel(
            name='MapObj',
            fields=[
                ('id', models.CharField(help_text=b'<strong class="caution">Caution</strong>: changing may break external resources (used for links and images)', max_length=80, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255, null=True)),
                ('image', models.ImageField(upload_to=b'uploads/images')),
                ('description', models.CharField(max_length=255, null=True)),
                ('profile', tinymce.models.HTMLField(null=True)),
                ('googlemap_point', models.CharField(help_text=b'E.g., <code>[28.6017, -81.2005]</code>', max_length=255, null=True)),
                ('illustrated_point', models.CharField(max_length=255, null=True)),
                ('poly_coords', models.TextField(null=True)),
                ('modified', models.DateTimeField(default=datetime.datetime.now)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Sidewalk',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('poly_coords', models.TextField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='SimpleSetting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=80)),
                ('value', tinymce.models.HTMLField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='BikeRack',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
            ],
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='Building',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
                ('abbreviation', models.CharField(max_length=50, null=True)),
                ('address', models.CharField(max_length=255, null=True)),
                ('sketchup', models.CharField(help_text=b'E.g., https://3dwarehouse.sketchup.com/model.html?id=<code>54b7f313bf315a3a85622796b26c9e66</code>', max_length=50, null=True)),
            ],
            options={
                'ordering': ('name', 'id'),
            },
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='DiningLocation',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
                ('address', models.CharField(max_length=255, null=True)),
            ],
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='DisabledParking',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
                ('num_spaces', models.IntegerField(null=True)),
            ],
            options={
                'verbose_name_plural': 'Handicap Parking',
            },
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='ElectricChargingStation',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
            ],
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='EmergencyAED',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
            ],
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='EmergencyPhone',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
            ],
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
            ],
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
            ],
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='ParkingLot',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
                ('permit_type', models.CharField(max_length=255, null=True)),
                ('abbreviation', models.CharField(max_length=50, null=True)),
                ('sketchup', models.CharField(help_text=b'E.g., https://3dwarehouse.sketchup.com/model.html?id=<code>54b7f313bf315a3a85622796b26c9e66</code>', max_length=50, null=True)),
            ],
            bases=('campus.mapobj',),
        ),
        migrations.CreateModel(
            name='RegionalCampus',
            fields=[
                ('mapobj_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='campus.MapObj')),
            ],
            options={
                'verbose_name_plural': 'UCF Connect Locations',
            },
            bases=('campus.mapobj',),
        ),
        migrations.AddField(
            model_name='mapobj',
            name='content_type',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType'),
        ),
        migrations.AlterUniqueTogether(
            name='groupedlocation',
            unique_together=set([('object_pk', 'content_type')]),
        ),
        migrations.AddField(
            model_name='group',
            name='locations',
            field=models.ManyToManyField(null=True, to='campus.GroupedLocation'),
        ),
    ]
