/* LookingGlass show.js
 *
 * Transparency Toolkit, 2018
 * Author: Brennan Novak
 */

$(document).ready(function() {

  // Show Article in Tab
  $('.show-article-tab').on('click', function(e) {

    e.preventDefault();

    $(this).attr('href');
    $(this).data('index');
    var new_tab_id = 'article-' + $(this).data('index');

    if ($('#' + new_tab_id).length == 0) {
      $('#maincontent').find('.nav-pills').append('<li id="li' + new_tab_id + '">\
        <a href="#' + new_tab_id + '" data-toggle="tab"> Article #' + $(this).data('index') + '</a>\
      </li>');

      $('#maincontent').find('.tab-content').append('<div class="tab-pane" id="' + new_tab_id + '">\
        <iframe class="show-iframe" src="' + $(this).attr('href') + '" width="100%" height="700" sandbox="allow-same-origin"></iframe>\
      </div>');
    }

    $('#li' + new_tab_id + ' a[href="#' + new_tab_id + '"]').tab('show');

  });


  // Diffing
  var dmp = new diff_match_patch();
  var doDiffing = function(doc_id, diffing, name, item) {
    dmp.Diff_Timeout = 4
    dmp.Diff_EditCost = 4

    var ms_start = (new Date()).getTime()
    var d = dmp.diff_main(item.versions.oldest, item.versions.newest)
    var ms_end = (new Date()).getTime()

    if (diffing == 'Sequentially') {
      dmp.diff_cleanupSemantic(d)
    }
    else if (diffing == 'Mixed') {
      dmp.diff_cleanupEfficiency(d)
    }

    var ds = dmp.diff_prettyHtml(d)

    $('#versions-diff-data-' + doc_id)
      .append('<' + item.element_type + ' class="diffed-' + name + '">' + item.label + ds + '</' + item.element_type + '>')
    return true
  }

  var doDiffingHTML = function(doc_id, diffing, name, item) {
    $('#versions-diff-data-' + doc_id)
      .append('<' + item.element_type + ' class="diffed-' + name + '">' + item.label + item.versions.oldest + '</' +
     item.element_type + '>')
  }

  var doNonDiffing = function(doc_id, diffing, name, item) {

    if (item.versions.oldest === undefined && item.versions.newest !== undefined) {
      $('#versions-diff-data-' + doc_id)
        .append('<' + item.element_type + ' class="diffed-' + name + '">' + item.label + item.versions.newest + ' <ins style="background:#e6ffe6;"> (shown in newest)</ins></' + item.element_type + '>')
    } else if (item.versions.newest === undefined && item.versions.oldest !== undefined) {
      $('#versions-diff-data-' + doc_id)
        .append('<' + item.element_type + ' class="diffed-' + name + '">' + item.label + item.versions.oldest + ' <ins style="background:#ffe6e6;"> (shown in oldest)</ins></' + item.element_type + '>')
    }

    return true
  }

  var extractDiffingItem = function(element_pairs, version, item) {

    var name = $(item).attr('class')
    var type = $(item).prop('tagName')

    // Filter non-content elements
    if (_.indexOf(['SMALL', 'HR'], type) == -1) {

      var text_all = $(item).html()
      var label = ''

      if ($(item).find('.label').prop('outerHTML') !== undefined) {
        label = $(item).find('.label').prop('outerHTML')
      }

      var text_trim = text_all.replace(label, '')

      // Does item exist
      if (element_pairs[name] === undefined) {
        element_pairs[name] = {
          'element_type': type,
          'label': label,
          'versions': {}
        }

        element_pairs[name].versions[version] = text_trim

      } else if (element_pairs[name]) {
        element_pairs[name].versions[version] = text_trim
      }
    } else {
      // Use to debug unusual elements
      // console.log(name + ' | SKIPPED')
    }

    return element_pairs
  }

  var getDiffingData = function(doc_id, diffing) {

    // Reset Diff View
    $('#versions-diff-data-' + doc_id).html('')

    // Get Data
    var version_oldest = $('#version-oldest-' + doc_id).children()
    var version_newest = $('#version-newest-' + doc_id).children()
    var element_pairs = {}

    // Do Oldest version
    _.each(version_oldest, function(item, key) {
      element_pairs = extractDiffingItem(element_pairs, 'oldest', item)
    })

    // Then Newest version
    _.each(version_newest, function(item, key) {
      element_pairs = extractDiffingItem(element_pairs, 'newest', item)
    })

    // Render
    // to debug results
    // console.log(element_pairs)
    _.each(element_pairs, function(item, name) {
      if (item.versions.oldest !== undefined && item.versions.newest !== undefined) {
        if (/<[a-z][\s\S]*>/i.test(item.versions.oldest)) {
          doDiffingHTML(doc_id, diffing, name, item)
        } else if (/<[a-z][\s\S]*>/i.test(item.versions.newest)) {
          $('#versions-diff-data-' + doc_id)
            .append('<' + item.element_type + ' class="diffed-' + name + '">' + item.label + item.versions.oldest + '</' + item.element_type + '>');
        } else {
          doDiffing(doc_id, diffing, name, item)
        }
      } else {
        doNonDiffing(doc_id, diffing, name, item)
      }
    })
  }

  // Perform Diff
  $('.versions-compute').on('click', function(e) {
    e.preventDefault()
    getDiffingData($(this).data('doc_id'), $(this).data('diffing'))

    $('#versions-diff-' + $(this).data('doc_id'))
      .removeClass('invisible')
      .find('h3.panel-title')
      .html('Data Differences: ' + $(this).data('diffing'))

    var position_offset = ($('#versions-diff-' + $(this).data('doc_id')).offset().top - 60)

    $('html, body').animate({ scrollTop: position_offset + 'px' }, 'fast')
  })

})
