import type { ErrorObject, Vocabulary } from "webpack-dev-middleware/node_modules/ajv/dist/types";
import { LimitNumberError } from "webpack-dev-middleware/node_modules/ajv/dist/vocabularies/validation/limitNumber";
import { MultipleOfError } from "webpack-dev-middleware/node_modules/ajv/dist/vocabularies/validation/multipleOf";
import { PatternError } from "webpack-dev-middleware/node_modules/ajv/dist/vocabularies/validation/pattern";
import { RequiredError } from "webpack-dev-middleware/node_modules/ajv/dist/vocabularies/validation/required";
import { UniqueItemsError } from "webpack-dev-middleware/node_modules/ajv/dist/vocabularies/validation/uniqueItems";
import { ConstError } from "webpack-dev-middleware/node_modules/ajv/dist/vocabularies/validation/const";
import { EnumError } from "webpack-dev-middleware/node_modules/ajv/dist/vocabularies/validation/enum";
declare const validation: Vocabulary;
export default validation;
type LimitError = ErrorObject<"maxItems" | "minItems" | "minProperties" | "maxProperties" | "minLength" | "maxLength", {
    limit: number;
}, number | {
    $data: string;
}>;
export type ValidationKeywordError = LimitError | LimitNumberError | MultipleOfError | PatternError | RequiredError | UniqueItemsError | ConstError | EnumError;
