import * as vue from 'vue';
import { ComponentPropsOptions, ExtractPropTypes, VNodeChild, VNode, Ref, PropType } from 'vue';

type SlotsToProps<U extends RawSlots, T = MakeInternalSlots<U>> = {
    $children?: (VNodeChild | (T extends {
        default: infer V;
    } ? V : {}) | {
        [K in keyof T]?: T[K];
    });
    'v-slots'?: {
        [K in keyof T]?: T[K] | false;
    };
} & {
    [K in keyof T as `v-slot:${K & string}`]?: T[K] | false;
};
type RawSlots = Record<string, unknown>;
type Slot<T> = [T] extends [never] ? () => VNodeChild : (arg: T) => VNodeChild;
type VueSlot<T> = [T] extends [never] ? () => VNode[] : (arg: T) => VNode[];
type MakeInternalSlots<T extends RawSlots> = {
    [K in keyof T]: Slot<T[K]>;
};
type MakeSlots<T extends RawSlots> = {
    [K in keyof T]: VueSlot<T[K]>;
};
type GenericProps<Props, Slots extends Record<string, unknown>> = {
    $props: Props & SlotsToProps<Slots>;
    $slots: MakeSlots<Slots>;
};
interface FilterPropsOptions<PropsOptions extends Readonly<ComponentPropsOptions>, Props = ExtractPropTypes<PropsOptions>> {
    filterProps<T extends Partial<Props>, U extends Exclude<keyof Props, Exclude<keyof Props, keyof T>>>(props: T): Partial<Pick<T, U>>;
}

interface VVirtualScrollSlot<T> {
    item: T;
    index: number;
}
declare const VVirtualScroll: {
    new (...args: any[]): vue.CreateComponentPublicInstance<{
        style: vue.StyleValue;
        itemHeight: string | number;
    } & {
        class?: any;
        width?: string | number | undefined;
        height?: string | number | undefined;
        maxHeight?: string | number | undefined;
        maxWidth?: string | number | undefined;
        minHeight?: string | number | undefined;
        minWidth?: string | number | undefined;
    }, {
        scrollToIndex: (index: number) => void;
    }, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Omit<Record<string, any>, "v-slot:default" | "$children" | "v-slots" | "items" | "renderless">, vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & {
        style: vue.StyleValue;
        itemHeight: string | number;
    } & {
        class?: any;
        width?: string | number | undefined;
        height?: string | number | undefined;
        maxHeight?: string | number | undefined;
        maxWidth?: string | number | undefined;
        minHeight?: string | number | undefined;
        minWidth?: string | number | undefined;
    }, {
        style: vue.StyleValue;
        itemHeight: string | number;
    }, true, {}, vue.SlotsType<Partial<{
        default: (arg: VVirtualScrollSlot<unknown> | (VVirtualScrollSlot<unknown> & {
            itemRef: Ref<HTMLElement | undefined>;
        })) => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>[];
    }>>, {
        P: {};
        B: {};
        D: {};
        C: {};
        M: {};
        Defaults: {};
    }, {
        style: vue.StyleValue;
        itemHeight: string | number;
    } & {
        class?: any;
        width?: string | number | undefined;
        height?: string | number | undefined;
        maxHeight?: string | number | undefined;
        maxWidth?: string | number | undefined;
        minHeight?: string | number | undefined;
        minWidth?: string | number | undefined;
    }, {
        scrollToIndex: (index: number) => void;
    }, {}, {}, {}, {
        style: vue.StyleValue;
        itemHeight: string | number;
    }>;
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    style: vue.StyleValue;
    itemHeight: string | number;
} & {
    class?: any;
    width?: string | number | undefined;
    height?: string | number | undefined;
    maxHeight?: string | number | undefined;
    maxWidth?: string | number | undefined;
    minHeight?: string | number | undefined;
    minWidth?: string | number | undefined;
}, {
    scrollToIndex: (index: number) => void;
}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Omit<Record<string, any>, "v-slot:default" | "$children" | "v-slots" | "items" | "renderless">, string, {
    style: vue.StyleValue;
    itemHeight: string | number;
}, {}, string, vue.SlotsType<Partial<{
    default: (arg: VVirtualScrollSlot<unknown> | (VVirtualScrollSlot<unknown> & {
        itemRef: Ref<HTMLElement | undefined>;
    })) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & (new <T, Renderless extends boolean = false>(props: {
    items?: readonly T[] | undefined;
    renderless?: Renderless | undefined;
}, slots: {
    default: VVirtualScrollSlot<T> & (Renderless extends true ? {
        itemRef: Ref<HTMLElement | undefined>;
    } : {});
}) => GenericProps<{
    items?: readonly T[] | undefined;
    renderless?: Renderless | undefined;
}, {
    default: VVirtualScrollSlot<T> & (Renderless extends true ? {
        itemRef: Ref<HTMLElement | undefined>;
    } : {});
}>) & FilterPropsOptions<{
    height: (StringConstructor | NumberConstructor)[];
    maxHeight: (StringConstructor | NumberConstructor)[];
    maxWidth: (StringConstructor | NumberConstructor)[];
    minHeight: (StringConstructor | NumberConstructor)[];
    minWidth: (StringConstructor | NumberConstructor)[];
    width: (StringConstructor | NumberConstructor)[];
    class: PropType<any>;
    style: {
        type: PropType<vue.StyleValue>;
        default: null;
    };
    itemHeight: {
        type: (StringConstructor | NumberConstructor)[];
        default: null;
    };
    items: {
        type: PropType<readonly unknown[]>;
        default: () => never[];
    };
    renderless: BooleanConstructor;
}, vue.ExtractPropTypes<{
    height: (StringConstructor | NumberConstructor)[];
    maxHeight: (StringConstructor | NumberConstructor)[];
    maxWidth: (StringConstructor | NumberConstructor)[];
    minHeight: (StringConstructor | NumberConstructor)[];
    minWidth: (StringConstructor | NumberConstructor)[];
    width: (StringConstructor | NumberConstructor)[];
    class: PropType<any>;
    style: {
        type: PropType<vue.StyleValue>;
        default: null;
    };
    itemHeight: {
        type: (StringConstructor | NumberConstructor)[];
        default: null;
    };
    items: {
        type: PropType<readonly unknown[]>;
        default: () => never[];
    };
    renderless: BooleanConstructor;
}>>;
type VVirtualScroll = InstanceType<typeof VVirtualScroll>;

export { VVirtualScroll };
