import * as vue from 'vue';
import { ComponentPropsOptions, ExtractPropTypes, JSXComponent, PropType, Ref, ComponentInternalInstance, ComputedRef } from 'vue';

interface FilterPropsOptions<PropsOptions extends Readonly<ComponentPropsOptions>, Props = ExtractPropTypes<PropsOptions>> {
    filterProps<T extends Partial<Props>, U extends Exclude<keyof Props, Exclude<keyof Props, keyof T>>>(props: T): Partial<Pick<T, U>>;
}

type IconValue = string | (string | [path: string, opacity: number])[] | JSXComponent;
declare const IconValue: PropType<IconValue>;

type VExpansionPanelSlot = {
    prev: () => void;
    next: () => void;
};
declare const VExpansionPanels: {
    new (...args: any[]): vue.CreateComponentPublicInstance<{
        flat: boolean;
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        variant: "default" | "inset" | "accordion" | "popout";
        multiple: boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    } & {
        class?: any;
        theme?: string | undefined;
        color?: string | undefined;
        modelValue?: any;
        rounded?: string | number | boolean | undefined;
        mandatory?: boolean | "force" | undefined;
        elevation?: string | number | undefined;
        max?: number | undefined;
        selectedClass?: string | undefined;
        bgColor?: string | undefined;
    } & {
        $children?: vue.VNodeChild | {
            default?: ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
        } | ((arg: VExpansionPanelSlot) => vue.VNodeChild);
        'v-slots'?: {
            default?: false | ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
    } & {
        "onUpdate:modelValue"?: ((val: unknown) => any) | undefined;
    }, {
        next: () => void;
        prev: () => void;
    }, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
        'update:modelValue': (val: unknown) => boolean;
    }, vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & {
        flat: boolean;
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        variant: "default" | "inset" | "accordion" | "popout";
        multiple: boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    } & {
        class?: any;
        theme?: string | undefined;
        color?: string | undefined;
        modelValue?: any;
        rounded?: string | number | boolean | undefined;
        mandatory?: boolean | "force" | undefined;
        elevation?: string | number | undefined;
        max?: number | undefined;
        selectedClass?: string | undefined;
        bgColor?: string | undefined;
    } & {
        $children?: vue.VNodeChild | {
            default?: ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
        } | ((arg: VExpansionPanelSlot) => vue.VNodeChild);
        'v-slots'?: {
            default?: false | ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
    } & {
        "onUpdate:modelValue"?: ((val: unknown) => any) | undefined;
    }, {
        flat: boolean;
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        modelValue: any;
        rounded: string | number | boolean;
        variant: "default" | "inset" | "accordion" | "popout";
        multiple: boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    }, true, {}, vue.SlotsType<Partial<{
        default: (arg: VExpansionPanelSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>[];
    }>>, {
        P: {};
        B: {};
        D: {};
        C: {};
        M: {};
        Defaults: {};
    }, {
        flat: boolean;
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        variant: "default" | "inset" | "accordion" | "popout";
        multiple: boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    } & {
        class?: any;
        theme?: string | undefined;
        color?: string | undefined;
        modelValue?: any;
        rounded?: string | number | boolean | undefined;
        mandatory?: boolean | "force" | undefined;
        elevation?: string | number | undefined;
        max?: number | undefined;
        selectedClass?: string | undefined;
        bgColor?: string | undefined;
    } & {
        $children?: vue.VNodeChild | {
            default?: ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
        } | ((arg: VExpansionPanelSlot) => vue.VNodeChild);
        'v-slots'?: {
            default?: false | ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
    } & {
        "onUpdate:modelValue"?: ((val: unknown) => any) | undefined;
    }, {
        next: () => void;
        prev: () => void;
    }, {}, {}, {}, {
        flat: boolean;
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        modelValue: any;
        rounded: string | number | boolean;
        variant: "default" | "inset" | "accordion" | "popout";
        multiple: boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    }>;
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    flat: boolean;
    style: vue.StyleValue;
    disabled: boolean;
    tag: string;
    static: boolean;
    readonly: boolean;
    variant: "default" | "inset" | "accordion" | "popout";
    multiple: boolean;
    tile: boolean;
    eager: boolean;
    ripple: boolean | {
        class: string;
    } | undefined;
    collapseIcon: IconValue;
    expandIcon: IconValue;
    hideActions: boolean;
    focusable: boolean;
} & {
    class?: any;
    theme?: string | undefined;
    color?: string | undefined;
    modelValue?: any;
    rounded?: string | number | boolean | undefined;
    mandatory?: boolean | "force" | undefined;
    elevation?: string | number | undefined;
    max?: number | undefined;
    selectedClass?: string | undefined;
    bgColor?: string | undefined;
} & {
    $children?: vue.VNodeChild | {
        default?: ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
    } | ((arg: VExpansionPanelSlot) => vue.VNodeChild);
    'v-slots'?: {
        default?: false | ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:default"?: false | ((arg: VExpansionPanelSlot) => vue.VNodeChild) | undefined;
} & {
    "onUpdate:modelValue"?: ((val: unknown) => any) | undefined;
}, {
    next: () => void;
    prev: () => void;
}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
    'update:modelValue': (val: unknown) => boolean;
}, string, {
    flat: boolean;
    style: vue.StyleValue;
    disabled: boolean;
    tag: string;
    static: boolean;
    readonly: boolean;
    modelValue: any;
    rounded: string | number | boolean;
    variant: "default" | "inset" | "accordion" | "popout";
    multiple: boolean;
    tile: boolean;
    eager: boolean;
    ripple: boolean | {
        class: string;
    } | undefined;
    collapseIcon: IconValue;
    expandIcon: IconValue;
    hideActions: boolean;
    focusable: boolean;
}, {}, string, vue.SlotsType<Partial<{
    default: (arg: VExpansionPanelSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    variant: {
        type: PropType<"default" | "inset" | "accordion" | "popout">;
        default: string;
        validator: (v: any) => boolean;
    };
    tag: {
        type: StringConstructor;
        default: string;
    };
    class: PropType<any>;
    style: {
        type: PropType<vue.StyleValue>;
        default: null;
    };
    theme: StringConstructor;
    color: StringConstructor;
    static: BooleanConstructor;
    readonly: BooleanConstructor;
    rounded: {
        type: (StringConstructor | NumberConstructor | BooleanConstructor)[];
        default: undefined;
    };
    tile: BooleanConstructor;
    eager: BooleanConstructor;
    elevation: {
        type: (StringConstructor | NumberConstructor)[];
        validator(v: any): boolean;
    };
    bgColor: StringConstructor;
    ripple: {
        type: PropType<boolean | {
            class: string;
        } | undefined>;
        default: boolean;
    };
    collapseIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    expandIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    hideActions: BooleanConstructor;
    focusable: BooleanConstructor;
    modelValue: {
        type: null;
        default: undefined;
    };
    multiple: BooleanConstructor;
    mandatory: PropType<boolean | "force">;
    max: NumberConstructor;
    selectedClass: StringConstructor;
    disabled: BooleanConstructor;
    flat: BooleanConstructor;
}, vue.ExtractPropTypes<{
    variant: {
        type: PropType<"default" | "inset" | "accordion" | "popout">;
        default: string;
        validator: (v: any) => boolean;
    };
    tag: {
        type: StringConstructor;
        default: string;
    };
    class: PropType<any>;
    style: {
        type: PropType<vue.StyleValue>;
        default: null;
    };
    theme: StringConstructor;
    color: StringConstructor;
    static: BooleanConstructor;
    readonly: BooleanConstructor;
    rounded: {
        type: (StringConstructor | NumberConstructor | BooleanConstructor)[];
        default: undefined;
    };
    tile: BooleanConstructor;
    eager: BooleanConstructor;
    elevation: {
        type: (StringConstructor | NumberConstructor)[];
        validator(v: any): boolean;
    };
    bgColor: StringConstructor;
    ripple: {
        type: PropType<boolean | {
            class: string;
        } | undefined>;
        default: boolean;
    };
    collapseIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    expandIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    hideActions: BooleanConstructor;
    focusable: BooleanConstructor;
    modelValue: {
        type: null;
        default: undefined;
    };
    multiple: BooleanConstructor;
    mandatory: PropType<boolean | "force">;
    max: NumberConstructor;
    selectedClass: StringConstructor;
    disabled: BooleanConstructor;
    flat: BooleanConstructor;
}>>;
type VExpansionPanels = InstanceType<typeof VExpansionPanels>;

interface GroupItem {
    id: number;
    value: Ref<unknown>;
    disabled: Ref<boolean | undefined>;
    useIndexAsValue?: boolean;
}
interface GroupProvide {
    register: (item: GroupItem, cmp: ComponentInternalInstance) => void;
    unregister: (id: number) => void;
    select: (id: number, value: boolean) => void;
    selected: Ref<Readonly<number[]>>;
    isSelected: (id: number) => boolean;
    prev: () => void;
    next: () => void;
    selectedClass: Ref<string | undefined>;
    items: ComputedRef<{
        id: number;
        value: unknown;
        disabled: boolean | undefined;
    }[]>;
    disabled: Ref<boolean | undefined>;
    getItemIndex: (value: unknown) => number;
}
interface GroupItemProvide {
    id: number;
    isSelected: Ref<boolean>;
    isFirst: Ref<boolean>;
    isLast: Ref<boolean>;
    toggle: () => void;
    select: (value: boolean) => void;
    selectedClass: Ref<(string | undefined)[] | false>;
    value: Ref<unknown>;
    disabled: Ref<boolean | undefined>;
    group: GroupProvide;
}

declare const VExpansionPanel: {
    new (...args: any[]): vue.CreateComponentPublicInstance<{
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    } & {
        class?: any;
        title?: string | undefined;
        text?: string | undefined;
        value?: any;
        color?: string | undefined;
        rounded?: string | number | boolean | undefined;
        elevation?: string | number | undefined;
        selectedClass?: string | undefined;
        bgColor?: string | undefined;
    } & {
        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
            default?: (() => vue.VNodeChild) | undefined;
            title?: (() => vue.VNodeChild) | undefined;
            text?: (() => vue.VNodeChild) | undefined;
        };
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
            title?: false | (() => vue.VNodeChild) | undefined;
            text?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:title"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:text"?: false | (() => vue.VNodeChild) | undefined;
    } & {
        "onGroup:selected"?: ((val: {
            value: boolean;
        }) => any) | undefined;
    }, {
        groupItem: GroupItemProvide;
    }, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
        'group:selected': (val: {
            value: boolean;
        }) => true;
    }, vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & {
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    } & {
        class?: any;
        title?: string | undefined;
        text?: string | undefined;
        value?: any;
        color?: string | undefined;
        rounded?: string | number | boolean | undefined;
        elevation?: string | number | undefined;
        selectedClass?: string | undefined;
        bgColor?: string | undefined;
    } & {
        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
            default?: (() => vue.VNodeChild) | undefined;
            title?: (() => vue.VNodeChild) | undefined;
            text?: (() => vue.VNodeChild) | undefined;
        };
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
            title?: false | (() => vue.VNodeChild) | undefined;
            text?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:title"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:text"?: false | (() => vue.VNodeChild) | undefined;
    } & {
        "onGroup:selected"?: ((val: {
            value: boolean;
        }) => any) | undefined;
    }, {
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        rounded: string | number | boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    }, true, {}, vue.SlotsType<Partial<{
        default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>[];
        title: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>[];
        text: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>[];
    }>>, {
        P: {};
        B: {};
        D: {};
        C: {};
        M: {};
        Defaults: {};
    }, {
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    } & {
        class?: any;
        title?: string | undefined;
        text?: string | undefined;
        value?: any;
        color?: string | undefined;
        rounded?: string | number | boolean | undefined;
        elevation?: string | number | undefined;
        selectedClass?: string | undefined;
        bgColor?: string | undefined;
    } & {
        $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
            default?: (() => vue.VNodeChild) | undefined;
            title?: (() => vue.VNodeChild) | undefined;
            text?: (() => vue.VNodeChild) | undefined;
        };
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
            title?: false | (() => vue.VNodeChild) | undefined;
            text?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:title"?: false | (() => vue.VNodeChild) | undefined;
        "v-slot:text"?: false | (() => vue.VNodeChild) | undefined;
    } & {
        "onGroup:selected"?: ((val: {
            value: boolean;
        }) => any) | undefined;
    }, {
        groupItem: GroupItemProvide;
    }, {}, {}, {}, {
        style: vue.StyleValue;
        disabled: boolean;
        tag: string;
        static: boolean;
        readonly: boolean;
        rounded: string | number | boolean;
        tile: boolean;
        eager: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    }>;
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    style: vue.StyleValue;
    disabled: boolean;
    tag: string;
    static: boolean;
    readonly: boolean;
    tile: boolean;
    eager: boolean;
    ripple: boolean | {
        class: string;
    } | undefined;
    collapseIcon: IconValue;
    expandIcon: IconValue;
    hideActions: boolean;
    focusable: boolean;
} & {
    class?: any;
    title?: string | undefined;
    text?: string | undefined;
    value?: any;
    color?: string | undefined;
    rounded?: string | number | boolean | undefined;
    elevation?: string | number | undefined;
    selectedClass?: string | undefined;
    bgColor?: string | undefined;
} & {
    $children?: vue.VNodeChild | (() => vue.VNodeChild) | {
        default?: (() => vue.VNodeChild) | undefined;
        title?: (() => vue.VNodeChild) | undefined;
        text?: (() => vue.VNodeChild) | undefined;
    };
    'v-slots'?: {
        default?: false | (() => vue.VNodeChild) | undefined;
        title?: false | (() => vue.VNodeChild) | undefined;
        text?: false | (() => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:title"?: false | (() => vue.VNodeChild) | undefined;
    "v-slot:text"?: false | (() => vue.VNodeChild) | undefined;
} & {
    "onGroup:selected"?: ((val: {
        value: boolean;
    }) => any) | undefined;
}, {
    groupItem: GroupItemProvide;
}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
    'group:selected': (val: {
        value: boolean;
    }) => true;
}, string, {
    style: vue.StyleValue;
    disabled: boolean;
    tag: string;
    static: boolean;
    readonly: boolean;
    rounded: string | number | boolean;
    tile: boolean;
    eager: boolean;
    ripple: boolean | {
        class: string;
    } | undefined;
    collapseIcon: IconValue;
    expandIcon: IconValue;
    hideActions: boolean;
    focusable: boolean;
}, {}, string, vue.SlotsType<Partial<{
    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    title: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    text: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    eager: BooleanConstructor;
    class: vue.PropType<any>;
    style: {
        type: vue.PropType<vue.StyleValue>;
        default: null;
    };
    color: StringConstructor;
    expandIcon: {
        type: vue.PropType<IconValue>;
        default: string;
    };
    collapseIcon: {
        type: vue.PropType<IconValue>;
        default: string;
    };
    hideActions: BooleanConstructor;
    focusable: BooleanConstructor;
    static: BooleanConstructor;
    ripple: {
        type: vue.PropType<boolean | {
            class: string;
        } | undefined>;
        default: boolean;
    };
    readonly: BooleanConstructor;
    tag: {
        type: StringConstructor;
        default: string;
    };
    rounded: {
        type: (StringConstructor | NumberConstructor | BooleanConstructor)[];
        default: undefined;
    };
    tile: BooleanConstructor;
    value: null;
    disabled: BooleanConstructor;
    selectedClass: StringConstructor;
    elevation: {
        type: (StringConstructor | NumberConstructor)[];
        validator(v: any): boolean;
    };
    title: StringConstructor;
    text: StringConstructor;
    bgColor: StringConstructor;
}, vue.ExtractPropTypes<{
    eager: BooleanConstructor;
    class: vue.PropType<any>;
    style: {
        type: vue.PropType<vue.StyleValue>;
        default: null;
    };
    color: StringConstructor;
    expandIcon: {
        type: vue.PropType<IconValue>;
        default: string;
    };
    collapseIcon: {
        type: vue.PropType<IconValue>;
        default: string;
    };
    hideActions: BooleanConstructor;
    focusable: BooleanConstructor;
    static: BooleanConstructor;
    ripple: {
        type: vue.PropType<boolean | {
            class: string;
        } | undefined>;
        default: boolean;
    };
    readonly: BooleanConstructor;
    tag: {
        type: StringConstructor;
        default: string;
    };
    rounded: {
        type: (StringConstructor | NumberConstructor | BooleanConstructor)[];
        default: undefined;
    };
    tile: BooleanConstructor;
    value: null;
    disabled: BooleanConstructor;
    selectedClass: StringConstructor;
    elevation: {
        type: (StringConstructor | NumberConstructor)[];
        validator(v: any): boolean;
    };
    title: StringConstructor;
    text: StringConstructor;
    bgColor: StringConstructor;
}>>;
type VExpansionPanel = InstanceType<typeof VExpansionPanel>;

declare const VExpansionPanelText: {
    new (...args: any[]): vue.CreateComponentPublicInstance<{
        style: vue.StyleValue;
        eager: boolean;
    } & {
        class?: any;
    } & {
        $children?: vue.VNodeChild | {
            default?: (() => vue.VNodeChild) | undefined;
        } | (() => vue.VNodeChild);
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
    }, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & {
        style: vue.StyleValue;
        eager: boolean;
    } & {
        class?: any;
    } & {
        $children?: vue.VNodeChild | {
            default?: (() => vue.VNodeChild) | undefined;
        } | (() => vue.VNodeChild);
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
    }, {
        style: vue.StyleValue;
        eager: boolean;
    }, true, {}, vue.SlotsType<Partial<{
        default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>[];
    }>>, {
        P: {};
        B: {};
        D: {};
        C: {};
        M: {};
        Defaults: {};
    }, {
        style: vue.StyleValue;
        eager: boolean;
    } & {
        class?: any;
    } & {
        $children?: vue.VNodeChild | {
            default?: (() => vue.VNodeChild) | undefined;
        } | (() => vue.VNodeChild);
        'v-slots'?: {
            default?: false | (() => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
    }, {}, {}, {}, {}, {
        style: vue.StyleValue;
        eager: boolean;
    }>;
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    style: vue.StyleValue;
    eager: boolean;
} & {
    class?: any;
} & {
    $children?: vue.VNodeChild | {
        default?: (() => vue.VNodeChild) | undefined;
    } | (() => vue.VNodeChild);
    'v-slots'?: {
        default?: false | (() => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:default"?: false | (() => vue.VNodeChild) | undefined;
}, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
    style: vue.StyleValue;
    eager: boolean;
}, {}, string, vue.SlotsType<Partial<{
    default: () => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    eager: BooleanConstructor;
    class: vue.PropType<any>;
    style: {
        type: vue.PropType<vue.StyleValue>;
        default: null;
    };
}, vue.ExtractPropTypes<{
    eager: BooleanConstructor;
    class: vue.PropType<any>;
    style: {
        type: vue.PropType<vue.StyleValue>;
        default: null;
    };
}>>;
type VExpansionPanelText = InstanceType<typeof VExpansionPanelText>;

interface ExpansionPanelTitleSlot {
    collapseIcon: IconValue;
    disabled: boolean | undefined;
    expanded: boolean;
    expandIcon: IconValue;
    readonly: boolean;
}
declare const VExpansionPanelTitle: {
    new (...args: any[]): vue.CreateComponentPublicInstance<{
        style: vue.StyleValue;
        static: boolean;
        readonly: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    } & {
        class?: any;
        color?: string | undefined;
    } & {
        $children?: vue.VNodeChild | {
            default?: ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
            actions?: ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        } | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild);
        'v-slots'?: {
            default?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
            actions?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        "v-slot:actions"?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
    }, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & {
        style: vue.StyleValue;
        static: boolean;
        readonly: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    } & {
        class?: any;
        color?: string | undefined;
    } & {
        $children?: vue.VNodeChild | {
            default?: ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
            actions?: ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        } | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild);
        'v-slots'?: {
            default?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
            actions?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        "v-slot:actions"?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
    }, {
        style: vue.StyleValue;
        static: boolean;
        readonly: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    }, true, {}, vue.SlotsType<Partial<{
        default: (arg: ExpansionPanelTitleSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>[];
        actions: (arg: ExpansionPanelTitleSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>[];
    }>>, {
        P: {};
        B: {};
        D: {};
        C: {};
        M: {};
        Defaults: {};
    }, {
        style: vue.StyleValue;
        static: boolean;
        readonly: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    } & {
        class?: any;
        color?: string | undefined;
    } & {
        $children?: vue.VNodeChild | {
            default?: ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
            actions?: ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        } | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild);
        'v-slots'?: {
            default?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
            actions?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        "v-slot:actions"?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
    }, {}, {}, {}, {}, {
        style: vue.StyleValue;
        static: boolean;
        readonly: boolean;
        ripple: boolean | {
            class: string;
        } | undefined;
        collapseIcon: IconValue;
        expandIcon: IconValue;
        hideActions: boolean;
        focusable: boolean;
    }>;
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    style: vue.StyleValue;
    static: boolean;
    readonly: boolean;
    ripple: boolean | {
        class: string;
    } | undefined;
    collapseIcon: IconValue;
    expandIcon: IconValue;
    hideActions: boolean;
    focusable: boolean;
} & {
    class?: any;
    color?: string | undefined;
} & {
    $children?: vue.VNodeChild | {
        default?: ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        actions?: ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
    } | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild);
    'v-slots'?: {
        default?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
        actions?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:default"?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
    "v-slot:actions"?: false | ((arg: ExpansionPanelTitleSlot) => vue.VNodeChild) | undefined;
}, {}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, {
    style: vue.StyleValue;
    static: boolean;
    readonly: boolean;
    ripple: boolean | {
        class: string;
    } | undefined;
    collapseIcon: IconValue;
    expandIcon: IconValue;
    hideActions: boolean;
    focusable: boolean;
}, {}, string, vue.SlotsType<Partial<{
    default: (arg: ExpansionPanelTitleSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    actions: (arg: ExpansionPanelTitleSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    class: PropType<any>;
    style: {
        type: PropType<vue.StyleValue>;
        default: null;
    };
    color: StringConstructor;
    expandIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    collapseIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    hideActions: BooleanConstructor;
    focusable: BooleanConstructor;
    static: BooleanConstructor;
    ripple: {
        type: PropType<boolean | {
            class: string;
        } | undefined>;
        default: boolean;
    };
    readonly: BooleanConstructor;
}, vue.ExtractPropTypes<{
    class: PropType<any>;
    style: {
        type: PropType<vue.StyleValue>;
        default: null;
    };
    color: StringConstructor;
    expandIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    collapseIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    hideActions: BooleanConstructor;
    focusable: BooleanConstructor;
    static: BooleanConstructor;
    ripple: {
        type: PropType<boolean | {
            class: string;
        } | undefined>;
        default: boolean;
    };
    readonly: BooleanConstructor;
}>>;
type VExpansionPanelTitle = InstanceType<typeof VExpansionPanelTitle>;

export { VExpansionPanel, VExpansionPanelText, VExpansionPanelTitle, VExpansionPanels };
