## 网站介绍
The Hack The Box platform provides a wealth of challenges - in the form of virtual machines - simulating real-world security issues and vulnerabilities that are constantly provided and updated by the community. Some of them simulate real-world scenarios, and some lean more toward a CTF-style of approach.

 

Hack The Box innovates by constantly providing fresh and curated hacking challenges in a fully gamified, immersive, and intuitive environment. The platform brings together security researchers, pentesters, infosec professionals, academia, and students, making it the social network for ethical hackers and infosec enthusiasts, counting more than 500k members and growing dynamically. 

 

HTB Labs Content
 

Machines 
Machines are instances of vulnerable virtual machines. These are virtualized services, virtualized operating systems, and virtualized hardware that all run on our servers. Machines can be Easy, Medium, Hard or Insane and can host different Operating Systems; Linux, Windows, FreeBSD, and more.

 

How to play Machines
 

Challenges
Challenges are bite-sized applications for different pentesting techniques. These come in three main difficulties, specifically Easy, Medium, and Hard, as per the coloring of their entries on the list. Their scope? To be attacked by you. 

 

How to play Challenges
 

Sherlocks
Sherlocks are defensive investigatory scenarios designed to provide hands-on practice in replicating real-life cases.

 

How to play Sherlocks
 

Prolabs
These consist of enclosed corporate networks of Machines using different operating systems, different security configurations, different vulnerabilities, and exploitation paths while simulating a real corporate environment.

 

How to play Prolabs
 

Retired Content
Retired content has been retired from our active labs and/or offerings and is no longer available on our free servers. In the case of Machines, the last few to be retired are still available to free users. We release one new Machine every week and also retire one Machine at the same time. Retired content does not give Points or Ownership.

 

Ranks, Points, and Game Elements of Hack The Box
Points, Badges, First Bloods, and Respect Points will help you climb the Global Rankings of Hack The Box, improve your Hacker Rank, and ultimately testify to your skillset in Cyber Security. These can be seen on any public profile by anyone. If you’ve got the skills and the points/tank to show for it, you won’t go unnoticed! 

 

Your only objective here is to grind and learn. In the end, it will be worth it.

 

Points 
The Points system is straightforward. Each Machine, Challenge, Endgame, or Fortress completed will offer you a number of Points that is based on its complexity. This way, harder tasks will earn you more Points, where easy ones will not earn you as many. The Points contribute to your overall position on the global and regional scoreboards.

 

Points are allocated based on a number of variables, such as user/root owns and challenges completed. Each Machine/Challenge displays the number of Points earned upon completion.

 

Points are calculated using the following Points Formula:

 

(userOwnPoints + systemOwnPoints + challengeOwnPoints + fortressOwnPoints + endgameOwnPoints + userBloodPoints + systemBloodPoints + challengeBloodPoints) * ownershipPercentage
 

It's worth noting that while Points are directly correlated to your global ranking, they are not what dictates your Hacker Rank.

 

Ranks
Sometimes referred to as your Hacker Rank, Ranks are achieved by increasing the total % of Ownership of active Machines and Challenges. The levels and required % are the following:

Noob >= 0%,

Script Kiddie > 5%,

Hacker > 20%,

Pro Hacker > 45%,

Elite Hacker > 70%,

Guru > 90% and

Omniscient = 100%

As you level up, you gain certain perks and features. For example, Fortresses unlock at Hacker, and Endgames unlock at Guru.

 

The Ownership % Formula can be seen here:

 

(ActiveSystemOwns + (ActiveUserOwns / 2) + (ActiveChallengeOwns / 10)) / (activeMachines + (activeMachines / 2) + (activeChallenges / 10)) * 100
 

General Game Elements
Note that only Active Machines and Active Challenges offer any Points or Ownership upon completion. These consist of tasks that do not have any available write-up and have been recently made public for everyone to solve. 

 

Once a Machine, Challenge, Fortress, or Endgame is retired, the points attributed to any user ever for solving that particular task will turn into 0. This means that every weekend, on retiring day, everyone's Ownership will drop with the number of Points equal to the Point value of the retired content for that week.

 

This means that users who were about to reach the next rank will have to work a little more until they hit it. This, however, does not mean that anyone loses their rank.

For example, if you've just hit the rank Hacker and have 0 progress towards Pro Hacker, and a Machine is retired, you will not be de-ranked back to Script Kiddie. You will keep your 0% progress towards Pro Hacker together with your current Hacker rank.

 

We've put this system in place to ensure that everyone gets the rank they deserve based on their skills, but if for any reason a user needs to stay inactive for a period of time, they will not lose their rank as they've already proven their skills for that position.

First Blood is a big thing in video games, so we've ported it over to our approach to the gaming paradigm. Once a new Machine or Challenge released, everyone has the chance to get First Blood on it.

 

This will display their name on the Machine or Challenge's dedicated page and also award them more points upon submitting the flags than a normal own would.

It's an excellent reason to level up your hacking skills and prove yourself to the community.

 

Points and the Leaderboard are updated once a day and not in real-time.

Points that show up on the profile get updated the moment you own a Machine and the moment a Machine retires. 

 

Respect Points can also be awarded to other users. To offer your respect point to a user for creating a Machine, Challenge, or just in general for being a really neat person, you can visit their profile and click on the Respect button. You will appear under their profile as a person who offered that user Respect.

 


 

Free and VIP account
At Hack The Box, we provide Free, VIP and VIP+ accounts. 

 

Free accounts have access to the 20 weekly Active Machines and Active Challenges.

 

VIP accounts have access to all available Hack The Box Machines (both Active and Retired), and they are able to view the official write-ups and videos for each Retired Machine. 

 

If you'd like to make a subscription to either VIP, our Pro Labs, or simply just to view the status of your current subscriptions, you can head over to the Billing&Plans page.

 

Here you can find your current available Hack The Box credit, which you can use to purchase services, and the status of your Subscriptions for our labs.

  

If you'd like to find out more about VIP, you can always visit this link or click on the Purchase button next to the VIP Subscription entry on this page. 

 

Both will contain all the information needed for you to make a decision on the VIP pack. Still, we guarantee that you will immediately fall in love with all the new features it unlocks and with how much it can accelerate the learning process for a new user!

  

The Dashboard
The Dashboard will be your landing page after logging in, from here you can navigate to all pages of the platform using the left side menu.

 


 

One more important tab is the profile page, you can access it from the top-right and you can edit many profile-related settings from there, find out more in this article : 

 

Setting Up Your Account
Progress Analysis
On the Overview tab, you can see your current progress in the different labs with the option to filter by time period.

 


Below is your skill breakdown for both Machines and Challenges. You can click on View More for more detailed information.

 


Below these, you can also track your progress on our Fortress and Endgame labs. Each separate one will be displayed under their respective category.

 


Scrolling even further down towards the end of the page, you can find your progress report for our Pro Labs line-up. You can use the navigation arrows to switch between the different Pro Labs.

 


 

Badges
With each feat that you accomplish as a community member of Hack The Box, we've made sure to reward you with a congratulatory Badge! Your Badges appear both on your public and your community profile on the platform. They contain a short description of the feat you accomplished to obtain the Badge.

 

You can think of them as video game achievements. For all intents and purposes, they prove to the world that you're a dedicated player with a keen eye to detail and an appetite for curiosity!

 

To view your Badges, one only needs to navigate to your Profile and click on their respective tab. Scrolling down will present the viewer with all the different categories.

## 前800名数据分析
因为八百名以后用户数据相似度过大，都没怎么打，所以挑选分析前八百名。
一、数据处理
分别对machine、challenge、Sherlock三个板块的数据进行筛选，去掉每个板块各个功能完成率都低于平均值的的数据后再进行数据分析。
二、数据分析
1、描述性统计
machine板块
对黑客使用的技术进行描述性统计（左图为按完成率得到结果，右图为按完成数得到结果，均按使用数量降序排序）
  
综合考虑每个技术的总出现频率count（即前八百名的人中某个技术在面板的出现频率）和平均完成数mean的影响，基于count和mean做主成分分析，综合考虑count和mean降至一维，得到主成分为0.707count+0.707mean，累计贡献率达0.91。

根据主成分降序排序得到的结果如下：
 

各技术的主成分数据可视化：
 
结论：推荐学习前7个技术。
推荐学习技术顺序：Reconnaissance、Password Reuse、Password Cracking、Injections、Software & OS exploitation、Common Applications、Web Site Structure Discovery、Security Tools
Reconnaissance主成分得分为778.37、Password Reuse主成分得分为759.59、Password Password Cracking主成分得分为748.97、Injections主成分得分为745.81、Software & OS exploitation主成分得分为707.69、Common Applications 主成分得分为700.23 、Web Site Structure Discovery 主成分得分为672.15、Security Tools主成分得分为422.61、Source Code Analysis主成分得分为374.41、SUDO Exploitation主成分得分为327.21、Authentication主成分得分为323.61、Databases主成分得分为297.85、Custom Applications主成分得分为220.55、Configuration Analysis主成分得分为142.28、Protocols主成分得分为95.58、Broken Authentication and Authorization主成分得分为89.88、Fuzzing主成分得分为85.97、User Enumeration主成分得分为79.15、Active Directory主成分得分为47.87、Reverse Engineering主成分得分为36.32

其他可视化内容（相对于上方的主成分分析可能用不上，因为衡量指标为单一的count或mean）：
前八个出现频率最高的技术的完成率雷达图：

Common Applications平均完成率为30.3%、Security Tools平均完成率为27.5%、Software & OS exploitation平均完成率为24.1%、Reconnaissance平均完成率为24.1%、Password Reuse平均完成率为23.8%、Password Cracking平均完成率为22.7%、Injections平均完成率为22.7%、Web Site Structure Discovery平均完成率为21.5%
前八个出现频率最高的技术的完成数条形图：
 
Reconnaissance平均完成数为48.86、Software & OS exploitation平均完成数为34.91、Injections平均完成数为30.81、Security Tools平均完成数为30.71、Password Reuse平均完成数为27.37、Password Cracking平均完成数为26.32、Web Site Structure Discovery平均完成数为23.68、Common Applications平均完成数为22.39

challenge板块
对前800名hacker完成的challenge类型进行描述性统计并按均值降序排序（左图为按完成率得到结果，右图为按完成数得到结果）
  
前800名hacker的challenge各类型挑战平均完成率可视化（雷达图）
 
OSINT平均完成率为28.0%、Mobile平均完成率为16.4%、GamePwn平均完成率为16.0%、Misc平均完成率为13.2%、Web平均完成率为12.3%、Hardware平均完成率为10.7%、Reversing平均完成率为10.0%、Forensics平均完成率为9.5%、Crypto平均完成率为8.0%、Blockchain平均完成率为6.6%、Pwn平均完成率为6.3%、AI - ML平均完成率为2.9%

前800名hacker的challenge各类型挑战平均完成数可视化（条形图）
 
结论由平均完成数顺序得到：推荐完成challenge顺序：Web、Crypto、Reversing、Misc、Forensics、Pwn、Hardware、Mobile、GamePwn、OSINT、Blockchain、AI - ML
Web平均完成数为15.26、Crypto平均完成数为8.22、Reversing平均完成数为7.59、Misc平均完成数为6.50、Forensics平均完成数为6.45、Pwn平均完成数为6.41、Hardware平均完成数为4.20、Mobile平均完成数为2.78、GamePwn平均完成数为1.76、OSINT平均完成数为1.40、Blockchain平均完成数为1.05、AI - ML平均完成数为0.17

Sherlock板块
对黑客完成的sherlock类型进行描述性统计并按均值降序排序（上图为按完成率得到结果，下图为按完成数得到结果）
 
 
前800名hacker的Sherlock各类型挑战平均完成率可视化（雷达图）
 
SOC平均完成率为41.2%、DFIR平均完成率为12.5%、Threat Intelligence平均完成率为11.3%、Malware Analysis平均完成率为9.6%、Cloud平均完成率为7.9%、Campaign平均完成率为5.9%
前800名hacker的Sherlock各类型挑战平均完成数可视化（条形图）
 
结论由平均完成数顺序得到：推荐完成sherlock顺序：DFIR、SOC、Malware Analysis、Campaign、Cloud、Threat Intelligence
DFIR平均完成数为3.65、SOC平均完成数为0.82、Malware Analysis平均完成数为0.49、Campaign平均完成数为0.29、Cloud平均完成数为0.16、Threat Intelligence平均完成数为0.11
operating systems
对黑客攻击的操作系统类型数目进行描述性统计并按均值降序排序
 
前800名hacker的各类型操作系统平均攻击数可视化（条形图）
 
结论：前800名hacker通常攻击Linux和Windows系统，推荐学习Linux和Windows系统相关知识
Linux平均攻击数为64.11、Windows平均攻击数为24.38、Other平均攻击数为0.78、FreeBSD平均攻击数为0.51、OpenBSD平均攻击数为0.49、Android平均攻击数为0.32、Solaris平均攻击数为0.16

2、相关性分析
由于machine数据缺失，只能对challenge和sherlock进行分析
challenge
 
challenge类型Reversing、Crypto、Pwn、Web、Misc、Forensics、Mobile、Hardware、GamePwn之间具有较强相关性，这些challenge可能考察了相近的能力，需要类似的技能和知识，完成其中一个challenge可以帮助完成其他challenge。
challenge类型OSINT与其他challenge相关性较弱，该类型可能涉及完全不同的领域或技能集，完成OSINT对完成其他challenge帮助有限。
结论：可优先完成相关性较强的challenge：Web、Crypto、Reversing、Misc、Forensics、Pwn、Hardware、Mobile、GamePwn

Sherlock
 
sherlock类型DFIR、Cloud、Malware Analysis、Threat Intelligence、Campaign之间具有较强相关性，这些sherlock可能考察了相近的能力，需要类似的技能和知识，完成其中一个sherlock可以帮助完成其他sherlock。
sherlock类型SOC与其他sherlock相关性较弱，该类型可能涉及完全不同的领域或技能集，完成sherlock对完成其他sherlock帮助有限。
结论：可优先完成相关性较强的sherlock：DFIR、Malware Analysis、Campaign、Cloud、Threat Intelligence

3、聚类分析
由于machine数据缺失，只能对challenge和sherlock进行分析，使用k-means对challenge/sherlock类别进行分析
challenge
由簇内误差平方和及轮廓系数确定k=4
根据前800名hacker的完成数可划分为以下4类：
 
第一类（Web）：完成数普遍较多，该挑战较为基础。
第二类（Crypto、Reversing、Pwn、Forensics）：完成情况中等，相关性较强，完成挑战需要一定进阶技能，且不同技能之间也有一定关联。
第三类（Misc）：完成数比第二类较少，完成数分布较集中。
第四类（Hardware、Mobile、GamePwn、Blockchain、OSINT、AI - ML）：完成数普遍较少，这些挑战可能较为复杂且涉及不同领域的专门技能 。
结论：可按照上述分类完成challenge，综合考虑平均完成数及相关性，推荐完成顺序：第一类（Web）、第二类（Crypto、Reversing、Pwn、Forensics）、第三类（Misc）、第四类（Hardware、Mobile、GamePwn、Blockchain、OSINT、AI - ML）。


sherlock
由簇内误差平方和及轮廓系数确定k=3
根据前800名hacker的完成数可划分为以下3类：
 
第一类（DFIR）：完成数普遍较多，该类sherlock较为基础。
第二类（SOC）：完成数普遍较少。
第三类（Malware Analysis、Campaign、Cloud、Threat Intelligence）：完成数比第二类略少。
结论：可按照上述分类完成sherlock，综合考虑平均完成数及相关性，推荐完成顺序：第一类（DFIR）、第三类（Malware Analysis、Campaign、Cloud、Threat Intelligence）、第二类（SOC）。

4、排名分析
分析个人排名与所在队伍排名之间的相关性
前800名hacker的个人排名与所在队伍排名如下表：
 
绘制散点图如下：
 
计算个人排名与所在队伍排名的相关系数为0.57，个人排名与所在队伍排名存在中等程度的正相关关系
