package com.hugai.core.midjourney.pool;

import com.hugai.core.midjourney.common.entity.DiscordAccount;
import com.org.bebas.core.function.OR;
import okhttp3.WebSocket;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

/**
 * discord ws缓存池
 *
 * @author WuHao
 * @since 2023/9/25 14:55
 */
public class DiscordSocketAccountPool {

    public static final ConcurrentHashMap<String, DiscordAccountCacheObj> CACHE = new ConcurrentHashMap<>();

    public static DiscordAccountCacheObj get(String userName) {
        return CACHE.get(userName);
    }

    public static DiscordAccountCacheObj getOne() {
        return CACHE.values().stream().findFirst().orElse(null);
    }

    public static DiscordAccountCacheObj getByChannelId(String channelId) {
        return CACHE.values().stream().filter(item -> Objects.nonNull(
                item.getDiscordAccount().getChannelIds().stream().filter(id -> id.equals(channelId)).findFirst().orElse(null)
        )).findFirst().orElse(null);
    }

    public static void add(String userName, DiscordAccountCacheObj cacheBean) {
        CACHE.put(userName, cacheBean);
    }

    public static void add(String userName, DiscordAccount discordAccount, WebSocket webSocket) {
        CACHE.put(userName, new DiscordAccountCacheObj(discordAccount, webSocket));
    }

    public static void update(String userName, String sessionId) {
        OR.run(get(userName), Objects::nonNull, cacheBean -> {
            cacheBean.setSessionId(sessionId);
        });
    }

    public static void remove(String userName) {
        OR.run(get(userName), Objects::nonNull, DiscordAccountCacheObj::cancel);
        CACHE.remove(userName);
    }

}
