
## Realtime Chat App with NestJS and Angular
### 1. Video (NestJS & Angular Set Up)
Link: https://youtu.be/IievSCity8c

You need:
- Angular
- Nestjs
- npm
- docker

Story:
As a developer I want the NestJS Backend and the Angular Frontend to be set up.
Both should be run with a dockerfile.
They should be run/started together via a docker-compose file, so we can start everything with one command.
The NestJS Backend should connect to a Postgres database, that is also started with docker-compose file.
At the end of this video the Frontend should be able to retrieve a value from the Backend, all inside docker.

Acceptance Criteria:
- Set Up Angular (/)
- Set Up NestJS (/)
- Start Angular with Docker-Compose/Dockerfile & access in the browser via http://localhost:4200 (/)
- Start NestJS with Docker-Compose/Dockerfile & get a basic value via http://localhost:3000/api (/)
- NestJS should connect to a postgres database with docker-compose (/)
- Angular should display a value that it gets from the NestJS Backend (/)
