# 2020法研杯-论辩挖掘

* 任务简介

  * 本任务旨在抽取出裁判文书中辩方诉方之间的逻辑交互论点对，即争议焦点。具体来说，提供裁判文书中辩诉双方的陈述文本，选手的任务是输出存在逻辑交互关系的论点对。允许选手使用任何外部资料作为知识来帮助模型，但是要求选手在预测过程中不能够进行联网操作.
  * 官网：http://cail.cipsc.org.cn:2020/instruction.html

* 时间：2020.5~2020.8

* 数据示例

  > text-train.csv

  | sentence_id | text_id | position | sentence                                                     |
  | ----------- | ------- | -------- | ------------------------------------------------------------ |
  | 1           | 0       | bc       | 被告人康某辩称:我的行为不构成故意伤害罪，不应当承担刑事责任，请求法庭依法驳回自诉人对我的刑事控诉。 |
  | 18          | 0       | sc       | 自诉人苏某某诉称：被告人康某丽珠的父亲马某与自诉人的母亲苏某原是夫妻。 |

  * sentence_id：句子id
  * text_id：裁判文书id
  * position：二分类标签：sc---诉方，bc---辩方
  * sentence：句子文本

  > train.csv

  ```
  id: 0
  text_id: 0 
  sc: 11时许，被告人康某骑一辆自行车来到现场，与我发生吵闹后上前揪住我的头发，用拳头打伤我的右眼，眼镜也被打掉在地并摔碎，眼皮也被打破，右眼流血不止,再者，本案只是因为简单争吵引起冲突的民事纠纷，而不是刑事案件。
  A: 民事赔偿上，由于我没有对自诉人进行打击，不应当由我承担赔偿责任，但我愿意承担自诉人的验光配镜支出的费用。
  B: 护理费，因为没有证据证明护理人员减少收入，也不予以赔偿。
  C: 且鉴定时间和事故发生时间之间间隔了3个半月，在这3个半月中是否有其他伤害也不能确定，证人杨某某也陈述，没有被告人打自诉人的情况。
  D: "她的伤是她自己雨伞造成的
  E: 她陈述“我揪住她头发打她”与她在剑川县公安局所作的陈述“我抓住她的头发，用雨伞打在她的额头”相互矛盾，两次陈述打击的部位不同，当时没有出现自诉人所说“流血不止”的情形她陈述“我揪住她头发打她”与她在剑川县公安局所作的陈述“我抓住她的头发，用雨伞打在她的额头”相互矛盾，两次陈述打击的部位不同，当时没有出现自诉人所说“流血不止”的情形"
  answer: 5
  ```

  * id：论点对id
  * text_id：裁判文书id
  * sc：论点对中诉方论点
  * A/B/C/D/E：给出的五句候选辩方论点
  * 辩方正确论点

  测试数据不包含answer字段

  

* 数据说明

  |   train    | test |                             下载                             |
  | :--------: | :--: | :----------------------------------------------------------: |
  | 2449 + 815 |  ？  | [官网直接下载](http://cail.cipsc.org.cn:2020/instruction.html) |

  

* 竞赛方案

  |                             方案                             |                           代码                           |
  | :----------------------------------------------------------: | :------------------------------------------------------: |
  | top1（[video](https://www.bilibili.com/video/BV15p4y167Vd) 2:36:15~2:50:30） |                            ×                             |
  | top2 （[video](https://www.bilibili.com/video/BV15p4y167Vd) 2:24:30~2:36:10） |                            ×                             |
  |                           baseline                           | [√](https://github.com/gaoyixu/CAIL2020-Argument-Mining) |

* 参考资料

  1. https://www.aclweb.org/anthology/C18-1314.pdf
  2. https://arxiv.org/pdf/1911.01621

