# CHIP2019-疾病问答迁移学习比赛

* 任务简介

  * 给定来自5个不同病种的问句对，要求判定两个句子语义是否相同或者相近。所有语料来自互联网上患者真实的问题，并经过了筛选和人工的意图匹配标注。
  * 官网：https://www.biendata.xyz/competition/chip2019/

* 时间：2019.9~2019.11

* 数据示例

  |     question1      |     question2      | label | category  |
  | :----------------: | :----------------: | :---: | :-------: |
  |   糖尿病吃什么？   |   糖尿病的食谱？   |   1   | diabetes  |
  | 乙肝小三阳的危害？ | 乙肝大三阳的危害？ |   0   | hepatitis |

  

* 数据说明

  > 注1：标注数据由5个病种构成，diabetes-糖尿病，hypertension-高血压，hepatitis-乙肝，aids-艾滋病，breast_cancer-乳腺癌。label表示问句之间的语义是否相同。若相同，标为1，若不相同，标为0。其中，训练集label已知，验证集和测试集label未知。  
  >
  > 注2：验证集数据作为A榜评测依据；测试集数据包含噪音数据，作为B榜最终评测依据

  

  | train  |  dev   |  test  |                             下载                             |
  | :----: | :----: | :----: | :----------------------------------------------------------: |
  | 20,000 | 10,000 | 50,000 | 官网报名直接下载，[other](https://www.heywhale.com/mw/dataset/5e4d4e198d3880002da45af7) |

  

  |           | diabetes | hypertension | hepatitis | aids  | breast_cancer |
  | :-------: | :------: | :----------: | :-------: | :---: | :-----------: |
  | train.csv |  10,000  |    2,500     |   2,500   | 2,500 |     2,500     |
  |  dev.csv  |  2,000   |    2,000     |   2,000   | 2,000 |     2,000     |
  | test.csv  |    ?     |      ?       |     ?     |   ?   |       ?       |

  

* 竞赛方案

  |                         方案/B榜rank                         |  A榜F1  |  B榜F1  |                             代码                             |
  | :----------------------------------------------------------: | :-----: | :-----: | :----------------------------------------------------------: |
  | [1](https://zhuanlan.zhihu.com/p/97227793)  （PPT：表格下方） | 0.88185 | 0.90257 |                              ×                               |
  |                     2 （PPT：表格下方）                      | 0.88312 | 0.86927 |                              ×                               |
  |                     3 （PPT：表格下方）                      | 0.88071 | 0.86909 |                              ×                               |
  |                              7                               | 0.87816 | 0.86410 | [√](https://github.com/ZhengZixiang/chip2019_task2_question_pairs_matching) |
  |                              10                              | 0.87612 | 0.86327 |          [√](https://github.com/wenyu332/chip-2019)          |
  |      [12](https://lsc417.com/2019/11/08/chip2019task2/)      | 0.87939 | 0.86297 |                              ×                               |
  |        [other](https://zhuanlan.zhihu.com/p/88749723)        |   ？    |   ？    |                              √                               |

  评测报告PPT： [here](http://www.cips-chip.org.cn:8000/static/data/%E8%AF%84%E6%B5%8B%E6%B1%87%E6%8A%A5PPT%E6%B1%87%E6%80%BB.zip) 

* 推荐资料

  1. 医疗NLP领域（主要关注中文） 评测数据集 与 论文等相关资源。[link](https://github.com/lrs1353281004/Chinese_medical_NLP) 
  2. 中文医学NLP公开资源整理：术语集/语料库/词向量/预训练模型/知识图谱/命名实体识别/QA/信息抽取/etc。[link](https://github.com/GanjinZero/awesome_Chinese_medical_NLP) 

