# 2022非标准化疾病诉求的简单分诊挑战赛2.0

## 任务简介

* 本次比赛提供了部分好大夫在线的真实问诊数据，经过严格脱敏，提供给参赛者进行单分类任务。具体为：通过处理文字诉求，给出20个常见的就诊方向之一和61个疾病方向之一。
* 官网：http://challenge.xfyun.cn/topic/info?type=disease-claims-2022
* 时间：2022.6.9-2022.7.18

## 数据示例

单条数据包含年龄段age、主诉diseaseName、标题title、希望获得的帮助hopeHelp和其他描述字段文本conditionDesc，以及就诊方向标签label_i∈int [0,19]，疾病方向标签label_j∈int [0,60] (训练数据中疾病方向标签存在缺失，以-1标记，测试数据中没有)。

| label_i | 就诊方向         |
| ------- | ---------------- |
| 0       | 乳腺外科         |
| 1       | 产前检查         |
| 2       | 内科             |
| 3       | 呼吸内科         |
| 4       | 咽喉疾病         |
| 5       | 妇产科           |
| 6       | 小儿保健         |
| 7       | 小儿呼吸系统疾病 |
| 8       | 小儿消化疾病     |
| 9       | 小儿耳鼻喉       |
| 10      | 心内科           |
| 11      | 消化内科         |
| 12      | 甲状腺疾病       |
| 13      | 皮肤科           |
| 14      | 直肠肛管疾病     |
| 15      | 眼科             |
| 16      | 神经内科         |
| 17      | 脊柱退行性变     |
| 18      | 运动医学         |
| 19      | 骨科             |

| label_j | 疾病方向         | label_j | 疾病方向       | label_j | 疾病方向         |
| ------- | ---------------- | ------- | -------------- | ------- | ---------------- |
| 0       | 乳房囊肿         | 21      | 小儿支气管肺炎 | 42      | 皮肤瘙痒         |
| 1       | 乳腺增生         | 22      | 小儿消化不良   | 43      | 皮肤科其他       |
| 2       | 乳腺疾病         | 23      | 小儿消化疾病   | 44      | 直肠肛管疾病     |
| 3       | 乳腺肿瘤         | 24      | 小儿耳鼻喉其他 | 45      | 眼部疾病         |
| 4       | 产前检查         | 25      | 小儿肺炎       | 46      | 神经内科其他     |
| 5       | 儿童保健         | 26      | 心内科其他     | 47      | 微量元素缺乏     |
| 6       | 先兆流产         | 27      | 心脏病         | 48      | 羊水异常         |
| 7       | 内科其他         | 28      | 扁桃体炎       | 49      | 肺部疾病         |
| 8       | 剖腹产           | 29      | 早孕反应       | 50      | 胃病             |
| 9       | 发育迟缓         | 30      | 月经失调       | 51      | 脊柱退行性变     |
| 10      | 呼吸内科其他     | 31      | 桥本甲状腺炎   | 52      | 腰椎间盘突出     |
| 11      | 咽喉疾病         | 32      | 消化不良       | 53      | 腹泻             |
| 12      | 喉疾病           | 33      | 消化内科其他   | 54      | 腹痛             |
| 13      | 围产保健         | 34      | 消化道出血     | 55      | 膝关节半月板损伤 |
| 14      | 外阴疾病         | 35      | 甲减           | 56      | 膝关节损伤       |
| 15      | 妇科病           | 36      | 甲状腺功能异常 | 57      | 膝关节韧带损伤   |
| 16      | 宫腔镜           | 37      | 甲状腺疾病     | 58      | 运动医学         |
| 17      | 小儿呼吸系统疾病 | 38      | 甲状腺瘤       | 59      | 韧带损伤         |
| 18      | 小儿咳嗽         | 39      | 甲状腺结节     | 60      | 骨科其他         |
| 19      | 小儿感冒         | 40      | 痔疮           |         |                  |
| 20      | 小儿支气管炎     | 41      | 皮肤病         |         |                  |

| id   | age  | diseaseName                     | conditionDesc                                                | title                        | hopeHelp                                                   | label_i | label_j |
| ---- | ---- | ------------------------------- | ------------------------------------------------------------ | ---------------------------- | ---------------------------------------------------------- | ------- | ------- |
| 1    | 30+  | 小红点是什么？                  | 四肢上部张图片中这样的小红疙瘩是怎么回事呢？特别痒。         | 小红点是什么？               | 请医生给我一些治疗上的建议                                 | 13      | 42      |
| 2    | 30+  | 乳腺结节                        | 体检发现左侧乳腺有结节，13mm×8mm,自己没有任何症状            | 左侧乳腺结节                 | 请医生给我一些治疗上的建议,目前病情是否需要手术？          | 0       | 1       |
| 3    | 20+  | 身体麻 身体坐左半面肢体有麻木感 | 年初患有带状疱疹 在左腿脚踝上方 之后疱疹好了 但是左脚开始麻 随后左手麻 然后左腿和左胳膊陆续开始麻 直到左边脸也略有麻木感 同时右脚也麻 | 左侧身体麻木                 | 什么原因导致的麻木以及如何治疗                             | 16      | 47      |
| 4    | 10+  | 生长缓慢，想再增长10厘米        | 今年8月满15岁，身高165厘米，近半年生长缓慢，能否打生长激素再增高10厘米。 | 想增高10厘米                 | 是否可打生长激素                                           | 6       | 9       |
| 5    | 30+  | 眼睛看东西突然变小，变远        | 从小记事时就有此病，发病时看任何东西都变小，距离也判断不太好了，没有就过医。 | 眼睛看东西突然变小，从小就有 | 希望医生诊断这是什么病？需要就医吗？有什么注意事项？谢谢。 | 15      | 46      |
| 6    | 20+  | 甲状腺                          | 嗓子疼，说话感觉里面有回音，先是由感冒引起，后来大量运动后天气变化着凉，疼痛加剧 | 甲状腺肿大                   | 如何控制病情，是否还需做下一步检查                         | 12      | 36      |
| 7    | 0+   | 晚上磨牙，缺钙                  | 女,5岁4个月。骨密度测试部缺钙，验血又显示缺钙，不知道到底怎么回事 | 孩子是否缺钙？               | 希望医生解答一下孩子是否缺钙                               | 6       | 48      |
| 8    | 50+  | 手指麻木                        | 一月前出现十个手指指尖麻木，现症状加重。                     | 手指麻木                     | 会是什么病？需要做什么检查？                               | 16      | 47      |
| 9    | 20+  | 便血，鲜红色的                  | 便血，鲜红色的，大便时还有点疼，就持续两天                   | 要不要做检查                 | 要不要做检查                                               | 11      | 34      |

另提供14000条相关知识文本，每条包含主体/（属性）/客体，供选手随意选用。

## 数据说明

|        | 样本总数 | 下载                                                         |
| ------ | -------- | ------------------------------------------------------------ |
| 训练集 | 22,868   | [√](https://aistudio.baidu.com/aistudio/datasetdetail/155594) |
| 测试集 | 7,596    | 同上                                                         |



## 竞赛方案

评估指标：本模型依据提交的结果文件，采用两种标签类别求和评价，就诊方向label_i用F1-macro score进行评价，疾病方向label_j用F1-micro score进行评价, 最终结果取两者之和。
$$
metric = F1_{macro}(label_i) + F1_{micro}(label_j)
$$

| 方案/rank                                                    | metric  | 代码                                                         |
| ------------------------------------------------------------ | ------- | ------------------------------------------------------------ |
| 1（[video](https://1024.iflytek.com/liveroom?date=1117&id=1.2_%E5%A4%A7%E8%B5%9B_39) 20:45-32:00） | 1.74177 | ×                                                            |
| 2（[video](https://1024.iflytek.com/liveroom?date=1117&id=1.2_%E5%A4%A7%E8%B5%9B_39) 14:20-20:40） | 1.73418 | ×                                                            |
| 3（[video](https://1024.iflytek.com/liveroom?date=1117&id=1.2_%E5%A4%A7%E8%B5%9B_39) -14:00） | 1.73418 | ×                                                            |
| [ai studio baseline](https://aistudio.baidu.com/aistudio/projectdetail/4277961) | 1.6332  | [√](https://aistudio.baidu.com/aistudio/projectdetail/4277961) |
| coggle baseline                                              | 1.6+    | [√](https://github.com/datawhalechina/competition-baseline/blob/master/competition/%E7%A7%91%E5%A4%A7%E8%AE%AF%E9%A3%9EAI%E5%BC%80%E5%8F%91%E8%80%85%E5%A4%A7%E8%B5%9B2022/%E9%9D%9E%E6%A0%87%E5%87%86%E5%8C%96%E7%96%BE%E7%97%85%E8%AF%89%E6%B1%82%E7%9A%84%E7%AE%80%E5%8D%95%E5%88%86%E8%AF%8A%E6%8C%91%E6%88%98%E8%B5%9B_baseline.ipynb) |



## 推荐资料

暂无

