# 2021CHIP-医学对话临床发现阴阳性判别任务

* 任务简介

  * 给出临床发现的mention，要求参赛选手预测分类label，包括“阳性、阴性、其它、不标注”4类。任务难点在于选手需要结合上下文语境去做推断，此外互联网对话语料的特点是患者表达偏口语化，真实场景中数据噪音大，对模型的健壮性提出了更高的要求。
  * 官网：http://www.cips-chip.org.cn/2021/eval1

* 时间：2021.8~2021.12

* 数据示例

  > 标注标准：

  * 阳性(pos)：已有症状疾/病等相关，医生诊断（包含多个诊断结论），以及假设未来可能发生的疾病等，如：“如果不治疗的话，大概率会引起A疾病”，“A疾病”标注为阳性；
  * 阴性(neg)：未患有的疾病症状相关；
  * 其他(other)：未知的标注其他，一般指用户没有回答、不知道或者回答不明确/模棱两可不好推断的情况；
  * 不标注(empty)：无实际意义的不标注，一般是医生的解释说的是一般知识，和病人当前的状态条件独立不具有标注意义，及有些检查项带疾病名称的，识别的疾病（ 乙肝 五项/ 乙肝 抗体），药品名中出现的“疾病”不标注。

  > 例子：

  ```
  病人： 医生您好，从昨天晚上开始 肚子一直疼， ，吃了布洛芬有所缓解。---- “肚子一直疼”标记 阳性
  医生： 肚子疼， 是 上腹部疼 么？---- “肚子疼”标记 阳性 ，是基于上文推断；“上腹部疼”标记 阴性 ，基于下文推断。
  病人： 不是，主要是 下腹部疼 。---- “下腹部疼”标记 阳性 ;
  医生： 是 针扎样的疼 么？---- “针扎样的疼”标注 其他 ;
  病人： 不知道，描述不出来， 有点抽筋的那种疼 。 ---- “针扎样的疼”标注 其他 ;
  ……
  医生： 这种情况考虑为急性肠胃炎导致的，急性肠胃炎可能除了 腹疼 之外，可能还会引起 腹泻 等，需要即时补充水分。---- “腹疼”和“腹泻”均标注为 不标注 ，是医生解释医学常识。
  ```

  > 实际标注：

  ```json
  [
      {
          "text":"胃肠感冒拉水第三天了",
          "ner":[
              {
                  "name":"腹泻",
                  "mention":"拉水",
                  "range":[4, 6],
                  "type":"clinical_findings",
                  "attr":"阳性"
              },
              {
                  "name":"胃肠型感冒",
                  "mention":"胃肠感冒",
                  "range":[ 0, 4],
                  "type":"clinical_findings",
                  "attr":"阳性"
              }
          ],
          "sender":"患者"
      },
      {
          "text":"你好，有没有其发烧？有没有呕吐？",
          "ner":[
              {
                  "name":"呕吐",
                  "mention":"呕吐",
                  "range":[13, 15],
                  "type":"clinical_findings",
                  "attr":"阳性"
              },
              {
                  "name":"发热",
                  "mention":"发烧",
                  "range":[7, 9],
                  "type":"clinical_findings",
                  "attr":"阴性"
              }
          ],
          "sender":"医生"
      },
      # ...
  ]
  ```

  * name：mention对应的标准名
  * mention：短文中出现的和实体匹配的字段
  * type：实体类型，均统一成“clinical_findings”，不再区分症状或者疾病
  * attr：阴性/阳性/其他/不标注

* 数据说明

  | train | test A | test B |                             下载                             |
  | :---: | :----: | :----: | :----------------------------------------------------------: |
  | 6000  |  2000  |  2000  | [√](https://tianchi.aliyun.com/dataset/dataDetail?dataId=108859) |

  

* 竞赛方案

  |                             方案                             |                   汇报题目                   | Macro-F1 |                        代码                         |
  | :----------------------------------------------------------: | :------------------------------------------: | :------: | :-------------------------------------------------: |
  | 1（[video](https://www.withzz.com/live/895402728) 8:14:13~8:24:33） | 《基于实体与实体上下文信息增强的阴阳性判别》 |  78.05   | [√](https://github.com/DataArk/CHIP2021-Task1-Top1) |
  | 2（[video](https://www.withzz.com/live/895402728) 8:25:16~8:35:46） |    《基于多模型融合的医学对话阴阳性判别》    |  77.87   |                          ×                          |
  | 3（[video](https://www.withzz.com/live/895402728) 9:02:57~9:11:15） |  《基于遮蔽语言模型的医学实体标签识别模型》  |   77.2   |                          ×                          |

  

* 推荐资料

  [评测整体报告](https://www.withzz.com/live/895402728) （8:01:20~8:13:00）