# 2020CCKS新冠知识图谱构建与问答评测-子任务2：新冠概念图谱的上下位关系预测

* 任务简介

  * 通常构建知识图谱需要在实体识别完成后，为每一个实体分配预定义的类型，而人工预定义的实体类型覆盖程度有限且不易更新，当涉及新的领域时，实体类别体系可能需要重新定义。通过在网络中动态的获得实体的概念类别，并自动化识别类别之间的上下位关系不但可以解决人工预定义的缺陷，还可以使知识图谱更加立体丰满，有助于上层应用。
  * 官网：https://www.biendata.xyz/competition/ccks_2020_7_2/

* 时间：2020.3~2020.9

* 数据示例

  > 输入
  >
  > entity.txt：实体列表。
  >
  > concept.txt：概念（类型）列表。

  > entity.txt:
  >
  > 终南山
  >
  > 新冠病毒

  > concept.txt:
  >
  > 病毒  
  > 细菌  
  > 疾病  
  > 药物  
  > 医学专科  
  > 检查科目  
  > 症状  

  > 输出：
  >
  > entity_concepts.txt：实体-概念之间的类型关系。
  >
  > concept_concept.txt：概念-概念之间的上下位关系，前者是后者的子概念。

  > entity_concepts.txt:
  >
  > 钟南山	著名医学家  
  > 钟南山	教授  
  > 新冠病毒	病毒  

  > concept_concept.txt: 
  >
  > 著名医学家	医学家  
  > 医学家	专家  
  > 专家	人物  
  > 教授	教师  
  > 教师	人物  
  > 病毒	微生物  
  > 微生物	生物  

* 数据说明

  | 实体  | 概念 |                             下载                             |
  | :---: | :--: | :----------------------------------------------------------: |
  | 19203 | 1179 | [官网](https://www.biendata.xyz/competition/ccks_2020_7_2/data/) |

  任务本身的设置是无监督的，因此不提供训练集。要测试模型性能可以在官网上提交预测结果。

* 竞赛方案

  | 方案 |                           评测论文                           | 代码 |
  | :--: | :----------------------------------------------------------: | :--: |
  | top1 | [基于模式扩充及 BERT 分类的上下位关系识别研究](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_1_2_1.pdf) |  ×   |
  | top2 | [基于 BERT 的新冠概念图谱上下位关系预测方法](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_1_2_2.pdf) |  ×   |
  | top3 | [基于知识增强的上下位关系识别](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_1_2_3.pdf) |  ×   |

* 推荐资料

  [新冠知识图谱开放数据集](http://openkg.cn/group/coronavirus) 

