# 2019法研杯-要素识别

* 任务简介

  * 给定司法文书中的相关段落，系统需针对文书中每个句子进行判断，识别其中的关键案情要素，并根据领域专家设计的案情要素体系进行分类。本任务共涉及三个领域，包括婚姻家庭、劳动争议、借款合同等领域。
  * 官网：http://cail.cipsc.org.cn:2019/instruction.html

* 时间：2019.5~2019.7

* 数据示例

  ```json
  [
      {
          "sentence": "本院查明的事实如下：", 
          "labels": []
      }, 
      {
          "sentence": "一、借款时间：2013年8月27日",
          "labels": []
      }, 
      {
          "sentence": "二、借款金额：5000000元",
          "labels": ["LN2"]
      }, 
      {
          "sentence": "三、约定利息：浮动年利率，借款时按中国人民银行公布的半年期基准年利率5.6%上浮30%，按半年调整，按月结息，结息日为每月的20日，罚息利率为贷款利率150%，对贷款期内不能按期支付的利息按合同利率按月计收复利，贷款逾期后改按合同罚息利率计收复利。", 
          "labels": []
      }, 
      {
          "sentence": "本院认为：原贷款人与各被告签订的书面合同为当事人真实意思表示，合法有效，对当事人具有法律拘束力。", 
          "labels": []
      }, 
      {
          "sentence": "现贷款人将本案债权让与原告，且已办妥公告手续，原告主张的借款本金、利息、罚息及借款利息的复利具有法律依据，本院予以支持。", 
          "labels": ["LN9", "LN5"]
      }
  ]
  ```

  ps1：每条训练数据由一份法律文书的案情描述片段构成，其中每个句子都被标记了对应的类别标签（需要特别注意的是，每个句子对应的类别标签个数不定）  

  ps2：“LN2”对应“借款金额x万元”，在selectedtags.txt中有说明（下载链接link2）

* 数据说明

  |                 train                 |                dev                 |                test                |                             下载                             |
  | :-----------------------------------: | :--------------------------------: | :--------------------------------: | :----------------------------------------------------------: |
  | 离婚：30523，劳动：26394，借贷：17824 | 离婚：3816，劳动：3300，借贷：2229 | 离婚：1500，劳动：1500，借贷：1500 | [link1](https://github.com/huanghuidmml/cail2019_track2/tree/master/data) 、[link2](https://storage.googleapis.com/roberta_zh/roberta_model/data_all.zip) |

  link1和link2中只有部分数据，离婚：1269，劳动：836，借贷：635

* 竞赛方案

  |                             方案                             |                             代码                             |
  | :----------------------------------------------------------: | :----------------------------------------------------------: |
  |  [top1](https://mp.weixin.qq.com/s/YboGAkLQq75NnCOuQRzGrg)   |                              ×                               |
  | [top2](https://github.com/brightmart/multi-label_classification) | [√](https://github.com/brightmart/multi-label_classification) |
  |   [top3](https://github.com/huanghuidmml/cail2019_track2)    |     [√](https://github.com/huanghuidmml/cail2019_track2)     |
  | [other](https://github.com/MrRace/TextClassification/tree/master/ElementsRecognition) |      [√](https://github.com/MrRace/TextClassification)       |

* 推荐资料

  1. 《基于深度学习的法律文书事实描述中判决要素抽取》
  2. 《基于预训练语言模型的案件要素识别方法》

