# 2021CCL-智能对话诊疗评测比赛

* 任务简介

  * 通过人机对话技术辅助问诊，包含三个赛道：
    * （1）医患对话理解，从医患对话文本中识别出五类医疗实体（症状、药品名、药物类别、检查、操作）以及病人症状；
    * （2）医疗报告自动生成，依据病人自述和医患对话，输出具有规定格式的医疗报告，包括：主诉、现病史、辅助检查、既往史、诊断和建议；
    * （3）智能化医疗诊断，要求参赛系统根据给出的显性信息 （病人自诉中提及的症状），与病人模拟器进行互动以获取更多病人的症状，依据交互内容判断疾病。。
  * 官网：http://www.fudan-disc.com/sharedtask/imcs21/index.html

* 时间：2021.4~2021.8

* 数据示例

  > 赛道1：医患对话理解

  > 任务1：命名实体识别，给定一段对话，预测每句话中的**BIO标签**列表。

  | input（对话）                        | output（BIO标签）                                            |
  | ------------------------------------ | ------------------------------------------------------------ |
  | 医生：有没有发热                     | O O O B-Symptom I-Symptom                                    |
  | 患者：没有                           | O O                                                          |
  | ...                                  |                                                              |
  | 医生：应用什么药物                   | O O O O O O                                                  |
  | 患者：给喝过小儿咳喘灵，阿莫西林颗粒 | O O O B-Drug I-Drug I-Drug I-Drug I-Drug O B-Drug I-Drug I-Drug I-Drug I-Drug I-Drug |

  > 任务2：症状识别 （0：没有，1：有，2：不确定），给定一段对话，预测对话中出现过的**症状标准化名称**及**病人是否具有这些症状**。

  | input（对话）                                                | output                                |
  | :----------------------------------------------------------- | ------------------------------------- |
  | ...<br /> 患者：没有发热，但是咳嗽<br /> ...<br /> 患者：嗓子里有呼噜声 | 发热：0<br /> 咳嗽：1<br /> 痰鸣音：1 |

  > 赛道2：医疗报告自动生成，给定一段对话，输出**具有规定格式的医疗报告**。

  | input（自述+对话）                                           | output（医疗报告）                                           |
  | ------------------------------------------------------------ | ------------------------------------------------------------ |
  | 【自述】宝宝九个月了，嗓子有痰咳不出，很少咳嗽，怎么办<br /> 【对话】<br /> 医生：有没有发热<br />  患者：没有<br /> ...<br /> 医生：应用什么药物<br /> 患者：给喝过小儿咳喘灵，阿莫西林颗粒 | (1) 主诉：有痰鸣音两天<br />(2) 现病史：患儿两天前咳嗽服药好转后，出现痰鸣音，口服小儿咳喘灵，阿莫西林颗粒治疗，症状改善不明显<br />(3) 辅助检查：听诊 <br />(4) 既往史：暂无<br />(5) 诊断：小儿支气管炎<br />(6) 建议：完善胸片，对症治疗 |

  > 赛道3：智能化医疗诊断给定显性症状（explicit info），选手提交agent与病人模拟器进行交互，在有限轮次（最多11轮）下，获取更多与病人相关的症状，并进行诊断。Agent最终需要输出询问到的症状和判断的级别标签。

  | 符号          | 含义                                                 |
  | ------------- | ---------------------------------------------------- |
  | id            | 样本id                                               |
  | diagnosis     | 患者疾病类别                                         |
  | explicit info | 病人主诉中明确提及的实体信息，包括症状、检查         |
  | implicit info | 病人整组对话中提及的症状和检查信息，以及它们类别标签 |

  ```json
  {
      "id": '10653868',
      "diagnosis": '小儿消化不良',
      "goal":{  # 用于构建交互系统的数据
          "explicit_info": {'便秘': '1'},  # 在病人的自述中，它含有便秘的症状
          "implicit_info": {'呕吐': '0', '哭闹': '1', '屁': '1'}  # 在医生后续的问诊中，我们可以得到的额外信息有：病人没有呕吐，但是会哭闹和放屁
      }
  }
  ```

  

* 数据说明

  > 下载：http://10.192.9.89:20005/download （复旦大学内网？不确定是否已关闭）

  |   疾病名称   | 样本量 |
  | :----------: | :----: |
  | 小儿支气管炎 |  553   |
  |   小儿发热   |  542   |
  |   小儿腹泻   |  534   |
  | 上呼吸道感染 |  486   |
  | 小儿消化不良 |  475   |
  |   小儿感冒   |  472   |

  * 赛道3：包含2150个样例，六种疾病，347中症状，允许询问11轮

* 竞赛方案

  > 赛道1：医患对话理解

  |                             方案                             |                        汇报题目                         | task1 F1 (%) | task2 F1 (%) |                             代码                             |
  | :----------------------------------------------------------: | :-----------------------------------------------------: | :----------: | :----------: | :----------------------------------------------------------: |
  | 2([video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) 00:12:43~00:25:10) |     基于Prompt和提及注释的症状识别，张昕楠（腾讯）      |      ?       |    76.356    |                              ×                               |
  | 3([video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) 00:25:55~00:38:30) |     基于多示例学习的问答流症状识别，李若松（搜狗）      |      ?       |    75.590    |                              ×                               |
  | 1([video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) 00:39:10~00:56:11) | 基于Pipline和图注意力网络的症状识别，姜逸文（卫宁健康） |    93.216    |    76.214    |                              ×                               |
  |                           baseline                           |                            *                            |    92.21     |    69.86     | [√](https://github.com/Guardianzc/MedicalChatBox/tree/main/track1) |

  > 赛道2：医疗报告自动生成，0.2 x ROUGE-1 + 0.4 x ROUGE-2 + 0.4 x ROUGE-L

  |                             方案                             |                           汇报题目                           | 加权ROUGE |                             代码                             |
  | :----------------------------------------------------------: | :----------------------------------------------------------: | --------- | :----------------------------------------------------------: |
  | 5([video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) 00:57:10~01:12:20) |   基于混合模型的两阶段医疗报告生成，彭佑铭（华南农业大学）   | 0.585     |                              ×                               |
  | 2([video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) 01:12:46~01:27:45) | 基于知识信息融合的医疗报告生成，赵亮（中国平安人寿保险股份有限公司） | 0.605     |                              ×                               |
  | 1([video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) 01:28:25~01:39:22) |          基于多模型混合的医疗报告生成，葛屾（腾讯）          | 0.618     |                              ×                               |
  |                           baseline                           |                              *                               | 0.548     | [√](https://github.com/Guardianzc/MedicalChatBox/tree/main/track2) |

  > 赛道3：智能化医疗诊断，0.8 x 疾病判断正确率 + 0.2 x 症状召回率

  |                             方案                             |                       汇报题目                       | 0.8A+0.2R |                             代码                             |
  | :----------------------------------------------------------: | :--------------------------------------------------: | :-------: | :----------------------------------------------------------: |
  | 2([video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) 01:40:30~01:50:20) |      基于多轮对话的智能疾病诊断，吴喆 （腾讯）       |  65.427   |                              ×                               |
  | 3([video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) 02:05:25~02:20:36) | 基于症状注意力机制的智能疾病诊断，陈俊颖 （哈工大）  |     ?     |                              ×                               |
  | 1 ([video](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) 01:52:37~02：04：50) | 结合检索及文本特诊的智能疾病诊断，刘文阁（中山大学） |     ?     |                              ×                               |
  |                           baseline                           |                          *                           |   0.46    | [√](https://github.com/Guardianzc/MedicalChatBox/tree/main/track3) |

  

* 推荐资料

  [评测总体报告](https://hub.baai.ac.cn/views/12742#mcetoc_1fmalub9qk) （00:03:50~00:11:45）