# 2020千言：多技能对话

* 任务简介
  * 本次评测的开放域对话数据集包含多个数据，涵盖了多个功能场景：包括日常闲聊对话，知识对话、推荐对话等。我们旨在衡量开放域对话模型在各个不同技能上的效果和模型通用性。参赛队所构建的模型需要同时具备三项能力（闲聊对话、知识对话、推荐对话）。
  * 官网：https://www.datafountain.cn/competitions/470
  
* 参赛时间：2020.10~2021.1

* 数据格式

  ```json
  {
  "subtrack": "recommend",
  "profile": {
      "profile key 1": "profile value 1", 
      "profile key 2": "profile value 2", 
      ..., 
      "profile key m-1": ["profile value m-1 element 1", "profile value m-1 element 2", ..., "profile value m-1 element n"],
  	"profile key m": ["profile value m element 1", "profile value m element 2", ..., "profile value m element n"]
  	},
  "situation": "xxxx",
  "goal": [
      ["goal 1 element 1", "goal 1 element 2", ..., "goal 1 element m"], 
      ["goal 2 element 1", "goal 2 element 2", ..., "goal 2 element m"], 
      ..., 
      ["goal n element 1", "goal n element 2", ..., "goal n element m"]
  	],
  "knowlege": [
      ["knowlege 1 element 1", "knowlege 1 element 2", ..., "knowlege 1 element m"], 
      ["knowlege 2 element 1", "knowlege 2 element 2", ..., "knowlege 2 element m"], 
      ..., 
      ["knowlege n element 1", "knowlege n element 2", ..., "knowlege n element m"]
  	],
  "history": ["utterance 1", "utterance 2", ..., "utterance n"]
  }
  ```

  subtrack：任务标识符，用来区分不同子任务（knowledge/chitchat/recommend）。  
  profile：用户画像，包含用户的基本属性和领域偏好、实体偏好等。个别任务可能为空。  
  situation：对话场景，包括对话时间、对话主题等。个别任务可能为空。  
  goal：对话目标或目标序列。个别任务可能为空。  
  knowledge：对话所需的背景知识。个别任务可能为空。  
  history：对话历史。只要不是预测首轮回复，就不为空。  

* 数据说明

  官方收集并提供了开源的中文对话数据，参赛队可以基于这些对话数据构建自己的对话模型：

  1. 闲聊对话相关数据：华为的微博数据，北航和微软的豆瓣多轮对话，清华的LCCC数据集。
  2. 知识对话相关数据：百度的DuConv，清华的KdConv，腾讯的检索辅助生成对话数据集。
  3. 推荐对话相关数据：百度的DuRecDial

  开源数据集：

  1. 华为的微博数据：Noah_NRM_Data，https://pan.baidu.com/s/1x4MD5OL-ewxvcCS6d0j5Jw，3n82
  2. 百度的DuRecDial：https://baidu-nlp.bj.bcebos.com/DuRecDial.zip
  3. 北航和微软的豆瓣多轮对话：https://github.com/MarkWuNLP/MultiTurnResponseSelection
  4. 百度的DuConv：https://ai.baidu.com/broad/subordinate?dataset=duconv
  5. 清华的KdConv：https://github.com/thu-coai/KdConv
  6. 腾讯的检索辅助生成对话数据集：https://github.com/jcyk/seqgen
  7. 清华的LCCC数据集：https://github.com/thu-coai/CDial-GPT

* 竞赛方案

  |                             方案                             | 代码 |
  | :----------------------------------------------------------: | :--: |
  | [baseline](https://github.com/PaddlePaddle/Knover/tree/luge-dialogue/luge-dialogue) |  √   |

  