# ccks2019 中文短文本的实体链指

* 任务描述：
  * 面向中文短文本的实体识别与链指，简称ERL（Entity Recognition and Linking），是NLP领域的基础任务之一，即对于给定的一个中文短文本（如搜索Query、微博、用户对话内容、文章标题等）识别出其中的实体，并与给定知识库中的对应实体进行关联。ERL整个过程包括**实体识别**和**实体链指**两个子任务。
  * 官网：https://www.biendata.com/competition/ccks_2019_el/
* 参赛时间：2019.4.20~2019.7.25
* 数据格式：  

> 输入：  输入文件包括若干行中文短文本。

 ```
 {
  "text_id":"1",  
  "text":"比特币吸粉无数，但央行的心另有所属|界面新闻 · jmedia"
 }
 ```

> 输出：输出文本每一行包括此中文短文本的实体识别与链指结果，需识别出文本中所有mention（包括实体与概念），每个mention包含信息如下：mention在给定知识库中的ID，mention名和在中文短文本中的位置偏移。

```
{
"text_id":"1",
"text":"比特币吸粉无数，但央行的心另有所属|界面新闻 · jmedia",
"mention_data":[
     {
         "kb_id":"278410",
         "mention":"比特币",
         "offset":"0"
     },
     {
         "kb_id":"199602",
         "mention":"央行",
         "offset":"9"
     },
     {
         "kb_id":"215472",
         "mention":"界面新闻",
         "offset":"18"
     }
  ]
}
```

* 数据说明：对于实体有歧义的查询 ，系统应该有能力来区分知识库中链接的候选实体中哪个实体为正确链指的实体结果。例如，知识库中有3个不同的实体都可能是『比特币』的正确链指结果，但在给定的上下文中，有足够的信息去区分这些候选实体哪个才是应该被关联的结果。  
* 数据下载：https://pan.baidu.com/s/1SShtugdAMVf0fdaBowtMiA ，提取码： 8r80
* 竞赛方案： 

|                             名次                             |                 实体识别                 |         实体链指          |   F1    | 代码 |
| :----------------------------------------------------------: | :--------------------------------------: | :-----------------------: | :-----: | ---- |
| [第一名](https://github.com/panchunguang/ccks_baidu_entity_link) | **BERT**-**E**ntity**N**ame**E**mbedding | 基于 BERT 的二分类，排序  | 0.80143 | √    |
|     [第五名](https://github.com/AlexYangLi/ccks2019_el)      |              BiLSTM+CNN+CRF              |        BiLSTM+CNN         | 0.79266 | √    |
|     [第十名](https://github.com/renjunxiang/ccks2019_el)     |            BERT+RNN+指针网络             | 预训练词向量+CNN+二分类器 | 0.78450 | √    |