# 2020中文医学文本命名实体识别

* 任务简介
  * 本评测任务为面向中文医学文本的命名实体识别，即给定schema及句子sentence，对于给定的一组纯医学文本文档，任务的目标是识别并抽取出与医学临床相关的实体，并将他们归类到预先定义好的类别。将医学文本命名实体划分为九大类，包括：疾病，临床表现，药物，医疗设备，医疗程序，身体，医学检验项目，微生物类，科室。标注之前对文章进行自动分词处理，所有的医学实体均已正确切分。
  * 命名实体标注的基本原则：
    1. “临床表现”实体类别中允许嵌套，该实体内部允许存在其他八类实体；
    2. 除了“临床表现”实体之外的医学实体，在标注时遵循“最大单位标注法”，即如果一个实体类别里包含其他的实体，只需要将最大的实体标注出来，不需要做嵌套标注。
    3. 为了保证医学实体意义的可理解性和完整性，九类实体内部可以包含必要的标点符号，实体可以是一个词、短语或句子。
  * 官网：https://www.biendata.xyz/competition/chip_2020_1/

* 参赛时间：2020.7~2020.9

* 数据格式：

  * （5）房室结消融和起搏器植入作为反复发作或难治性心房内折返性心动过速的替代疗法。|||3    7    pro|||9    13    pro|||16    33    dis|||
  * 4.第三类（1）无症状性WPW综合征患者，年龄小于5岁。|||8    17    dis|||

* 数据说明：

  * 记录医学实体的位置以及标签，医学实体的位置和标签之间以四个空格分隔
  
* ![样例](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB/pic/1.png?raw=true)
  
  | 训练集 | 验证集 | 测试集 |  开放获取  |
  | :----: | :----: | :----: | :--------: |
  | 15000  |  5000  |  8000  | 官网可下载 |
  
  
  
* 参赛方案：暂无详细top方案公开，只有一份不知名代码，https://github.com/zhangzhang66/CHIP2020_Entity

  | 排名 |                           参赛单位                           |    队伍名称    |                             方案                             |       外部资源       |   F1   |
  | :--: | :----------------------------------------------------------: | :------------: | :----------------------------------------------------------: | :------------------: | :----: |
  |  1   | 腾讯天衍实验室 （[video](https://www.bilibili.com/video/BV185411574p?p=44) ） |     yangyf     |            预训练模型+MRC；预训练模型+CRF；词增强            | 医疗网站上的相关文本 | 0.6835 |
  |  2   |                           纽约大学                           |       xi       | 1.基于CRF的实体抽取，结合阅读理解完成训练<br/>2.采取词汇增强，动态规划文本分割，半监督数据增强及模型融合方法增强效果 |          否          | 0.6825 |
  |  3   | 北京理工大学 （[video](https://www.bilibili.com/video/BV185411574p?p=45) ） | 信息抽取三元组 |               biaffine、伪标、模型融合、MRC-QA               |  开源预训练语言模型  | 0.6824 |

* 推荐资料

  [CHIP2020评测整体报告](https://www.bilibili.com/video/BV185411574p?p=42) 
  
  [面向医学文本处理的实体标注规范](https://www.bilibili.com/video/BV185411574p?p=43) 

