# 2020CCKS面向中文电子病历的医疗实体及事件抽取-子任务1：医疗命名实体识别

* 任务简介

  * 本任务为中文病历医疗实体识别任务，即对于给定的一组电子病历纯文本文档，识别并抽取出与医学临床相关的实体提及（entity mention），并将它们归类到预定义类别（pre-defined categories），比如疾病、治疗、检查检验等。
  * 官网：https://www.biendata.xyz/competition/ccks_2020_2_1/

* 时间：2020.3~2020.9

* 数据示例

  ```json
  {
      "originalText": "缘于入院前1月余因“胆石症、急性胆囊炎”就诊我院，下腹部CT示：1、胆总管上段多发结石，伴肝内外胆管扩张。2、急性胆囊炎，胆囊多发结石。入院后予抗感染，保肝，抑制胰酶分泌，营养支持等治疗，于2014.01.16在B超定位上行“胆囊穿刺造瘘术”，术顺，术后症状好转，家属要求出院。此次为行进一步治疗再次就诊我院，门诊拟“胆石症PTCD术后”收入院，自发病以来神志清，精神不振，饮食少，睡眠可，二便正常，体重未见明显增减。",
      "entities": [
          {"start_pos": 10, "end_pos": 13, "label_type": "疾病和诊断"},
          {"start_pos": 14, "end_pos": 19, "label_type": "疾病和诊断"}, 
          {"start_pos": 25, "end_pos": 30, "label_type": "影像检查"}, 
          {"start_pos": 34, "end_pos": 43, "label_type": "疾病和诊断"}, 
          {"start_pos": 45, "end_pos": 52, "label_type": "疾病和诊断"}, 
          {"start_pos": 55, "end_pos": 60, "label_type": "疾病和诊断"}, 
          {"start_pos": 61, "end_pos": 67, "label_type": "疾病和诊断"}, 
          {"start_pos": 77, "end_pos": 78, "label_type": "解剖部位"}, 
          {"start_pos": 81, "end_pos": 82, "label_type": "解剖部位"}, 
          {"start_pos": 106, "end_pos": 108, "label_type": "影像检查"}, 
          {"start_pos": 113, "end_pos": 120, "label_type": "手术"}, 
          {"start_pos": 159, "end_pos": 168, "label_type": "疾病和诊断"}
      ]
  }
  ```

  预定义类别定义如下：  
  **1) 疾病和诊断：**医学上定义的疾病和医生在临床工作中对病因、病生理、分型分期等所作的判断。  
  **2) 检查：** 影像检查（X线、CT、MR、PETCT等）+造影+超声+心电图，未避免检查操作与手术操作过多冲突，不包含此外其它的诊断性操作，如胃镜、肠镜等。  
  **3）检验：** 在实验室进行的物理或化学检查，本期特指临床工作中检验科进行的化验，不含免疫组化等广义实验室检查
  **4) 手术：** 医生在患者身体局部进行的切除、缝合等治疗，是外科的主要治疗方法。  
  **5) 药物：** 用于疾病治疗的具体化学物质。  
  **6) 解剖部位：** 指疾病、症状和体征发生的人体解剖学部位。  

* 数据说明

  | 标注数据 | 非标注数据 | 词表 | 测试集 |                             下载                             |
  | :------: | :--------: | :--: | :----: | :----------------------------------------------------------: |
  |   1500   |    1000    | 6292 |  300   | [√](https://github.com/hy-struggle/ccks_ner/tree/2c72021b371c80e95b62c1a42e7e5dc557296332/clinic/PreModel_Encoder_CRF) （ccks2020_2_task1_train、ccks2_task1_val） 、[官网](https://www.biendata.xyz/competition/ccks_2021_clinic/data/) |

  

* 竞赛方案

  |                             方案                             |                           评测论文                           |                             代码                             |
  | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: |
  | [top1 & 技术创新奖](https://www.bilibili.com/video/BV1jK4y177Ya?p=23) | [《Noisy Label Learning for Chinese Medical Named Entity Recognition Based on Uncertainty Strategy》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_3_1_1.pdf) |                              ×                               |
  |                             top2                             | [《基于 BERT 与字形字音特征的医疗命名实体识别》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_3_1_2.pdf) |                              ×                               |
  |                             top3                             | [《基于 ChiEHRBert 与多模型融合的医疗命名实体识别》](https://bj.bcebos.com/v1/conference/ccks2020/eval_paper/ccks2020_eval_paper_3_1_3.pdf) |                              ×                               |
  |                             top5                             |                              ×                               | [√](https://github.com/hy-struggle/ccks_ner/tree/2c72021b371c80e95b62c1a42e7e5dc557296332) |

* 推荐资料

  https://github.com/yongzhuo/Pytorch-NLU/blob/0589d496ece9490c435b2ebf7d70ae427fda815e/pytorch_sequencelabeling/README.md