#  2020语言与智能技术竞赛：关系抽取任务

* 任务简介

  * 任务目标是在给定的文本句子中，根据预先定义的schema集合，抽取出所有满足 schema 约束的 SPO 三元组。schema 定义了关系 P 以及其对应的主体 S 和客体 O 的类别。
  * 官网：https://aistudio.baidu.com/aistudio/competition/detail/31

* 参赛时间：2020.3~2020.5

* 数据格式

  * 输入：schema约束集合及句子sent
  * 输出：句子sent中包含的符合给定schema约束的三元组知识Triples

     输出根据 O 类型的复杂程度可以划分为以下两种：

  1. 简单 O 值：也就是说 O 是一个单一的文本。例如，「妻子」关系的 schema 定义为：

     ```json
     {
         S_TYPE: 人物,
         P: 妻子,
         O_TYPE: {
             @value: 人物
     	}
     }
     ```

     

  2. 复杂 O 值：也就是说 O 是一个结构体，由多个语义明确的文本共同组成，多个文本对应了结构体中的多个槽位（slot）。例如，「饰演」关系中 O 值有两个槽位 @value 和 inWork，分别表示「饰演的角色是什么」以及「在哪部影视作品中发生的饰演关系」，其 schema 定义为：

     ```json
     {
         S_TYPE: 娱乐人物,
         P: 饰演,
         O_TYPE: {
             @value: 角色
             inWork: 影视作品
         }
     } 
     ```

     

* 数据说明

  | 训练集  | 验证集 | 测试集 |                             下载                             |
  | :-----: | :----: | :----: | :----------------------------------------------------------: |
  | 170,000 | 20,000 | 20,000 | other baseline中，https://pan.baidu.com/s/1aUIbJOupIEruSn5Z_X7P3g，rrrs |

  数据来自DuIE2.0，是业界规模最大的基于schema的中文信息抽取数据集，其包含超过21万中文句子及48个已定义好的schema，[表1](https://ai.baidu.com/file/18FAC5D981664C07B7314731229C214B) 中展示了DuIE2.0数据集中包含的43个简单知识的schema及对应的例子，[表2](https://ai.baidu.com/file/7660F27FA19E43D2AC6CF2CBD6A2D271) 中展示了DuIE2.0数据集中包含的5个复杂知识的schema及对应的例子。

* 竞赛方案

  |                             方案                             | 代码 |  
  | :----------------------------------------------------------: | :--: |  
  | [top1](http://live.baidu.com/m/media/pclive/pchome/live.html?room_id=4008201814&source=h5pre) （1:35:50开始） |  ×   |  
  | [top15](https://github.com/aker218/Baidu-2020-Language-and-Intelligent-Technology-Competition-Relation-Extraction-rank15) |  √   |  
  | official baseline（[github](https://github.com/PaddlePaddle/Research/tree/master/KG/DuIE_Baseline) 、[AIstudio](https://aistudio.baidu.com/aistudio/projectdetail/357344) ） |  √   |  
  |   [other baseline](https://zhuanlan.zhihu.com/p/136277427)   |  √   |
  
* 其它资料

  * [关系抽取调研--工业界](https://github.com/BDBC-KG-NLP/IE-Survey/blob/master/%E5%85%B3%E7%B3%BB%E6%8A%BD%E5%8F%96-%E5%B7%A5%E4%B8%9A%E7%95%8C.md) (也可以下载任务数据集)

