# 2020科大讯飞事件抽取挑战赛

* 任务简介
  * 本赛事任务旨在从通用新闻文本中抽取事件触发词、事件论元以及事件属性。 在传统的事件定义中，事件由事件触发词( Trigger) 和描述事件结构的元素 (Argument)构成。事件触发词标识着事件的发生。事件论元为事件主体(Subject)、客体(Object)、时间(Time)、地点(Location)等，是表达事件重要信息的载体。事件属性包括事件极性（Polarity）、时态(Tense)，是衡量事件是否真实发生的重要依据。 通过极性，事件分为肯定、否定、可能事件。通过时态，事件分为过去发生的事件、现在正在发生的事件、将要发生的事件以及其他无法确定时态的事件。
  * 官网：http://challenge.xfyun.cn/topic/info?type=hotspot
  
* 参赛时间：2020.8~2020.10

* 数据格式：

  * 任务一：事件触发词及论元抽取

  文本：北京时间 3 月 27 日晚上 7 点 15 分，英国首相鲍里斯约翰逊确诊感染了新冠肺炎。

  抽取结果：

  ![xunfei_1.png](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/pic/xunfei_1.png?raw=true)

  * 任务二：事件属性抽取

  文本：中国驻俄罗斯大使张汉晖 4 月 7 日向媒体回应称，经向俄有关强力部门了解，目前在俄没有一起中国公民遭到拘留或受到俄强力部门限制的案例。

  抽取结果：

  ![xunfei_2.png](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/pic/xunfei_2.png?raw=true)

* 数据说明：

  * 本赛事任务一为初赛任务，任务二为复赛任务，在任务一的基础上增加了事件属性识别。为 了模拟真实场景，数据中包含了非实际发生的事件。

  * 任务一：该任务旨在从文本中抽取标识事件发生的触发词和论元，触发词往往为动词和名词。触发词 对应的事件论元，主要为主体、客体、时间、地点，其中主体为必备论元。

  * 任务二：该任务旨在从文本中抽取表达事件发生状态的属性，包括极性、时态。极性分为：肯定、否定、可能；时态分为：过去、现在、将来、其他。

  * |                                    | 训练集 | 测试集 | 开放获取 |
    | :--------------------------------: | :----: | :----: | :------: |
    | 初赛（6958条句子，9644条提取结果） |  5758  |  1200  |    否    |
    | 复赛（3335条句子，3384条提取结果） |  2456  |  879   |    否    |

* 竞赛方案：

  |                             方案                             | 代码 |
  | :----------------------------------------------------------: | :--: |
  | [top1](https://mp.weixin.qq.com/s/WXWD7fmitaFHfUAv1mNLPA) ，[code](https://github.com/WuHuRestaurant/xf_event_extraction2020Top1) |  √   |
  | [前三名队伍总结](https://blog.csdn.net/herosunly/article/details/109289786) ，付费警告 | 不明 |