# 2020CHIP-中文医学文本实体关系抽取

* 任务简介

  * 给定schema约束集合及句子，输出句子中所有满足schema约束的SPO三元组知识Triples=[(S1, P1, O1), (S2, P2, O2)...]。数据集包含儿科训练语料和百种常见疾病训练语料，儿科训练语料来源于518种儿科疾病，百种常见疾病训练语料来源于109种常见疾病。近7.5万三元组数据，2.8万疾病语句和53种定义好的schema。
  * 官网：https://biendata.xyz/competition/chip_2020_2/

* 时间：2020.7~2020.9

* 数据示例

  > schema约束集合，共53条

  ```json
  {"subject_type": "疾病", "predicate": "预防", "object_type": "其他"}
  {"subject_type": "疾病", "predicate": "阶段", "object_type": "其他"}
  {"subject_type": "疾病", "predicate": "就诊科室", "object_type": "其他"}
  # 省略余下50条，具体内容可在官网下载数据集查看
  ```

  > 数据集：在每句之前增加主题疾病实体，并以@和原文分割。抽取语料时，如果三元组来源于上下多个句子，此时将句子进行拼接，”spo_list”中的Combined字段记录拼接信息。若句子中存在多个三元组，则记录在”spo_list”字段中，”text”字段记录来源文本。

  ```json
  {
      "text": "慢性胰腺炎@### 低剂量放射 自1964年起，有几项病例系列报道称外照射 (5-50Gy) 可以有效改善慢性胰腺炎患者的疼痛症状。慢性胰腺炎@从概念上讲，外照射可以起到抗炎和止痛作用，并且已经开始被用于非肿瘤性疼痛的治疗。", 
      "spo_list": [
          {
              "Combined": true, 
              "predicate": "放射治疗", 
              "subject": "慢性胰腺炎", 
              "subject_type": "疾病", 
              "object": {"@value": "外照射"}, 
              "object_type": {"@value": "其他治疗"}
          }, 
          {
              "Combined": true,
              "predicate": "放射治疗",
              "subject": "非肿瘤性疼痛",
              "subject_type": "疾病",
              "object": {"@value": "外照射"},
              "object_type": {"@value": "其他治疗"}
          }
      ]
  }
  ```

  

* 数据说明

  |   训练集   | 验证集 | 测试集 |                             下载                             |
  | :--------: | :----: | :----: | :----------------------------------------------------------: |
  | 14339+3585 |  4482  |  5602  | [官网](https://biendata.xyz/competition/chip_2020_2/data/) 、[CBLUE-CMeIE](https://tianchi.aliyun.com/dataset/dataDetail?spm=5176.22060218.J_2657303350.1.70e813433GZvjS&dataId=95414) |

  

* 竞赛方案

  |                             方案                             |   F1   |                             代码                             |
  | :----------------------------------------------------------: | :----: | :----------------------------------------------------------: |
  | [top1](https://zhuanlan.zhihu.com/p/326302618) （[video](https://www.bilibili.com/video/BV185411574p?p=46) ） | 0.6486 | [√](https://github.com/loujie0822/DeepIE/tree/master/models/spo_net) |
  | top2 （[video](https://www.bilibili.com/video/BV185411574p?p=47) ） | 0.6387 |                              ×                               |
  | top3 （[video](https://www.bilibili.com/video/BV185411574p?p=48) ） | 0.6378 |                              ×                               |

  

* 推荐资料

  [CBLUE](https://tianchi.aliyun.com/specials/promotion/2021chinesemedicalnlpleaderboardchallenge) 榜单中的CMeIE
  
  [CHIP2020评测整体报告](https://www.bilibili.com/video/BV185411574p?p=42) 