# NLPer-Arsenal

NLP人军火库，主要收录NLP竞赛策略实现、各任务教程、经验贴、学习资料以及会议时间等，如果对你有帮助，请给我们一个star。

本项目主要包含以下内容：

* [NLPer-Arsenal-Code](https://github.com/TingFree/NLPer-Arsenal/tree/master/codes) （2021.12）
  * 插件式验证NLP竞赛策略，并提供解耦实现，方便迁移到自己的模型中，[here](./codes/tricks) 
  * NLP各任务教程（文本分类/文本生成），通过注释详细的baseline快速了解各个任务，[here](./codes/examples) 
* NLPer-Arsenal-Post（2021.03）
  * 往期竞赛总结，收录已经结束的竞赛，包括数据集、开源代码、选手方案，[here](#往期竞赛) 
  * 当前重点赛事与训练赛，记录当下正在进行的NLP赛事，[here](#当前赛事) 
* 其它
  * 自媒体推荐，提供一些NLPer常用的公众号/网站等，简单了解一些前沿动态，[here](#自媒体推荐) 
  * 算力推荐，推荐一些算力资源，免费/收费的都有，[here](#算力推荐) 
  * 竞赛平台，推荐一些主要的竞赛平台，[here](#竞赛平台) 
  * 会议时间，跟踪记录NLP会议收稿/开会时间，[here](#会议时间) 

项目正在不断完善，如果您有什么建议，欢迎到[issue](https://github.com/TingFree/NLPer-Arsenal/issues) 留言，或者通过邮箱（hello@arsenal-ai.cn）联系我们。

所有内容均由我们从网络公开资料中收集整理得到，版权归原作者所有，如有侵权请立即与我们联系，我们将及时处理。

整理不易，转载时请务必备注本项目github链接，感谢您为维护良好的开源环境出一份力。 


## 目录  

* [当前赛事](#当前赛事)
* [往期竞赛](#往期竞赛)
* [自媒体推荐](#自媒体推荐)
* [算力推荐](#算力推荐)
* [竞赛平台](#竞赛平台)
* [会议时间](#会议时间)

## 当前赛事

### 重点赛

> 记录当前正在进行的竞赛，奖金丰厚，适合有一定基础的NLPer；结束时间为官网标准时间或会议召开时间。

|                   领域/会议                    | 竞赛                                                         |  报名时间  | 结束时间  |
| :--------------------------------------------: | ------------------------------------------------------------ | :--------: | :-------: |
| 大模型 | [基于通用大模型的知识库问答](https://www.datafountain.cn/competitions/961) <br />[面向大语言模型的提示注入攻防竞赛](https://www.datafountain.cn/competitions/668) <br />[基于大模型的开源软件安全应用情报员应用开发](https://www.datafountain.cn/competitions/672) | 2023.08.23-10.24<br>2023.8.14-9.28<br>同上 | 2023.11.03-11.05<br>2023.11<br>同上 |
| CAIL2023 | 1. [司法考试](http://cail.cipsc.org.cn/task_summit.html?raceID=0&cail_tag=2023) <br />2. [对话式类案检索](http://cail.cipsc.org.cn/task_summit.html?raceID=2&cail_tag=2023) <br />3. [类案检索](http://cail.cipsc.org.cn/task_summit.html?raceID=3&cail_tag=2023) <br />4. [事实认定](http://cail.cipsc.org.cn/task_summit.html?raceID=4&cail_tag=2023) <br />5. [论辩理解](http://cail.cipsc.org.cn/task_summit.html?raceID=5&cail_tag=2023) <br />6. [信息抽取](http://cail.cipsc.org.cn/task_summit.html?raceID=6&cail_tag=2023) <br />7. [司法大模型](http://cail.cipsc.org.cn/task_summit.html?raceID=7&cail_tag=2023) | 2023.8-11，具体时间详见各赛事安排 | 2023.12 |
| CHIP2023 | [评测一: CHIP-PromptCBLUE医疗大模型评测任务](http://cips-chip.org.cn/2023/eval1) （[不微调](https://tianchi.aliyun.com/competition/entrance/532131/introduction) 、[参数微调](https://tianchi.aliyun.com/competition/entrance/532132/introduction) ） <br />[评测二: 中文医学文本小样本命名实体识别评测任务](http://cips-chip.org.cn/2023/eval2) <br />[评测三:药品纸质文档识别与实体关系抽取任务](http://cips-chip.org.cn/2023/eval3) | 2023.8.1-9.27 | 2023.10.27-10.29 |
| SMP2023 | [ChatGLM 金融大模型挑战赛](https://tianchi.aliyun.com/competition/entrance/532126/introduction) | 2023.7.19-8.16 | 2023.9 |
| AI开发者大赛 | [中文语义病句识别与纠正挑战赛](http://challenge.xfyun.cn/topic/info?type=identification-and-correction) <br />[多语言机器翻译挑战赛](http://challenge.xfyun.cn/topic/info?type=multilingual-machine-translation) <br />[人岗匹配挑战赛2.0](http://challenge.xfyun.cn/topic/info?type=person-post-matching-2023) <br />[汽车领域文本规X则泛化性增强挑战赛](http://challenge.xfyun.cn/topic/info?type=increased-generalization) <br />[基于论文摘要的文本分类与关键词抽取挑战赛](http://challenge.xfyun.cn/topic/info?type=abstract-of-the-paper) <br />[机器翻译质量评估挑战赛2023](http://challenge.xfyun.cn/topic/info?type=translation-quality-2023) <br />[校招简历应聘岗位与项目技能匹配检测挑战赛](http://challenge.xfyun.cn/topic/info?type=skill-matching) <br />[校招简历信息完整性检测挑战赛](http://challenge.xfyun.cn/topic/info?type=information-integrity) <br />[方面情感三元组提取的跨领域迁移挑战赛](http://challenge.xfyun.cn/topic/info?type=aspect-emotion) <br />[微博评论机器人](http://challenge.xfyun.cn/topic/info?type=weibo-comment-robot) <br />[ChatGPT生成文本检测器](http://challenge.xfyun.cn/topic/info?type=text-detector) <br />[标书实体抽取挑战赛](https://challenge.xfyun.cn/topic/info?type=physical-extraction-of-tender) <br />[基于自然语言的软件任务执行挑战赛](https://challenge.xfyun.cn/topic/info?type=software-task) <br />[学术文档篇章级结构恢复挑战赛](https://challenge.xfyun.cn/topic/info?type=academic-documents-2023) <br />[学术文档要素分类挑战赛](https://challenge.xfyun.cn/topic/info?type=academic-documents) | 2023.5-9，具体实践详见各赛事 | 2023.10.24 |
| [DSTC11](https://dstc11.dstc.community/tracks) | Track 4：[Robust and Multilingual Automatic Evaluation Metrics for Open-Domain Dialogue Systems](https://chateval.org/dstc11) <br />Track 5：Task-oriented Conversational Modeling with Subjective Knowledge |  -2023.3   | 2023.8-9  |
| [CCMT2023](http://mteval.cipsc.org.cn:81/CCMT2023/index.html) | CCMT与WMT2023合作组织的汉英、英汉新闻领域的翻译评测<br />维汉、蒙汉、藏汉的翻译评测<br />翻译质量估计评测<br />自动译后编辑评测<br />一带一路”低资源语言机器翻译任务<br />以中文为中心的多语言机器翻译任务<br />中英零指代机器翻译任务 | -2023.5.10 | 2023.10 |
|      [千言数据集](https://www.luge.ai/#/)      | 文本生成、情感分析、阅读理解、中文对话、文本相似度、语义解析、机器同传、信息抽取、实体链指、低资源语言翻译、自然语言推理、事实核查、可解释评测、段落检索、视频语义理解等15个任务60个数据集 |    现在    |   暂无    |
|          中文医疗信息处理挑战榜CBLUE           | 目前任务包括医学文本信息抽取（实体识别、关系抽取）、医学术语归一化、医学文本分类、医学句子关系判定和医学QA共5大类任务8个子任务，-> [官网](https://tianchi.aliyun.com/specials/promotion/2021chinesemedicalnlpleaderboardchallenge) |    现在    |   暂无    |

### 训练赛

> 记录长期进行的训练赛，有排行榜，方便刚入门的NLPer练手

|   领域   |                             竞赛                             |                           报名时间                           |                           结束时间                           |
| :------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: |
| 文本分类 | [WEBSHELL文本检测学习赛](https://tianchi.aliyun.com/competition/entrance/532068/introduction?spm=a2c22.12281949.0.0.605a3b74ICNRo2) <br /> [医疗诊疗对话意图识别挑战赛](https://tianchi.aliyun.com/competition/entrance/532044/introduction) <br />[知乎问题自动标注](https://god.yanxishe.com/75) （有数据）<br /> [数据分析达人赛1：用户情感可视化分析](https://tianchi.aliyun.com/competition/entrance/531890/introduction) <br> [中文新闻文本标题分类](https://aistudio.baidu.com/aistudio/competition/detail/107/0/introduction) <br>[金融用户评论分类](https://god.yanxishe.com/67?from=god_home_list) <br /> [中文对话情感分析](https://god.yanxishe.com/28?from=god_home_list) <br />  [新闻文本分类](https://tianchi.aliyun.com/competition/entrance/531810/introduction) <br> [文本分类对抗攻击](https://tianchi.aliyun.com/competition/entrance/231762/introduction) <br> [虚假职位招聘预测](https://www.datafountain.cn/competitions/448) <br> [疫情期间互联网虚假新闻检测](https://www.datafountain.cn/competitions/422) <br> [疫情期间网民情绪识别](https://www.datafountain.cn/competitions/423) <br> [O2O商铺食品安全相关评论发现](https://www.datafountain.cn/competitions/370) <br> [互联网新闻情感分析](https://www.datafountain.cn/competitions/350) <br> [汽车行业用户观点主题及情感识别](https://www.datafountain.cn/competitions/310) <br> [影评文本情感分析](https://js.dclab.run/v2/cmptDetail.html?id=359) <br> [垃圾邮件分类](https://js.dclab.run/v2/cmptDetail.html?id=352) <br> [短文本分类大赛-图灵联邦](https://www.turingtopia.com/competitionnew/detail/6f2569bf525c4bc8a6049a52ec919aac/sketch) <br> [情感分类大赛-图灵联邦](https://www.turingtopia.com/competitionnew/detail/319f33ab29c04d9583e7f5c208dea119/sketch) <br> [医疗文本分类 - FlyAI](https://www.flyai.com/d/303) <br> [中文垃圾短信识别 - FlyAI](https://www.flyai.com/d/199) <br> [英文垃圾信息分类](https://god.yanxishe.com/31?from=god_home_list) <br /> [社交网站消息内容分类 - FlyAI](https://www.flyai.com/d/180) <br> [用户商场评价情感分析 - FlyAI](https://www.flyai.com/d/8) <br>  [Stanford-Sentiment-Treebank 情感分析 - FlyAI](https://www.flyai.com/d/162) <br> [COLA 英文句子可理解性分类 - FlyAI](https://www.flyai.com/d/160) <br> [今日头条新闻分类 - FlyAI](https://www.flyai.com/d/138) <br> [美国点评网站Yelp评价预测赛 - FlyAI](https://www.flyai.com/d/3) <br> [千言数据集：情感分析 - 百度AI Studio](https://aistudio.baidu.com/aistudio/competition/detail/50) <br>  [Kaggle-Contradictory, My Dear Watson](https://www.kaggle.com/c/contradictory-my-dear-watson) <br> [Kaggle-Natural Language Processing with Disaster Tweets](https://www.kaggle.com/c/nlp-getting-started/rules) <br> [CLEF 2019 Lab ProtestNews ](https://competitions.codalab.org/competitions/34242#learn_the_details-overview) (Document、Sentence、Token) | -<br>-<br>已结束<br />- <br>-<br>-<br>-<br>- <br> - <br> - <br> -<br> - <br> -<br> - <br> - <br> - <br> - <br> 每月1号<br> 每月1号<br>- <br/> - <br/> -<br> - <br/> - <br/> - <br/> - <br/> - <br/> - <br/> -<br> -<br> - <br> - | 2024.02<br>2024.02<br>已结束<br />2022.4.30 <br>2023.01<br>-<br>-<br>- <br>2021.12.31<br> - <br> - <br/> - <br/> - <br/> - <br/> -<br/> - <br/> - <br/> 每月27号<br> 每月27号<br/> - <br/> - <br/> - <br/> -<br>- <br/> - <br/> - <br/> - <br/> - <br/> 2023.1<br> -<br> - <br> - |
| 文本匹配 | [医学搜索Query相关性判断](https://tianchi.aliyun.com/competition/entrance/532001/introduction) <br>[Quora-检测两个问题是否重复 - FlyAI](https://www.flyai.com/d/73) <br> [千言数据集：文本相似度](https://aistudio.baidu.com/aistudio/competition/detail/45) <br />[千言数据集：问题匹配鲁棒性](https://aistudio.baidu.com/aistudio/competition/detail/130/0/introduction) <br /> [英文文本语义相似度](https://god.yanxishe.com/60?from=god_home_list) <br /> [IMDB评论剧透检测](https://god.yanxishe.com/36?from=god_home_list) <br />[医学搜索Query相关性判断](https://tianchi.aliyun.com/competition/entrance/532001/introduction) <br />[CCKS2021中文NLP地址相关性任务](https://tianchi.aliyun.com/competition/entrance/531901/introduction) （[数据集](https://tianchi.aliyun.com/dataset/110146) ） |   -<br>- <br/> -<br>-<br /> -<br> -<br />-2022.9.30<br />-   | 2024.02<br>- <br/> 2023.1<br> 2023.1<br />-<br> -<br />2022.10.7<br />- |
| 文本蕴含 | [Contradictory, My Dear Watson](https://www.kaggle.com/competitions/contradictory-my-dear-watson/overview) |                              -                               |                              -                               |
| 推荐系统 | [阿里移动推荐算法挑战赛](https://tianchi.aliyun.com/competition/entrance/532043/introduction) <br>[零基础入门推荐系统 - 新闻推荐](https://tianchi.aliyun.com/competition/entrance/531842/introduction?spm=5176.12281949.1003.21.493e2448CFpD1w) <br> [天池新人挑战赛之阿里移动推荐算法](https://tianchi.aliyun.com/competition/entrance/231522/introduction) <br> [电商用户购买行为预测](https://www.datafountain.cn/competitions/482) <br> [图书推荐系统](https://www.datafountain.cn/competitions/542) |                  -<br>-<br> - <br> -<br> -                   |                2024.02<br>- <br> -<br> -<br>-                |
|   问答   | [疫情政务问答助手](https://www.datafountain.cn/competitions/424) <br> [医疗智能问答 - FlyAI](https://www.flyai.com/d/305) <br> [2021心理对话问答挑战赛](https://www.flyai.com/d/319) <br>  [CommonsenseQA Dataset](https://www.biendata.xyz/competition/commonsense_qa/) <br> [OpenBookQA Dataset](https://www.biendata.xyz/competition/open_book_qa/) |                 - <br> - <br> - <br> -<br>-                  |        -  <br> -<br> - <br> 2026.4.15 <br> 2026.4.15         |
| 语义解析 | [千言数据集：语义解析](https://aistudio.baidu.com/aistudio/competition/detail/47) |                              -                               |                            2023.1                            |
|   摘要   | [媒体文章自动摘要](https://god.yanxishe.com/105) <br /> [知乎文本摘要](https://god.yanxishe.com/72?from=god_home_list) <br /> [新闻摘要自动生成](https://www.datafountain.cn/competitions/541) <br /> [问答摘要与推理](https://aistudio.baidu.com/aistudio/competition/detail/80/0/introduction) （end: 2023.1） |                              -                               |                              -                               |
|   语音   |     [生活场景汉语语音识别](https://www.flyai.com/d/203)      |                              -                               |                              -                               |
| 信息抽取 | [CCKS2021中文NLP地址要素解析](https://tianchi.aliyun.com/competition/entrance/531900/introduction) <br>[CCF BDCI 文本实体识别及关系抽取](https://www.datafountain.cn/competitions/371) <br /> [千言数据集：信息抽取](https://aistudio.baidu.com/aistudio/competition/detail/46/?isFromLUGE=TRUE) <br /> [英文文本实体关系抽取](https://god.yanxishe.com/92?from=god_home_list) <br /> [法律领域篇章级多事件检测](https://www.datafountain.cn/competitions/540) |                  -<br>-<br /> -<br> -<br> -                  |           2024.02<br>-<br /> 2023.1.1<br> -<br> -            |
| 实体链指 | [千言数据集：实体链指](https://aistudio.baidu.com/aistudio/competition/detail/83/?isFromLUGE=TRUE) |                              -                               |                           2023.1.1                           |
| 机器翻译 | [千言数据集：低资源语言翻译](https://aistudio.baidu.com/aistudio/competition/detail/84/?isFromLUGE=TRUE) <br /> [机器翻译领域适应](https://www.datafountain.cn/competitions/543) |                           -<br> -                            |                        2023.1.1<br> -                        |
| 实体识别 |  [中文的命名实体识别 - FlyAI](https://www.flyai.com/d/174)   |                              -                               |                              -                               |
| 关系抽取 | [英文文本实体关系抽取](https://god.yanxishe.com/82) （有数据） |                            已结束                            |                            已结束                            |
| 立场检测 | [中文微博的立场检测 - FlyAI](https://www.flyai.com/d/187) <br /> [微博立场检测](https://god.yanxishe.com/52?from=god_home_list) |                           -<br> -                            |                           -<br> -                            |
|   对话   | [MuTual Dataset](https://www.biendata.xyz/competition/mutual/) <br /> [千言数据集：开放域对话](https://aistudio.baidu.com/aistudio/competition/detail/48/?isFromLUGE=TRUE) <br /> [对话系统中的口语理解](https://god.yanxishe.com/76?from=god_home_list) |                       -<br /> -<br> -                        |                 2026.4.15<br> 2023.1.1<br> -                 |
| Text2SQL |         [耶鲁文本转SQL](https://www.flyai.com/d/302)         |                              -                               |                              -                               |
| 阅读理解 | [千言数据集：阅读理解](https://aistudio.baidu.com/aistudio/competition/detail/49/?isFromLUGE=TRUE) <br>  [中文阅读理解练习赛 - FlyAI](https://www.flyai.com/d/161) <br> [RACE Dataset](https://www.biendata.xyz/competition/race/) <br> [RACE-C Dataset](https://www.biendata.xyz/competition/race_c/) <br>  [Dream Dataset](https://www.biendata.xyz/competition/dream/) <br> [C3 Dataset](https://www.biendata.xyz/competition/c3/) <br> [SciQ Dataset](https://www.biendata.xyz/competition/sciq/) <br> [LogiQA Dataset](https://www.biendata.xyz/competition/logiqa/) <br> [MCTest Dataset](https://www.biendata.xyz/competition/mctest/) <br />[OpenBookQA Dataset](https://www.biendata.xyz/competition/open_book_qa/) |   -<br> -<br> -<br> -<br>-<br> -<br> -<br> -<br> -<br />-    | 2023.1.1<br> - <br> 2026.4.15 <br> 2026.4.15 <br>2026.4.15 <br>2026.4.15 <br>2026.4.15 <br>2026.4.15 <br>2026.4.15<br />2026.4.15 |
|  Graph   | [HGB-Node Classification](https://www.biendata.xyz/competition/hgb-1/) <br /> [HGB-Link Prediction](https://www.biendata.xyz/competition/hgb-2/) <br /> [HGB-Knowledge-aware Recommendation](https://www.biendata.xyz/competition/hgb-3/) |                          2021.6.28-                          |                            2030.6                            |
|   其它   |  [评论情感词提取](https://god.yanxishe.com/103) （含数据）   |                            已结束                            |                            已结束                            |

## 往期竞赛

> 这里记录整理好的竞赛，包含数据下载以及竞赛方案

| 目录     | 赛事                                                         |
| -------- | ------------------------------------------------------------ |
| 文本分类 | [2018法研杯-罪名预测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2018%E6%B3%95%E7%A0%94%E6%9D%AF-%E7%BD%AA%E5%90%8D%E9%A2%84%E6%B5%8B.md) <br /> [2018法研杯-法条推荐](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2018%E6%B3%95%E7%A0%94%E6%9D%AF-%E6%B3%95%E6%9D%A1%E6%8E%A8%E8%8D%90.md) <br /> [2019法研杯-要素识别](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2019%E6%B3%95%E7%A0%94%E6%9D%AF-%E8%A6%81%E7%B4%A0%E8%AF%86%E5%88%AB.md) <br /> [2019CHIP-临床试验筛选标准短文本分类](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2019CHIP-%E4%B8%B4%E5%BA%8A%E8%AF%95%E9%AA%8C%E7%AD%9B%E9%80%89%E6%A0%87%E5%87%86%E7%9F%AD%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB.md) <br> [2019“技术需求”与“技术成果”项目之间关联度计算模型](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2019%E2%80%9C%E6%8A%80%E6%9C%AF%E9%9C%80%E6%B1%82%E2%80%9D%E4%B8%8E%E2%80%9C%E6%8A%80%E6%9C%AF%E6%88%90%E6%9E%9C%E2%80%9D%E9%A1%B9%E7%9B%AE%E4%B9%8B%E9%97%B4%E5%85%B3%E8%81%94%E5%BA%A6%E8%AE%A1%E7%AE%97%E6%A8%A1%E5%9E%8B.md) <br> [2020smp微博情绪分析评测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2020smp%E5%BE%AE%E5%8D%9A%E6%83%85%E7%BB%AA%E5%88%86%E6%9E%90%E8%AF%84%E6%B5%8B%EF%BC%88EWECT%EF%BC%89.md) <br> [2020百度人工智能开源大赛-观点阅读理解任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2020%E7%99%BE%E5%BA%A6%E4%BA%BA%E5%B7%A5%E6%99%BA%E8%83%BD%E5%BC%80%E6%BA%90%E5%A4%A7%E8%B5%9B-%E8%A7%82%E7%82%B9%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3%E4%BB%BB%E5%8A%A1.md) <br> [2020CCKS新冠知识图谱构建与问答评测-子任务1：新冠百科知识图谱类型推断](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2020CCKS%E6%96%B0%E5%86%A0%E7%9F%A5%E8%AF%86%E5%9B%BE%E8%B0%B1%E6%9E%84%E5%BB%BA%E4%B8%8E%E9%97%AE%E7%AD%94%E8%AF%84%E6%B5%8B-%E5%AD%90%E4%BB%BB%E5%8A%A11%EF%BC%9A%E6%96%B0%E5%86%A0%E7%99%BE%E7%A7%91%E7%9F%A5%E8%AF%86%E5%9B%BE%E8%B0%B1%E7%B1%BB%E5%9E%8B%E6%8E%A8%E6%96%AD.md) <br /> [2020CCKS新冠知识图谱构建与问答评测-子任务2：新冠概念图谱的上下位关系预测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2020CCKS%E6%96%B0%E5%86%A0%E7%9F%A5%E8%AF%86%E5%9B%BE%E8%B0%B1%E6%9E%84%E5%BB%BA%E4%B8%8E%E9%97%AE%E7%AD%94%E8%AF%84%E6%B5%8B-%E5%AD%90%E4%BB%BB%E5%8A%A12%EF%BC%9A%E6%96%B0%E5%86%A0%E6%A6%82%E5%BF%B5%E5%9B%BE%E8%B0%B1%E7%9A%84%E4%B8%8A%E4%B8%8B%E4%BD%8D%E5%85%B3%E7%B3%BB%E9%A2%84%E6%B5%8B.md) <br/> [2021SMP-ECISA中文隐式情感分析评测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2021SMP-ECISA%E4%B8%AD%E6%96%87%E9%9A%90%E5%BC%8F%E6%83%85%E6%84%9F%E5%88%86%E6%9E%90.md) <br /> [2021DIGIX-基于多模型迁移预训练文章质量判别](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2021DIGIX-%E5%9F%BA%E4%BA%8E%E5%A4%9A%E6%A8%A1%E5%9E%8B%E8%BF%81%E7%A7%BB%E9%A2%84%E8%AE%AD%E7%BB%83%E6%96%87%E7%AB%A0%E8%B4%A8%E9%87%8F%E5%88%A4%E5%88%AB.md) <br /> [2021试题标签预测挑战赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2021%E8%AF%95%E9%A2%98%E6%A0%87%E7%AD%BE%E9%A2%84%E6%B5%8B%E6%8C%91%E6%88%98%E8%B5%9B.md) <br /> [2021非标准化疾病诉求的简单分诊挑战赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2021%E9%9D%9E%E6%A0%87%E5%87%86%E5%8C%96%E7%96%BE%E7%97%85%E8%AF%89%E6%B1%82%E7%9A%84%E7%AE%80%E5%8D%95%E5%88%86%E8%AF%8A%E6%8C%91%E6%88%98%E8%B5%9B.md) <br /> [2021CHIP-医学对话临床发现阴阳性判别任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2021CHIP-%E5%8C%BB%E5%AD%A6%E5%AF%B9%E8%AF%9D%E4%B8%B4%E5%BA%8A%E5%8F%91%E7%8E%B0%E9%98%B4%E9%98%B3%E6%80%A7%E5%88%A4%E5%88%AB%E4%BB%BB%E5%8A%A1.md) <br /> [2021CCL-中文空间语义理解评测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2021CCL-%E4%B8%AD%E6%96%87%E7%A9%BA%E9%97%B4%E8%AF%AD%E4%B9%89%E7%90%86%E8%A7%A3%E8%AF%84%E6%B5%8B.md) <br /> [2021CCL-“小牛杯”图文多模态幽默识别评测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2021CCL-%E2%80%9C%E5%B0%8F%E7%89%9B%E6%9D%AF%E2%80%9D%E5%9B%BE%E6%96%87%E5%A4%9A%E6%A8%A1%E6%80%81%E5%B9%BD%E9%BB%98%E8%AF%86%E5%88%AB%E8%AF%84%E6%B5%8B.md) <br />[2022疫情微博情绪识别挑战赛](./往期竞赛/文本分类/2022疫情微博情绪识别挑战赛.md) <br />[2022非标准化疾病诉求的简单分诊挑战赛2.0](./往期竞赛/文本分类/2022非标准化疾病诉求的简单分诊挑战赛2.0.md) <br />[2022机器翻译质量评估挑战赛](./往期竞赛/文本分类/2022机器翻译质量评估挑战赛.md) <br />[2022基于论文摘要的文本分类与查询性问答](./往期竞赛/文本分类/2022基于论文摘要的文本分类与查询性问答.md) <br />[2022应用类型识别挑战赛](./往期竞赛/文本分类/2022应用类型识别挑战赛.md) <br /> [2022 Amazon KDD Cup (task2 Multi-class Product Classification, task3 Product Substitute Identification)](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%88%86%E7%B1%BB/2022%20Amazon%20KDD%20Cup%20(task2%20Multi-class%20Product%20Classification%2C%20task3%20Product%20Substitute%20Identification).md) <br>[2022医疗搜索意图识别挑战赛](./往期竞赛/文本分类/2022医疗搜索意图识别挑战赛.md) <br />[2022CCF BDCI小样本数据分类任务](./往期竞赛/文本分类/2022CCF BDCI小样本数据分类任务.md) <br />[2023CCL电信网络诈骗案件分类评测](./往期竞赛/文本分类/2023CCL电信网络诈骗案件分类评测.md) |
| 实体链指 | [2019CCKS中文短文本实体链指](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E9%93%BE%E6%8C%87/ccks2019%E4%B8%AD%E6%96%87%E7%9F%AD%E6%96%87%E6%9C%AC%E5%AE%9E%E4%BD%93%E9%93%BE%E6%8C%87.md) <br> [2020CCKS面向中文短文本的实体链指任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E9%93%BE%E6%8C%87/2020ccks%E9%9D%A2%E5%90%91%E4%B8%AD%E6%96%87%E7%9F%AD%E6%96%87%E6%9C%AC%E7%9A%84%E5%AE%9E%E4%BD%93%E9%93%BE%E6%8C%87%E4%BB%BB%E5%8A%A1.md) <br> [2020CCKS基于标题的大规模商品实体检索](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E9%93%BE%E6%8C%87/2020ccks%E5%9F%BA%E4%BA%8E%E6%A0%87%E9%A2%98%E7%9A%84%E5%A4%A7%E8%A7%84%E6%A8%A1%E5%95%86%E5%93%81%E5%AE%9E%E4%BD%93%E6%A3%80%E7%B4%A2.md) <br> [2020千言数据集：面向中文短文本的实体链指任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E9%93%BE%E6%8C%87/2020%E5%8D%83%E8%A8%80%E6%95%B0%E6%8D%AE%E9%9B%86%EF%BC%9A%E9%9D%A2%E5%90%91%E4%B8%AD%E6%96%87%E7%9F%AD%E6%96%87%E6%9C%AC%E7%9A%84%E5%AE%9E%E4%BD%93%E9%93%BE%E6%8C%87%E4%BB%BB%E5%8A%A1.md) <br /> 2021SDU@AAAI-Task2-Acronym Disambiguation |
| 实体识别 | [2019互联网金融新实体发现](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB/2019%E4%BA%92%E8%81%94%E7%BD%91%E9%87%91%E8%9E%8D%E6%96%B0%E5%AE%9E%E4%BD%93%E5%8F%91%E7%8E%B0.md) <br> [2020CHIP-中药说明书实体识别挑战](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB/2020%E4%B8%AD%E8%8D%AF%E8%AF%B4%E6%98%8E%E4%B9%A6%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB%E6%8C%91%E6%88%98.md) <br> [2020CHIP-中文医学文本命名实体识别](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB/2020%E4%B8%AD%E6%96%87%E5%8C%BB%E5%AD%A6%E6%96%87%E6%9C%AC%E5%91%BD%E5%90%8D%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB.md) <br> [2020CCKS面向试验鉴定的命名实体识别](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB/2020CCKS%E9%9D%A2%E5%90%91%E8%AF%95%E9%AA%8C%E9%89%B4%E5%AE%9A%E7%9A%84%E5%91%BD%E5%90%8D%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB.md) <br> [2020CCKS面向中文电子病历的医疗实体及事件抽取-子任务1：医疗命名实体识别](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB/2020CCKS%E9%9D%A2%E5%90%91%E4%B8%AD%E6%96%87%E7%94%B5%E5%AD%90%E7%97%85%E5%8E%86%E7%9A%84%E5%8C%BB%E7%96%97%E5%AE%9E%E4%BD%93%E5%8F%8A%E4%BA%8B%E4%BB%B6%E6%8A%BD%E5%8F%96-%E5%AD%90%E4%BB%BB%E5%8A%A1%E4%B8%80%EF%BC%9A%E5%8C%BB%E7%96%97%E5%90%8D%E9%97%A8%E5%AE%9E%E4%BD%93%E8%AF%86%E5%88%AB.md) <br> 2021智能医疗决策 <br> 2021互联网舆情企业风险事件的识别和预警 <br> 2021海通&工商-2021互联网舆情企业风险事件的识别和预警 |
| 问题生成 | [2020CHIP-中医文献问题生成挑战](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E9%97%AE%E9%A2%98%E7%94%9F%E6%88%90/2020%E4%B8%AD%E5%8C%BB%E6%96%87%E7%8C%AE%E9%97%AE%E9%A2%98%E7%94%9F%E6%88%90%E6%8C%91%E6%88%98.md) |
| 摘要生成 | [2020法研杯-司法摘要](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%91%98%E8%A6%81%E7%94%9F%E6%88%90/2020%E6%B3%95%E7%A0%94%E6%9D%AF-%E5%8F%B8%E6%B3%95%E6%91%98%E8%A6%81.md) <br />2021MEDIQA-Summarization of Consumer Health Questions <br> 2021MEDIQA-Summarization of Multiple Answers <br> 2021MEDIQA-Summarization of Radiology Reports |
| 句法分析 | [2021CCL-跨领域句法分析评测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%8F%A5%E6%B3%95%E5%88%86%E6%9E%90/2021CCL-%E8%B7%A8%E9%A2%86%E5%9F%9F%E5%8F%A5%E6%B3%95%E5%88%86%E6%9E%90%E8%AF%84%E6%B5%8B.md) <br /> [2021CCL-中译语通-Nihao无监督汉语分词评测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%8F%A5%E6%B3%95%E5%88%86%E6%9E%90/2021CCL-%E4%B8%AD%E8%AF%91%E8%AF%AD%E9%80%9A-Nihao%E6%97%A0%E7%9B%91%E7%9D%A3%E6%B1%89%E8%AF%AD%E5%88%86%E8%AF%8D%E8%AF%84%E6%B5%8B.md) |
| 阅读理解 | [2018机器阅读理解技术竞赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3/2018%E6%9C%BA%E5%99%A8%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3%E6%8A%80%E6%9C%AF%E7%AB%9E%E8%B5%9B.md) <br/> [2019法研杯-阅读理解](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3/2019%E6%B3%95%E7%A0%94%E6%9D%AF-%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3.md) <br /> [2020法研杯-阅读理解](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3/2020%E6%B3%95%E7%A0%94%E6%9D%AF-%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3.md) <br /> [2020语言与智能技术竞赛：机器阅读理解任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3/2020%E8%AF%AD%E8%A8%80%E4%B8%8E%E6%99%BA%E8%83%BD%E6%8A%80%E6%9C%AF%E7%AB%9E%E8%B5%9B%EF%BC%9A%E6%9C%BA%E5%99%A8%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3%E4%BB%BB%E5%8A%A1.md) <br> [2021海华AI挑战赛·中文阅读理解（技术组）](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3/2021%E6%B5%B7%E5%8D%8EAI%E6%8C%91%E6%88%98%E8%B5%9B%C2%B7%E4%B8%AD%E6%96%87%E9%98%85%E8%AF%BB%E7%90%86%E8%A7%A3%EF%BC%88%E6%8A%80%E6%9C%AF%E7%BB%84%EF%BC%89.md) <br> 2021语言与智能技术竞赛：机器阅读理解任务 <br /> 2021NLPCC-AIDebater |
| 文本匹配 | [2019大数据挑战赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2019%E5%A4%A7%E6%95%B0%E6%8D%AE%E6%8C%91%E6%88%98%E8%B5%9B.md) <br> [2019金融信息负面及主体判定](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2019%E9%87%91%E8%9E%8D%E4%BF%A1%E6%81%AF%E8%B4%9F%E9%9D%A2%E5%8F%8A%E4%B8%BB%E4%BD%93%E5%88%A4%E5%AE%9A%20.md) <br> [2019CHIP-疾病问答迁移学习比赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2019CHIP-%E7%96%BE%E7%97%85%E9%97%AE%E7%AD%94%E8%BF%81%E7%A7%BB%E5%AD%A6%E4%B9%A0%E6%AF%94%E8%B5%9B.md) <br /> [2019CHIP-临床术语标准化任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2019CHIP-%E4%B8%B4%E5%BA%8A%E6%9C%AF%E8%AF%AD%E6%A0%87%E5%87%86%E5%8C%96%E4%BB%BB%E5%8A%A1.md) <br /> [2019法研杯-相似案例匹配](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2019%E6%B3%95%E7%A0%94%E6%9D%AF-%E7%9B%B8%E4%BC%BC%E6%A1%88%E4%BE%8B%E5%8C%B9%E9%85%8D.md) <br /> [2020“公益AI之星”挑战赛-新冠疫情相似句对判定大赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2020%E2%80%9C%E5%85%AC%E7%9B%8AAI%E4%B9%8B%E6%98%9F%E2%80%9D%E6%8C%91%E6%88%98%E8%B5%9B-%E6%96%B0%E5%86%A0%E7%96%AB%E6%83%85%E7%9B%B8%E4%BC%BC%E5%8F%A5%E5%AF%B9%E5%88%A4%E5%AE%9A%E5%A4%A7%E8%B5%9B.md) <br> [2020房产行业聊天匹配问答](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2020%E6%88%BF%E4%BA%A7%E8%A1%8C%E4%B8%9A%E8%81%8A%E5%A4%A9%E5%8C%B9%E9%85%8D%E9%97%AE%E7%AD%94.md) <br> [2020CHIP-临床术语标准化任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2020CHIP-%E4%B8%B4%E5%BA%8A%E5%8C%BB%E5%AD%A6%E6%9C%AF%E8%AF%AD%E6%A0%87%E5%87%86%E5%8C%96%E4%BB%BB%E5%8A%A1.md) <br /> [2020法研杯-论辩挖掘](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2020%E6%B3%95%E7%A0%94%E6%9D%AF-%E8%AE%BA%E8%BE%A9%E6%8C%96%E6%8E%98.md) <br /> [2021搜狐校园文本匹配算法大赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2021%E6%90%9C%E7%8B%90%E6%A0%A1%E5%9B%AD%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D%E7%AE%97%E6%B3%95%E5%A4%A7%E8%B5%9B.md) <br> [2021小布助手对话短文本语义匹配](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2021%E5%B0%8F%E5%B8%83%E5%8A%A9%E6%89%8B%E5%AF%B9%E8%AF%9D%E7%9F%AD%E6%96%87%E6%9C%AC%E8%AF%AD%E4%B9%89%E5%8C%B9%E9%85%8D.md) <br /> [2021CHIP-临床术语标准化任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%96%87%E6%9C%AC%E5%8C%B9%E9%85%8D/2021CHIP-%E4%B8%B4%E5%BA%8A%E6%9C%AF%E8%AF%AD%E6%A0%87%E5%87%86%E5%8C%96%E4%BB%BB%E5%8A%A1.md) |
| 对话     | 2019SMP中文人机对话技术评测 <br> [2020千言：多技能对话](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AF%B9%E8%AF%9D%E7%94%9F%E6%88%90/2020%E5%8D%83%E8%A8%80%EF%BC%9A%E5%A4%9A%E6%8A%80%E8%83%BD%E5%AF%B9%E8%AF%9D.md) <br> [2020语言与智能技术竞赛：面向推荐的对话任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AF%B9%E8%AF%9D%E7%94%9F%E6%88%90/2020%E8%AF%AD%E8%A8%80%E4%B8%8E%E6%99%BA%E8%83%BD%E6%8A%80%E6%9C%AF%E7%AB%9E%E8%B5%9B%EF%BC%9A%E9%9D%A2%E5%90%91%E6%8E%A8%E8%8D%90%E7%9A%84%E5%AF%B9%E8%AF%9D%E4%BB%BB%E5%8A%A1.md) <br> 2021SMP对话式AI算法技术评测（小样本对话式意图识别与槽位提取、对话式指代消解与省略恢复 ）<br>[2021CCL-智能对话诊疗评测比赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%AF%B9%E8%AF%9D/2021CCL-%E6%99%BA%E8%83%BD%E5%AF%B9%E8%AF%9D%E8%AF%8A%E7%96%97%E8%AF%84%E6%B5%8B%E6%AF%94%E8%B5%9B.md) <br />2021DSTC10 |
| Text2SQL | [2019中文NL2SQL挑战赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/Text2SQL/2019%E4%B8%AD%E6%96%87NL2SQL%E6%8C%91%E6%88%98%E8%B5%9B.md) <br/> [2020语言与智能技术竞赛：语义解析任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/Text2SQL/2020%E8%AF%AD%E8%A8%80%E4%B8%8E%E6%99%BA%E8%83%BD%E6%8A%80%E6%9C%AF%E7%AB%9E%E8%B5%9B%EF%BC%9A%E8%AF%AD%E4%B9%89%E8%A7%A3%E6%9E%90%E4%BB%BB%E5%8A%A1.md) |
| 问答     | [2020CCKS新冠知识图谱构建与问答评测-子任务4：新冠百科知识图谱问答评测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E9%97%AE%E7%AD%94/2020CCKS%E6%96%B0%E5%86%A0%E7%9F%A5%E8%AF%86%E5%9B%BE%E8%B0%B1%E6%9E%84%E5%BB%BA%E4%B8%8E%E9%97%AE%E7%AD%94%E8%AF%84%E6%B5%8B-%E5%AD%90%E4%BB%BB%E5%8A%A14%EF%BC%9A%E6%96%B0%E5%86%A0%E7%99%BE%E7%A7%91%E7%9F%A5%E8%AF%86%E5%9B%BE%E8%B0%B1%E9%97%AE%E7%AD%94%E8%AF%84%E6%B5%8B.md) <br /> [2020法研杯-司法考试](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E9%97%AE%E7%AD%94/2020%E6%B3%95%E7%A0%94%E6%9D%AF-%E5%8F%B8%E6%B3%95%E8%80%83%E8%AF%95.md) |
| 信息抽取 | [2020科大讯飞事件抽取挑战赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2020%E7%A7%91%E5%A4%A7%E8%AE%AF%E9%A3%9E%E4%BA%8B%E4%BB%B6%E6%8A%BD%E5%8F%96%E6%8C%91%E6%88%98%E8%B5%9B.md) <br> [2020语言与智能技术竞赛：关系抽取任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2020%E8%AF%AD%E8%A8%80%E4%B8%8E%E6%99%BA%E8%83%BD%E6%8A%80%E6%9C%AF%E7%AB%9E%E8%B5%9B%EF%BC%9A%E5%85%B3%E7%B3%BB%E6%8A%BD%E5%8F%96%E4%BB%BB%E5%8A%A1.md) <br> [2020语言与智能技术竞赛：事件抽取任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2020%E8%AF%AD%E8%A8%80%E4%B8%8E%E6%99%BA%E8%83%BD%E6%8A%80%E6%9C%AF%E7%AB%9E%E8%B5%9B%EF%BC%9A%E4%BA%8B%E4%BB%B6%E6%8A%BD%E5%8F%96%E4%BB%BB%E5%8A%A1.md) <br> [2020-SemEval Task 6: Definition Extraction from Free Text with the DEFT Corpus](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2020-SemEval%20Task%206%20Definition%20Extraction%20from%20Free%20Text%20with%20the%20DEFT%20Corpus.md) <br> [2020CCKS面向中文电子病历的医疗实体及事件抽取-子任务2：医疗事件抽取](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2020CCKS%E9%9D%A2%E5%90%91%E4%B8%AD%E6%96%87%E7%94%B5%E5%AD%90%E7%97%85%E5%8E%86%E7%9A%84%E5%8C%BB%E7%96%97%E5%AE%9E%E4%BD%93%E5%8F%8A%E4%BA%8B%E4%BB%B6%E6%8A%BD%E5%8F%96-%E5%AD%90%E4%BB%BB%E5%8A%A12%EF%BC%9A%E5%8C%BB%E7%96%97%E4%BA%8B%E4%BB%B6%E6%8A%BD%E5%8F%96.md) <br> [2020CCKS面向金融领域的小样本跨类迁移事件抽取](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2020CCKS%E9%9D%A2%E5%90%91%E9%87%91%E8%9E%8D%E9%A2%86%E5%9F%9F%E7%9A%84%E5%B0%8F%E6%A0%B7%E6%9C%AC%E8%B7%A8%E7%B1%BB%E8%BF%81%E7%A7%BB%E4%BA%8B%E4%BB%B6%E6%8A%BD%E5%8F%96.md) <br> [2020CCKS面向金融领域的篇章级事件主体与要素抽取](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2020CCKS%E9%9D%A2%E5%90%91%E9%87%91%E8%9E%8D%E9%A2%86%E5%9F%9F%E7%9A%84%E7%AF%87%E7%AB%A0%E7%BA%A7%E4%BA%8B%E4%BB%B6%E4%B8%BB%E4%BD%93%E4%B8%8E%E8%A6%81%E7%B4%A0%E6%8A%BD%E5%8F%96.md) <br> [2020CHIP-中文医学文本实体关系抽取](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2020CHIP-%E4%B8%AD%E6%96%87%E5%8C%BB%E5%AD%A6%E6%96%87%E6%9C%AC%E5%AE%9E%E4%BD%93%E5%85%B3%E7%B3%BB%E6%8A%BD%E5%8F%96.md) <br /> 2021语言与智能技术竞赛：多形态信息抽取任务 <br /> [2021医疗实体与关系识别挑战赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2021%E5%8C%BB%E7%96%97%E5%AE%9E%E4%BD%93%E4%B8%8E%E5%85%B3%E7%B3%BB%E8%AF%86%E5%88%AB%E6%8C%91%E6%88%98%E8%B5%9B.md) <br /> 2021NLPCC-AutoIE 2 <br /> [2021CHIP-临床发现事件抽取任务](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E4%BF%A1%E6%81%AF%E6%8A%BD%E5%8F%96/2021CHIP-%E4%B8%B4%E5%BA%8A%E5%8F%91%E7%8E%B0%E4%BA%8B%E4%BB%B6%E6%8A%BD%E5%8F%96%E4%BB%BB%E5%8A%A1.md) <br /> 2021SDU@AAAI-Task1-Acronym Identification |
| 机器翻译 | [2020CCMT-双语、多语、语音、质量评估、语料过滤](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%9C%BA%E5%99%A8%E7%BF%BB%E8%AF%91/2020CCMT-%E5%8F%8C%E8%AF%AD%E3%80%81%E5%A4%9A%E8%AF%AD%E3%80%81%E8%AF%AD%E9%9F%B3%E3%80%81%E8%B4%A8%E9%87%8F%E8%AF%84%E4%BC%B0%E3%80%81%E8%AF%AD%E6%96%99%E8%BF%87%E6%BB%A4.md) <br> [2021NAACL同传Workshop：千言 - 机器同传](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%9C%BA%E5%99%A8%E7%BF%BB%E8%AF%91/2021NAACL%E5%90%8C%E4%BC%A0Workshop%EF%BC%9A%E5%8D%83%E8%A8%80%20-%20%E6%9C%BA%E5%99%A8%E5%90%8C%E4%BC%A0.md) <br> [2021低资源多语种文本翻译挑战赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%9C%BA%E5%99%A8%E7%BF%BB%E8%AF%91/2021%E4%BD%8E%E8%B5%84%E6%BA%90%E5%A4%9A%E8%AF%AD%E7%A7%8D%E6%96%87%E6%9C%AC%E7%BF%BB%E8%AF%91%E6%8C%91%E6%88%98%E8%B5%9B.md) <br> [2021领域迁移机器翻译挑战赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%9C%BA%E5%99%A8%E7%BF%BB%E8%AF%91/2021%E9%A2%86%E5%9F%9F%E8%BF%81%E7%A7%BB%E6%9C%BA%E5%99%A8%E7%BF%BB%E8%AF%91%E6%8C%91%E6%88%98%E8%B5%9B.md) <br /> [2021CCMT-双语、多语、低资源、自动译后编辑、质量评估、语料过滤](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E6%9C%BA%E5%99%A8%E7%BF%BB%E8%AF%91/2021CCMT-%E5%8F%8C%E8%AF%AD%E3%80%81%E5%A4%9A%E8%AF%AD%E3%80%81%E4%BD%8E%E8%B5%84%E6%BA%90%E3%80%81%E8%87%AA%E5%8A%A8%E8%AF%91%E5%90%8E%E7%BC%96%E8%BE%91%E3%80%81%E8%B4%A8%E9%87%8F%E8%AF%84%E4%BC%B0%E3%80%81%E8%AF%AD%E6%96%99%E8%BF%87%E6%BB%A4.md) |
| 其它     | [2018法研杯-刑期预测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%85%B6%E5%AE%83/2018%E6%B3%95%E7%A0%94%E6%9D%AF-%E5%88%91%E6%9C%9F%E9%A2%84%E6%B5%8B.md) <br />[2020NLP中文预训练模型泛化能力挑战赛](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%85%B6%E5%AE%83/2020NLP%E4%B8%AD%E6%96%87%E9%A2%84%E8%AE%AD%E7%BB%83%E6%A8%A1%E5%9E%8B%E6%B3%9B%E5%8C%96%E8%83%BD%E5%8A%9B%E6%8C%91%E6%88%98%E8%B5%9B.md) <br>[2020CCKS新冠知识图谱构建与问答评测-子任务3：新冠科研抗病毒药物图谱的链接预测](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%85%B6%E5%AE%83/2020CCKS%E6%96%B0%E5%86%A0%E7%9F%A5%E8%AF%86%E5%9B%BE%E8%B0%B1%E6%9E%84%E5%BB%BA%E4%B8%8E%E9%97%AE%E7%AD%94%E8%AF%84%E6%B5%8B-%E5%AD%90%E4%BB%BB%E5%8A%A13%EF%BC%9A%E6%96%B0%E5%86%A0%E7%A7%91%E7%A0%94%E6%8A%97%E7%97%85%E6%AF%92%E8%8D%AF%E7%89%A9%E5%9B%BE%E8%B0%B1%E7%9A%84%E9%93%BE%E6%8E%A5%E9%A2%84%E6%B5%8B.md) <br />2021未来杯-探索科技未来 (论文推荐) <br />[2021NLPCC-FewCLUE](https://github.com/TingFree/NLPer-Arsenal/blob/master/%E5%BE%80%E6%9C%9F%E7%AB%9E%E8%B5%9B/%E5%85%B6%E5%AE%83/2021NLPCC-FewCLUE.md) |

## 自媒体推荐  

> NLP相关的学界、业界、理论、实践以及时事动态

| 平台       | 主要领域 | 自媒体                                                       |
| ---------- | -------- | ------------------------------------------------------------ |
| 微信公众号 | 技术     | Coggle数据科学、DataFunTalk（偏向业界方案）                  |
|            | 行业信息 | 机器之心、机器之能、AI报道、AI前线、AI科技评论、机器学习研究组订阅 |
|            | 学术     | 科学空间、PaperWeekly、智源社区、人工智能前沿讲习、专知、AINLP、AI TIME 论道、夕小瑶的卖萌屋、机器学习算法与自然语言处理（MLNLP） |
| BiliBili   | 前沿论坛 | 智源社区、AITIME论道                                         |
|            | 基础     | 跟李沐学AI                                                   |
| 网站       | 竞赛     | [Coggle数据科学](https://coggle.club/) 、[CompHub](https://comphub.notion.site/comphub/CompHub-c353e310c8f84846ace87a13221637e8) |
|            | 学术     | [Paper With Code](https://paperswithcode.com/) 、[AMiner学术头条](https://www.aminer.cn/) 、[科学空间](https://kexue.fm/) |

## 算力推荐

> warning: 请仔细评估第三方平台信誉，警惕代码、数据等重要信息泄露

|                             平台                             |             算力             |               价格               |                             说明                             |
| :----------------------------------------------------------: | :--------------------------: | :------------------------------: | :----------------------------------------------------------: |
|              [featurize](https://featurize.cn/)              |         2080Ti、3090         | 2080Ti（￥2/h）、3090（￥3.6/h） | 镜像环境，使用灵活，可以通过jupyter_lab、vscode、pycharm远程连接 |
|            [AutoDL](https://www.autodl.com/home)             |    rtx a5000、3090、A100     |         ￥0.6/h~￥8.5/h          |            单机ssh连接，存储空间不大，不过很便宜             |
|              [智星云](http://www.ai-galaxy.cn/)              | 1080Ti、3080、3090、V/A100等 |          ￥2.1/h~￥11/h          |             整机，可远程连接（pycharm/vs code）              |
|             [沣云平台](https://www.fenghub.com/)             |            ML270             |             ￥2.8/h              |    一站式AI计算平台，CPU可以增量配置，按运行时间收取费用     |
|               [恒源云](https://gpushare.com/)                |  2080Ti、3060、3090、V100等  |         ￥1.25/h~￥5.5/h         | 可以搭配完整的CPU和硬盘，相比bithub有更高的自由度，目前处于推广期，有很多优惠 |
|        [并行云](https://www.paratera.com/index.html)         |     V100、2080Ti、P100等     |               不明               | 计算节点来自超算，可个性化定制CPU核数、GPU、存储空间，有非常简便的操作界面，并且提供远程linux桌面，灵活度优于以上三个平台。目前处于推广期，有很多优惠 |
|    [AI Studio](https://aistudio.baidu.com/aistudio/index)    |             V100             |             基本免费             | 由百度开发, 偶尔申请不到V100，最高可免费8卡。主要使用飞桨PaddlePaddle框架，其它框架需自行折腾，也可用X2Paddle一键转为飞桨的代码和模型，大部分比赛参与即送算力卡。 |
|        [天池DSW](https://dsw-dev.data.aliyun.com/#/)         |             p100             |  免费，单次限时8小时，不限次数   |              阿里的一个在线平台，运行时不能关闭              |
|     [天池实验室](https://tianchi.aliyun.com/notebook-ai)     |             V100             |           免费，60h/年           |      相比于AI Studio不限制深度学习框架，就是时间比较短       |
| [Kaggle](https://www.kaggle.com/dansbecker/running-kaggle-kernels-with-a-gpu) |             k80              |       免费，每周限时30小时       |                           外网访问                           |
| [Google Colab](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=&ved=2ahUKEwjlws2zvLzvAhULPnAKHUKCAQAQFjAAegQIBhAD&url=https%3A%2F%2Fcolab.research.google.com%2F&usg=AOvVaw3A5aPK2kLFzKOzb6sOckVw) |      k80、T4、P4、P100       |       免费，单次限时12小时       | 外网访问，无法指定具体GPU，未订阅Colab Pro用户多数时间下估计会被分配k80 |

## 竞赛平台

* [CompHub](https://comphub.notion.site/comphub/CompHub-c353e310c8f84846ace87a13221637e8) ：一站式聚合国内外竞赛
* [阿里天池](https://tianchi.aliyun.com/competition/gameList/activeList) ：阿里，奖金丰厚
* [AI Studio](https://aistudio.baidu.com/aistudio/competition) ：百度AI Studio深度学习社区，成绩优异可获得[飞桨开发者技术专家(PPDE)](https://www.paddlepaddle.org.cn/ppde) 认证申请绿色通道。
* [讯飞开发平台](http://challenge.xfyun.cn/) ：科大讯飞，每年下半年至10.24会举办大量赛事
* [Codalab](https://codalab.lisn.upsaclay.fr/) ：国外数据科学竞赛
* [DataFountain](https://www.datafountain.cn/competitions) ： CCF指定专业大数据及人工智能竞赛平台，有很多训练赛  
* [DCLab](https://www.datacastle.cn/index.html) ：和天池比较像，学校政府举办的竞赛多一些
* [Kaggle](https://www.kaggle.com/competitions?tagIds=13204) ：偶尔会有NLP竞赛
* [biendata](https://www.biendata.xyz/competition/) ： 国内领先的人工智能竞赛平台，包含大量NLP学术评测  
* [FlyAI-AI竞赛服务平台](https://www.flyai.com/c/nlp) ：难度分为新手、简单、中等、精英、困难，有大量GPU算力可供获取，奖金不多，但适合练手  
* [和鲸社区](https://www.kesci.com/home/competition) ：一个综合的学习平台 ，偏向政府企业类竞赛
* ACL、EMNLP、AAAI、NLPCC、CCL、CCKS、SMP等会议每年都会举办相关学术评测  
* [AI研习社](https://god.yanxishe.com/) ：很多很多NLP竞赛

## 会议时间

> [中国计算机学会推荐国际学术会议和期刊目录-2022](https://www.ccf.org.cn/Academic_Evaluation/By_category/)  
> [中国计算机学会推荐中文科技期刊目录](https://www.ccf.org.cn/ccftjgjxskwml/)  
> [dblp](https://dblp.org)：计算机科学文献库  
> [AI会议deadline](https://aideadlin.es/?sub=ML,CV,NLP,RO,SP,DM) ：会议倒计时  
> [会议时间记录表](https://jackietseng.github.io/conference_call_for_paper/conferences.html) ：Updated by Jackie Tseng, Tsinghua Computer Vision and Intelligent Learning Lab  
> note：以下时间为官网默认时间，暂未换算成北京时间

|                             会议                             | 级别  |             摘要截稿             |                      原文截稿                       |                           审稿通知                           |       开会时间       |                      说明                      |
| :----------------------------------------------------------: | :---: | :------------------------------: | :-------------------------------------------------: | :----------------------------------------------------------: | :------------------: | :--------------------------------------------: |
| ICLR([官网](https://iclr.cc/)、[dblp](https://dblp.uni-trier.de/db/conf/iclr/index.html)) |   *   |            2023.9.21             |                      2023.9.28                      |             2023.11.10(review)、2024.1.15(final)             |    2024.5.7-5.11     |                     Vienna                     |
| ACL([官网](https://2023.aclweb.org/)、[dblp](http://dblp.uni-trier.de/db/conf/acl/)) | CCF-A | ~~2023.1.13(direct submission)~~ | ~~2023.1.20(direct submission)、2022.12.15（ARR）~~ |          ~~2023.2.15（review）、2023.5.1（final）~~          |  ~~2023.7.9-7.14~~   |                Toronto，Canada                 |
| NeurIPS([官网](https://neurips.cc/Conferences/2023/)、[dblp](http://dblp.uni-trier.de/db/conf/nips/)) | CCF-A |          ~~2023.5.11~~           |                    ~~2023.5.17~~                    |                          2023.9.21                           |   2023.12.10-12.16   | New Orleans Ernest N. Morial Convention Center |
| ICML([官网](https://icml.cc/Conferences/2024)、[dblp](https://dblp.uni-trier.de/db/conf/icml/index.html)) | CCF-A |                *                 |                          ?                          |                              ?                               |    2024.7.21-7.27    |     Messe Wien Exhibition Congress Center      |
| SIGIR([官网](https://sigir.org/sigir2023)、[dblp](https://dblp.uni-trier.de/db/conf/sigir/index.html)) | CCF-A |          ~~2023.1.24~~           |                    ~~2023.1.31~~                    |                         ~~2023.4.4~~                         |  ~~2023.7.23-7.27~~  |                 Taipei, Taiwan                 |
| WWW([官网](https://www2024.thewebconf.org/)、[dblp](https://dblp.uni-trier.de/db/conf/www/index.html)) | CCF-A |            2023.10.5             |                     2023.10.12                      |       2023.12.1-12.14（rebuttal）<br>2024.2.1（final）       |    2024.5.13-5.17    |                   Singapore                    |
| AAAI([官网](https://aaai.org/aaai-conference/)、[dblp](http://dblp.uni-trier.de/db/conf/aaai/)) | CCF-A |           ~~2023.8.8~~           |                    ~~2023.8.15~~                    |       2023.9.27(phase 1 rejections)、2023.12.19(final)       |    2024.2.20-2.27    |               VANCOUVER, CANADA                |
| IJCAI([官网](https://ijcai-23.org/)、[dblp](http://dblp.uni-trier.de/db/conf/ijcai/)) | CCF-A |          ~~2023.1.11~~           |                    ~~2023.1.18~~                    | ~~2023.2.24（summary reject notification）、2023.4.19（paper notification）~~ |  ~~2023.8.19-8.25~~  |            Cape Town, South Africa             |
| EMNLP([官网](https://2023.emnlp.org/)、[dblp](http://dblp.uni-trier.de/db/conf/emnlp/)) | CCF-B |          ~~2022.6.16~~           |        ~~2023.6.23(Direct)、2023.7.21(ARR)~~        |            2023.8.22~8.28（rebuttal）、2023.10.6             |   2023.12.6-12.10    |                   Singapore                    |
| NAACL([官网](https://2024.naacl.org/)、[dblp](http://dblp.uni-trier.de/db/conf/naacl/)) | CCF-B |                *                 |       2023.12.15(ARR)、2024.2.20(Commitment)        |                          2024.3.15                           |    2024.6.16-6.21    |              Mexico City, Mexico               |
| COLING([官网](https://coling2022.org/)、[dblp](http://dblp.uni-trier.de/db/conf/coling/)) | CCF-B |                *                 |                    ~~2022.5.17~~                    |                        ~~2022.8.15~~                         | ~~2022.10.12~10.17~~ |                Gyeongju, Korea                 |
| CoNLL([官网](https://www.conll.org/2023)、[dblp](http://dblp.uni-trier.de/db/conf/conll)) | CCF-C |                *                 |                    ~~2023.6.30~~                    |                          2023.10.6                           |    2023.12.6-12.7    |            colocated with emnlp2023            |
| NLPCC([官网](http://tcci.ccf.org.cn/conference/2023/)、[dblp](https://dblp.uni-trier.de/db/conf/nlpcc/)) | CCF-C |                *                 |                    ~~2023.5.18~~                    |                        ~~2023.7.17~~                         |   2023.10.12-10.15   |                      佛山                      |
| IJCNN([官网](https://2023.ijcnn.org/) 、[dblp](https://dblp.uni-trier.de/db/conf/ijcnn/index.html) ) | CCF-C |                *                 |                    ~~2023.1.31~~                    |                         ~~2023.4.7~~                         |  ~~2023.6.18-6.23~~  |             Queensland, Australia              |
|        ICONIP([官网](https://iconip2022.apnns.org/))         | CCF-C |                *                 |                    ~~2022.6.15~~                    |                        ~~2022.8.15~~                         | ~~2022.11.22~11.26~~ |                New Delhi, India                |
|         ACML([官网](http://www.acml-conf.org/2023/))         | CCF-C |                *                 |    ~~2023.6.23（会议）<br />2023.5.26（期刊）~~     | 2023.8.11-8.18（rebuttal）、9.8 (final)；<br />2023.7.7（初审）、9.8（final） |   2023.11.11-11.14   |                İstanbul, Turkey                |
|        AACL([官网](http://www.ijcnlp-aacl2023.org/))         |   *   |                *                 |  ~~2023.5.23(direct submission)、2023.8.15(ARR)~~   |              2023.8.2-8.9(rebuttal)、9.4(final)              |    2023.11.1-11.4    |                Bali, Indonesia                 |
| EACL([官网](https://eacl.org/)、[dblp](https://dblp.uni-trier.de/db/conf/eacl/)) |   *   |                *                 |  ~~2022.10.20(direct submission)、2023.1.8 (ARR)~~  |                        ~~2023.1.20~~                         |   ~~2023.5.2-5.6~~   |             Kiev, Ukraine、online              |
| CCL([官网](http://cips-cl.org/static/CCL2023/index.html)、[dblp](https://dblp.uni-trier.de/db/conf/cncl/)) |   *   |                *                 |                    ~~2023.4.15~~                    |                        ~~2023.5.20~~                         |   ~~2023.8.3-8.5~~   |                     哈尔滨                     |
| CCKS([官网](http://sigkg.cn/ccks2023/)、[dblp](https://dblp.uni-trier.de/db/conf/ccks/)) |   *   |                *                 |                    ~~2023.5.19~~                    |                        ~~2023.6.30~~                         |  ~~2023.8.24~8.27~~  |                      沈阳                      |
| SMP([官网](https://conference.cipsc.org.cn/smp2023/)、[dblp](https://dblp.uni-trier.de/db/conf/smp/)) |   *   |                *                 |                    ~~2023.5.15~~                    |                         ~~2023.7.1~~                         |   2023.11.24-11.26   |                      北京                      |
|   CCMT([官网](http://sc.cipsc.org.cn/mt/conference/2023/))   |   *   |                *                 |                    ~~2023.7.10~~                    |                        ~~2023.8.15~~                         |   2023.10.19-10.21   |                    山东济南                    |
