# 2020中医文献问题生成挑战

* 任务描述：
  * 问题生成是指根据上下文和答案生成相应问题
  * 官网：https://tianchi.aliyun.com/competition/entrance/531826/introduction
* 参赛时间：2020.9~2020.11
* 数据格式：

```json
{
2  "id": 98,
3  "text": "黄帝道：什麽叫重实？岐伯说：所谓重实，如大热病人，邪气甚热，而脉象又盛满，内外俱实，便叫重实",
4  "annotations": [
5   {
6     "Q": "重实是指什么？",
7     "A": "所谓重实，如大热病人，邪气甚热，而脉象又盛满，内外俱实，便叫重实"
8   },
9   {
10   "Q": "重实之人的脉象是什么样？",
11   "A": "脉象又盛满"
12   }
13  ],
14  "source": "黄帝内经翻译版"
15   },
16
17  {
18   "id": 714,
19   "text": "葡萄胎：表现为剧烈恶心呕吐，阴道不规则流血，偶有水泡状胎块排出。子宫质软大多较停经月份大。妊娠合并急性胃肠炎：多有饮食不洁史，不仅有恶心呕吐，还常伴有腹痛、腹泻等胃肠道症状。孕痈：即妊娠期急性阑尾炎，表现为脐周或中上腹部疼痛，伴有恶心、呕吐，24小时内腹痛可转移到右下腹。",
20  "annotations": [
21   {
22     "Q": "葡萄胎有什么症状表现？",
23     "A": "表现为剧烈恶心呕吐，阴道不规则流血，偶有水泡状胎块排出。子宫质软大多较停经月份大。"
24    },
25    {
26      "Q": "孕痈有什么表现？",
27      "A": "表现为脐周或中上腹部疼痛，伴有恶心、呕吐，24小时内腹痛可转移到右下腹。"
28    },
29    {
30      "Q": "孕痈有其它叫法吗？",
31      "A": "妊娠期急性阑尾炎"
32    }
33  ],
34  "source": "名医百科中医篇"
35    },
36
37    {
38     "id": 1078,
39     "text": "发热是小儿最常见的临床症状，是机体抵抗疾病的一种防御性反应，家长不必惊慌，也不要一发热就吃退热药，这样反而会影响疾病的诊断，也不利于炎症的控制，要掌握以下几点：\n（1）首先找一找原因。小婴儿在夏季是否衣服太多，包得太严，喂水太少等。也可以查一查耳朵内、脖子及全身皮肤（肛门周围）有无发红、发肿、疖子等。\n（2）可给予降温处理。解开衣服，让散热增加。用38℃的温水擦浴20分钟。也可用75%酒精加水一半（为30%酒精）擦腋下、腹股沟、颈部。也可用热水袋内加水和冰块，枕于头下，或冷水毛巾敷于额头部。\n（3）如体温不降，烦躁不安，应去医院治疗。\n（4）发热时，要多喂水，多喂易消化、清淡的食物，如咽喉红肿疼痛，喂凉饮食可减轻疼痛。体温下降后，要注意保暖和营养的摄入。",
40  "annotations": [
41   {
42     "Q": "小儿发热能否必须吃退烧药？",
43     "A": "发热是小儿最常见的临床症状，是机体抵抗疾病的一种防御性反应，家长不必惊慌，也不要一发热就吃退热药，这样反而会影响疾病的诊断，也不利于炎症的控制。"
44    },
45    {
46      "Q": "小儿发热要掌握哪几点？",
47      "A": "（1）首先找一找原因。小婴儿在夏季是否衣服太多，包得太严，喂水太少等。也可以查一查耳朵内、脖子及全身皮肤（肛门周围）有无发红、发肿、疖子等。（2）可给予降温处理。解开衣服，让散热增加。用38℃的温水擦浴20分钟。也可用75%酒精加水一半（为30%酒精）擦腋下、腹股沟、颈部。也可用热水袋内加水和冰块，枕于头下，或冷水毛巾敷于额头部。（3）如体温不降，烦躁不安，应去医院治疗。（4）发热时，要多喂水，多喂易消化、清淡的食物，如咽喉红肿疼痛，喂凉饮食可减轻疼痛。体温下降后，要注意保暖和营养的摄入。"
48    },
49    {
50      "Q": "小儿发热什么情况下要去看医生？",
51      "A": "体温不降，烦躁不安，应去医院治疗。"
52     }
53  ],
54  "source": "慢性病养生保健科普知识"
55     }
```

* 数据说明：
  * 标注数据源来自中医药领域文本，包括【黄帝内经翻译版】、【名医百科中医篇】、【中成药用药卷】、【慢性病养生保健科普知识】四个主要来源，问题类型包括实体类和描述类两大类（是非类问题包含在描述类中），其中**问题**均由人工标注产生，**答案**是**段落**中的文本中的连续片段。
  
  * |                        | Context |  QA   |    说明    |                           开放获取                           |
    | :--------------------: | :-----: | :---: | :--------: | :----------------------------------------------------------: |
    | round1_trian_0907.json |  5881   | 18478 | 初赛训练集 | [是](https://tianchi.aliyun.com/dataset/dataDetail?dataId=86895) |
    | round1_test_0907.json  |  1399   | 4373  | 初赛测试集 |                              否                              |
    |    juesai_1011.json    |  1644   | 5096  | 决赛测试集 |                              否                              |
    
  * 数据快速下载：https://github.com/kangyishuai/CHINESE-MEDICINE-QUESTION-GENERATION/tree/master/data
  
* 参赛方案：

|                             方案                             |                             代码                             |
| :----------------------------------------------------------: | :----------------------------------------------------------: |
| [top1](https://github.com/kangyishuai/CHINESE-MEDICINE-QUESTION-GENERATION?spm=5176.12282029.0.0.46a21bd4Bd3ovJ) | [√](https://github.com/kangyishuai/CHINESE-MEDICINE-QUESTION-GENERATION?spm=5176.12282029.0.0.46a21bd4Bd3ovJ) |
| [top2](https://tianchi.aliyun.com/forum/postDetail?spm=5176.12586969.1002.6.767a1ebbsqTpuN&postId=156421) |                              ×                               |
| [top3](https://tianchi.aliyun.com/forum/postDetail?spm=5176.12586969.1002.15.767a1ebbsqTpuN&postId=154869) |                              ×                               |
| [top4](https://tianchi.aliyun.com/forum/postDetail?spm=5176.12586969.1002.12.767a1ebbsqTpuN&postId=155051) | [√](https://github.com/chenxichen95/Tianchi2020ChineseMedicineQuestionGeneration?spm=5176.12282029.0.0.37c34f1fgK4pG1) |
| [top7](https://tianchi.aliyun.com/forum/postDetail?spm=5176.12586969.1002.9.767a1ebbxuIt2J&postId=155097) |  [√](https://github.com/theDyingofLight/nqg-Unilm-tianchi)   |
| [top8](https://github.com/menghuanlater/Tianchi2020ChineseMedicineQuestionGeneration) | [√](https://github.com/menghuanlater/Tianchi2020ChineseMedicineQuestionGeneration) |
| [中医文献问题生成竞赛总结](https://zhuanlan.zhihu.com/p/350080984) |                              ×                               |
| [竞赛总结：中医文献问题生成](https://mp.weixin.qq.com/s/Qfc0EOrFfFGPonOKKZAJ7Q) |                              ×                               |

* 推荐资料

  [CHIP2020评测整体报告](https://www.bilibili.com/video/BV185411574p?p=42) 
