# 2021搜狐校园文本匹配算法大赛

* 任务简介

  * 参赛选手需要为每对文本在两个颗粒度上判断文本对中的两段文字是否匹配。其中，一个颗粒度较为宽泛，两段文字属于一个话题即可视为匹配；另一个颗粒度较为严格，两段文字必须是同一事件才视为匹配。另外根据文本长度，又可分为长长，长短，短短三类数据。
  * 官网：https://www.biendata.xyz/competition/sohu_2021/

* 时间：2021.3~2021.5

* 数据示例

  > 1. 参赛选手需要正确判断两段文字是否匹配，数据分为A和B两个文件，A和B文件匹配标准不一样。其中，A文件匹配标准较为宽泛，两段文字是同一个话题便视为匹配，B文件匹配标准较为严格，两段文字须是同一个事件才视为匹配。
  > 2. source为第一段文字，target为第二段文字，labelA为A文件中匹配情况，labelB为B文件中匹配情况，“0”表示不匹配，“1”表示匹配。

  > A.txt

  ```json
  {
      "source": "英国伦敦，20/21赛季英超第20轮，托特纳姆热刺VS利物浦。热刺本赛季18轮联赛是9胜6平3负，目前积33分排名联赛第5位。利物浦本赛季19轮联赛是9胜7平3负，目前积34分排名联赛第4位。从目前的走势来看，本场比赛从热刺的角度来讲，是非常被动的。最终，本场比赛的比分为托特纳姆热刺1-3利",
      "target": " 北京时间1月29日凌晨4时，英超联赛第20轮迎来一场强强对话，热刺坐镇主场迎战利物浦。  热刺vs利物浦，比赛看点如下： 第一：热刺能否成功复仇？双方首回合，热刺客场1-2被利物浦绝杀，赛后穆里尼奥称最好的球队输了，本轮热刺主场迎战利物浦，借着红军5轮不胜的低迷状态，能否成功复仇？ 第二：利物浦近",
      "labelA": "1"
  }
  ```

  >B.txt

  ```json
  {
      "source": "英国伦敦，20/21赛季英超第20轮，托特纳姆热刺VS利物浦。热刺本赛季18轮联赛是9胜6平3负，目前积33分排名联赛第5位。利物浦本赛季19轮联赛是9胜7平3负，目前积34分排名联赛第4位。从目前的走势来看，本场比赛从热刺的角度来讲，是非常被动的。最终，本场比赛的比分为托特纳姆热刺1-3利",
      "target": " 北京时间1月29日凌晨4时，英超联赛第20轮迎来一场强强对话，热刺坐镇主场迎战利物浦。  热刺vs利物浦，比赛看点如下： 第一：热刺能否成功复仇？双方首回合，热刺客场1-2被利物浦绝杀，赛后穆里尼奥称最好的球队输了，本轮热刺主场迎战利物浦，借着红军5轮不胜的低迷状态，能否成功复仇？ 第二：利物浦近",
      "labelB": "0"
  }
  ```

* 数据说明

  |  初赛   |  复赛  |  决赛  |                             下载                             |
  | :-----: | :----: | :----: | :----------------------------------------------------------: |
  | 180,000 | 30,000 | 90,000 | [官网](https://www.biendata.xyz/competition/sohu_2021/data/) |

  

* 竞赛方案

  |                             方案                             |             macro f1             |                             代码                             |
  | :----------------------------------------------------------: | :------------------------------: | :----------------------------------------------------------: |
  | [top2](https://zhuanlan.zhihu.com/p/388854673) （[决赛pdf](https://github.com/hflserdaniel/sohu_text_matching/blob/main/%E5%86%B3%E8%B5%9B%E7%AD%94%E8%BE%A9-%E5%88%86%E6%AF%94%E6%88%91%E4%BB%AC%E4%BD%8E%E7%9A%84%E9%83%BD%E6%98%AF%E5%B8%85%E5%93%A5-%E7%BB%88%E7%A8%BF.pdf) ） | 0.78921（复赛），0.78123（决赛） |   [√](https://github.com/hflserdaniel/sohu_text_matching)    |
  |  [top3](https://github.com/zzy99/competition-solutions) (?)  |                ？                | [√](https://github.com/zzy99/competition-solutions/tree/main/code/sohu) |
  | [top8](https://github.com/CQUPT-GML/2021Sohu_Text_Matching)  |         0.73901（初赛）          |   [√](https://github.com/CQUPT-GML/2021Sohu_Text_Matching)   |
  |         [other](https://github.com/KKenny0/sohu2021)         | 0.74531（初赛），0.7848（复赛）  |           [√](https://github.com/KKenny0/sohu2021)           |
  |      [苏剑林-baseline](https://kexue.fm/archives/8337)       |         0.73621（初赛）          |       [√](https://github.com/bojone/sohu2021-baseline)       |
  |                      official baseline                       |                ？                |    [√](https://github.com/biendata-com/sohu2021-baseline)    |
  
  