# 2019法研杯-相似案例匹配

* 任务简介

  * 本任务是针对多篇法律文书进行相似度的计算和判断，具体来说，对于每份文书的标题和事实描述，选手需要从两篇候选集文书中找到与询问文书更为相似的一篇文书。数据只涉及民间借贷、知识产权纠纷和海商海事这三类文书。
  * 官网：http://cail.cipsc.org.cn:2019/instruction.html

* 时间：2019.5~2019.10

* 数据示例

  ```json
  {
      "B": "原告：张某1，男，1934年10月7日出生。委托诉讼代理人：王振忠，男，1963年3月5日出生。被告：王某1，男，1948年10月20日出生。\n\n张某1向本院提出诉讼请求：1、王某1归还借款17500元，并按年利率36％支付自2012年12月30日起至该款付清之日的利息。2、本案诉讼费由王某1承担。事实与理由：2012年7月29日，王某1向张某1借款15000元并出具借条。2012年12月29日，王某1向张某1借款2500元并重新出具借款金额17500元的借条，约定月息5％，2012年底前还清。借款期限届满后，王某1未归还借款本息，故张某1诉至法院。王某1答辩称2011年9月份，王某1从张某1处借款10000元，当时拖了十个月未还款，王某1向张某1出具了一张15000元的借条，后来拖到十五个月未还款，王某1又向张某1出具一张借款金额为17500元的借条，约定月息5％。后王某1未归还张某1借款。王某1认为实际借款金额是10000元，且约定的月息5％过高。当事人张某1围绕诉讼请求依法提交借条，王某1认可借条的真实性，但辩称实际借款金额是10000元，7500元是利息，本院对该借据的真实性、合法性、关联性均予以确认。本院经审理认定事实如下：2012年12月29日，王某1向张某1出具借条，内容为：“今借到张某12012年年底前还壹万柒仟伍佰元，月息5％。借款人王某1，王某某。2012年12月29。介绍人：吕某某。”王某1称王某某不是借款人，借条上的签字亦是王某1书写。后王某1未归还借款。\n",
      "A": "原告李某1，居民。被告陈某1，居民。\n\n原告李某1诉称，原、被告系同学关系，被告因购车经济困难，于2013年12月、2014年5月分别向原告借款50000元、50000元，并分别写有借条交由原告执存，2015年2月13日，经双方结算，被告重新出具了一张金额为100000元的借条交由原告执存，约定按月利率20‰计算，借期为12个月，到期后，被告未按约定归还借款本息，原告多次催取未果，为维护原告的合法权益，特向法院提起诉讼，请求：1、依法判令被告陈某1归还原告借款100000元并支付利息（自2015年2月13日起至还清之日止按月利率20‰计算）；2、本案诉讼费由被告承担。原告为证明其诉讼主张，在举证期限内向本院提交了以下证据：1、原告身份证复印件，拟证明原告的诉讼主体资格；2、借条1张，拟证明被告陈某1向原告借款的事实。被告陈某1在答辩期限届满前未提交书面答辩，在举证期限届满前未向本院提交证据。对原告提交的两组证据，由于被告未到庭质证，经本院审查，对原告提交的证据1、2的三性予以认定。经审理查明，被告陈某1尚欠原告李某1借款100000元，2015年2月13日，被告重新出具了一张借条交由原告执存，约定按月利率20‰计算，借期为12个月；借款后，被告未向原告支付月息，到期后，被告未按约定归还借款，原告催取未果，因而成讼。以上事实，有原告向本院提交的证据、庭审笔录等证据证实，足以认定。\n",
      "label": "C", 
      "C": "原告：周某1，男，1963年2月8日出生，汉族，住杭州市余杭区。被告：王某1，女，1970年3月3日出生，汉族，住浙江省永嘉县。\n\n原告起诉称：2014年6月29日，被告因资金周转所需，向原告借款共计人民币100000元，被告并承诺按银行同期贷款利率的四倍计算利息，归还期限至2014年7月29日，逾期未能归还则由借款人承担借款本金5％的违约金。被告并于借款同日向原告出具书面借条一份。原告经多次催讨无果，特起诉到法院。诉讼请求：1、判令被告立即归还借款100000元；2、判令被告按年利率百分之六的四倍标准支付借款利息，自2014年6月30日起至2016年7月29日止，计人民币50000元；自2016年7月30日起，至判决确认支付之日止的借款利息按上述标准另行计算；3、本案诉讼费用由被告承担。案件审理过程中原告变更第二项诉讼请求为：2、判令被告按银行同期贷款利率的四倍支付借款利息，自2014年6月30日起至2016年7月29日止，计人民币46197元；自2016年7月30日起，至判决确认支付之日止的借款利息按上述标准另行计算。原告为支持其诉请主张，在庭审中出示并陈述了下列证据：借条一份，证明被告向原告借款的事实。被告在法定答辩期间未提交书面答辩状，也未向法庭提供证据，并放弃到庭质证的权利。原告出示的证据，本院经审查后认为，符合有效证据的采信规则，故确认其作为认定本案相关事实的依据。根据到庭当事人的陈述以及本院确认的有效证据，本院认定本案的事实与原告起诉主张的事实相一致。\n"
  }
  ```

  训练数据中，A与B的相似度大于A与C的相似度，即sim(A,B)>sim(A,C)。

* 数据说明

  

  | train | dev  | test |                             下载                             |
  | :---: | :--: | :--: | :----------------------------------------------------------: |
  | 5102  | 1500 | 1536 | [√](https://cail.oss-cn-qingdao.aliyuncs.com/cail2019/CAIL2019-SCM.zip) |

  

* 竞赛方案

  |                           方案                           | dev acc | test acc |                    代码                     |
  | :------------------------------------------------------: | :-----: | :------: | :-----------------------------------------: |
  | [top1](https://www.jiqizhixin.com/articles/2019-10-24-9) |  70.07  |  72.66   | [√](https://github.com/GuidoPaul/CAIL2019)  |
  |        [top2](https://github.com/padeoe/cail2019)        |  67.73  |  71.81   |   [√](https://github.com/padeoe/cail2019)   |
  |      [top7](https://zhuanlan.zhihu.com/p/88207736)       |  65.93  |  69.66   | [√](https://github.com/hecongqing/CAIL2019) |

  

* 推荐资料

  总体报告：[《CAIL2019-SCM: A Dataset of Similar Case Matching in Legal Domain》](https://arxiv.org/abs/1911.08962v3) 

