#  2019CHIP-临床术语标准化任务

* 任务简介

  * 本次评测任务主要目标是针对中文电子病历中挖掘出的真实手术实体进行语义标准化。 给定一手术原词，要求给出其对应的手术标准词。所有手术原词均来自于真实医疗数据，并以《ICD9-2017协和临床版》 手术词表为标准进行了标注。
  * 官网：http://www.cips-chip.org.cn:8000/evaluation

* 时间：2019.9~2019.11

* 数据示例

  > 一个原始词可能对应多个标准词，中间用‘##’隔开

  |            原始词            |          标准词          |
  | :--------------------------: | :----------------------: |
  |       横结肠造口还纳术       |     横结肠造口闭合术     |
  |    右肾上腺巨大肿瘤切除术    |     肾上腺病损切除术     |
  |   左侧单侧乳房根治性切除术   |   单侧根治性乳房切除术   |
  | 经皮三叉神经半月节射频热凝术 | 三叉神经半月节射频热凝术 |
  |     右肾探查，右肾根治术     |  肾探查术##单侧肾切除术  |

* 数据说明

  > 数据下载：[1](http://openkg.cn/dataset/yidu-n7k) 、[2](https://tianchi.aliyun.com/dataset/dataDetail?dataId=92094) （含《ICD9-2017协和临床版》 手术词表）

  |                            | train |  dev  | test  | 手术词表 |
  | :------------------------: | :---: | :---: | :---: | :------: |
  |           数据量           | 4,000 | 1,000 | 2,000 |    *     |
  |      最大手术原词长度      |  122  |  102  |  80   |    *     |
  |      最小手术原词长度      |   2   |   2   |   3   |    *     |
  |      平均手术原词长度      | 12.36 | 12.34 | 12.35 |    *     |
  | 手术原词对应最多标准词个数 |   7   |   4   |   5   |    *     |
  | 手术原词对应最少标准词个数 |   1   |   1   |   1   |    *     |
  | 手术原词对应平均标准词个数 | 1.07  | 1.06  | 1.06  |    *     |
  |     最大手术标准词长度     |  24   |  24   |  27   |    37    |
  |     最小手术标准词长度     |   3   |   4   |   3   |    1     |
  |     平均手术标准词长度     | 9.14  | 9.24  | 9..16 |   9.16   |

  注：长度不超过20的手术原词在训练集中占比约为94%，在验证集和测试集中将近95%。

* 竞赛方案 

  |     方案/rank      |  acc   | 代码 |
  | :----------------: | :----: | :--: |
  | 1（PPT：表格下方） | 0.9483 |  ×   |
  | 2（PPT：表格下方） | 0.9272 |  ×   |
  | 3（PPT：表格下方） | 0.9134 |  ×   |

  [评测报告PPT](http://www.cips-chip.org.cn:8000/static/data/%E8%AF%84%E6%B5%8B%E6%B1%87%E6%8A%A5PPT%E6%B1%87%E6%80%BB.zip) 

* 推荐资料

  1. [《CHIP2019评测任务1概述：临床术语标准化任务 》](http://jcip.cipsc.org.cn/CN/abstract/abstract3104.shtml) 
  2. [《基于BERT的临床术语标准化》](http://jcip.cipsc.org.cn/CN/abstract/abstract3119.shtml) 
  3.  知乎：[《一文详解常见医学自然语言理解任务和算法》](https://zhuanlan.zhihu.com/p/385000705) 

