# 2022机器翻译质量评估挑战赛

## 任务简介

* 本次大赛提供非受限场景，可使用任何数据资源和模型，在提供的500句中->英方向的翻译数据上进行质量评估（0-100分）。
* 官网：http://challenge.xfyun.cn/topic/info?type=translation-quality
* 时间：2022.6.24-2022.8.4

## 数据示例

| 源端                                                         | 目标端                                                       | 质量评分 |
| ------------------------------------------------------------ | ------------------------------------------------------------ | -------- |
| With Murray seemingly happy to just keep the ball in play in the early moments Federer then stepped in with aggressive winners off the backhand and forehand sides to break for 2-0. | 在穆雷似乎乐于在前几局保持球路的情况下，费德勒随后以极具攻击性的反手和正手制胜球取得2-0的破发。 | 100      |
| 们 倭 着 身 子 像 四 个 蒜 瓣                                | They were like four garlic cloves                            | 80       |
| 个 位 上 是 3 十 位 上 是 1 组 成 的 数                      | The number of 3 on one digit and 1 on ten digits .           | 70       |

注：人工评分0-100分，打分最小粒度为5分，人工评分分别就“忠实度”和“流利度”两个维度制定评价标准，最终分数为忠实度和流利度打分的算术平均值。

忠实度（fidelity）：评测译文是否忠实地表达了原文的内容。按0–100分打分，打分最小粒度5分。

| 分数 | 得分标准                                                     |
| ---- | ------------------------------------------------------------ |
| 0    | 完全没有译出来                                               |
| 20   | 译文中只有个别词被孤立地翻译                                 |
| 40   | 译文中有少数短语或比词大的语法成分被翻译                     |
| 60   | 原文中60%的概念及其之间的关系被正确翻译，或原文中的主谓宾及其关系被正确的翻译 |
| 80   | 原文中80%的概念及其之间的关系被正确翻译                      |
| 100  | 原文中100%的概念及其之间的关系被正确翻译                     |

流利度（fluency）：评测译文是否流畅和地道。按0–100分打分，打分最小粒度5分。

| 分数 | 得分标准                                                     |
| ---- | ------------------------------------------------------------ |
| 0    | 完全不可理解                                                 |
| 20   | 译文晦涩难懂（只有个别短语或比词大的语法成分可以理解）       |
| 40   | 40%的部分基本流畅（少数的短语或比词大的语法成分可以理解）    |
| 60   | 译文60%的部分基本流畅                                        |
| 80   | 译文80%的部分基本流畅，或原文中的主谓宾部分基本流畅，只是个别词语或搭配不地道 |
| 100  | 译文流畅而且地道                                             |

## 数据说明

|        | 总数 | 下载                                                         |
| ------ | ---- | ------------------------------------------------------------ |
| 训练集 | 无   | 无                                                           |
| 开发集 | 500  | [√](https://aistudio.baidu.com/aistudio/datasetdetail/154704) |
| 测试集 | 500  | 同上                                                         |

注：训练集可考虑CCMT质量评估评测任务、WMT质量评估评测任务

## 竞赛方案

本次比赛采用按与人工评分的pearson相关系数进行评价，计算公式如下：

![](https://ai-contest-static.xfyun.cn/2022/picture/130.png)

![](https://ai-contest-static.xfyun.cn/2022/picture/131.png)



| 方案/rank                                                    | 初赛pearson | 代码                                                         |
| ------------------------------------------------------------ | ----------- | ------------------------------------------------------------ |
| 1（[video](https://1024.iflytek.com/liveroom?date=1117&id=1.2_%E5%A4%A7%E8%B5%9B_39) 13:25-） | 0.42290     | ×                                                            |
| 2（[评测论文](http://sc.cipsc.org.cn/mt/conference/2022/papers/test_paper/59/59_Paper.pdf) 、[video](https://1024.iflytek.com/liveroom?date=1117&id=1.2_%E5%A4%A7%E8%B5%9B_39) -12:30） | 0.41759     | ×                                                            |
| [baseline](https://aistudio.baidu.com/aistudio/projectdetail/4276435) | 0.17389     | [√](https://aistudio.baidu.com/aistudio/projectdetail/4276435) |



## 推荐资料

1. CCMT2022QE评测论文 [《An improved Multi-task Approach to Pre-trained Model Based MT Quality Estimation》](http://sc.cipsc.org.cn/mt/conference/2022/papers/test_paper/58/58_Paper.pdf) 
2. CCMT2022QE评测论文 [《HW-TSC Submission for CCMT 2022 Translation Quality Estimation Task》](http://sc.cipsc.org.cn/mt/conference/2022/papers/test_paper/63/63_Paper.pdf) 
3. CCMT2022QE评测论文 [《NJUNLP’s Submission for CCMT 2022 Quality Estimation Task》](http://sc.cipsc.org.cn/mt/conference/2022/papers/test_paper/71/71_Paper.pdf) 