# 2021DIGIX-基于多模型迁移预训练文章质量判别 

* 任务简介
  * 本题目将为选手提供脱敏文章数据，参赛选手基于给定的数据构建文章质量判别模型，任务是预测文章的类别（doctype），训练集中的类别共有10种，测试集有个在训练集中不存在的类需要判断出。
  * 官网：https://developer.huawei.com/consumer/cn/activity/devStarAI/algo/competition.html#/preliminary/info/005/introduction
  
* 时间：2021.6~2021.9

* 数据示例

  ```json
  {
      "id": "cc4dbfd2-273d-402e-8fb5-8dd774fe6fcf",
      "title": "19岁嫁给张艺谋，5年生3子，巩俐拿不下的男人她凭什么拿下",
      "body": "19岁嫁给张艺谋，5年生3子，巩俐拿不下的男人她凭什么拿下的文/简单点张艺谋的儿子张壹男19岁了，母亲陈婷在社交网络上为儿子庆生，并感慨19年来第一次没和儿子一起过生日……",
      "category": 8,
      "doctype": "人物专栏"
  }
  ```

  * category：文章分类编码，测试数据也有这个信息，没弄明白这个有什么用，质量越高，这个值就越高吗？
  * doctype：优质文章类别信息，测试数据无此信息

* 数据说明

  |                train                | A榜 test | B榜 test |                             下载                             |
  | :---------------------------------: | :------: | :------: | :----------------------------------------------------------: |
  | 无标注：500,000 <br> 有标注：76,454 |  45,284  |    ？    | [√](https://aistudio.baidu.com/aistudio/datasetdetail/105318) |

  | 文章质量类型 | 训练集中的标注数据 |                             定义                             |
  | :----------: | :----------------: | :----------------------------------------------------------: |
  |   深度事件   |       16,670       |   对各领域重大事件的深度分析、专题报道、脉络构建，事件呈现   |
  |   人物专栏   |       7,242        | 在某一领域有影响力、成为焦点或热点的人物的访谈、深度挖掘、人生故事 |
  |   行业解读   |       9,968        | 对某一行业、领域所发生的变化进行现象解说、数据解读、原因剖析、论点论证 |
  |   物品评测   |       4,381        | 从多个维度对某一物品进行测试评价，展现该物品特点，为人们提供参考 |
  |   作品分析   |       14,094       | 对经典或者热门作品内容的赏析、解读或者背景挖掘，作品包含文学作品、娱乐影视和综艺作品 |
  |    攻略文    |       5,517        | 针对不同的生活场景为达到某个目的而展开方法论描述和可行性的指导，有助于读者学习到新知识，解决问题 |
  |  科普知识文  |       6,337        | 针对不同的专业领域的知识点或现象进行描述、说明以及论证，使得读者获得新知识，增长见识 |
  |   情感解读   |       7,183        |              针对情感问题或情感事件进行解读分析              |
  |  治愈系文章  |       3,868        |  呈现美好事物的文章，能引起读者极度舒适，激发愉悦心情的文章  |
  |    推荐文    |       1,194        | 针对单个或多个文学作品、小说、游戏、动漫作品的汇总、评价比较，介绍推荐文章 |
  |     其他     |         *          |                    不在上述10种类型的文章                    |

  

  * 训练数据中没有预置质量类型为“其他”的数据，而是包含大量未标注数据，即`doctype`为`""` ，未标注数据中可能包含优质文章。

  * 测试数据中包含大量文章质量类型为“其他”的数据，这个数据可以认为是质量较差的文章。

    

* 竞赛方案

  |                          方案/rank                           |  A榜 F1  |  B榜 F1  |                             代码                             |
  | :----------------------------------------------------------: | :------: | :------: | :----------------------------------------------------------: |
  |         [1](https://zhuanlan.zhihu.com/p/416421241)          | 0.759326 | 0.748082 |                              ×                               |
  | [baseline1](https://aistudio.baidu.com/aistudio/projectdetail/2304528) |    ?     |   0.45   | [1](https://aistudio.baidu.com/aistudio/projectdetail/2304528) 、[2](https://gitee.com/coggle/DIGIX2021-BASELINE/tree/main/baseline-game2) |
  |                          baseline2                           |    ？    |    ？    | [√](https://github.com/luoda888/2021-DIGIX-BASELINE/tree/main/baseline-game2) |

  

* 推荐资料

  * 赛题讲解：[here](https://www.bilibili.com/video/BV1Rf4y157eo) 